
/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/ReferenceFactoryImpl.java $
  $Revision: 4 $
  $Modtime: 5/11/98 2:14p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.*;

import javax.naming.*;

//import com.novell.java.naming.Environment;

import com.novell.utility.naming.URLParser;
import com.novell.utility.naming.spi.ReferenceFactory;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 * ReferenceFactoryImpl is used to facilitate implicit federation from a
 * context in another name space to a context in the NDS name space.
 *
 * This ReferenceFactory's properties:
 *    "java.naming.provider.url" - the name of the nds context's tree
 *       - or -
 *    "nsi.nds.tree" - the name of the nds context's tree
 *
 *    "nsi.nds.object" - the name of the context's object
 */
public class ReferenceFactoryImpl implements ReferenceFactory
{
   /**
    *
    */
   public Reference createReference (
         Hashtable environment)
      throws NamingException
   {
      NdsEnvironment ndsEnvironment = new NdsEnvironment (environment);

      return (createReference (
                  "com.novell.service.nds.naming.NdsDirContext",
                  ndsEnvironment.getProviderURL (),
                  ndsEnvironment));

   } /* getReference () */

   /**
    *
    */
   static Reference createReference (
         String className,
         String url,
         NdsEnvironment ndsEnvironment)
      throws NamingException
   {
      ContextFactoryBuilder builder;
      ContextFactory factory;

      builder = new WrapperContextFactoryBuilder (ndsEnvironment);
      factory = builder.createContextFactory (url, ndsEnvironment);

      return (new Reference (
                     className,
                     new StringRefAddr ("ndsaddr", url),
                     factory.getClass ().getName (),
                     ""));

   } /* getReference () */

} /* ReferenceFactoryImpl */


