
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetAttributeValueEnumerator.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:40p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;
import javax.naming.*;

import com.novell.service.jncp.*;
import com.novell.service.toolkit.jcl.*;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2.net.*;

import com.novell.service.nds.naming.NdsNamingExceptionFactory;

/**@internal
 *  Nds attribute values enumeration class.
 *  This class allows single attribute only.
 */
public class NetAttributeValueEnumerator implements Enumeration
{
   private String objectName;
   private String attrName;
   private NetService service;

   private NetIterationHandle iterationHandle;
   private NetBuffer rawValues;
   private NWInteger valueCount;

   private NWInteger syntaxId;
   private boolean moreValues;
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

    /**
     *  Constructs a NetAttributeValueEnumerator object.
     *
     *  @param ndsContext   Nds context handle.
     *  @param objectDN     Object's FDN in dot format.
     *  @param attrName     Attribute's name.
     *
     *  @exception NSIException
     */
   public NetAttributeValueEnumerator (
                   NetService service,
                   String objectDN,
                   String attrName)
      throws NSIException
   {
      this.service = service;
      this.objectName = objectDN;
      this.attrName = attrName;

      this.iterationHandle = new NetIterationHandle(
                  service, NetJNI.DSV_READ);
      this.rawValues = new NetBuffer(service);

      this.valueCount = new NWInteger(0);

      this.syntaxId = new NWInteger(0);
      this.moreValues = true;
   }

    /**
     * Read some values of the attribute from NDS.
     */
   private void getRawValues()
      throws NSIException
   {
      if (!this.moreValues)
         return;

      /* prepare buffer for retrieve the values */
      NetBuffer query = new NetBuffer(service,
                                 NetJNI.DSV_READ,
                                 NetJNI.DEFAULT_MESSAGE_LEN);
      query.putAttributeName(this.attrName);

      try
      {
         /* ask Nds for attribute values */
         service.read (
                          this.objectName,
                          NetJNI.DS_ATTRIBUTE_VALUES,
                          false,
                          query.getHandle(),
                          this.iterationHandle,
                          this.rawValues.getHandle());
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

      /* the return value is ignored althought this call is required. */
      this.rawValues.getAttrCount();

      /* read the attribute name. */
      StringBuffer attrName = new StringBuffer();

      this.rawValues.getAttrName(attrName, this.valueCount, this.syntaxId);

      moreValues = this.iterationHandle.moreIterations();
   }

    /**
     * Tests if this enumeration contains more elements.
     */
   public boolean hasMoreElements()
   {
       try {
          if (this.valueCount.getValue() == 0)
             this.getRawValues();
       }
       catch (NSIException e) {
           this.valueCount.setValue(0);
       }

      return this.valueCount.getValue() != 0;
   }

    /**
     * Returns the next element of this enumeration.
     */
   public Object nextElement()
       throws NoSuchElementException
   {
       /* if no more values to read from the cache, */
       /* try to ask NDS for some values.           */
       try {
          if (this.valueCount.getValue() == 0)
             this.getRawValues();
       }
       catch (NSIException e) {
           throw new NoSuchElementException(e.getMessage());
       }

      /* if both the internal cache and NDS don't have
      **  any offer, signal the calling client
      */
      if (this.valueCount.getValue() == 0)
           throw new NoSuchElementException();

      /* read a value from internal cache */
      byte[] value = null;

      try
      {
         value = this.rawValues.getAttributeValue (syntaxId.getValue ());
      }
      catch (NSIException e)
      {
         throw new NoSuchElementException(e.getMessage());
      }

        /* decrease the counter */
      this.valueCount.setValue (this.valueCount.getValue () - 1);

      return value;
   }
	
	/**
	 * Closes the iteration handle for this NamingEnumeration.
	 */
	public void closeIteration ()
	   throws NamingException
	{
		try
		{
			iterationHandle.closeIteration ();
		}
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }
	}
	
}