/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/net/NetReplicaOperations.java $
  $Revision: 1 $
  $Modtime: 3/02/98 2:28p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.naming.net;

import com.novell.service.nds.naming.NdsPartitionOperationException;

/**
*  Interface for aborting partition operations
*   - To be implemented by the NdsPartitionTreeRootContext class
*/

public interface NetReplicaOperations
{
    public final static int REPLICATYPE_MASTER = 0;
    public final static int REPLICATYPE_SECONDARY = 1;
    public final static int REPLICATYPE_READONLY = 2;

    /*
    * Change the replica type
    * @param type    One of the following
    *               REPLICATYPE_MASTER
    *               REPLICATYPE_SECONDARY
    *               REPLICATYPE_READONLY
    * @exception PartitionOperationException
    */
    public void changeReplicaType (
         int type)
      throws NdsPartitionOperationException;

    /*
    * Synchronize replicas - wrapper for NWDSSyncReplicaToServer
    * @param destServer    Server with which to be synced
    * @param flags    Synchronization flags
    * @param dealy    Delay after which to start synchronization process
    * @exception PartitionOperationException
    */
    public void syncReplica (
            String destServer,
            int flags,
            int delay)
        throws NdsPartitionOperationException;

    /*
    * Synchronize replicas - wrapper for NWDSSyncPartition
    * @param dealy    Delay after which to start synchronization process
    * @exception PartitionOperationException
    */
    public void syncReplica (
         int delay)
      throws NdsPartitionOperationException;

}