
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetObjectACL.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsObjectACL;


/** @internal
 * NetObjectACL is an Adapter for NdsObjectACL.
 *
 * This class converts to/from the NWNet Object_ACL_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar            protectedAttrName;
 *       pnchar            subjectName;
 *       NWDS_PRIVILEGES   privileges;
 *
 * } Object_ACL_T;
 */
public final class NetObjectACL
   extends NdsObjectACL implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Object ACL from the "API Data Structure".
    *
    * @param   value   byte[] containing a Object_ACL_T
    */
   protected NetObjectACL (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.protectedAttrName = edis.readLoHiChars ();
         this.subjectName = edis.readLoHiChars ();
         this.privileges = edis.readLoHiInt ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetObjectACL adapter for an NdsObjectACL.
    *
    * @param   value   an NdsObjectACL object.
    */
   protected NetObjectACL (
         NdsObjectACL value)
   {
      super (value);
   }

   /**
    * Returns a Object ACL "API Data Structure".
    *
    * @return   byte[] containing Object_ACL_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.protectedAttrName);
         eos.writeLoHiChars (this.subjectName);
         eos.writeLoHiInt (this.privileges);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetObjectACL */


