
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetOctetList.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsOctetList;


/** @internal
 * NetOctetList is an Adapter for NdsOctetList.
 *
 * This class converts to/from the NWNet Octet_List_T.
 *
 * API Data Structure:
 *    typedef struct _OCTET_LIST
 *    {
 *       struct _Octet_List  *next;
 *       NWLEN                length;
 *       pnuint8              data;
 *
 * } Octet_List_T;
 */
public final class NetOctetList
   extends NdsOctetList implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Octet List from the "API Data Structure".
    *
    * @param   value   byte[] containing a Octet_List_T
    */
   protected NetOctetList (
         byte[] value)
      throws NSIException
   {
      try
      {
         int count;
         EndianInputStream edis = new EndianInputStream (value);

         count = edis.readLoHiInt ();
         this.values = new byte[count][];
         for (int i = 0; i < count; i++)
         {
            byte[] component = new byte[edis.readLoHiInt ()];

            edis.readFully (component);
            this.values[i] = component;
         }
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetOctetList adapter for an NdsOctetList.
    *
    * @param   value   an NdsOctetList object.
    */
   protected NetOctetList (
         NdsOctetList value)
   {
      super (value);
   }

   /**
    * Returns a Octet List "API Data Structure".
    *
    * @return   byte[] containing Octet_List_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         int count;
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         count = this.values.length;
         eos.writeLoHiInt (count);
         for (int i = 0; i < count; i++)
         {
            byte[] element = (byte[]) this.values[i];

            eos.writeLoHiInt (element.length);
            eos.write (element);
         }
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetOctetList */


