
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetOctetString.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsOctetString;


/** @internal
 * NetOctetString is an Adapter for NdsOctetString.
 *
 * This class converts to/from the NWNet Octet_String_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWLEN    length;
 *       pnuint8  data;
 *
 *    } Octet_String_T;
 */
public final class NetOctetString
   extends NdsOctetString implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Octet String from the "API Data Structure".
    *
    * @param   value   byte[] containing a Octet_String_T
    */
   protected NetOctetString (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = new byte [edis.readLoHiInt ()];
         edis.readFully (this.value);
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetOctetString adapter for an NdsOctetString.
    *
    * @param   value   an NdsOctetString object.
    */
   protected NetOctetString (
         NdsOctetString value)
   {
      super (value);
   }

   /**
    * Returns a Octet String "API Data Structure".
    *
    * @return   byte[] containing Octet_String_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.value.length);
         eos.write (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetOctetString */


