
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetTimestamp.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsTimestamp;


/** @internal
 * NetTimestamp is an Adapter for NdsTimestamp.
 *
 * This class converts to/from the NWNet NWDS_Timestamp_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWSECONDS      wholeSeconds;
 *       NWDS_EVENT     eventID;
 *
 *    } NWDS_Timestamp_T;
 */
public final class NetTimestamp
   extends NdsTimestamp implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Time Stamp from the "API Data Structure".
    * 
    * @param   value   byte[] containing a NWDS_Timestamp_T
    */
   protected NetTimestamp (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.wholeSeconds = edis.readLoHiInt ();
         this.replicaNumber = edis.readLoHiShort ();
         this.eventId = edis.readLoHiShort ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetTimestamp adapter for an NdsTimestamp.
    * 
    * @param   value   an NdsTimestamp object.
    */
   protected NetTimestamp (
         NdsTimestamp value)
   {
      super (value);
   }

   /**
    * Returns a Time Stamp "API Data Structure".
    * 
    * @return   byte[] containing NWDS_Timestamp_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt ((int) this.wholeSeconds);
         eos.writeLoHiShort (this.replicaNumber);
         eos.writeLoHiShort (this.eventId);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetTimestamp */


