/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/SessionAttrEnumerator.java $
  $Revision: 9 $
  $Modtime: 1/24/00 7:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import com.novell.service.session.util.Debug;

/**
 * Provides an implementation of Enumeration that contains
 * only session attributes. An object that implements the Enumeration
 * interface generates a series of elements, one at a time. Successive
 * calls to the nextElement() method return successive elements of the
 * series.
 */
public class SessionAttrEnumerator implements Enumeration
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean S_DEBUG = false; // May have side effects

   private Enumeration  enum;
   private SessionAttrs attributes;

   /**
    * Constructs a SessionAttrEnumerator object with the passed in
    * attributes.
    *
    * @param attributes The attributes passed in to the constructor.
    *
    * @exception SessionException A top-level exception thrown by
    * session objects.
    */
   public SessionAttrEnumerator
   (
      SessionAttrs attributes
   )
   throws SessionException
   {
      this.attributes = attributes;
      this.enum = this.attributes.getSessionAttrIds();
   }

   /**
    * @internal
    *
    * Tests if this enumeration contains more elements.
    * Inherited from Sun's java.util.Enumeration interface.
    *
    * @return A boolean set to TRUE if this enumeration contains
    * more elements, otherwise set to FALSE. 
    */
   public boolean hasMoreElements
   (
   )
   {
      return this.enum.hasMoreElements();
   }

   /**
    * @internal
    *
    * Returns the next element of this enumeration. 
    * Inherited from Sun's java.util.Enumeration interface.
    *
    * @return The next element of this enumeration.
    *
    * @exception NoSuchElementException Thrown if no more elements exist. 
    */
   public Object nextElement
   (
   )
   throws NoSuchElementException
   {
      String attrId = (String)this.enum.nextElement();

      try
      {
        return this.attributes.get(attrId);
      }
      catch (SessionException e)
      {
         throw new NoSuchElementException();
      }
   }

   /**
    * @internal
    *
    * Returns a session attribute for the next element in the
    * enumeration.
    * 
    * @return A session attribute for the next element.
    *
    * @exception NoSuchElementException Thrown if no more elements exist. 
    */
   public SessionAttr next
   (
   )
   throws NoSuchElementException
   {
      return ((SessionAttr)nextElement());
   }

   /**
    * @internal
    *
    * Returns an array of session attributes for the next batchSize
    * elements in the enumeration. If there are not batchSize elements
    * in the enumeration only those elements retrieved will be returned.
    *
    * @param batchSize The number of elements to return.
    *
    * @return An array containing the session attributes.
    */
   public SessionAttr[] next
   (
      int batchSize
   )
   {
      SessionAttr[] batch = new SessionAttr[(int) batchSize];

      try
      {
         for (int i = 0; i < batchSize; i++)
            batch[i] = next();
      }
      catch (NoSuchElementException e)
      {
         if (I_DEBUG)
         {
            Debug.ignoreException(e);
         }
      }

      return batch;
   }
}

