/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/SessionManager.java $
  $Revision: 8 $
  $Modtime: 6/23/99 3:02p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

/**
 * Provides a single interface under which various session providers can be
 * abstracted. SessionManager provides for a collection of packages using
 * one manager to tie the various abstracted session providers together. It
 * is a top-level session that is responsible for loading and managing
 * initial providers.
 *
 * <p>As a Factory, SessionManager tries to construct each InitialSessionFactory
 * that is listed in com.novell.service.session.spi.InitialSessionFactory
 * (via passed environment). Otherwise, it behaves just like any other
 * session.
 */
public interface SessionManager extends Session
{
   /**
    * Scope the session manager was created in.
    *
    * <p>(SCOPE_ATTR_ID =  "SCOPE")
    *
    * @see  SessionAttr
    * @see  #getAttributes
    */
   public static final String SCOPE_ATTR_ID = "SCOPE";

   /**
    * The Domain name for SessionManager Sessions.
    *
    * <p>(SESSION_MANAGER = "com.novell.service.session.SessionManager")
    *
    * @see SessionAttr
    */
   public static final String SESSION_MANAGER =
      "com.novell.service.session.SessionManager";
}

