/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/bindery/BinderyServerPersistenceService.java $
  $Revision: 10 $
  $Modtime: 4/04/99 5:28p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.bindery;

import com.novell.service.session.Session;
import com.novell.service.session.xplat.PersistenceService;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.SessionException;

/**@internal
 *
 */
public class BinderyServerPersistenceService
implements PersistenceService
{
   SessionImpl session;

   BinderyServerPersistenceService
   (
      SessionImpl session
   )
   {
      this.session = session;
   }

   public void persist
   (
   )
   throws SessionException
   {
      BinderyServerSessionState state = (BinderyServerSessionState)session.getState();
      state.connection.keep();
   }

   private void desist
   (
   )
   throws SessionException
   {
      BinderyServerSessionState state = (BinderyServerSessionState)session.getState();
      Session parent = session.getParent();
      InvalidSessionState.makeInvalid(
         (SessionImpl)session,
         new SessionException("BinderyServerPersistenceService.desist() called"));
//      parent.invalidate(session);
      Connection connection = state.connection;
      session.close();
      connection.closeRef();
      parent.validateLinks();
   }
}



