/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/CallsServiceRemote.java $
  $Revision: 10 $
  $Modtime: 9/16/99 11:25a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import com.novell.service.session.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import java.io.Serializable;

/** @internal
 * Object returned by Session.getService()
 */
public interface CallsServiceRemote extends SessionServiceRemote
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.session.xplat.CallsServiceRemote.4655434B01";
   public static final String KEY =
"com.novell.service.session.xplat.CallsServiceRemote.1239078123";

   public String getObjectName
   (
      int objectId,
      IntegerBuffer type
   )
   throws SessionException, java.rmi.RemoteException;

   public void freePtr(int mallocedPtr)
   throws SessionException, java.rmi.RemoteException;

   public int allocEAHandle()
   throws SessionException, java.rmi.RemoteException;

   public int allocEAFFStruct()
   throws SessionException, java.rmi.RemoteException;

   public void addObjectToSet
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
      )
   throws SessionException, java.rmi.RemoteException;

   public void changeObjectSecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
      )
   throws SessionException, java.rmi.RemoteException;

   public void changePropertySecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String propertyName,
      /*in*/   int   newPropertySecurity
      )

   throws SessionException, java.rmi.RemoteException;

   public void closeBindery ()

   throws SessionException, java.rmi.RemoteException;

   public void createObject
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity
      )
   throws SessionException, java.rmi.RemoteException;

   public void createProperty
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
      )
   throws SessionException, java.rmi.RemoteException;
   public void deleteObject
      (
      /*in */  String objName,
      /*in*/   int objType
      )

   throws SessionException, java.rmi.RemoteException;

   public void deleteObjectFromSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )

   throws SessionException, java.rmi.RemoteException;

   public void disallowObjectPassword
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )

   throws SessionException, java.rmi.RemoteException;

   public BinderyAccessLevel getBinderyAccessLevel
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public ObjectDiskSpaceLeft getObjectDiskSpaceLeft
   (
      /*in*/   int           objID
   )
   throws SessionException, java.rmi.RemoteException;

   public IntegerBuffer getObjectID
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException;

   public void isObjectInSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException;

   public void openBindery()

   throws SessionException, java.rmi.RemoteException;

   public PropertyValue readPropertyValue
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         propertyName,
      /*in*/   int            segmentNum
   )
   throws SessionException, java.rmi.RemoteException;

   public void renameObject
   (
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType
   )
   throws SessionException, java.rmi.RemoteException;

   public BinderyObject scanObject
   (
      /*in*/      String         searchName,
      /*in*/      int            searchType
   )
   throws SessionException, java.rmi.RemoteException;

   public BinderyObjectProperty scanProperty
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         searchPropertyName,
      /*in*/   int            iterHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void writePropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException, java.rmi.RemoteException;

   public void getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException, java.rmi.RemoteException;

   public void getVolumeName
   (
      int volNumber,
      String[] volName  // return a new string in first element
   )
   throws SessionException, java.rmi.RemoteException;

   public void getVolumeNumber
   (
      String volName,
      int[] volNumber   // return vol number in first element
   )
   throws SessionException, java.rmi.RemoteException;

   public void getNSLoadedList
   (
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   )
   throws SessionException, java.rmi.RemoteException;

   public void openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )
   throws SessionException, java.rmi.RemoteException;

   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )
   throws SessionException, java.rmi.RemoteException;

   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void closeEA
   (
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void readEA
   (
      int EAHandle,
      byte[] buf,
      int off,
      int len,
      int[] totalEASize,
      int[] bytesRead
   )
   throws SessionException, java.rmi.RemoteException;

   public void writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   )
   throws SessionException, java.rmi.RemoteException;

   public void findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException, java.rmi.RemoteException;

   public void findNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException, java.rmi.RemoteException;

   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public void scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorImpl tEnum
   )
   throws SessionException, java.rmi.RemoteException;

   public void getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   )
   throws SessionException, java.rmi.RemoteException;

   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException, java.rmi.RemoteException;

   public void setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   )
   throws SessionException, java.rmi.RemoteException;

   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException, java.rmi.RemoteException;

   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'data' array must be 512 bytes long
   public void readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // output parameter
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'data' array must be 512 bytes long
   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException, java.rmi.RemoteException;

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   public void getVolumeInfoWithNumber
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   public void getExtendedVolumeInfo
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   public void getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   public void getDiskUtilization
   (
      int objID,
      int volNum,
      VolumeUtilization data
   )
   throws SessionException, java.rmi.RemoteException;

   public void getObjDiskRestrictions
   (
      int volNumber,
      int objectId,
      VolumeRestriction data
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanVolDiskRestrictions2
   (
      int volNumber,
      VolumeRestrictionEnumeratorImpl data
   )
   throws SessionException, java.rmi.RemoteException;

   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException, java.rmi.RemoteException;

   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException, java.rmi.RemoteException;

   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanMountedVolumes
   (
      int startVolNumber,
      int[][] numbers,
      String[][] names,    // return new array of vol names in first elem.
      int[] nextVolNumber  // return next vol number in first element
   )
   throws SessionException, java.rmi.RemoteException;

   public void allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException, java.rmi.RemoteException;

   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException, java.rmi.RemoteException;

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException, java.rmi.RemoteException;

   public void getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   )
   throws SessionException, java.rmi.RemoteException;

   public void getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   )
   throws SessionException, java.rmi.RemoteException;

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      String extensionName
   )
   throws SessionException, java.rmi.RemoteException;

   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException;

   public Object[] ncpExtensionRequest
   (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength
   )
   throws SessionException, java.rmi.RemoteException;

   public NCPExtensionInfoImpl scanNCPExtensions
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException;

   public void createQueueFile2
      (
      int            queueID,
      NWQueueJob     job,
      IntegerBuffer  fileHandle
      )

   throws SessionException, java.rmi.RemoteException;

   public void closeFileAndAbortQueueJob2
      (
      int   queueID,
      int   jobNumber,
      int   fileHandle
      )

   throws SessionException, java.rmi.RemoteException;

   public void closeFileAndStartQueueJob2
      (
      int   queueID,
      int   jobNumber,
      int   fileHandle
      )

   throws SessionException, java.rmi.RemoteException;

   public void abortServicingQueueJob2
      (
      int   QueueID,
      int   JobNumber,
      int   fileHandle
      )
   throws SessionException, java.rmi.RemoteException;

   public void changeQueueJobEntry2
      (
      int queueID,
      NWQueueJob   job
      )

   throws SessionException, java.rmi.RemoteException;

   public void changeQueueJobPosition2
      (
      int queueID,
      int jobNumber,
      int newJobPos
      )

   throws SessionException, java.rmi.RemoteException;
   public void getQueueJobList2
      (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
      )

   throws SessionException, java.rmi.RemoteException;

/*
   public void readQueueCurrentSessionAttrSet2
      (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
      )
   throws SessionException, java.rmi.RemoteException;
*/

   public QueueCurrentStatus readQueueCurrentStatus2
   (
         /*in*/   int   queueID
   )
   throws SessionException, java.rmi.RemoteException;

   public void readQueueJobEntry2
      (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
      )

   throws SessionException, java.rmi.RemoteException;

   public void removeJobFromQueue2
      (
      int queueID,
      int jobNumber
      )

   throws SessionException, java.rmi.RemoteException;

/*
   public void setQueueCurrentSessionAttrSet2
      (
      int queueID,
      int queueSessionAttrSet
      )
   throws SessionException, java.rmi.RemoteException;
*/

   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
      throws SessionException, java.rmi.RemoteException;

   public void createQueue
      (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path,
      IntegerBuffer queueID
      )
   throws SessionException, java.rmi.RemoteException;

   public void destroyQueue
      (
      int queueID
      )
   throws SessionException, java.rmi.RemoteException;

   public void getQueueJobFileSize2
      (
      int queueID,
      int jobNumber,
      IntegerBuffer fileSize
      )

/* *************************************************************************
* Server natives
****************************************************************************/

   throws SessionException, java.rmi.RemoteException;

   public void getFileServerVersionInfo
      (
      CVersionInfo info
      )

   throws SessionException, java.rmi.RemoteException;

   public void getFileServerInfo
      (
      CNWFSEFileServerInfo info
      )
   throws SessionException, java.rmi.RemoteException;

   public void getFileServerLoginStatus
      (
      BooleanBuffer info
      )
   throws SessionException, java.rmi.RemoteException;

   public void loadNLM(String loadCommand)
   throws SessionException, java.rmi.RemoteException;

   public void unloadNLM(String NLMName)
   throws SessionException, java.rmi.RemoteException;

   public void getFileServerDescription
      (
      StringBuffer companyName,
      StringBuffer revision,
      StringBuffer revisionDate,
      StringBuffer copyrightNotice
      )
   throws SessionException, java.rmi.RemoteException;

   public void getFileServerDateAndTime
      (
      Object[] holder //holder is a one element array
      )
   throws SessionException, java.rmi.RemoteException;

   public void setFileServerDateAndTime
      (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
      )
   throws SessionException, java.rmi.RemoteException;

  /** 
   * @internal
   */
   public class BinderyAccessLevel implements Serializable
   {
      public IntegerBuffer accessLevel;
      public IntegerBuffer objID;

      public BinderyAccessLevel
      (
      )
      {
         accessLevel  = new IntegerBuffer();
         objID        = new IntegerBuffer();
      }
   }

  /** 
   * @internal
   */
   public class ObjectDiskSpaceLeft implements Serializable
   {
      public IntegerBuffer systemElapsedTime;
      public IntegerBuffer unusedDiskBlocks;
      public IntegerBuffer restrictionEnforced;

      public ObjectDiskSpaceLeft
      (
      )
      {
         systemElapsedTime     = new IntegerBuffer();
         unusedDiskBlocks      = new IntegerBuffer();
         restrictionEnforced   = new IntegerBuffer();
      }
   }

  /** 
   * @internal
   */
   public class PropertyValue implements Serializable
   {
      public byte[]        segmentData;
      public IntegerBuffer moreSegments;
      public IntegerBuffer flags;

      public PropertyValue
      (
      )
      {
         segmentData  = new byte[129];
         moreSegments = new IntegerBuffer();
         flags        = new IntegerBuffer();
      }
   }

  /** 
   * @internal
   */
   public class BinderyObject implements Serializable
   {
      public IntegerBuffer  objID;
      public StringBuffer   objName;
      public IntegerBuffer  objType;
      public IntegerBuffer  hasPropertiesFlag;
      public IntegerBuffer  objFlags;
      public IntegerBuffer  objSecurity;

      public BinderyObject
      (
      )
      {
         objID              = new IntegerBuffer();
         objName            = new StringBuffer();
         objType            = new IntegerBuffer();
         hasPropertiesFlag  = new IntegerBuffer();
         objFlags           = new IntegerBuffer();
         objSecurity        = new IntegerBuffer();
      }
   }

  /** 
   * @internal
   */
   public class BinderyObjectTrusteePath implements Serializable
   {
      IntegerBuffer iterHandle;
      StringBuffer dirPath;

      public BinderyObjectTrusteePath
      (
      )
      {
         iterHandle = new IntegerBuffer();
         dirPath = new StringBuffer();
      }
   }

  /** 
   * @internal
   */
   public class BinderyObjectProperty implements Serializable
   {
      public IntegerBuffer  iterHandle;
      public StringBuffer   propertyName;
      public IntegerBuffer  propertyFlags;
      public IntegerBuffer  propertySecurity;
      public IntegerBuffer  valueAvailable;
      public IntegerBuffer  moreFlag;

      public BinderyObjectProperty
      (
      )
      {
         iterHandle        = new IntegerBuffer();
         propertyName      = new StringBuffer();
         propertyFlags     = new IntegerBuffer();
         propertySecurity  = new IntegerBuffer();
         valueAvailable    = new IntegerBuffer();
         moreFlag          = new IntegerBuffer();
      }
   }

  /** 
   * @internal
   */
   public class QueueCurrentStatus implements Serializable
   {
      IntegerBuffer  queueStatus;
      IntegerBuffer  numberOfJobs;
      IntegerBuffer  numberOfServers;
      int[]          serverIDlist;
      int[]          serverConnList;

      public QueueCurrentStatus
      (
      )
      {
         queueStatus       = new IntegerBuffer();
         numberOfJobs      = new IntegerBuffer();
         numberOfServers   = new IntegerBuffer();
         serverIDlist      = new int[25];
         serverConnList    = new int[25];
      }
   }
}
