/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/CallsServiceRemoteImpl.java $
  $Revision: 13 $
  $Modtime: 1/28/00 1:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.jncpv2.cal.*;
import com.novell.service.session.*;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import java.io.Serializable;
import com.novell.service.session.xplat.CallsServiceRemote.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class CallsServiceRemoteImpl
extends java.rmi.server.UnicastRemoteObject
implements CallsServiceRemote
{
   Connection conn;
   int connection;

   /**
    */
   public CallsServiceRemoteImpl
   (
      Connection conn
   )
   throws SessionException, java.rmi.RemoteException
   {
      // Important: get connection for performance but also keep
      // conn so object doesn't go out of scope.
      connection = conn.getHandle();
   }

   /**
    */
   public String getObjectName
   (
      int objectId,
      IntegerBuffer type
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer name = new StringBuffer();
      int ccode = CalJNI.NWGetObjectName(
         connection,
         objectId,
         name,
         type);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return name.toString();
   }

   /**
    */
   public void freePtr(int mallocedPtr)
   throws SessionException, java.rmi.RemoteException
   {
      CalJNI.freePtr(mallocedPtr);
   }

   /**
    */
   public int allocEAHandle()
   throws SessionException, java.rmi.RemoteException
   {
      return CalJNI.allocEAHandle();
   }

   /**
    */
   public int allocEAFFStruct()
   throws SessionException, java.rmi.RemoteException
   {
      return CalJNI.allocEAFFStruct();
   }

   /**
    */
   public void addObjectToSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAddObjectToSet(
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);

      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changeObjectSecurity
   (
      /*in*/   String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeObjectSecurity(
         connection,
         objName,
         objType,
         newObjSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changePropertySecurity
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      newPropertySecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangePropertySecurity(
         connection,
         objName,
         objType,
         propertyName,
         newPropertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeBindery ()
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseBindery(connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void createObject
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   int      objFlags,
      /*in*/   int      objSecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateObject (
         connection,
         objName,
         objType,
         objFlags,
         objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void createProperty
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateProperty (
         connection,
         objName,
         objType,
         propertyName,
         propertyFlags,
         propertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   /**
    */
   public void deleteObject
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteObject(
         connection,
         objName,
         objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteObjectFromSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteObjectFromSet (
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteProperty
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteProperty (
         connection,
         objName,
         objType,
         propertyName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void disallowObjectPassword
   (
      /*in*/   String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDisallowObjectPassword (
         connection,
         objName,
         objType,
         disallowedPassword);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public BinderyAccessLevel getBinderyAccessLevel
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      BinderyAccessLevel x = new BinderyAccessLevel();
      int ccode = CalJNI.NWGetBinderyAccessLevel (
         connection,
         x.accessLevel,
         x.objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public ObjectDiskSpaceLeft getObjectDiskSpaceLeft
   (
      /*in*/   int           objID
   )
   throws SessionException, java.rmi.RemoteException
   {
      ObjectDiskSpaceLeft x = new ObjectDiskSpaceLeft();
      int ccode = CalJNI. NWGetObjectDiskSpaceLeft (
         connection,
         objID,
         x.systemElapsedTime,
         x.unusedDiskBlocks,
         x.restrictionEnforced);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public IntegerBuffer getObjectID
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer objID = new IntegerBuffer();
      int ccode = CalJNI.NWGetObjectID (
         connection,
         objName,
         objType,
         objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return objID;
   }

   /**
    */
   public void isObjectInSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWIsObjectInSet (
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openBindery
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenBindery(connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public PropertyValue readPropertyValue
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         propertyName,
      /*in*/   int            segmentNum
   )
   throws SessionException, java.rmi.RemoteException
   {
      PropertyValue x = new PropertyValue();
      int ccode = CalJNI.NWReadPropertyValue(
         connection,
         objName,
         objType,
         propertyName,
         segmentNum,
         x.segmentData,
         x.moreSegments,
         x.flags);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public void renameObject
   (
      /*in*/   String   oldObjName,
      /*in*/   String   newObjName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRenameObject(
         connection,
         oldObjName,
         newObjName,
         objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public BinderyObject scanObject
   (
      /*in*/      String         searchName,
      /*in*/      int            searchType
   )
   // the rights are not returned through this API because the NCP does
   //   not support the rights because it was written for the 2.x rights
   //   scheme.  To get a valid rights mask for the path, call the
   //   NWScanForTrustees method in this class.
   throws SessionException, java.rmi.RemoteException
   {
      BinderyObject x = new BinderyObject();
      int ccode = CalJNI.NWScanObject(
         connection,
         searchName,
         searchType,
         x.objID,
         x.objName,
         x.objType,
         x.hasPropertiesFlag,
         x.objFlags,
         x.objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public BinderyObjectProperty scanProperty
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         searchPropertyName,
      /*in*/   int            iterHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      BinderyObjectProperty x = new BinderyObjectProperty();
      x.iterHandle.setValue(iterHandle);
      int ccode = CalJNI.NWScanProperty(
         connection,
         objName,
         objType,
         searchPropertyName,
         x.iterHandle,
         x.propertyName,
         x.propertyFlags,
         x.propertySecurity,
         x.valueAvailable,
         x.moreFlag);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public void writePropertyValue
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWritePropertyValue(
         connection,
         objName,
         objType,
         propertyName,
         segmentNum,
         segmentData, //128 byte bu
         moreSegments);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetNSEntryInfo(
         connection,
         dirHandle,
         path,
         srcNamSpc,
         dstNamSpc,
         attributes,
         retInfoMask,
         entryInfo);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanNSEntryInfo(
         connection,
         dirHandle,
         nameSpace,
         attr,
         volNumber,
         dirNumber,
         searchDirNumber,
         pattern,
         retInfoMask,
         entryInfo);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getVolumeName
   (
      int volNumber,
      String[] volName  // return a new string in first element
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetVolumeName(
         connection,
         volNumber,
         volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getVolumeNumber
   (
      String volName,
      int[] volNumber   // return vol number in first element
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetVolumeNumber(
         connection,
         volName,
         volNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getNSLoadedList
   (
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetNSLoadedList(
         connection,
         volNumber,
         NSLoadedList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenCreateNSEntry(
         connection,
         dirHandle,
         path,
         nameSpace,
         openCreateMode,
         searchSessionAttrSet,
         createSessionAttrSet,
         accessRights,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenNSEntry(
         connection,
         dirHandle,
         nameSpace,
         dataStream,
         path,
         openCreateMode,
         searchSessionAttrSet,
         createSessionAttrSet,
         accessRights,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteNSEntry(
         connection,
         dirHandle,
         filePath,
         nameSpace,
         searchAttr);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWNSRename(
         connection,
         dirHandle,
         nameSpace,
         oldName,
         isFile,
         newName,
         renameInAllNS);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenEA(
         connection,
         dirHandle,
         path,
         EAName,
         nameSpace,
         EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeEA
   (
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseEA(EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void readEA
   (
      int EAHandle,
      byte[] buf,
      int off,
      int len,
      int[] totalEASize,
      int[] bytesRead
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadEA(
         EAHandle,
         buf,
         off,
         len,
         totalEASize,
         bytesRead);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWriteEA(
         EAHandle,
         totalWriteSize,
         buf,
         off,
         len,
         bytesWritten);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWFindFirstEA(
         connection,
         dirHandle,
         path,
         dstNamSpc,
         EAFFStruct,
         EAHandle,
         EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void findNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWFindNextEA(
         EAFFStruct,
         EAHandle,
         EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   /**
    */
   public void scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorImpl tEnum
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanForTrustees(
         connection,
         dirHandle,
         path,
         nameSpace,
         tEnum);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetDirSpaceLimitList(
         connection,
         dirHandle,
         path,
         nameSpace,
         maxAvailable,
         currentUse);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetDirSpaceLimit(
         connection,
         dirHandle,
         path,
         nameSpace,
         limit);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetCompressedFileSize(
         connection,
         OSFileHandle,
         desiredSize,
         actualSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAddTrustee(
         connection,
         dirHandle,
         path,
         nameSpace,
         objID,
         rightsMask);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteTrustee(
         connection,
         dirHandle,
         path,
         nameSpace,
         objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
/*
      int ccode = CalJNI.NWGetNSInfo(
         connection,
         volume,
         nameSpace,
         info);
      if (0!= ccode)
*/
      int ccode = 0;
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'data' array must be 512 bytes long
   /**
    */
   public void readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // output parameter
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         NSInfoBitMask,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'data' array must be 512 bytes long
   /**
    */
   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWriteNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         NSInfoBitMask,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   /**
    */
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadExtendedNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         extendedBitMask,
         hugeStateInfo,
         hugeDataLength,   // output paramete
         hugeData );        // output paramete


      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   /**
    */
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWriteExtendedNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         extendedBitMask,
         hugeStateInfo,
         hugeDataLength,
         hugeData,
         offset);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   /**
    */
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetNSEntryDOSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         searchAttr,
         modifyMask,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getVolumeInfoWithNumber
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetVolumeInfoWithNumber(
         connection,
         volNumber,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getExtendedVolumeInfo
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetExtendedVolumeInfo(
         connection,
         volNumber,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetDirSpaceInfo(
         connection,
         volNumber,
         path,
         nameSpace,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   /**
    */
   public void getDiskUtilization
   (
      int objID,
      int volNum,
      VolumeUtilization data
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetDiskUtilization(
         connection,
         objID,
         volNum,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getObjDiskRestrictions
   (
      int volNumber,
      int objectId,
      VolumeRestriction data
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetObjDiskRestrictions(
         connection,
         volNumber,
         objectId,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanVolDiskRestrictions2
   (
      int volNumber,
      VolumeRestrictionEnumeratorImpl data
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanVolDiskRestrictions2(
         connection,
         volNumber,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRemoveObjectDiskRestrictions(
         connection,
         volNumber,
         objectId);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetObjectVolSpaceLimit(
         connection,
         volNumber,
         objectId,
         restriction);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMMountVolume(
         connection,
         volName,
         volNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMDismountVolumeByName(
         connection,
         volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanMountedVolumes
   (
      int startVolNumber,
      int[][] numbers,
      String[][] names,    // return new array of vol names in first elem.
      int[] nextVolNumber  // return next vol number in first element
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanMountedVolumes(
            this.connection,
            startVolNumber,
            numbers,
            names,
            nextVolNumber);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAllocTempNSDirHandle(
            this.connection,
            dirHandle,
            path,
            srcNameSpace,
            dstNameSpace,
            newDirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeallocateDirectoryHandle(
            this.connection,
            dirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanForDeletedFiles(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            info);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWPurgeDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   /**
    */
   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRecoverDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName,
            newFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetEffectiveRights(
            this.connection,
            dirHandle,
            path,
            nameSpace,
            effectiveRights);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetObjectEffectiveRights(
            connection,
            objID,
            dirHandle,
            path,
            nameSpace,
            rights);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWScanObjectTrusteePaths(
            connection,
            objID,
            volNumber,
            nameSpace,
            iterHandle,
            rights,
            path);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      String s = path[0].replace(':', '/');
      s = s.replace('\\', '/');

      path[0] = s;
   }

   /**
    */
   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      String extensionName
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(extensionName);
      int ccode = CalJNI.NWGetNCPExtensionInfoByName(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return extension;
   }

   /**
    */
   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(id);
      int ccode = CalJNI.NWGetNCPExtensionInfoByName(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return extension;
   }

   /**
    */
   public Object[] ncpExtensionRequest
   (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength
   )
   throws SessionException, java.rmi.RemoteException
   {
      Object[] replyHolder = new Object[1];
      int ccode = CalJNI.NWNCPExtensionRequest(
         connection,
         extensionID,
         request,
         maxReplyLength,
         replyHolder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return replyHolder;
   }

   /**
    */
   public NCPExtensionInfoImpl scanNCPExtensions
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(id);
      int ccode = CalJNI.NWScanNCPExtensions(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return(extension);
   }

   /**
    */
   public void createQueueFile2
   (
      int            queueID,
      NWQueueJob     job,
      IntegerBuffer  fileHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateQueueFile2(
         connection,
         queueID,
         job,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeFileAndAbortQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseFileAndAbortQueueJob2(
         connection,
         queueID,
         jobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeFileAndStartQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseFileAndStartQueueJob2(
         connection,
         queueID,
         jobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void abortServicingQueueJob2
   (
      int   QueueID,
      int   JobNumber,
      int   fileHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAbortServicingQueueJob2(
         connection,
         QueueID,
         JobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changeQueueJobEntry2
   (
      int queueID,
      NWQueueJob   job
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeQueueJobEntry2(
         connection,
         queueID,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changeQueueJobPosition2
   (
      int queueID,
      int jobNumber,
      int newJobPos
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeQueueJobPosition2(
         connection,
         queueID,
         jobNumber,
         newJobPos);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   /**
    */
   public void getQueueJobList2
   (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetQueueJobList2(
         connection,
         queueID,
         queueStartPos,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/*
   public void readQueueCurrentSessionAttrSet2
   (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadQueueCurrentSessionAttrSet2(
                                                  connection,
                                                  queueID,
                                                  queueSessionAttrSet,
                                                  numberOfJobs,
                                                  numberOfServers,
                                                  serverIDlist,
                                                  serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   /**
    */
   public QueueCurrentStatus readQueueCurrentStatus2
   (
         /*in*/   int   queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      QueueCurrentStatus x = new QueueCurrentStatus();
      int ccode = CalJNI.NWReadQueueCurrentStatus2 (
         connection,
         queueID,
         x.queueStatus,
         x.numberOfJobs,
         x.numberOfServers,
         x.serverIDlist,
         x.serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }


   /**
    */
   public void readQueueJobEntry2
   (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadQueueJobEntry2(
         connection,
         queueID,
         jobNumber,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void removeJobFromQueue2
   (
      int queueID,
      int jobNumber
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRemoveJobFromQueue2(
         connection,
         queueID,
         jobNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/*
   public void setQueueCurrentSessionAttrSet2
   (
      int queueID,
      int queueSessionAttrSet
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetQueueCurrentSessionAttrSet2(
                                                 connection,
                                                 queueID,
                                                 queueSessionAttrSet);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   /**
    */
   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetQueueCurrentStatus2(
         connection,
         queueID,
         queueStatus);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void createQueue
   (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path,
      IntegerBuffer queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateQueue(
         connection,
         queueName,
         queueType,
         dirPath,
         path,
         queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void destroyQueue
   (
      int queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDestroyQueue(
         connection,
         queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getQueueJobFileSize2
   (
      int queueID,
      int jobNumber,
      IntegerBuffer fileSize
   )

/* *************************************************************************
* Server natives
****************************************************************************/

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetQueueJobFileSize2(
         connection,
         queueID,
         jobNumber,
         fileSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getFileServerVersionInfo
   (
      CVersionInfo info
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetFileServerVersionInfo(
         connection,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getFileServerInfo
   (
      CNWFSEFileServerInfo info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetFileServerInfo(
         connection,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getFileServerLoginStatus
   (
      BooleanBuffer info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetFileServerLoginStatus(
         connection, info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void loadNLM(String loadCommand)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMLoadNLM(connection, loadCommand);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void unloadNLM(String NLMName)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMUnloadNLM(connection, NLMName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getFileServerDescription
   (
      StringBuffer companyName,
      StringBuffer revision,
      StringBuffer revisionDate,
      StringBuffer copyrightNotice
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetFileServerDescription(
         connection,
         companyName,
         revision,
         revisionDate,
         copyrightNotice);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getFileServerDateAndTime
   (
      Object[] holder //holder is a one element array
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetFileServerDateAndTime(
         connection,
         holder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void setFileServerDateAndTime
   (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetFileServerDateAndTime(
         connection,
         year,
         month,
         day,
         hour,
         minute,
         second);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
}



