/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/SemaphoreServiceImpl.java $
  $Revision: 1 $
  $Modtime: 4/17/00 11:41a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.jncpv2.cal.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class SemaphoreServiceImpl
implements SemaphoreService
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   Connection conn;
   int connection;

   public SemaphoreServiceImpl
   (
      Connection connection
   )
   throws SessionException
   {
      conn = connection;
      this.connection = conn.getHandle(); //NOTE:this needs to be fixed
   }

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      int ccode = CalJNI.NWOpenSemaphore(
                     connection,
                     semaphoreName,
                     resourceAccessCount,
                     semaphoreHandle,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      int ccode = CalJNI.NWExamineSemaphore(
                     connection,
                     semaphoreHandle,
                     semaphoreValue,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException
   {
      int ccode = CalJNI.NWWaitOnSemaphore(
         connection,
         semaphoreHandle,
         timeOutValue);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException
   {
      int ccode = CalJNI.NWSignalSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException
   {
      int ccode = CalJNI.NWCloseSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
}



