/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/Shibboleth.java $
  $Revision: 9 $
  $Modtime: 3/20/03 5:54p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.security.NdsIdentity;
import com.novell.service.session.SessionService;
import com.novell.service.session.SessionException;

/**@internal
 * @deprecated Use com.novell.service.security and related packages.
 *
 * Shibboleth is a word used with literary license to describe a password
 * service.
 *
 * From Hebrew literature: a word used by the Gileadites as a test to detect
 * the fleeing Ephraimites, who could not pronounce the sound sh
 * (Judges 12:46)
 */
public interface Shibboleth extends SessionService
{
   /*
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   protected static final String KEY =
//"com.novell.service.session.xplat.Shibboleth.534154414E" ;

   public void changePassword
   (
      String userName,
      String oldPassword,
      String newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException;

   public void setPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException;

   public void verifyPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException;

   public void authenticate
   (
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException;

   public void authenticateNAS
   (
      NdsIdentity ident,
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException;

   public void authenticateService
   (
      String serviceName
   )
   throws SessionException;

   public void unauthenticate
   (
   )
   throws SessionException;

   public void unauthenticateNAS
   (
      NdsIdentity ident
   )
   throws SessionException;
}
