/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.handlers.DataContentHandlerFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public class AttachmentPartImpl
extends AttachmentPart {
    private DataHandler _handler;
    private final MimeHeaders _headers = new MimeHeaders();

    public AttachmentPartImpl() {
    }

    public AttachmentPartImpl(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this._handler = dataHandler;
        this.setMimeHeader("Content-Type", this._handler.getContentType());
    }

    public AttachmentPartImpl(Object object, String string) {
        this._handler = new DataHandler(object, string);
        this.setMimeHeader("Content-Type", string);
    }

    public void addMimeHeader(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Header name must be specified");
        }
        this._headers.addHeader(string, string2);
    }

    public void clearContent() {
        this._handler = null;
    }

    public Iterator getAllMimeHeaders() {
        return this._headers.getAllHeaders();
    }

    public Object getContent() throws SOAPException {
        if (this._handler == null) {
            throw new SOAPException("Error: No DataHandler specified");
        }
        try {
            return this._handler.getContent();
        }
        catch (IOException iOException) {
            throw new SOAPException("Error: " + iOException.getMessage());
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this._handler == null) {
            throw new SOAPException("Error: No DataHandler specified");
        }
        return this._handler;
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this._headers.getMatchingHeaders(stringArray);
    }

    public String[] getMimeHeader(String string) {
        return this._headers.getHeader(string);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this._headers.getNonMatchingHeaders(stringArray);
    }

    public int getSize() throws SOAPException {
        if (this._handler == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this._handler.writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SOAPException("Error: " + iOException.getMessage());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray != null ? byArray.length : -1;
    }

    public void removeAllMimeHeaders() {
        this._headers.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this._headers.removeHeader(string);
    }

    public void setContent(Object object, String string) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Content-Type cannot be null");
        }
        this._handler = new DataHandler(object, string);
        if (this._handler == null) {
            throw new IllegalArgumentException("Either the content or type is invalid");
        }
        this.setMimeHeader("Content-Type", string);
    }

    public void setDataHandler(DataHandler dataHandler) throws IllegalArgumentException {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this._handler = dataHandler;
        this.setMimeHeader("Content-Type", this._handler.getContentType());
    }

    public void setMimeHeader(String string, String string2) throws IllegalArgumentException {
        this._headers.setHeader(string, string2);
    }

    protected boolean hasHeaders(MimeHeaders mimeHeaders) throws IllegalArgumentException {
        if (mimeHeaders == null) {
            throw new IllegalArgumentException("Error: No headers specified.");
        }
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            if (this.hasHeader((MimeHeader)iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasHeader(MimeHeader mimeHeader) throws IllegalArgumentException {
        if (mimeHeader == null) {
            throw new IllegalArgumentException("Error: No header specified.");
        }
        String[] stringArray = this._headers.getHeader(mimeHeader.getName());
        if (stringArray == null) {
            return false;
        }
        String string = mimeHeader.getValue();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) break;
            ++n;
        }
        return n != stringArray.length;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this._handler != null) {
            this._handler.writeTo(outputStream);
        }
    }

    static {
        try {
            DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)new DataContentHandlerFactoryImpl());
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

