/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.NameImpl;
import com.sssw.jbroker.saaj.soap.SOAPBodyElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPEnvelopeImpl;
import com.sssw.jbroker.saaj.soap.SOAPFaultImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

public class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    private SOAPFault _fault = null;
    private static final byte[] _openclose = "<SOAP-ENV:Body/>".getBytes();
    private static final byte[] _open = "<SOAP-ENV:Body>".getBytes();
    private static final byte[] _close = "</SOAP-ENV:Body>".getBytes();

    public SOAPBodyImpl() throws SOAPException {
        super((Name)new NameImpl("body"));
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        if (name == null) {
            throw new SOAPException("Name must be specified.");
        }
        if (this._fault != null) {
            throw new SOAPException("Error: A SOAPFault already exists.");
        }
        SOAPBodyElementImpl sOAPBodyElementImpl = new SOAPBodyElementImpl(name);
        this.addChildElement(sOAPBodyElementImpl);
        return sOAPBodyElementImpl;
    }

    public SOAPBodyElement addBodyElement(NameImpl nameImpl) throws SOAPException {
        return this.addBodyElement((Name)nameImpl);
    }

    public SOAPFault addFault() throws SOAPException {
        if (this._fault != null) {
            throw new SOAPException("Fault already exists");
        }
        if (this.getChildElements().hasNext()) {
            throw new SOAPException("1 or more SOAPBodyElements already exist");
        }
        this._fault = new SOAPFaultImpl();
        this.addChildElement(this._fault);
        return this._fault;
    }

    public SOAPFault getFault() {
        return this._fault;
    }

    public boolean hasFault() {
        return this._fault != null;
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Iterator iterator = this.getChildElements();
        if (iterator.hasNext()) {
            outputStream.write(_open);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SOAPFaultImpl) {
                    ((SOAPFaultImpl)e).writeTo(outputStream);
                    continue;
                }
                ((SOAPElementImpl)e).writeTo(outputStream);
            }
            outputStream.write(_close);
        } else {
            outputStream.write(_openclose);
        }
    }

    protected void removeFault() {
        this._fault = null;
    }

    public void detachNode() {
        SOAPElement sOAPElement = this.getParentElement();
        super.detachNode();
        if (sOAPElement instanceof SOAPEnvelopeImpl) {
            ((SOAPEnvelopeImpl)sOAPElement).removeBody();
        }
    }
}

