/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.soap.SOAPMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPConnectionImpl
extends SOAPConnection {
    private URL _url = null;
    private boolean isClosed = false;

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        if (this.isClosed) {
            throw new SOAPException("The connection is closed.");
        }
        if (object instanceof String) {
            try {
                this._url = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SOAPException((String)object + " is not a URL.");
            }
        } else if (object instanceof URL) {
            this._url = (URL)object;
        } else {
            throw new SOAPException("The spcecified endpoint is invalid");
        }
        return this.sendP2P(sOAPMessage);
    }

    public void close() throws SOAPException {
        if (this.isClosed) {
            throw new SOAPException("Connection already closed");
        }
        this.isClosed = true;
    }

    private SOAPMessage sendP2P(SOAPMessage sOAPMessage) throws SOAPException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            String[] stringArray;
            httpURLConnection = (HttpURLConnection)this._url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            HttpURLConnection.setFollowRedirects(true);
            if (sOAPMessage.saveRequired()) {
                sOAPMessage.saveChanges();
            }
            MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                object = stringArray.getName();
                String[] stringArray2 = mimeHeaders.getHeader((String)object);
                if (stringArray2.length == 1) {
                    httpURLConnection.setRequestProperty((String)object, stringArray2[0]);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray2[0]);
                int n = 1;
                while (n < stringArray2.length) {
                    stringBuffer.append(',');
                    stringBuffer.append(stringArray2[n]);
                    ++n;
                }
                httpURLConnection.setRequestProperty((String)object, stringBuffer.toString());
            }
            stringArray = sOAPMessage.getSOAPPart().getMimeHeader("soapAction");
            if (stringArray != null) {
                httpURLConnection.setRequestProperty("soapAction", "\"" + stringArray[0] + "\"");
            } else {
                httpURLConnection.setRequestProperty("soapAction", "\"\"");
            }
            object = httpURLConnection.getOutputStream();
            sOAPMessage.writeTo((OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            switch (n) {
                case 200: {
                    return this.getResponse(httpURLConnection, n);
                }
                case 401: 
                case 403: {
                    throw new SOAPException(this.getErrorMessage(httpURLConnection, n));
                }
                case 404: {
                    throw new SOAPException(this.getErrorMessage(httpURLConnection, n));
                }
                case 500: {
                    if (httpURLConnection.getErrorStream() != null) {
                        return this.getResponse(httpURLConnection, n);
                    }
                    throw new SOAPException(this.getErrorMessage(httpURLConnection, n));
                }
            }
            throw new SOAPException(this.getErrorMessage(httpURLConnection, n));
        }
        catch (IOException iOException) {
            throw new SOAPException(iOException.getMessage());
        }
    }

    private String getErrorMessage(HttpURLConnection httpURLConnection, int n) throws IOException {
        return "HTTP " + n + " " + httpURLConnection.getResponseMessage();
    }

    private SOAPMessage getResponse(HttpURLConnection httpURLConnection, int n) throws SOAPException {
        SOAPMessageImpl sOAPMessageImpl = null;
        MimeHeaders mimeHeaders = new MimeHeaders();
        try {
            Object object;
            Object object2;
            int n2 = 1;
            String string = ((URLConnection)httpURLConnection).getHeaderFieldKey(n2);
            while (string != null) {
                String string2;
                if ((string2 = ((URLConnection)httpURLConnection).getHeaderField(n2++)) != null) {
                    object2 = new StringTokenizer(string2, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim();
                        mimeHeaders.addHeader(string, (String)object);
                    }
                }
                string = ((URLConnection)httpURLConnection).getHeaderFieldKey(n2);
            }
            object2 = n == 500 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n3 = 0;
            while ((n3 = ((InputStream)object2).read(byArray)) > 0) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n3);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            sOAPMessageImpl = new SOAPMessageImpl(mimeHeaders, byteArrayInputStream);
            ((InputStream)object2).close();
            httpURLConnection.disconnect();
        }
        catch (IOException iOException) {
            throw new SOAPException(iOException.getMessage());
        }
        return sOAPMessageImpl;
    }
}

