/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.NameImpl;
import com.sssw.jbroker.saaj.soap.NodeImpl;
import com.sssw.jbroker.saaj.soap.TextImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class SOAPElementImpl
extends NodeImpl
implements SOAPElement {
    private Name _name = null;
    private final HashMap _attributes = new HashMap();
    private final HashMap _namespaces = new HashMap();
    private NameImpl _encodingStyleAtt;
    private static final byte[] _close_1 = ">".getBytes();
    private static final byte[] _close_2 = "/>".getBytes();
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";

    public SOAPElementImpl(String string) throws SOAPException {
        this((Name)new NameImpl(string));
    }

    public SOAPElementImpl(Name name) throws SOAPException {
        if (name == null) {
            throw new SOAPException("Element name cannot be null");
        }
        this._name = name;
        if (this._name.getPrefix().length() > 0 && this._name.getURI().length() > 0) {
            this.addNamespaceDeclaration(this._name.getPrefix(), this._name.getURI());
        }
        this._encodingStyleAtt = new NameImpl("SOAP-ENV:encodingStyle");
    }

    public SOAPElementImpl(NameImpl nameImpl) throws SOAPException {
        this((Name)nameImpl);
    }

    public SOAPElement addAttribute(Name name, String string) throws SOAPException {
        if (name == null) {
            throw new SOAPException("Attribute name must be specified");
        }
        if (string == null) {
            throw new SOAPException("Attribute value must be specified");
        }
        this._attributes.put(name, string);
        return this;
    }

    public SOAPElement addChildElement(NameImpl nameImpl) throws SOAPException {
        SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(nameImpl);
        return this.addChildElement(sOAPElementImpl);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(name);
        return this.addChildElement(sOAPElementImpl);
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        sOAPElement.setParentElement(this);
        this._children.add(sOAPElement);
        return sOAPElement;
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(new NameImpl(string));
        return this.addChildElement(sOAPElementImpl);
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            throw new SOAPException("No namespace defined for prefix: " + string2);
        }
        SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(new NameImpl(string, string2, string3));
        return this.addChildElement(sOAPElementImpl);
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(new NameImpl(string, string2, string3));
        return this.addChildElement(sOAPElementImpl);
    }

    public SOAPElement addNamespaceDeclaration(String string, String string2) throws SOAPException {
        this._namespaces.put(string, string2);
        return this;
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        boolean bl = false;
        if (string != null && string.startsWith(COMMENT_BEGIN) && string.endsWith(COMMENT_END)) {
            bl = true;
        }
        TextImpl textImpl = new TextImpl(string, bl);
        textImpl.setParentElement(this);
        this._children.add(textImpl);
        return this;
    }

    public Iterator getAllAttributes() {
        return this._attributes.keySet().iterator();
    }

    public String getAttributeValue(Name name) {
        return (String)this._attributes.get(name);
    }

    public Iterator getChildElements() {
        return ((AbstractList)this._children).iterator();
    }

    public Iterator getChildElements(Name name) {
        ArrayList<SOAPElementImpl> arrayList = new ArrayList<SOAPElementImpl>();
        Iterator iterator = ((AbstractList)this._children).iterator();
        while (iterator.hasNext()) {
            SOAPElementImpl sOAPElementImpl;
            Node node = (Node)iterator.next();
            if (!(node instanceof SOAPElementImpl) || !(sOAPElementImpl = (SOAPElementImpl)node).getElementName().equals(name)) continue;
            arrayList.add(sOAPElementImpl);
        }
        return ((AbstractList)arrayList).iterator();
    }

    public Name getElementName() {
        return this._name;
    }

    public String getEncodingStyle() {
        return this.getAttributeValue(this._encodingStyleAtt);
    }

    public Iterator getNamespacePrefixes() {
        return this._namespaces.keySet().iterator();
    }

    public String getNamespaceURI(String string) {
        return (String)this._namespaces.get(string);
    }

    public boolean removeAttribute(Name name) {
        return this._attributes.remove(name) != null;
    }

    public boolean removeNamespaceDeclaration(String string) {
        return this._namespaces.remove(string) != null;
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (string == null) {
            throw new IllegalArgumentException("Encoding style cannot be null");
        }
        if (!string.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/encoding/") && !string.equalsIgnoreCase("http://www.w3.org/2002/06/soap-encoding")) {
            throw new IllegalArgumentException(string + " is not a valid Encoding style");
        }
        this.removeAttribute(this._encodingStyleAtt);
        this.addAttribute(this._encodingStyleAtt, string);
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Iterator iterator = this.getChildElements();
        this.writeElementStart(outputStream, iterator.hasNext());
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof TextImpl) {
                    outputStream.write(((TextImpl)e).getValue().getBytes());
                    continue;
                }
                ((SOAPElementImpl)e).writeTo(outputStream);
            }
            this.writeElementEnd(outputStream);
        }
    }

    protected void writeElementStart(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(("<" + this._name.getQualifiedName()).getBytes());
        this.writeNamespacesAndAttributes(outputStream);
        if (bl) {
            outputStream.write(_close_1);
        } else {
            outputStream.write(_close_2);
        }
    }

    protected void writeNamespacesAndAttributes(OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        Iterator iterator = this.getNamespacePrefixes();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.getNamespaceURI((String)object2);
            outputStream.write((" xmlns:" + (String)object2 + "=\"" + (String)object + "\"").getBytes());
        }
        object2 = this.getAllAttributes();
        while (object2.hasNext()) {
            object = (Name)object2.next();
            String string = this.getAttributeValue((Name)object);
            outputStream.write((" " + object.getQualifiedName() + "=\"" + string + "\"").getBytes());
        }
    }

    protected void writeElementEnd(OutputStream outputStream) throws IOException {
        outputStream.write(("</" + this._name.getQualifiedName() + ">").getBytes());
    }

    protected void remove(NodeImpl nodeImpl) {
        ((AbstractCollection)this._children).remove(nodeImpl);
    }
}

