/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.NameImpl;
import com.sssw.jbroker.saaj.soap.SOAPBodyImpl;
import com.sssw.jbroker.saaj.soap.SOAPElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPHeaderImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    private SOAPBody _body = null;
    private SOAPHeader _header = null;
    private static final byte[] _xml_utf8 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n".getBytes();
    private static final byte[] _open_1 = "<SOAP-ENV:Envelope".getBytes();
    private static final byte[] _open_2 = ">".getBytes();
    private static final byte[] _close = "</SOAP-ENV:Envelope>".getBytes();

    public SOAPEnvelopeImpl() throws SOAPException {
        super(new NameImpl("envelope"));
        this.addNamespaceDeclaration("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        this._header = new SOAPHeaderImpl();
        this.addChildElement(this._header);
        this._body = new SOAPBodyImpl();
        this.addChildElement(this._body);
    }

    public SOAPBody addBody() throws SOAPException {
        if (this._body != null) {
            throw new SOAPException("Body already exists.");
        }
        this._body = new SOAPBodyImpl();
        this.addChildElement(this._body);
        return this._body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        if (this._header != null) {
            throw new SOAPException("Header already exists.");
        }
        SOAPBody sOAPBody = null;
        if (this._body != null) {
            sOAPBody = this._body;
            this._body.detachNode();
        }
        this._header = new SOAPHeaderImpl();
        this.addChildElement(this._header);
        if (sOAPBody != null) {
            this._body = sOAPBody;
            this.addChildElement(this._body);
        }
        return this._header;
    }

    public Name createName(String string) throws SOAPException {
        return new NameImpl(string);
    }

    public Name createName(String string, String string2, String string3) throws SOAPException {
        String string4 = this.getNamespaceURI(string2);
        if (string4 != null && !string4.equals(string3)) {
            throw new SOAPException("Namespace \"" + string3 + "\" does not match previously declared value \"" + string4 + "\" for prefix " + string2);
        }
        return new NameImpl(string, string2, string3);
    }

    public SOAPBody getBody() throws SOAPException {
        return this._body;
    }

    public SOAPHeader getHeader() throws SOAPException {
        return this._header;
    }

    protected byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(_xml_utf8);
        outputStream.write(_open_1);
        this.writeNamespacesAndAttributes(outputStream);
        outputStream.write(_open_2);
        if (this._header != null) {
            ((SOAPHeaderImpl)this._header).writeTo(outputStream);
        }
        if (this._body != null) {
            ((SOAPBodyImpl)this._body).writeTo(outputStream);
        }
        outputStream.write(_close);
    }

    protected void removeBody() {
        this._body = null;
    }

    protected void removeHeader() {
        this._header = null;
    }
}

