/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.NameImpl;
import com.sssw.jbroker.saaj.soap.SOAPElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPEnvelopeImpl;
import com.sssw.jbroker.saaj.soap.SOAPHeaderElementImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;

public class SOAPHeaderImpl
extends SOAPElementImpl
implements SOAPHeader {
    private static final byte[] _open_1 = "<SOAP-ENV:Header".getBytes();
    private static final byte[] _open_2 = ">".getBytes();
    private static final byte[] _close = "</SOAP-ENV:Header>".getBytes();

    public SOAPHeaderImpl() throws SOAPException {
        super(new NameImpl("Header"));
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        String string = name.getPrefix();
        if (string == null || string.trim().length() == 0) {
            throw new SOAPException("Error: SOAP header element must be namespace qualified.");
        }
        String string2 = name.getURI();
        if (string2 == null || string2.trim().length() == 0) {
            throw new SOAPException("Error: SOAP header element must be namespace qualified.");
        }
        SOAPHeaderElementImpl sOAPHeaderElementImpl = new SOAPHeaderElementImpl(name);
        this.addChildElement(sOAPHeaderElementImpl);
        return sOAPHeaderElementImpl;
    }

    public SOAPHeaderElement addHeaderElement(NameImpl nameImpl) throws SOAPException {
        return this.addHeaderElement((Name)nameImpl);
    }

    public Iterator examineHeaderElements(String string) {
        return this.findMatchingElements(string, false);
    }

    public Iterator extractHeaderElements(String string) {
        return this.findMatchingElements(string, true);
    }

    public Iterator findMatchingElements(String string, boolean bl) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Invalid value for actor");
        }
        Iterator iterator = this.getChildElements();
        ArrayList<SOAPHeaderElement> arrayList = new ArrayList<SOAPHeaderElement>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPHeaderElement)) continue;
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)e;
            String string2 = sOAPHeaderElement.getActor();
            if (string2 == null || string2.equals("")) {
                string2 = "http://schemas.xmlsoap.org/soap/actor/next";
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            arrayList.add(sOAPHeaderElement);
        }
        if (bl) {
            int n = 0;
            while (n < arrayList.size()) {
                ((SOAPHeaderElement)arrayList.get(n)).detachNode();
                ++n;
            }
        }
        return ((AbstractList)arrayList).iterator();
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Iterator iterator = this.getChildElements();
        if (iterator.hasNext()) {
            outputStream.write(_open_1);
            this.writeNamespacesAndAttributes(outputStream);
            outputStream.write(_open_2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SOAPHeaderElementImpl)) continue;
                SOAPHeaderElementImpl sOAPHeaderElementImpl = (SOAPHeaderElementImpl)e;
                sOAPHeaderElementImpl.writeTo(outputStream);
            }
            outputStream.write(_close);
        }
    }

    public void detachNode() {
        SOAPElement sOAPElement = this.getParentElement();
        super.detachNode();
        if (sOAPElement instanceof SOAPEnvelope) {
            ((SOAPEnvelopeImpl)sOAPElement).removeHeader();
        }
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (!(sOAPElement instanceof SOAPEnvelope)) {
            throw new SOAPException("Parent element must be a SOAPEnvelope");
        }
        super.setParentElement(sOAPElement);
    }
}

