/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.DataSourceImpl;
import com.sssw.jbroker.saaj.soap.AttachmentPartImpl;
import com.sssw.jbroker.saaj.soap.SOAPPartImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.stream.StreamSource;

public class SOAPMessageImpl
extends SOAPMessage {
    private boolean _saveRequired = true;
    private byte[] _bytes;
    private InputStream _is;
    private MimeHeaders _headers;
    private SOAPPart _soapPart;
    private Vector _attachments;
    private static final byte[] _newline = "\n".getBytes();
    private static final byte[] _mime_boundary = "--MIME_boundary\n".getBytes();
    private static final byte[] _content_type = "Content-Type: text/xml; charset=\"utf-8\"\n".getBytes();
    private static final byte[] _content_transfer_encoding = "Content-Transfer-Encoding: 8bit\n".getBytes();
    private static final byte[] _start_id = "Content-ID: <soapbody>\n".getBytes();
    private static final byte[] _mime_boundary_end = "--MIME_boundary--\n".getBytes();

    public SOAPMessageImpl() throws SOAPException {
        this._headers = new MimeHeaders();
        this._soapPart = new SOAPPartImpl();
        this._attachments = new Vector();
    }

    public SOAPMessageImpl(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException {
        if (mimeHeaders == null) {
            throw new SOAPException("Error: MimeHeaders not specified");
        }
        if (inputStream == null) {
            throw new SOAPException("Error: InputStream not specified");
        }
        this._headers = mimeHeaders;
        this._soapPart = new SOAPPartImpl();
        this._attachments = new Vector();
        String[] stringArray = this._headers.getHeader("Content-Type");
        if (stringArray == null || stringArray[0] == null) {
            throw new SOAPException("Error: Content-Type is not specified");
        }
        String string = stringArray[0];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        String string3 = null;
        try {
            string2 = stringTokenizer.nextToken("/");
            string3 = stringTokenizer.nextToken(" ;\n");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SOAPException("Error: Invalid Content-Type: " + string);
        }
        string = string2 + string3;
        if (string.equalsIgnoreCase("text/xml")) {
            this._soapPart.setContent(new StreamSource(inputStream));
        } else if (string.equalsIgnoreCase("Multipart/Related")) {
            String string4 = null;
            String string5 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken().trim();
                int n = string6.indexOf(61);
                if (n <= 0) continue;
                String string7 = string6.substring(0, n).trim();
                String string8 = string6.substring(n + 1).trim();
                if (string7.equalsIgnoreCase("boundary")) {
                    string4 = this.removeQuotes(string8);
                    continue;
                }
                if (!string7.equalsIgnoreCase("start")) continue;
                string5 = this.removeAngleBrackets(this.removeQuotes(string8));
            }
            if (string4 == null) {
                throw new SOAPException("Error: MIME Boundary not specified in Content-Type");
            }
            this.parseMimeMultipart(inputStream, string4, string5);
        } else {
            throw new SOAPException("Error: Invalid Content-Type: " + string);
        }
        this._saveRequired = true;
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) throws IllegalArgumentException {
        this._attachments.add(attachmentPart);
        this._saveRequired = true;
    }

    public int countAttachments() {
        return this._attachments.size();
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) throws IllegalArgumentException {
        return new AttachmentPartImpl(dataHandler);
    }

    public AttachmentPart createAttachmentPart(Object object, String string) throws IllegalArgumentException {
        return new AttachmentPartImpl(object, string);
    }

    public Iterator getAttachments() {
        return ((AbstractList)this._attachments).iterator();
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        if (mimeHeaders == null) {
            throw new IllegalArgumentException("Error: No headers specified.");
        }
        Iterator iterator = this.getAttachments();
        ArrayList<AttachmentPartImpl> arrayList = new ArrayList<AttachmentPartImpl>();
        while (iterator.hasNext()) {
            AttachmentPartImpl attachmentPartImpl = (AttachmentPartImpl)iterator.next();
            if (!attachmentPartImpl.hasHeaders(mimeHeaders)) continue;
            arrayList.add(attachmentPartImpl);
        }
        return ((AbstractList)arrayList).iterator();
    }

    public String getContentDescription() {
        String[] stringArray = this._headers.getHeader("Content-Description");
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    public MimeHeaders getMimeHeaders() {
        return this._headers;
    }

    public SOAPPart getSOAPPart() {
        return this._soapPart;
    }

    public void removeAllAttachments() {
        this._attachments.removeAllElements();
        this._saveRequired = true;
    }

    public void saveChanges() throws SOAPException {
        if (this.countAttachments() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(_mime_boundary);
                byteArrayOutputStream.write(_content_type);
                byteArrayOutputStream.write(_start_id);
                byteArrayOutputStream.write(_newline);
                ((SOAPPartImpl)this.getSOAPPart()).writeTo(byteArrayOutputStream);
                byteArrayOutputStream.write(_newline);
                Iterator iterator = this.getAttachments();
                while (iterator.hasNext()) {
                    byteArrayOutputStream.write(_mime_boundary);
                    AttachmentPartImpl attachmentPartImpl = (AttachmentPartImpl)iterator.next();
                    byteArrayOutputStream.write(("Content-Type: " + attachmentPartImpl.getContentType() + "\n").getBytes());
                    byteArrayOutputStream.write(("Content-ID: " + attachmentPartImpl.getContentId() + "\n\n").getBytes());
                    attachmentPartImpl.writeTo(byteArrayOutputStream);
                }
                byteArrayOutputStream.write(_mime_boundary_end);
                byteArrayOutputStream.flush();
                this._bytes = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                throw new SOAPException("Error: " + iOException.getMessage());
            }
            this._headers.setHeader("Content-Type", "Multipart/Related; boundary=\"MIME_boundary\"; type=\"text/xml\"; start=\"<soapbody>\"");
            this._headers.setHeader("Content-Length", Integer.toString(this._bytes != null ? this._bytes.length : 0));
        } else {
            try {
                this._bytes = ((SOAPPartImpl)this.getSOAPPart()).getBytes();
            }
            catch (IOException iOException) {
                throw new SOAPException("Error: " + iOException.getMessage());
            }
            this._headers.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            this._headers.setHeader("Content-Length", Integer.toString(this._bytes != null ? this._bytes.length : 0));
        }
        this._saveRequired = false;
    }

    public boolean saveRequired() {
        return this._saveRequired;
    }

    public void setContentDescription(String string) {
        this._headers.setHeader("Content-Description", string);
        this._saveRequired = true;
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        if (this._saveRequired) {
            this.saveChanges();
        }
        if (this._bytes != null) {
            outputStream.write(this._bytes, 0, this._bytes.length);
        }
        this._bytes = null;
        this._saveRequired = true;
    }

    protected void parseMimeMultipart(InputStream inputStream, String string, String string2) throws SOAPException {
        String string3;
        String string4 = "--" + string;
        int n = string4.length();
        byte[] byArray = string4.getBytes();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        if (!bufferedReader.markSupported()) {
            throw new SOAPException("Error: Input Stream doesn't support mark");
        }
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.trim().equals(string4)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new SOAPException("Error: " + iOException.getMessage());
        }
        if (string3 == null) {
            throw new SOAPException("Error: Missing Start Mime-boundary");
        }
        int n2 = 0;
        while (true) {
            int n3;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            try {
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.length() != 0) {
                        int n4 = string3.indexOf(58);
                        if (n4 == 0) {
                            throw new SOAPException("Error: invalid Mime Header - " + string3);
                        }
                        String string8 = string3.substring(0, n4).trim();
                        String string9 = string3.substring(n4 + 1).trim();
                        if (string8.equalsIgnoreCase("Content-Type")) {
                            string5 = string9;
                            continue;
                        }
                        if (string8.equalsIgnoreCase("Content-Id")) {
                            string6 = this.removeAngleBrackets(string9);
                            continue;
                        }
                        if (!string8.equalsIgnoreCase("Content-Location")) continue;
                        string7 = string9;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new SOAPException("Error: " + iOException.getMessage());
            }
            if (string3 == null) {
                throw new SOAPException("Error: Unexpected end of input");
            }
            if (string5 == null) {
                throw new SOAPException("Error: Content-Type not specified for MIME part");
            }
            if (string6 == null) {
                throw new SOAPException("Error: Content-Id not specified for MIME part");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n5 = 0;
            try {
                while ((n3 = bufferedReader.read()) != -1) {
                    if (n3 == byArray[n5]) {
                        ++n5;
                    } else {
                        if (n5 > 0) {
                            byteArrayOutputStream.write(byArray, 0, n5);
                            n5 = 0;
                        }
                        byteArrayOutputStream.write(n3);
                    }
                    if (n5 != n) continue;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    if (++n2 == 1) {
                        this._soapPart.setContent(new StreamSource(byteArrayInputStream));
                    } else {
                        AttachmentPart attachmentPart = this.createAttachmentPart();
                        DataSourceImpl dataSourceImpl = new DataSourceImpl(byteArrayInputStream, null, string5, null);
                        attachmentPart.setDataHandler(new DataHandler((DataSource)dataSourceImpl));
                        attachmentPart.setContentId(string6);
                        this.addAttachmentPart(attachmentPart);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new SOAPException("Error: " + iOException.getMessage());
            }
            if (n5 < n) {
                throw new SOAPException("Error: Missing Mime-boundary");
            }
            try {
                bufferedReader.mark(2);
                n3 = bufferedReader.read();
                if (n3 == 10) continue;
                if (n3 == 45 && bufferedReader.read() == 45) break;
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                throw new SOAPException("Error: " + iOException.getMessage());
            }
        }
    }

    protected String removeQuotes(String string) {
        String string2 = string;
        if (string2 == null || string2.length() < 2) {
            return string2;
        }
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    protected String removeAngleBrackets(String string) {
        String string2 = string;
        if (string2 == null || string2.length() < 2) {
            return string2;
        }
        if (string2.startsWith("<")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(">")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

