/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.saaj.soap;

import com.sssw.jbroker.saaj.Util;
import com.sssw.jbroker.saaj.soap.DetailImpl;
import com.sssw.jbroker.saaj.soap.SOAPBodyImpl;
import com.sssw.jbroker.saaj.soap.SOAPElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPEnvelopeImpl;
import com.sssw.jbroker.saaj.soap.SOAPFaultImpl;
import com.sssw.jbroker.saaj.soap.SOAPHeaderElementImpl;
import com.sssw.jbroker.saaj.soap.SOAPHeaderImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlPullParserFactory;
import org.gjt.xpp.XmlStartTag;

public class SOAPPartImpl
extends SOAPPart {
    private SOAPEnvelope _envelope = new SOAPEnvelopeImpl();
    private MimeHeaders _headers = new MimeHeaders();
    private Source _source = null;

    public SOAPPartImpl() throws SOAPException {
        this._headers.setHeader("Content-Type", "text/xml");
    }

    public void addMimeHeader(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Name must be specified");
        }
        this._headers.addHeader(string, string2);
    }

    public Iterator getAllMimeHeaders() {
        return this._headers.getAllHeaders();
    }

    public Source getContent() throws SOAPException {
        if (this._source != null) {
            return this._source;
        }
        String string = this._envelope.toString();
        if (string == null) {
            throw new SOAPException("Error: getting Contents of SOAPEnvelope");
        }
        return new StreamSource(new StringReader(string));
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this._source != null) {
            this.parseSource();
            this._source = null;
        }
        return this._envelope;
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this._headers.getMatchingHeaders(stringArray);
    }

    public String[] getMimeHeader(String string) {
        return this._headers.getHeader(string);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this._headers.getNonMatchingHeaders(stringArray);
    }

    public void removeAllMimeHeaders() {
        this._headers.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this._headers.removeHeader(string);
    }

    public void setContent(Source source) throws SOAPException {
        this._source = source;
    }

    public void setMimeHeader(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Name must be specified");
        }
        this._headers.setHeader(string, string2);
    }

    protected byte[] getBytes() throws IOException {
        if (this._source != null) {
            try {
                this.parseSource();
            }
            catch (SOAPException sOAPException) {
                throw new IOException(sOAPException.getMessage());
            }
            this._source = null;
        }
        return ((SOAPEnvelopeImpl)this._envelope).getBytes();
    }

    public String toString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this._source != null) {
            try {
                this.parseSource();
            }
            catch (SOAPException sOAPException) {
                throw new IOException(sOAPException.getMessage());
            }
            this._source = null;
        }
        ((SOAPEnvelopeImpl)this._envelope).writeTo(outputStream);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSource() throws SOAPException {
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance(System.getProperty("org.gjt.xpp.XmlPullParserFactory"));
            xmlPullParserFactory.setNamespaceAware(true);
            XmlStartTag xmlStartTag = xmlPullParserFactory.newStartTag();
            XmlEndTag xmlEndTag = xmlPullParserFactory.newEndTag();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setAllowedMixedContent(true);
            xmlPullParser.setNamespaceAttributesReporting(true);
            StreamSource streamSource = (StreamSource)this._source;
            InputStreamReader inputStreamReader = new InputStreamReader(streamSource.getInputStream());
            xmlPullParser.setInput(inputStreamReader);
            Node node = null;
            Object var8_11 = null;
            int n = 0;
            block8: do {
                byte by = xmlPullParser.next();
                switch (by) {
                    case 2: {
                        String string;
                        xmlPullParser.readStartTag(xmlStartTag);
                        String string2 = xmlStartTag.getNamespaceUri();
                        String string3 = xmlStartTag.getLocalName();
                        String string4 = xmlStartTag.getPrefix();
                        if (++n == 1) {
                            if (!Util.compareName(string3, "envelope")) {
                                throw new SOAPException("Error: Invalid Soap Message - missing Envelope element");
                            }
                            this._envelope = new SOAPEnvelopeImpl();
                            node = this._envelope;
                        } else if (n == 2) {
                            if (Util.compareName(string3, "header")) {
                                node = this._envelope.getHeader();
                            } else {
                                if (!Util.compareName(string3, "body")) throw new SOAPException("Error: Invalid Soap Message - " + string3 + " is not a valid child element of Envelope.");
                                node = this._envelope.getBody();
                            }
                        } else if (n == 3) {
                            void var8_12;
                            Name name = Util.createName(string3, string4, string2);
                            if (node instanceof SOAPHeaderImpl) {
                                SOAPHeaderElement sOAPHeaderElement = ((SOAPHeaderImpl)node).addHeaderElement(name);
                            } else if (node instanceof SOAPBodyImpl) {
                                if (Util.compareName(string3, "fault")) {
                                    SOAPFault sOAPFault = ((SOAPBodyImpl)node).addFault();
                                } else {
                                    SOAPBodyElement sOAPBodyElement = ((SOAPBodyImpl)node).addBodyElement(name);
                                }
                            }
                            node = var8_12;
                        } else if (n == 4) {
                            void var8_22;
                            Name name = Util.createName(string3, string4, string2);
                            if (node instanceof SOAPFaultImpl) {
                                if (Util.compareName(string3, "faultcode")) {
                                    this.setFaultAttrib("faultcode", xmlPullParser, (SOAPElement)node);
                                    --n;
                                    Node node2 = node;
                                } else if (Util.compareName(string3, "faultstring")) {
                                    this.setFaultAttrib("faultstring", xmlPullParser, (SOAPElement)node);
                                    --n;
                                    Node node3 = node;
                                } else if (Util.compareName(string3, "faultactor")) {
                                    this.setFaultAttrib("faultactor", xmlPullParser, (SOAPElement)node);
                                    --n;
                                    Node node4 = node;
                                } else if (Util.compareName(string3, "detail")) {
                                    Detail detail = ((SOAPFaultImpl)node).addDetail();
                                } else {
                                    SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(name);
                                    node.addChildElement(sOAPElementImpl);
                                }
                            } else {
                                SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(name);
                                node.addChildElement(sOAPElementImpl);
                            }
                            node = var8_22;
                        } else {
                            void var8_25;
                            Name name = Util.createName(string3, string4, string2);
                            if (node instanceof DetailImpl) {
                                DetailEntry detailEntry = ((DetailImpl)node).addDetailEntry(name);
                            } else {
                                SOAPElementImpl sOAPElementImpl = new SOAPElementImpl(name);
                                node.addChildElement(sOAPElementImpl);
                            }
                            node = var8_25;
                        }
                        int n2 = xmlStartTag.getAttributeCount();
                        int n3 = 0;
                        while (n3 < n2) {
                            string = xmlStartTag.getAttributeNamespaceUri(n3);
                            String string5 = xmlStartTag.getAttributePrefix(n3);
                            String string6 = xmlStartTag.getAttributeLocalName(n3);
                            String string7 = xmlStartTag.getAttributeValue(n3);
                            Name name = Util.createName(string6, string5, string);
                            if (string5 != null && string6 != null && string5.equalsIgnoreCase("xmlns")) {
                                node.addNamespaceDeclaration(string6, string7);
                            } else if (node instanceof SOAPHeaderElementImpl) {
                                if (string6.equalsIgnoreCase("actor") || string6.toLowerCase().endsWith("actor")) {
                                    ((SOAPHeaderElementImpl)node).setActor(string7);
                                } else if (string6.equalsIgnoreCase("mustunderstand") || string6.toLowerCase().endsWith("mustunderstand")) {
                                    ((SOAPHeaderElementImpl)node).setMustUnderstand(string7 != null && string7.equals("1"));
                                } else {
                                    node.addAttribute(name, string7);
                                }
                            } else {
                                node.addAttribute(name, string7);
                            }
                            ++n3;
                        }
                        continue block8;
                    }
                    case 3: {
                        --n;
                        node = node.getParentElement();
                        break;
                    }
                    case 4: {
                        String string = xmlPullParser.readContent();
                        if (n <= 2 || node instanceof SOAPFaultImpl || node instanceof DetailImpl || string == null || string.length() <= 0) continue block8;
                        node.addTextNode(string);
                        break;
                    }
                }
            } while (n != 0);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Throwable throwable = xmlPullParserException;
            if (xmlPullParserException.getDetail() != null) {
                throwable = xmlPullParserException.getDetail();
            }
            throwable.printStackTrace();
            throw new SOAPException(throwable.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SOAPException(iOException.getMessage());
        }
    }

    private void setFaultAttrib(String string, XmlPullParser xmlPullParser, SOAPElement sOAPElement) throws SOAPException {
        SOAPFaultImpl sOAPFaultImpl = (SOAPFaultImpl)sOAPElement;
        try {
            byte by = xmlPullParser.next();
            while (by != 3) {
                String string2;
                if (by == 4 && (string2 = xmlPullParser.readContent()) != null && string2.length() > 0) {
                    if (string.equals("faultstring")) {
                        sOAPFaultImpl.setFaultString(string2);
                    } else if (string.equals("faultcode")) {
                        sOAPFaultImpl.setFaultCode(string2);
                    } else if (string.equals("faultactor")) {
                        sOAPFaultImpl.setFaultActor(string2);
                    }
                }
                by = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            Throwable throwable = xmlPullParserException;
            if (xmlPullParserException.getDetail() != null) {
                throwable = xmlPullParserException.getDetail();
            }
            throwable.printStackTrace();
            throw new SOAPException(throwable.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SOAPException(iOException.getMessage());
        }
    }
}

