/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.java2rmi;

import com.sssw.jbroker.tools.java2rmi.Main;
import com.sssw.jbroker.tools.java2rmi.MethodWizard;
import com.sssw.jbroker.tools.java2rmi.Wizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ClassWizard
extends Wizard {
    private final TreeMap _classes = new TreeMap();
    private final TreeSet _loaders = new TreeSet();
    private final JList _list = new JList();
    private final JCheckBox _statics = new JCheckBox("Include static methods");
    private final MethodWizard _methWiz;
    private ClassLoader _clLoader = this.getClass().getClassLoader();

    public ClassWizard(MethodWizard methodWizard) {
        Object object;
        File[] fileArray;
        Object object2;
        Object object3;
        String string;
        this._methWiz = methodWizard;
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            object3 = new File(string);
            try {
                object2 = ((File)object3).getCanonicalPath();
                if (!((File)object3).exists() || vector.contains(object2)) continue;
                vector.addElement(object2);
                this._loaders.add(object2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        string = System.getProperty("java.home");
        if (string != null && string.length() > 0 && ((File)(object2 = new File((File)(object3 = new File(string)), "lib"))).exists() && ((File)object2).canRead()) {
            fileArray = ((File)object2).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".jar");
                }
            });
            int n = 0;
            while (n < fileArray.length) {
                try {
                    object = fileArray[n].getCanonicalPath();
                    if (!vector.contains(object)) {
                        vector.addElement(object);
                        this._loaders.add(object);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            object3 = (String)vector.elementAt(0);
            this._list.setListData(this.getClasses((String)object3));
        }
        object3 = new JLabel("Path or JAR file:");
        object2 = new JComboBox(vector);
        ((JComboBox)object2).setEditable(true);
        fileArray = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(2);
        fileArray.setLayout(borderLayout);
        fileArray.add((Component)object3, "North");
        fileArray.add((Component)object2);
        object = new JLabel("Class list:");
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        borderLayout2.setVgap(2);
        jPanel.setLayout(borderLayout2);
        jPanel.add((Component)object, "North");
        jPanel.add(new JScrollPane(this._list));
        jPanel.add((Component)this._statics, "South");
        this._list.setSelectionMode(0);
        ((JComboBox)object2).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                Vector vector = ClassWizard.this.getClasses(string);
                if (vector != null) {
                    ClassWizard.this._list.setListData(vector);
                }
            }
        });
        BorderLayout borderLayout3 = (BorderLayout)this.getLayout();
        borderLayout3.setVgap(10);
        this.add((Component)fileArray, "North");
        this.add(jPanel);
    }

    private Vector getClasses(String string) {
        Vector<String> vector = (Vector<String>)this._classes.get(string);
        if (vector != null) {
            return vector;
        }
        vector = new Vector<String>();
        this._classes.put(string, vector);
        try {
            if (string.endsWith(".jar") || string.endsWith(".zip")) {
                JarFile jarFile = new JarFile(string);
                if (!this._loaders.contains(string)) {
                    this._clLoader = new JarClassLoader(this._clLoader, jarFile, "");
                    this._loaders.add(string);
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string2 = jarEntry.getName();
                    if ((string2 = this.checkClass(string2)) == null) continue;
                    vector.addElement(string2);
                }
            } else {
                File file = new File(string);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, string + " doesn't exist", "Error", 0);
                    return null;
                }
                if (!file.isDirectory()) {
                    JOptionPane.showMessageDialog(this, string + " is not a directory", "Error", 0);
                    return null;
                }
                if (!this._loaders.contains(string)) {
                    this._clLoader = new JarClassLoader(this._clLoader, null, string);
                    this._loaders.add(string);
                }
                this.addClassFiles(string, file, vector);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        Collections.sort(vector);
        return vector;
    }

    private void addClassFiles(String string, File file, Vector vector) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                String string2 = fileArray[n].getPath();
                if (string2.startsWith(string)) {
                    string2 = string2.substring(string.length() + 1);
                }
                if ((string2 = this.checkClass(string2)) != null) {
                    vector.addElement(string2);
                }
            } else if (fileArray[n].isDirectory()) {
                this.addClassFiles(string, fileArray[n], vector);
            }
            ++n;
        }
    }

    private String checkClass(String string) {
        String string2 = null;
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
            string = string.replace('/', '.');
            try {
                Class<?> clazz = Class.forName(string, true, this._clLoader);
                if (Modifier.isPublic(clazz.getModifiers())) {
                    string2 = string;
                }
            }
            catch (Throwable throwable) {
                System.out.println(Main._msgs.get("java2rmi.warning.load.class", string, throwable.getMessage()));
            }
        }
        return string2;
    }

    public boolean getEnableNext() {
        return true;
    }

    public boolean getEnableBack() {
        return false;
    }

    public boolean getEnableDone() {
        return false;
    }

    public boolean getEnableCancel() {
        return true;
    }

    public boolean allowNext() {
        try {
            String string = (String)this._list.getSelectedValue();
            if (string != null) {
                this._methWiz.setClass(Class.forName(string, true, this._clLoader), this._statics.isSelected(), false);
                return true;
            }
            JOptionPane.showMessageDialog(this, "No class selected", "Error", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
        }
        return false;
    }

    public String getName() {
        return "Select class to convert";
    }

    static class JarClassLoader
    extends ClassLoader {
        private final JarFile _file;
        private final String _path;

        public JarClassLoader(ClassLoader classLoader, JarFile jarFile, String string) {
            super(classLoader);
            this._file = jarFile;
            this._path = string.endsWith(File.separator) ? string : string + File.separator;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            try {
                int n;
                Object object;
                String string2 = this._path + string.replace('.', '/') + ".class";
                InputStream inputStream = null;
                if (this._file != null) {
                    object = (JarEntry)this._file.getEntry(string2);
                    if (object != null) {
                        inputStream = this._file.getInputStream((ZipEntry)object);
                    }
                } else {
                    inputStream = new FileInputStream(string2);
                }
                if (inputStream == null) {
                    throw new ClassNotFoundException();
                }
                object = new byte[1024];
                int n2 = 0;
                while ((n = inputStream.read((byte[])object, n2, 1024)) != -1) {
                    if (1024 + (n2 += n) <= ((Object)object).length) continue;
                    byte[] byArray = new byte[2 * ((Object)object).length];
                    System.arraycopy(object, 0, byArray, 0, ((Object)object).length);
                    object = byArray;
                }
                return this.defineClass(string, (byte[])object, 0, n2);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException();
            }
        }

        public InputStream getResourceAsStream(String string) {
            block4: {
                try {
                    if (this._file != null) {
                        JarEntry jarEntry = (JarEntry)this._file.getEntry(this._path + string);
                        if (jarEntry != null) {
                            return this._file.getInputStream(jarEntry);
                        }
                        break block4;
                    }
                    return new FileInputStream(this._path + string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

