/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.java2rmi;

import com.sssw.jbroker.tools.java2rmi.ClassWizard;
import com.sssw.jbroker.tools.java2rmi.MethodWizard;
import com.sssw.jbroker.tools.java2rmi.Wizard;
import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Main
extends JPanel {
    public static final Messages _msgs = new Messages(class$com$sssw$jbroker$tools$java2rmi$Main == null ? (class$com$sssw$jbroker$tools$java2rmi$Main = Main.class$("com.sssw.jbroker.tools.java2rmi.Main")) : class$com$sssw$jbroker$tools$java2rmi$Main);
    private static final String _usage = _msgs.get("java2rmi.usage") + Copyright._copyright + "\n";
    private static CommandLine _cmdline;
    private Wizard[] _panels;
    private int _index;
    private JPanel _panel = null;
    private final MethodWizard _methWiz = new MethodWizard();
    private final JFrame _frame = new JFrame();
    private final JPanel _buttons = new JPanel();
    private final JLabel _titleL = new JLabel();
    private final JButton _nextB = new JButton(_msgs.get("java2rmi.gui.next"));
    private final JButton _backB = new JButton(_msgs.get("java2rmi.gui.back"));
    private final JButton _cancelB = new JButton(_msgs.get("java2rmi.gui.cancel"));
    private final JButton _doneB = new JButton(_msgs.get("java2rmi.gui.done"));
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$java2rmi$Main;

    public static void main(String[] stringArray) {
        Main main = new Main(stringArray);
    }

    public Main(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            System.err.println(_usage);
            System.exit(1);
        }
        boolean bl = _cmdline.getArg("static") != null;
        String[] stringArray2 = _cmdline.getTralingArguments();
        if (stringArray2.length > 1) {
            System.err.println(_usage);
            System.exit(1);
        }
        Wizard[] wizardArray = null;
        if (stringArray2.length == 1) {
            try {
                Class<?> clazz = Class.forName(stringArray2[0]);
                if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = Main.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                    System.err.println(_msgs.get("java2rmi.error.already.remote", stringArray2[0]));
                    System.exit(1);
                }
                String string = null;
                Hashtable hashtable = _cmdline.getArgs();
                Object v = hashtable.get("file");
                if (v != null) {
                    string = v instanceof String ? (String)v : ((String[])v)[0];
                }
                boolean bl2 = string != null;
                try {
                    this._methWiz.setClass(clazz, bl, bl2);
                }
                catch (Exception exception) {
                    System.err.println(_msgs.get("java2rmi.error.introspection.failed", stringArray2[0], exception.getMessage()));
                    System.exit(1);
                }
                if (string != null) {
                    try {
                        String string2;
                        int n = stringArray2[0].lastIndexOf(".");
                        String string3 = string2 = n == -1 ? "" : stringArray2[0].substring(0, n);
                        if (!string.endsWith(".java")) {
                            string = string + ".java";
                        }
                        File file = new File(string);
                        String string4 = file.getName().substring(0, file.getName().length() - 5);
                        this._methWiz.writeRMI(file, string2, string4);
                    }
                    catch (IOException iOException) {
                        System.err.println("I/O exception: " + iOException.getMessage());
                    }
                    System.exit(0);
                }
                Wizard[] wizardArray2 = new Wizard[]{this._methWiz};
                wizardArray = wizardArray2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(_msgs.get("java2rmi.error.class.not.found", stringArray2[0]));
                System.exit(1);
            }
        } else {
            Wizard[] wizardArray3;
            wizardArray = wizardArray3 = new Wizard[]{new ClassWizard(this._methWiz), this._methWiz};
        }
        this.gui();
        this.setWizards(wizardArray);
        this.setWizard(wizardArray[0]);
    }

    boolean parseArguments(String[] stringArray) {
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("static", false, 0, 0), new CommandArg("file", false, 1, 1)};
        _cmdline = new CommandLine("java2rmi", commandArgArray, _usage, "-", false);
        boolean bl = _cmdline.parse(stringArray, System.err);
        return bl;
    }

    public void gui() {
        this._frame.getContentPane().setLayout(new BorderLayout());
        this._frame.setTitle(_msgs.get("java2rmi.gui.title"));
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        this.setLayout(borderLayout);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton == Main.this._nextB) {
                    Main.this.next();
                } else if (jButton == Main.this._backB) {
                    Main.this.back();
                } else if (jButton == Main.this._cancelB) {
                    System.exit(0);
                } else if (jButton == Main.this._doneB) {
                    Main.this.done();
                }
            }
        };
        this._nextB.addActionListener(actionListener);
        this._backB.addActionListener(actionListener);
        this._cancelB.addActionListener(actionListener);
        this._doneB.addActionListener(actionListener);
        this._nextB.setToolTipText(_msgs.get("java2rmi.gui.next.tip"));
        this._backB.setToolTipText(_msgs.get("java2rmi.gui.back.tip"));
        this._cancelB.setToolTipText(_msgs.get("java2rmi.gui.cancel.tip"));
        this._doneB.setToolTipText(_msgs.get("java2rmi.gui.done.tip"));
        this._titleL.setFont(new Font("Helvetica", 0, 24));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._buttons, "East");
        jPanel.add((Component)new JSeparator(), "North");
        borderLayout = new BorderLayout();
        borderLayout.setHgap(10);
        this._panel = new JPanel(borderLayout);
        this.add(this._panel);
        this.add((Component)jPanel, "South");
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this._frame).setSize(new Dimension(450, 300));
        this._frame.getContentPane().add(this);
        ((Component)this._frame).setVisible(true);
    }

    public void setWizards(Wizard[] wizardArray) {
        this._panels = wizardArray;
    }

    public void next() {
        if (this._index == this._panels.length - 1) {
            throw new RuntimeException("exhausted panels");
        }
        if (this._panels[this._index].allowNext()) {
            this.setWizard(this._panels[++this._index]);
        }
    }

    public void back() {
        if (this._index == 0) {
            throw new RuntimeException("back panel doesn't exist");
        }
        this.setWizard(this._panels[--this._index]);
    }

    public void done() {
        this._panels[this._index].done();
    }

    public void setWizard(Wizard wizard) {
        this._panel.removeAll();
        this._titleL.setText(wizard.getName());
        this._titleL.setForeground(new Color(128, 128, 192));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._titleL, "North");
        jPanel.add(new JSeparator());
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        JPanel jPanel2 = new JPanel(borderLayout);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(wizard);
        this._panel.add(jPanel2);
        this._buttons.removeAll();
        if (wizard.getEnableBack()) {
            this._buttons.add(this._backB);
        }
        if (wizard.getEnableNext()) {
            this._buttons.add(this._nextB);
        }
        if (wizard.getEnableDone()) {
            this._buttons.add(this._doneB);
        }
        if (wizard.getEnableCancel()) {
            this._buttons.add(this._cancelB);
        }
        this.validate();
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

