/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.java2rmi;

import com.sssw.jbroker.tools.java2rmi.Wizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class MethodWizard
extends Wizard {
    private Class _clz;
    private final Vector _methods = new Vector();
    private final MethodList _left = new MethodList();
    private final MethodList _right = new MethodList();
    private final JScrollPane _leftS = new JScrollPane(this._left);
    private final JScrollPane _rightS = new JScrollPane(this._right);
    private final JButton _add = new JButton(">>");
    private final JButton _remove = new JButton("<<");
    static /* synthetic */ Class class$java$lang$Object;

    public MethodWizard() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._add, "North");
        jPanel.add((Component)this._remove, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        this.add((Component)this._leftS, "West");
        this.add(jPanel2);
        this.add((Component)this._rightS, "East");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton == MethodWizard.this._add) {
                    Object[] objectArray = MethodWizard.this._left.getSelectedValues();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (!MethodWizard.this._methods.contains(objectArray[n])) {
                            MethodWizard.this._methods.addElement(objectArray[n]);
                        }
                        ++n;
                    }
                    MethodWizard.this._right.setListData(MethodWizard.this._methods);
                } else if (jButton == MethodWizard.this._remove) {
                    Object[] objectArray = MethodWizard.this._right.getSelectedValues();
                    int n = 0;
                    while (n < objectArray.length) {
                        MethodWizard.this._methods.remove(objectArray[n]);
                        ++n;
                    }
                    MethodWizard.this._right.setListData(MethodWizard.this._methods);
                }
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                int n = component.getWidth() - MethodWizard.this._add.getWidth() - 20;
                if (n < 0) {
                    n = 0;
                }
                Dimension dimension = new Dimension(n / 2, component.getHeight());
                MethodWizard.this._leftS.setPreferredSize(dimension);
                MethodWizard.this._rightS.setPreferredSize(dimension);
                component.invalidate();
                component.validate();
                component.repaint();
            }
        });
        this._add.addActionListener(actionListener);
        this._remove.addActionListener(actionListener);
        this._add.setToolTipText("Add selected method(s)");
        this._remove.setToolTipText("Remove selected method(s)");
        this._left.setToolTipText("x");
        this._right.setToolTipText("x");
    }

    public void setClass(Class clazz, boolean bl, boolean bl2) throws Exception {
        this._clz = clazz;
        BeanInfo beanInfo = clazz.isInterface() ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = MethodWizard.class$("java.lang.Object")) : class$java$lang$Object);
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        Vector<MethodDescriptorWrapper> vector = new Vector<MethodDescriptorWrapper>(methodDescriptorArray.length);
        int n = 0;
        while (n < methodDescriptorArray.length) {
            if (bl) {
                vector.addElement(new MethodDescriptorWrapper(methodDescriptorArray[n]));
            } else if (!Modifier.isStatic(methodDescriptorArray[n].getMethod().getModifiers())) {
                vector.addElement(new MethodDescriptorWrapper(methodDescriptorArray[n]));
            }
            ++n;
        }
        if (vector.size() == 0) {
            throw new RuntimeException(clazz.toString() + " has no " + "public methods");
        }
        this._left.setListData(vector);
        this._right.setListData(new Vector());
        if (bl2) {
            this._methods.addAll(vector);
        }
    }

    public void done() {
        Object[] objectArray;
        int n;
        String string;
        int n2;
        if (this._methods.size() == 0) {
            JOptionPane.showMessageDialog(this, "No methods added", "Error", 0);
            return;
        }
        String string2 = this._clz.getPackage() == null ? "" : this._clz.getPackage().getName();
        String string3 = (String)JOptionPane.showInputDialog(this, "Package:", "Select target package", 3, null, null, string2);
        if (string3 == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save as RMI");
        String string4 = System.getProperty("user.dir");
        if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        if ((n2 = (string = this._clz.getName()).lastIndexOf(".")) != -1) {
            string = string.substring(n2 + 1);
        }
        File file = new File(string4 + string + "_REMOTE.java");
        jFileChooser.setSelectedFile(file);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".java");
            }

            public String getDescription() {
                return "Java (*.java)";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        while (true) {
            int n3;
            if ((n3 = jFileChooser.showSaveDialog(this)) == 1) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (file.getName() != null && file.getName().length() != 0 && file.getName().endsWith(".java")) break;
            JOptionPane.showMessageDialog(this, "Invalid file name", "Error", 0);
        }
        if (file.exists() && (n = JOptionPane.showOptionDialog(this, "File exists. Replace?", "Save as RMI", 2, 3, null, objectArray = new String[]{"OK", "Cancel"}, objectArray[0])) != 0) {
            return;
        }
        try {
            string = file.getName().substring(0, file.getName().length() - 5);
            this.writeRMI(file, string3, string);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "I/O exception: " + iOException.getMessage(), "Error", 0);
        }
    }

    public void writeRMI(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println("package " + string + ";");
        printWriter.println();
        printWriter.print("public interface " + string2);
        printWriter.println(" extends java.rmi.Remote");
        printWriter.println("{");
        int n = this._methods.size();
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptorWrapper methodDescriptorWrapper = (MethodDescriptorWrapper)this._methods.elementAt(n2);
            Method method = methodDescriptorWrapper.desc.getMethod();
            printWriter.print("    " + MethodWizard.getClassName(method.getReturnType()));
            printWriter.print(" " + method.getName() + "(");
            Class<?>[] classArray = method.getParameterTypes();
            int n3 = 0;
            while (n3 < classArray.length) {
                printWriter.print(MethodWizard.getClassName(classArray[n3]) + " arg" + n3);
                if (n3 != classArray.length - 1) {
                    printWriter.print(", ");
                }
                ++n3;
            }
            printWriter.print(") throws ");
            Class<?>[] classArray2 = method.getExceptionTypes();
            int n4 = 0;
            while (n4 < classArray2.length) {
                printWriter.print(classArray2[n4].getName() + ", ");
                ++n4;
            }
            printWriter.println("java.rmi.RemoteException;");
            ++n2;
        }
        printWriter.println("}");
        printWriter.flush();
        fileOutputStream.close();
        System.out.println("wrote " + file);
        System.exit(0);
    }

    public boolean getEnableNext() {
        return false;
    }

    public boolean getEnableBack() {
        return true;
    }

    public boolean getEnableDone() {
        return true;
    }

    public boolean getEnableCancel() {
        return true;
    }

    public String getName() {
        return "Select methods from " + (this._clz == null ? "class" : this._clz.getName());
    }

    public static String getClassName(Class clazz) {
        return clazz.isArray() ? MethodWizard.getClassName(clazz.getComponentType()) + "[]" : clazz.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodDescriptorWrapper {
        private final MethodDescriptor desc;

        MethodDescriptorWrapper(MethodDescriptor methodDescriptor) {
            this.desc = methodDescriptor;
        }

        public String toString() {
            return this.desc.getDisplayName();
        }
    }

    private static class MethodList
    extends JList {
        private MethodList() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                MethodDescriptorWrapper methodDescriptorWrapper = (MethodDescriptorWrapper)this.getModel().getElementAt(n);
                Method method = methodDescriptorWrapper.desc.getMethod();
                String string = "public ";
                string = string + MethodWizard.getClassName(method.getReturnType());
                string = string + " " + method.getName() + "(";
                Class<?>[] classArray = method.getParameterTypes();
                int n2 = 0;
                while (n2 < classArray.length) {
                    string = string + MethodWizard.getClassName(classArray[n2]);
                    if (n2 != classArray.length - 1) {
                        string = string + ",";
                    }
                    ++n2;
                }
                string = string + ")";
                return string;
            }
            return null;
        }
    }
}

