/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap;

import com.sssw.jbroker.tools.javac.Compiler;
import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPortType;
import com.sssw.jbroker.util.ClassUtil;
import com.sssw.jbroker.util.CodeGenUtil;
import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.JavaUtil;
import com.sssw.jbroker.util.Messages;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.encoding.ValueTypeMarshaler;
import com.sssw.jbroker.web.encoding.XMLType;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;

public class Main {
    private static final boolean NO_ERROR = true;
    private static final boolean COMPILE_ERROR = false;
    private static final String rmi2soap = "rmi2soap";
    private static final boolean _debug = false;
    private static boolean _programmatic = true;
    private static boolean _verbose = false;
    private static boolean _nowarn;
    private static String _xmlns;
    private static String _xsd;
    private boolean _status = true;
    private static boolean _nogenerate;
    private CodeGenerator _generator = null;
    private static CommandLine _cmdline;
    private static final String _generatorSuffix = ".CodeGenerator";
    private static final String _generatorPrefix = "com.sssw.jbroker.tools.rmi2soap.";
    public static final Messages _messages;
    private static final String _usage;
    private static final DefaultTypeMappingRegistry _mapper;
    private static final Properties _generatedMappings;
    private static final HashSet _generatedClasses;
    private static final HashMap _needsMarshaler;
    private static final HashMap _alsoNeedMarshaler;
    private static final HashMap _pack2ns;
    private static final HashMap _namespaces;
    private static final HashMap _revNamespaces;
    private static final HashMap _generatedTypes;
    static HashMap _types;
    static PrimitiveTypeMapper _primitive;
    private static String _location;
    private static boolean _isDocument;
    private static String _transport;
    private static String _action;
    private static boolean _isLiteral;
    private static String _encodingURI;
    private static boolean _noMarshaler;
    private static String _serviceName;
    private static int _nsCount;
    private static int _tmCount;
    private static Class[] _nonPrimitiveMappings;
    private static Class _stackTraceElementClass;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$rmi2soap$Main;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$SetMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ListMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapEntryMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ClassMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$QNameMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$BindingMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$ElementMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static void main(String[] stringArray) {
        try {
            Main.initializeTypeMapper(_mapper);
            Main main = new Main();
            System.exit(main.compile(stringArray) ? 0 : 1);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.length() == 0) {
                string = exception.toString();
            }
            System.out.println(string);
            System.exit(1);
        }
    }

    boolean parseArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            return false;
        }
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("ds", false, 1, 1), new CommandArg("verbose", false, 0, 0), new CommandArg("xsd", false, 1, 1), new CommandArg("xmlns", false, 1, 1), new CommandArg("literal", false, 0, 0), new CommandArg("document", false, 0, 0), new CommandArg("addr", false, 1, 1), new CommandArg("pkgns", false, 2, 2), new CommandArg("typemapping", false, 1, 1), new CommandArg("wsdllocation", false, 1, 1), new CommandArg("nocompile", false, 0, 0), new CommandArg("keepgenerated", false, 0, 0), new CommandArg("keep", false, 0, 0), new CommandArg("nogenerate", false, 0, 0), new CommandArg("nostub", false, 0, 0), new CommandArg("noskel", false, 0, 0), new CommandArg("notie", false, 0, 0), new CommandArg("noserv", false, 0, 0), new CommandArg("transport", false, 1, 1), new CommandArg("action", false, 1, 1), new CommandArg("encoding", false, 1, 1), new CommandArg("mdb", false, 0, 0), new CommandArg("oldstyle", false, 0, 0), new CommandArg("generator", false, 1, 1), new CommandArg("genclient", false, 0, 0), new CommandArg("gencallclient", false, 0, 0), new CommandArg("genserver", false, 0, 0), new CommandArg("clienthandler", false, 1, 1), new CommandArg("serverhandler", false, 1, 1), new CommandArg("nomarshalers", false, 0, 0), new CommandArg("servicename", false, 1, 1), new CommandArg("servimplext", false, 1, 1), new CommandArg("classpath", false, 1, 1), new CommandArg("d", false, 1, 1), new CommandArg("g", false, 0, 0), new CommandArg("O", false, 0, 0), new CommandArg("depend", false, 0, 0), new CommandArg("nowarn", false, 0, 0)};
        _cmdline = new CommandLine(rmi2soap, commandArgArray, _usage, "-", true);
        _cmdline.markAppendable("addr");
        _cmdline.markAppendable("pkgns");
        _cmdline.markAppendable("typemapping");
        _cmdline.markAppendable("clienthandler");
        _cmdline.markAppendable("serverhandler");
        _cmdline.getArgDef("nocompile").setAlias("noCompile");
        _cmdline.getArgDef("noserv").setAlias("noServ");
        _cmdline.getArgDef("nostub").setAlias("noStub");
        _cmdline.getArgDef("noskel").setAlias("noSkel");
        _cmdline.getArgDef("notie").setAlias("noTie");
        _cmdline.getArgDef("nogenerate").setAlias("noGenerate");
        _cmdline.getArgDef("addr").setAlias("url");
        _cmdline.getArgDef("xsd").setAlias("schema");
        _cmdline.getArgDef("keepgenerated").setAlias("keepGenerated");
        _cmdline.getArgDef("servicename").setAlias("serviceName");
        _cmdline.getArgDef("servimplext").setAlias("servImplExt");
        boolean bl = _cmdline.parse(stringArray, System.err);
        return bl;
    }

    boolean compile(String[] stringArray) throws Exception {
        boolean bl;
        if (!this.parseArguments(stringArray)) {
            System.err.println(_usage);
            return false;
        }
        _verbose = _cmdline.getArg("verbose") != null;
        _nowarn = _cmdline.getArg("nowarn") != null;
        Vector vector = new Vector();
        String[] stringArray2 = _cmdline.getTralingArguments();
        if (_cmdline.getArg("addr") != null && stringArray2.length > 1) {
            System.err.println(_messages.get("rmi2soap.error.addr.one.file.only"));
            return false;
        }
        boolean bl2 = _cmdline.getArg("document") != null;
        boolean bl3 = bl = _cmdline.getArg("literal") != null;
        if (bl2) {
            if (!bl) {
                Main.error(_messages.get("rmi2soap.error.document.encoded"));
            }
        } else if (bl) {
            Main.error(_messages.get("rmi2soap.error.rpc.literal"));
        }
        _programmatic = false;
        int n = 0;
        while (n < stringArray2.length) {
            if (_verbose) {
                System.out.println(_messages.get("rmi2soap.verbose.processing.class", stringArray2[n]));
            }
            try {
                Class clazz = ClassUtil.forName(stringArray2[n]);
                if (clazz == null) {
                    throw new ClassNotFoundException();
                }
                this._status &= Main.compile(clazz, this.getCodeGenerator(), _cmdline.getArgs(), vector).getStatus();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(_messages.get("rmi2soap.error.unable.to.find.class", rmi2soap, stringArray2[n]));
                return false;
            }
            ++n;
        }
        if (this._status && _cmdline.getArg("nocompile") == null && vector.size() > 0) {
            this._status = Main.compileJavaFiles(vector, _cmdline.getArgs());
        }
        return this._status;
    }

    private static boolean compileJavaFiles(Vector vector, Hashtable hashtable) throws Exception {
        boolean bl;
        boolean bl2 = hashtable.get("verbose") != null;
        boolean bl3 = bl = hashtable.get("keep") == null && hashtable.get("keepgenerated") == null;
        if (bl2) {
            System.out.println(_messages.get("rmi2soap.verbose.compiling"));
        }
        Compiler compiler = new Compiler();
        Object v = hashtable.get("d");
        String string = null;
        if (v != null) {
            string = v instanceof String ? (String)v : ((String[])v)[0];
        }
        String string2 = System.getProperty("java.class.path");
        v = hashtable.get("classpath");
        String string3 = v != null ? (v instanceof String ? (String)v : ((String[])v)[0]) : string2;
        if (string != null) {
            string3 = string3 + File.pathSeparatorChar + string;
        }
        System.setProperty("java.class.path", string3);
        boolean bl4 = compiler.compile(hashtable, vector);
        System.setProperty("java.class.path", string2);
        if (bl2) {
            System.out.println();
        }
        if (bl) {
            int n = 0;
            while (n < vector.size()) {
                ((File)vector.elementAt(n)).delete();
                ++n;
            }
        }
        return bl4;
    }

    private CodeGenerator getCodeGenerator() {
        if (this._generator != null) {
            return this._generator;
        }
        String string = "generic";
        if (_cmdline.getArg("generator") != null && (string = _cmdline.getArgAsString("generator")).startsWith(_generatorPrefix) && string.endsWith(_generatorSuffix)) {
            string = string.substring(_generatorPrefix.length(), string.length() - _generatorSuffix.length());
        }
        try {
            this._generator = Main.getCodeGenerator(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(_messages.get("rmi2soap.error.unable.to.instantiate.generator", string));
            System.exit(1);
        }
        return this._generator;
    }

    public static ASTDocument compile(Class clazz, CodeGenerator codeGenerator, Hashtable hashtable, Vector vector) throws Exception {
        Object object;
        int n;
        String[] stringArray;
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Main.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz) || !clazz.isInterface()) {
            throw new Exception(_messages.get("rmi2soap.error.not.remote", clazz.getName()));
        }
        _verbose = hashtable.get("verbose") != null;
        _nowarn = hashtable.get("nowarn") != null;
        _xmlns = Main.getParamAsString(hashtable, "xmlns");
        _nogenerate = hashtable.get("nogenerate") != null;
        _location = Main.getParamAsString(hashtable, "addr");
        _transport = Main.getParamAsString(hashtable, "transport");
        _action = Main.getParamAsString(hashtable, "action");
        _encodingURI = Main.getParamAsString(hashtable, "encoding");
        if (_encodingURI == null) {
            _encodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        _isDocument = hashtable.get("document") != null;
        _isLiteral = hashtable.get("literal") != null;
        _noMarshaler = hashtable.get("nomarshalers") != null;
        _serviceName = Main.getParamAsString(hashtable, "servicename");
        if (_nogenerate) {
            _noMarshaler = true;
        }
        if (_isDocument) {
            if (!_isLiteral) {
                Main.error(_messages.get("rmi2soap.error.document.encoded"));
            }
        } else if (_isLiteral) {
            Main.error(_messages.get("rmi2soap.error.rpc.literal"));
        }
        ((Hashtable)_generatedMappings).clear();
        _generatedClasses.clear();
        _needsMarshaler.clear();
        _alsoNeedMarshaler.clear();
        _tmCount = 0;
        vector.clear();
        _mapper.clear();
        Main.initializeTypeMapper(_mapper);
        String[] stringArray2 = (String[])hashtable.get("typemapping");
        if (stringArray2 != null) {
            stringArray = Thread.currentThread().getContextClassLoader();
            n = 0;
            while (n < stringArray2.length) {
                object = new FileInputStream(stringArray2[n]);
                _generatedMappings.load((InputStream)object);
                ((FileInputStream)object).close();
                Main.info(_messages.get("rmi2soap.verbose.loading.mappings", stringArray2[n]));
                ++n;
            }
            _mapper.importTypeMappings(_generatedMappings, (ClassLoader)stringArray);
        }
        if ((stringArray = (String[])hashtable.get("pkgns")) != null) {
            n = 0;
            while (n < stringArray.length) {
                _pack2ns.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
        }
        ASTDocument aSTDocument = new ASTDocument();
        object = Main.packageNS(clazz.getName());
        if (object != null && ((String)object).length() == 0) {
            object = null;
        }
        aSTDocument.generateASTFromClass(clazz, true, (String)object);
        String[] stringArray3 = aSTDocument.findInvalidRMI();
        if (stringArray3 != null) {
            Main.error(_messages.get("rmi2soap.error.invalid.rmi", stringArray3[0], stringArray3[1]));
        }
        _xsd = Constants.XSD_URI;
        Object v = hashtable.get("xsd");
        if (v != null) {
            if (v instanceof String) {
                _xsd = (String)v;
            } else if (v instanceof String[]) {
                _xsd = ((String[])v)[0];
            }
        }
        _namespaces.put(_xsd, "xsd");
        _revNamespaces.put("xsd", _xsd);
        String string = null;
        Object v2 = hashtable.get("ds");
        if (v2 == null) {
            v2 = hashtable.get("d");
        }
        if (v2 != null) {
            string = v2 instanceof String ? (String)v2 : ((String[])v2)[0];
        }
        File file = null;
        if (string != null) {
            file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(_messages.get("rmi2soap.error.unable.to.create.directory", rmi2soap, string));
            }
            if (!file.isDirectory()) {
                throw new Exception(_messages.get("rmi2soap.error.exists.but.not.directory", rmi2soap, string));
            }
        } else {
            file = new File(".");
        }
        hashtable.put("destDir", file);
        if (aSTDocument.hasPortTypes()) {
            Main.fixXMLTypes(aSTDocument);
            try {
                if (!_noMarshaler) {
                    Main.generateMarshalers(file, vector);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            if (((Hashtable)_generatedMappings).size() > 0) {
                aSTDocument.setTypeMappings(_generatedMappings);
            }
            String string2 = clazz.getName();
            String string3 = Main.packageNS(string2);
            aSTDocument.addSoapBinding(_location, _isDocument, _transport, _action, _isLiteral, _encodingURI, string3, _serviceName);
        }
        if (!_nogenerate) {
            boolean bl = Main.compile(aSTDocument, codeGenerator, hashtable, vector);
            aSTDocument.setStatus(bl);
        } else {
            aSTDocument.setStatus(false);
        }
        return aSTDocument;
    }

    static void generateMarshalers(File file, Vector vector) {
        Iterator iterator = _needsMarshaler.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            try {
                Main.writeMarshaler(clazz, (QName)_needsMarshaler.get(clazz), file, vector);
                _generatedClasses.add(clazz);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        iterator = null;
        _needsMarshaler.clear();
        if (!_alsoNeedMarshaler.isEmpty()) {
            _needsMarshaler.putAll(_alsoNeedMarshaler);
            _alsoNeedMarshaler.clear();
        }
        if (!_needsMarshaler.isEmpty()) {
            Main.generateMarshalers(file, vector);
        }
    }

    public static CodeGenerator getCodeGenerator(String string) throws Exception {
        String string2 = string.indexOf(".") == -1 ? _generatorPrefix + string + _generatorSuffix : string;
        return (CodeGenerator)Class.forName(string2).newInstance();
    }

    public static boolean compile(ASTDocument[] aSTDocumentArray, CodeGenerator codeGenerator, Hashtable hashtable) throws Exception {
        boolean bl = true;
        _programmatic = false;
        Vector vector = new Vector();
        int n = 0;
        while (n < aSTDocumentArray.length) {
            bl &= Main.compile(aSTDocumentArray[n], codeGenerator, hashtable, vector);
            ++n;
        }
        if (bl && hashtable.get("nocompile") == null && vector.size() > 0) {
            bl = Main.compileJavaFiles(vector, hashtable);
        }
        return bl;
    }

    public static boolean compile(ASTDocument aSTDocument, CodeGenerator codeGenerator, Hashtable hashtable, Vector vector) throws Exception {
        String string = null;
        Object v = hashtable.get("ds");
        if (v == null) {
            v = hashtable.get("d");
        }
        if (v != null) {
            string = v instanceof String ? (String)v : ((String[])v)[0];
        }
        boolean bl = _nogenerate = hashtable.get("nogenerate") != null;
        if (_nogenerate) {
            return false;
        }
        if (_programmatic) {
            vector.clear();
        }
        File file = null;
        if (string != null) {
            file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(_messages.get("rmi2soap.error.unable.to.create.directory", rmi2soap, string));
            }
            if (!file.isDirectory()) {
                throw new Exception(_messages.get("rmi2soap.error.exists.but.not.directory", rmi2soap, string));
            }
        } else {
            file = new File(".");
        }
        hashtable.put("destDir", file);
        codeGenerator.setASTDoc(aSTDocument);
        boolean bl2 = codeGenerator.generate(hashtable, vector);
        if (bl2 && _programmatic && hashtable.get("nocompile") == null && vector.size() > 0) {
            bl2 &= Main.compileJavaFiles(vector, hashtable);
        }
        return bl2;
    }

    public static void initializeTypeMapper(DefaultTypeMappingRegistry defaultTypeMappingRegistry) {
        try {
            Serializable serializable;
            ClassLoader classLoader = (class$com$sssw$jbroker$tools$rmi2soap$Main == null ? (class$com$sssw$jbroker$tools$rmi2soap$Main = Main.class$("com.sssw.jbroker.tools.rmi2soap.Main")) : class$com$sssw$jbroker$tools$rmi2soap$Main).getClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("xmlrpc.type.mappings");
            while (enumeration.hasMoreElements()) {
                Properties properties = new Properties();
                serializable = enumeration.nextElement();
                if (!(serializable instanceof URL)) continue;
                Main.info(_messages.get("rmi2soap.verbose.loading.mappings", serializable));
                properties.load(((URL)serializable).openStream());
                _mapper.importTypeMappings(properties, classLoader);
            }
            int n = 0;
            while (n < _nonPrimitiveMappings.length) {
                serializable = (TypeMappingBase)_nonPrimitiveMappings[n].newInstance();
                TypeMap[] typeMapArray = ((TypeMappingBase)serializable).getTypeMappings();
                int n2 = 0;
                while (n2 < typeMapArray.length) {
                    _mapper.put(typeMapArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Main.warn(_messages.get("rmi2soap.warning.loading.mappings.fail", throwable.toString()));
        }
    }

    private static void error(String string) {
        throw new RuntimeException(string);
    }

    private static void info(String string) {
        if (_verbose) {
            System.out.println(string);
        }
    }

    private static void warn(String string) {
        if (!_nowarn) {
            System.out.println("warn: " + string);
        }
    }

    private static String getParamAsString(Hashtable hashtable, String string) {
        String string2 = null;
        Object v = hashtable.get(string);
        if (v != null) {
            string2 = v instanceof String ? (String)v : ((String[])v)[0];
        }
        return string2;
    }

    private static void fixXMLTypes(ASTDocument aSTDocument) {
        ASTPortType[] aSTPortTypeArray = aSTDocument.getPortTypes();
        int n = 0;
        while (n < aSTPortTypeArray.length) {
            ASTPortType aSTPortType = aSTPortTypeArray[n];
            ASTOperation[] aSTOperationArray = aSTPortType.getOperations();
            if (aSTOperationArray != null) {
                int n2 = 0;
                while (n2 < aSTOperationArray.length) {
                    int n3;
                    Object[] objectArray;
                    ASTOperation aSTOperation = aSTOperationArray[n2];
                    ASTMessage aSTMessage = aSTOperation.getInput();
                    if (aSTMessage != null && aSTMessage.hasParts()) {
                        objectArray = aSTMessage.getParts();
                        n3 = 0;
                        while (n3 < objectArray.length) {
                            Main.mapJavaType((ASTPart)objectArray[n3]);
                            ++n3;
                        }
                    }
                    if ((aSTMessage = aSTOperation.getOutput()) != null && aSTMessage.hasParts()) {
                        objectArray = aSTMessage.getParts();
                        n3 = 0;
                        while (n3 < objectArray.length) {
                            Main.mapJavaType((ASTPart)objectArray[n3]);
                            ++n3;
                        }
                    }
                    if (aSTOperation.hasFaults()) {
                        objectArray = aSTOperation.getFaults();
                        n3 = 0;
                        while (n3 < objectArray.length) {
                            Class clazz = ((ASTMessage)objectArray[n3]).getPart(0).getJavaClass();
                            if (!clazz.getName().equals("java.rmi.RemoteException")) {
                                ASTPart aSTPart = ((ASTMessage)objectArray[n3]).getPart(0);
                                Main.mapJavaType(aSTPart);
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public static void mapJavaType(ASTPart aSTPart) {
        String string;
        Class clazz = aSTPart.getJavaClass();
        String string2 = Main.mapJavaType(clazz);
        String string3 = Main.getPrefix(string2);
        if (string3 == null) {
            string3 = "";
        }
        if ((string = Main.getLocalName(string2)) == null) {
            string3 = "xsd";
            string = "anyType";
        }
        string = string.replace('$', '.');
        aSTPart.setQName(new QName((String)_revNamespaces.get(string3), string));
        if (_isLiteral) {
            aSTPart.setElement(true);
        } else {
            aSTPart.setElement(false);
        }
        Class<?> clazz2 = aSTPart.getJavaClass();
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        if (!_noMarshaler && Main.needsMarshaler(clazz2)) {
            _needsMarshaler.put(clazz2, aSTPart.getQName());
        }
    }

    private static boolean needsMarshaler(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        if (_primitive.get(clazz2) != null) {
            return false;
        }
        if (clazz2.equals(Character.TYPE)) {
            return false;
        }
        if (_mapper.get(clazz2) != null) {
            return false;
        }
        if (_generatedClasses.contains(clazz2)) {
            return false;
        }
        if (_needsMarshaler.containsKey(clazz2)) {
            return false;
        }
        return !_alsoNeedMarshaler.containsKey(clazz2);
    }

    private static String mapJavaType(Class clazz) {
        TypeMap typeMap = _primitive.get(clazz);
        if (typeMap != null) {
            return "xsd:" + typeMap.getQName().getLocalPart();
        }
        String string = (String)_types.get(clazz);
        if (string == null) {
            if (clazz.equals(Character.TYPE)) {
                return "xsd:string";
            }
            TypeMap typeMap2 = _mapper.get(clazz);
            if (typeMap2 != null) {
                XMLType xMLType = typeMap2.getXMLType();
                QName qName = xMLType.getQName();
                String string2 = Main.importType(xMLType);
                string = string2 + ":" + qName.getLocalPart();
                _types.put(clazz, string);
            }
        }
        if (string == null) {
            string = Main.generateSchema(clazz, class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object);
            _types.put(clazz, string);
        }
        return string;
    }

    public static String getPrefix(String string) {
        int n = string.lastIndexOf(":");
        return n == -1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.lastIndexOf(":");
        return n == -1 ? string : string.substring(n + 1, string.length());
    }

    private static String importType(XMLType xMLType) {
        Main.info("importing type " + xMLType);
        QName qName = xMLType.getQName();
        String string = (String)_namespaces.get(qName.getNamespaceURI());
        if (string == null) {
            string = "ns" + _nsCount++;
            _namespaces.put(qName.getNamespaceURI(), string);
            _revNamespaces.put(string, qName.getNamespaceURI());
        }
        return string;
    }

    private static String generateSchema(Class clazz, Class clazz2) {
        if (clazz.isArray()) {
            return Main.generateXML(clazz, false);
        }
        ArrayList arrayList = CodeGenUtil.getSuperclasses(clazz, clazz2);
        Class[] classArray = new Class[arrayList.size()];
        classArray = arrayList.toArray(classArray);
        int n = classArray.length;
        Main.checkForMarshalerDifferences(classArray);
        String string = Main.generateSchema(clazz);
        return string;
    }

    private static void checkForMarshalerDifferences(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return;
        }
        int n = classArray.length;
        Class clazz = classArray[n - 1];
        TypeMap typeMap = Main.getMapping(clazz);
        if (typeMap == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Class clazz2 = classArray[n2];
            TypeMap typeMap2 = Main.getMapping(clazz2);
            if (typeMap2 == null) {
                Main.error("incompatible mapping for superclasses of " + clazz.getName());
            }
            if (!Main.isSameClass(typeMap2.getSerializer(), typeMap.getSerializer()) || !Main.isSameClass(typeMap2.getDeserializer(), typeMap.getDeserializer())) {
                Main.error("incompatible mapping for superclasses of " + clazz.getName());
            }
            ++n2;
        }
    }

    private static boolean isSameClass(Object object, Object object2) {
        return object.getClass().getName().equals(object2.getClass().getName());
    }

    private static TypeMap getMapping(Class clazz) {
        return _mapper.get(clazz);
    }

    private static String generateSchema(Class clazz) {
        if (clazz.isArray()) {
            return Main.generateXML(clazz, false);
        }
        TypeMap typeMap = _mapper.get(clazz);
        String string = null;
        if (typeMap == null) {
            return Main.generateXML(clazz);
        }
        string = Main.importType(typeMap.getXMLType());
        if (string != null) {
            String string2 = string + ":" + typeMap.getXMLType().getQName().getLocalPart();
            _types.put(clazz, string2);
            return string2;
        }
        Main.info("unknown mapping for " + typeMap);
        return null;
    }

    private static String generateXML(Class clazz) {
        String string = (String)_generatedTypes.get(clazz);
        if (string != null) {
            return string;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var5_5 = null;
        TypeMap typeMap = _mapper.get(clazz);
        string4 = typeMap == null ? null : typeMap.getQName().getNamespaceURI();
        if (string4 == null) {
            string4 = Main.packageNS(CodeGenUtil.getClassName(clazz));
        }
        if ((string3 = clazz.getName()).indexOf(".") != -1) {
            int n = string3.lastIndexOf(".");
            string3 = string3.substring(n + 1, string3.length());
        }
        if (string4 != null && string4.length() > 0 && (string2 = (String)_namespaces.get(string4)) == null) {
            string2 = "ns" + _nsCount++;
            _namespaces.put(string4, string2);
            _revNamespaces.put(string2, string4);
        }
        string = string2 == null ? string3 : string2 + ":" + string3;
        _types.put(clazz, string);
        if (clazz.isPrimitive()) {
            return string;
        }
        string = string2 == null ? string3 : string2 + ":" + string3;
        _generatedTypes.put(clazz, string);
        return string;
    }

    private static String generateXML(Class clazz, boolean bl) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Class<?> clazz2 = null;
        String string4 = null;
        int n = 0;
        if (clazz.isArray()) {
            n = 1;
            clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            string3 = Main.packageNS(CodeGenUtil.getClassName(clazz2));
            if (clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = Main.class$("java.lang.Object")) : class$java$lang$Object)) {
                Main.warn(_messages.get("rmi2soap.warning.object.array"));
                return "xsd:anyType";
            }
            string2 = clazz2.getName();
        } else {
            TypeMap typeMap = _mapper.get(clazz);
            string3 = typeMap.getQName().getNamespaceURI();
            if (string3 == null) {
                string3 = Main.packageNS(CodeGenUtil.getClassName(clazz));
            }
            string2 = clazz.getName();
        }
        if (string2.indexOf(".") != -1) {
            int n2 = string2.lastIndexOf(".");
            string2 = string2.substring(n2 + 1, string2.length());
        }
        if (string3 != null && string3.length() > 0 && (string = (String)_namespaces.get(string3)) == null) {
            string = "ns" + _nsCount++;
            _namespaces.put(string3, string);
            _revNamespaces.put(string, string3);
        }
        if (n > 0) {
            int n3;
            int n4 = n3 = clazz2 == Byte.TYPE ? 1 : 0;
            while (n4 < n) {
                Class<?> clazz3 = clazz;
                int n5 = 0;
                while (n5 < n - n4 - 1) {
                    clazz3 = clazz3.getComponentType();
                    ++n5;
                }
                if (_types.get(clazz3) == null) {
                    string4 = string != null ? string + ":" + string2 : string2;
                    _types.put(clazz3, string2);
                }
                ++n4;
            }
        } else {
            string4 = string == null ? string2 : string + ":" + string2;
            _types.put(clazz, string4);
        }
        return string4;
    }

    private static String packageNS(String string) {
        String string2;
        if (string.indexOf(".") == -1) {
            return "";
        }
        String string3 = string.substring(0, string.lastIndexOf("."));
        if (_pack2ns.containsKey(string3)) {
            string2 = (String)_pack2ns.get(string3);
            Main.info(_messages.get("rmi2soap.verbose.mapped.pkg.to.ns", string3, string2));
        } else {
            if (_xmlns != null) {
                return _xmlns;
            }
            string2 = "http://www.";
            int n = string3.indexOf(".");
            if (n != -1) {
                int n2 = string3.indexOf(".", n + 1);
                if (n2 == -1) {
                    n2 = string3.length();
                }
                string2 = string2 + string3.substring(n + 1, n2);
                string2 = string2 + "." + string3.substring(0, n);
                if (n2 != -1 && n2 != string3.length()) {
                    string2 = string2 + "/" + string3.substring(n2 + 1, string3.length()).replace('.', '/');
                }
            } else {
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static void writeMarshaler(Class var0, QName var1_1, File var2_2, Vector var3_3) throws IOException {
        if (var0.isInterface()) {
            return;
        }
        if (var0 == (Main.class$java$lang$Object == null ? (Main.class$java$lang$Object = Main.class$("java.lang.Object")) : Main.class$java$lang$Object)) {
            return;
        }
        if (ValueTypeMarshaler.isJAXRPCValueType(var0)) ** GOTO lbl9
        Main.warn(Main._messages.get("rmi2soap.warning.not.valuetype", var0.getName()));
        return;
lbl-1000:
        // 1 sources

        {
            var0 = var0.getComponentType();
lbl9:
            // 2 sources

            ** while (var0.isArray())
        }
lbl10:
        // 1 sources

        var4_4 = CodeGenUtil.getClassName(var0);
        var5_5 = var4_4.indexOf(".") == -1 ? var4_4 : var4_4.substring(var4_4.lastIndexOf(".") + 1);
        var6_6 = "";
        if (var4_4.lastIndexOf(".") != -1) {
            var6_6 = var4_4.substring(0, var4_4.lastIndexOf(".")).trim();
        }
        var7_7 = var6_6.length() > 0 ? "." + var6_6 : var6_6;
        var8_8 = var2_2 + var7_7.replace('.', File.separatorChar);
        if (!var8_8.endsWith(File.separator)) {
            var8_8 = var8_8 + File.separator;
        }
        if (!(var9_9 = new File(var8_8)).exists() && !var9_9.mkdirs()) {
            Main.error(Main._messages.get("rmi2soap.error.unable.to.create.directory", "rmi2soap", var8_8));
        } else if (!var9_9.isDirectory()) {
            Main.error(Main._messages.get("rmi2soap.error.exists.but.not.directory", "rmi2soap", var8_8));
        }
        var10_10 = var8_8 + var5_5 + "Marshaler.java";
        var11_11 = new FileWriter(var10_10);
        var11_11.write("// Generated by rmi2soap \n");
        var11_11.write("// On " + new Date().toString() + "\n\n");
        if (var6_6 != null && var6_6.trim().length() > 0) {
            var11_11.write("package " + var6_6 + ";\n\n");
        }
        var11_11.write("public class " + var5_5 + "Marshaler");
        var11_11.write(" implements com.sssw.jbroker.web.encoding.Marshaler\n{\n");
        var11_11.write("    public " + var5_5 + "Marshaler()");
        var11_11.write("\n    {\n    }\n\n");
        var12_12 = Main.getBeanProperties(var0, Main.class$java$lang$Object == null ? (Main.class$java$lang$Object = Main.class$("java.lang.Object")) : Main.class$java$lang$Object);
        var13_13 = Main.getPublicFields(var0, true);
        var14_14 = var12_12.keySet().iterator();
        while (var14_14.hasNext()) {
            var15_15 = (String)var14_14.next();
            var13_13.remove(var15_15);
        }
        var15_15 = new HashMap<K, V>();
        var15_15.putAll(var12_12);
        var15_15.putAll(var13_13);
        var16_16 = new HashMap<String, String>();
        var14_14 = var15_15.keySet().iterator();
        while (var14_14.hasNext()) {
            var17_17 = (String)var14_14.next();
            var18_18 = "_" + var17_17.toUpperCase();
            var11_11.write("    private static final java.lang.String " + var18_18 + " = " + "\"" + var17_17 + "\";\n");
            var16_16.put(var17_17, var18_18);
        }
        var11_11.write("\n");
        var11_11.write("\n    public com.sssw.jbroker.web.encoding.Attribute[] getAttributes(");
        var11_11.write("java.lang.Object obj)\n");
        var11_11.write("    {\n        return null;\n    }\n");
        var11_11.write("\n    public void serialize(com.sssw.jbroker.web.portable.OutputStream os,");
        var11_11.write(" java.lang.Object obj) throws java.io.IOException\n    {\n");
        var17_17 = var5_5;
        if (Modifier.isStatic(var0.getModifiers())) {
            var17_17 = var4_4.replace('$', '.');
        }
        var11_11.write("        " + var17_17 + " mar = (" + var17_17 + ") obj;\n");
        var14_14 = var12_12.keySet().iterator();
        while (var14_14.hasNext()) {
            var18_18 = (String)var14_14.next();
            var19_19 = (Class)var12_12.get(var18_18);
            var20_21 = CodeGenUtil.getClassName(var19_19);
            if (!Main.isSimple(var20_21)) {
                var20_21 = "Object";
            }
            var11_11.write("        os.write");
            var11_11.write(Character.toUpperCase(var20_21.charAt(0)));
            var11_11.write(var20_21.substring(1));
            var11_11.write("(mar.get");
            var21_22 = Main.fixName(var18_18);
            var11_11.write(Character.toUpperCase(var21_22.charAt(0)));
            var11_11.write(var21_22.substring(1) + "(), " + (String)var16_16.get(var18_18) + ");\n");
        }
        var14_14 = var13_13.keySet().iterator();
        while (var14_14.hasNext()) {
            var18_18 = (String)var14_14.next();
            var19_19 = (Class)var13_13.get(var18_18);
            var20_21 = CodeGenUtil.getClassName(var19_19);
            if (!Main.isSimple(var20_21)) {
                var20_21 = "Object";
            }
            var11_11.write("        os.write");
            var11_11.write(Character.toUpperCase(var20_21.charAt(0)));
            var11_11.write(var20_21.substring(1));
            var11_11.write("(mar." + var18_18 + ", " + (String)var16_16.get(var18_18) + ");\n");
        }
        var11_11.write("    }\n");
        var18_18 = "";
        var11_11.write("\n    public java.lang.String getMechanismType()\n");
        var11_11.write("    {\n        return null;\n    }\n");
        var11_11.write("\n    public java.lang.Object deserialize(com.sssw.jbroker.web.portable.InputStream is, java.lang.Class cl)");
        var11_11.write(" throws java.io.IOException\n    {\n");
        var11_11.write("        if (cl != " + var4_4 + ".class)\n");
        var11_11.write("            throw new\n");
        var11_11.write("                com.sssw.jbroker.web.ServiceException(\"can't deserialize \" + cl.getName());\n");
        var11_11.write("\n        try {\n");
        var18_18 = "            ";
        var11_11.write(var18_18 + "// create the object\n");
        var11_11.write(var18_18 + var17_17 + " mar = new " + var17_17 + "();\n");
        var11_11.write(var18_18 + "try {\n");
        var18_18 = "                ";
        var11_11.write(var18_18 + "// read elements\n");
        var11_11.write(var18_18 + "java.lang.String fName = null;\n");
        var11_11.write(var18_18 + "com.sssw.jbroker.web.QName qName = null;\n");
        var11_11.write(var18_18 + "for (int i=0; i < " + var15_15.size() + "; i++) {\n");
        var18_18 = "                    ";
        var11_11.write(var18_18 + "qName = is.peek();\n");
        var11_11.write(var18_18 + "if (qName == null) break;\n");
        var11_11.write(var18_18 + "fName = qName.getLocalPart();\n");
        var19_20 = 0;
        var14_14 = var12_12.keySet().iterator();
        while (var14_14.hasNext()) {
            var20_21 = (String)var14_14.next();
            var21_22 = (Class)var12_12.get(var20_21);
            if (var19_20++ == 0) {
                var11_11.write(var18_18 + "if");
            } else {
                var11_11.write(var18_18 + "else if");
            }
            var11_11.write("(fName.equals(" + (String)var16_16.get(var20_21) + "))\n");
            var11_11.write(var18_18 + "    mar.set");
            var22_23 = Main.fixName(var20_21);
            var11_11.write(Character.toUpperCase(var22_23.charAt(0)));
            var11_11.write(var22_23.substring(1) + "(");
            var23_24 = CodeGenUtil.getClassName((Class)var21_22);
            var24_25 = var23_24;
            if (ClassUtil.isInner((Class)var21_22)) {
                var24_25 = JavaUtil.getInnerClassName((Class)var21_22);
            }
            if (!Main.isSimple((String)var23_24)) {
                var11_11.write("(" + var24_25 + ")");
                var23_24 = "Object";
            }
            var11_11.write("is.read");
            var11_11.write(Character.toUpperCase(var23_24.charAt(0)));
            var11_11.write(var23_24.substring(1));
            if ("Object".equals(var23_24)) {
                var11_11.write("(" + var24_25 + ".class, " + (String)var16_16.get(var20_21) + "));\n");
                continue;
            }
            var11_11.write("(" + (String)var16_16.get(var20_21) + "));\n");
        }
        var14_14 = var13_13.keySet().iterator();
        while (var14_14.hasNext()) {
            var20_21 = (String)var14_14.next();
            var21_22 = (Class)var13_13.get(var20_21);
            if (var19_20++ == 0) {
                var11_11.write(var18_18 + "if");
            } else {
                var11_11.write(var18_18 + "else if");
            }
            var11_11.write("(fName.equals(" + (String)var16_16.get(var20_21) + "))\n");
            var11_11.write(var18_18 + "    mar." + var20_21 + " = ");
            var22_23 = CodeGenUtil.getClassName((Class)var21_22);
            var23_24 = var22_23;
            if (ClassUtil.isInner((Class)var21_22)) {
                var23_24 = JavaUtil.getInnerClassName((Class)var21_22);
            }
            if (!Main.isSimple((String)var22_23)) {
                var11_11.write("(" + (String)var23_24 + ")");
                var22_23 = "Object";
            }
            var11_11.write("is.read");
            var11_11.write(Character.toUpperCase(var22_23.charAt(0)));
            var11_11.write(var22_23.substring(1));
            if ("Object".equals(var22_23)) {
                var11_11.write("(" + (String)var23_24 + ".class, " + (String)var16_16.get(var20_21) + ");\n");
                continue;
            }
            var11_11.write("(" + (String)var16_16.get(var20_21) + ");\n");
        }
        if (!var13_13.isEmpty() || !var12_12.isEmpty()) {
            var11_11.write(var18_18 + "else\n");
            var11_11.write(var18_18 + "    throw new java.io.IOException(\"encountered " + "unexpected element: \" + fName);\n");
        }
        var18_18 = "                ";
        var11_11.write(var18_18 + "}\n");
        var18_18 = "            ";
        var11_11.write(var18_18 + "} catch (java.io.EOFException eofExc) {}\n");
        var11_11.write(var18_18 + "return mar;\n");
        var18_18 = "        ";
        var11_11.write(var18_18 + "} catch (Exception ex) {\n");
        var11_11.write(var18_18 + "    if (ex instanceof java.io.IOException)\n");
        var11_11.write(var18_18 + "        throw (java.io.IOException) ex;\n");
        var11_11.write(var18_18 + "    throw new com.sssw.jbroker.web.ServiceException(ex);\n");
        var11_11.write(var18_18 + "}\n");
        var11_11.write("    }\n");
        var11_11.write("}\n");
        var11_11.flush();
        var11_11.close();
        var20_21 = var6_6.trim();
        if (var20_21.length() > 0) {
            var20_21 = var20_21 + ".";
        }
        var20_21 = var20_21 + var5_5 + "Marshaler";
        Main._generatedMappings.put("tm" + Main._tmCount++, var4_4 + " " + var20_21 + " " + var20_21 + " " + var1_1.getNamespaceURI() + " " + var1_1.getLocalPart() + " none");
        var3_3.addElement(new File(var10_10));
        Main.info(Main._messages.get("rmi2soap.verbose.writing", var10_10));
        var14_14 = var15_15.keySet().iterator();
        while (var14_14.hasNext()) {
            var21_22 = (String)var14_14.next();
            var22_23 = (Class)var15_15.get(var21_22);
            var23_24 = var22_23;
            while (var23_24.isArray()) {
                var23_24 = var23_24.getComponentType();
            }
            if (!Main.needsMarshaler(var23_24)) continue;
            var24_25 = Main.mapJavaType(var23_24);
            var25_26 = Main.getPrefix(var24_25);
            var26_27 = (String)Main._revNamespaces.get(var25_26);
            var27_28 = Main.getLocalName(var24_25);
            Main._alsoNeedMarshaler.put(var23_24, new QName(var26_27, var27_28));
        }
    }

    private static final Map getPublicFields(Class clazz) {
        HashMap hashMap = new HashMap();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            hashMap.put(fieldArray[n].getName(), fieldArray[n].getType());
            ++n;
        }
        return hashMap;
    }

    private static final Map getPublicFields(Class clazz, boolean bl) {
        if (bl) {
            return Main.getPublicFields(clazz);
        }
        HashMap hashMap = new HashMap();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (!Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                hashMap.put(fieldArray[n].getName(), fieldArray[n].getType());
            }
            ++n;
        }
        return hashMap;
    }

    private static final Map getBeanProperties(Class clazz, Class clazz2) {
        if ((class$java$lang$Throwable == null ? (class$java$lang$Throwable = Main.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(clazz)) {
            clazz2 = class$java$lang$Throwable == null ? (class$java$lang$Throwable = Main.class$("java.lang.Throwable")) : class$java$lang$Throwable;
        }
        HashMap hashMap = new HashMap();
        try {
            BeanInfo beanInfo = clazz2 == null ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, clazz2);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (!Main.isReadWrite(propertyDescriptorArray[n])) {
                    Main.warn(_messages.get("rmi2soap.warning.bean.read.only.prop", propertyDescriptorArray[n].getName(), clazz.getName()));
                } else {
                    hashMap.put(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n].getPropertyType());
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            Main.warn(_messages.get("rmi2soap.warning.bean.introspection", clazz));
            Main.warn(introspectionException.getMessage());
        }
        return hashMap;
    }

    private static String fixName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = "";
        string2 = string2 + (Character.isJavaIdentifierStart(string.charAt(0)) ? string.charAt(0) : (char)'_');
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            string2 = string2 + (Character.isJavaIdentifierPart(string.charAt(n2)) ? string.charAt(n2) : (char)'_');
            ++n2;
        }
        return string2;
    }

    private static boolean isSimple(String string) {
        return string.equals("boolean") || string.equals("byte") || string.equals("double") || string.equals("float") || string.equals("int") || string.equals("long") || string.equals("short");
    }

    private static boolean isReadWrite(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getName() != "class" && !Main.isStackTraceElement(propertyDescriptor);
    }

    private static boolean isStackTraceElement(PropertyDescriptor propertyDescriptor) {
        return _stackTraceElementClass != null && propertyDescriptor.getPropertyType().isArray() && propertyDescriptor.getPropertyType().getComponentType().equals(_stackTraceElementClass) && propertyDescriptor.getName().equals("stackTrace");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _nogenerate = false;
        _messages = new Messages(class$com$sssw$jbroker$tools$rmi2soap$Main == null ? (class$com$sssw$jbroker$tools$rmi2soap$Main = Main.class$("com.sssw.jbroker.tools.rmi2soap.Main")) : class$com$sssw$jbroker$tools$rmi2soap$Main);
        _usage = _messages.get("rmi2soap.usage") + Copyright._copyright + "\n";
        _mapper = new DefaultTypeMappingRegistry();
        _generatedMappings = new Properties();
        _generatedClasses = new HashSet();
        _needsMarshaler = new HashMap();
        _alsoNeedMarshaler = new HashMap();
        _pack2ns = new HashMap();
        _namespaces = new HashMap();
        _revNamespaces = new HashMap();
        _generatedTypes = new HashMap();
        _types = new HashMap();
        _primitive = PrimitiveTypeMapper.getSingleton();
        _location = null;
        _isDocument = false;
        _transport = null;
        _action = null;
        _isLiteral = false;
        _encodingURI = null;
        _noMarshaler = false;
        _serviceName = null;
        _nsCount = 0;
        _tmCount = 0;
        _nonPrimitiveMappings = new Class[]{class$com$sssw$jbroker$web$core$mapping$SetMapping == null ? (class$com$sssw$jbroker$web$core$mapping$SetMapping = Main.class$("com.sssw.jbroker.web.core.mapping.SetMapping")) : class$com$sssw$jbroker$web$core$mapping$SetMapping, class$com$sssw$jbroker$web$core$mapping$ListMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ListMapping = Main.class$("com.sssw.jbroker.web.core.mapping.ListMapping")) : class$com$sssw$jbroker$web$core$mapping$ListMapping, class$com$sssw$jbroker$web$core$mapping$MapMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapMapping = Main.class$("com.sssw.jbroker.web.core.mapping.MapMapping")) : class$com$sssw$jbroker$web$core$mapping$MapMapping, class$com$sssw$jbroker$web$core$mapping$MapEntryMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapEntryMapping = Main.class$("com.sssw.jbroker.web.core.mapping.MapEntryMapping")) : class$com$sssw$jbroker$web$core$mapping$MapEntryMapping, class$com$sssw$jbroker$web$core$mapping$ClassMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ClassMapping = Main.class$("com.sssw.jbroker.web.core.mapping.ClassMapping")) : class$com$sssw$jbroker$web$core$mapping$ClassMapping, class$com$sssw$jbroker$web$core$mapping$QNameMapping == null ? (class$com$sssw$jbroker$web$core$mapping$QNameMapping = Main.class$("com.sssw.jbroker.web.core.mapping.QNameMapping")) : class$com$sssw$jbroker$web$core$mapping$QNameMapping, class$com$sssw$jbroker$web$core$mapping$BindingMapping == null ? (class$com$sssw$jbroker$web$core$mapping$BindingMapping = Main.class$("com.sssw.jbroker.web.core.mapping.BindingMapping")) : class$com$sssw$jbroker$web$core$mapping$BindingMapping, class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping = Main.class$("com.sssw.jbroker.web.core.mapping.ServiceObjectMapping")) : class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping, class$com$sssw$jbroker$web$soap$mapping$ElementMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$ElementMapping = Main.class$("com.sssw.jbroker.web.soap.mapping.ElementMapping")) : class$com$sssw$jbroker$web$soap$mapping$ElementMapping, class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping = Main.class$("com.sssw.jbroker.web.soap.mapping.StackTraceMapping")) : class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping};
        _stackTraceElementClass = null;
        try {
            _stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

