/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap;

import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPart;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class Util {
    private static final Class[] _primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private static final String[] _primNames = new String[_primitives.length];
    private static Hashtable streamMethods;

    public static String getPrimitiveWrapper(String string, String string2) {
        if (string.equals("char")) {
            String string3 = "String";
            return "(\"\" + " + string2 + ")";
        }
        String string4 = (String)PrimitiveUtil.primitiveWrappers.get(string);
        return "new " + string4 + "(" + string2 + ")";
    }

    public static String getObjectWrapper(String string, QName qName) {
        return "new com.sssw.jbroker.web.ObjectWrapper(\"" + qName.getNamespaceURI() + "\", " + "\"" + qName.getLocalPart() + "\", " + string + ")";
    }

    public static String getParmWrite(String string, QName qName) {
        return "out.writeObject(" + string + ",  \"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");";
    }

    public static String getParmWrite(String string, ASTSoapPart aSTSoapPart) {
        if (aSTSoapPart.getTypeQName() == null) {
            return Util.getParmWrite(string, aSTSoapPart.getQName());
        }
        return "out.writeObject(" + string + ",  \"" + aSTSoapPart.getQName().getNamespaceURI() + "\", \"" + aSTSoapPart.getQName().getLocalPart() + "\", \"" + aSTSoapPart.getTypeQName().getNamespaceURI() + "\", \"" + aSTSoapPart.getTypeQName().getLocalPart() + "\");";
    }

    public static String getParmWrite(boolean bl, ASTSoapPart aSTSoapPart, String string) {
        QName qName = aSTSoapPart.getQName();
        boolean bl2 = aSTSoapPart.getMimePart();
        if (bl2) {
            return Util.getMIMEParmWrite(aSTSoapPart, string);
        }
        if (bl) {
            if (aSTSoapPart.isElement()) {
                return Util.getParmWrite("arg", aSTSoapPart);
            }
            return Util.getParmWrite("arg", aSTSoapPart);
        }
        if (aSTSoapPart.isElement()) {
            String string2 = Util.getObjectWrapper("arg", qName);
            return Util.getParmWrite(string2, aSTSoapPart);
        }
        return Util.getParmWrite("arg", aSTSoapPart);
    }

    public static String getMIMEParmWrite(ASTSoapPart aSTSoapPart, String string) {
        if (aSTSoapPart.isElement()) {
            return "out.writeAttachment(" + string + ", \"" + aSTSoapPart.getQName().getNamespaceURI() + "\", \"" + aSTSoapPart.getQName().getLocalPart() + "\", \"" + aSTSoapPart.getMimeType() + "\");";
        }
        return "out.writeAttachment(" + string + ", null, \"" + aSTSoapPart.getName() + "\", \"" + aSTSoapPart.getMimeType() + "\");";
    }

    public static void generateParmWrite(ASTSoapPart aSTSoapPart, String string, int n, boolean bl, boolean bl2, Formatter formatter) {
        if (n == 1 && !bl2) {
            return;
        }
        if (n == 2 && bl2) {
            return;
        }
        if (n != 1) {
            if (aSTSoapPart.isInOutPrimitive()) {
                String string2 = string + "Value";
                formatter.println(aSTSoapPart.getInOutType() + " " + string2 + " = " + string + ".value;");
                formatter.println("arg = " + Util.getPrimitiveWrapper(aSTSoapPart.getInOutType(), string2) + ";");
            } else {
                formatter.println("arg = " + string + ".value;");
            }
        } else if (aSTSoapPart.isPrimitive()) {
            formatter.println("arg = " + Util.getPrimitiveWrapper(aSTSoapPart.getDataType(), string) + ";");
        } else {
            formatter.println("arg = " + string + ";");
        }
        formatter.println(Util.getParmWrite(bl, aSTSoapPart, "arg"));
    }

    public static void generateParmWrite(ASTSoapPart aSTSoapPart, String string, boolean bl, boolean bl2, Formatter formatter) {
        Util.generateParmWrite(aSTSoapPart, string, aSTSoapPart.getMode(), bl, bl2, formatter);
    }

    public static void generateParmRead(String string, ASTSoapPart aSTSoapPart, String string2, int n, boolean bl, boolean bl2, Formatter formatter) {
        QName qName = aSTSoapPart.getQName();
        String string3 = aSTSoapPart.getDataType();
        if (bl2 && n == 1) {
            return;
        }
        if (n == 2 && !bl2) {
            formatter.println(string3 + " " + string2 + " = new " + string3 + "();");
            return;
        }
        String string4 = null;
        String string5 = null;
        if (n != 1) {
            if (!bl2) {
                formatter.println(string3 + " " + string2 + " = new " + string3 + "();");
            }
            if (aSTSoapPart.isInOutPrimitive()) {
                string3 = aSTSoapPart.getInOutType();
                string5 = (String)PrimitiveUtil.primitiveWrappers.get(string3);
                string4 = string2 + "Wrapper";
                formatter.print(string5 + " " + string4 + " = (" + string5 + ")");
            } else {
                string3 = aSTSoapPart.getInOutType();
                string4 = string2 + "Wrapper";
                formatter.println(string3 + " " + string4 + " = null;");
                formatter.println("try {");
                formatter.startBlock();
                formatter.println(string4 + " = (" + string3 + ")");
            }
        } else if (aSTSoapPart.isPrimitive()) {
            string5 = (String)PrimitiveUtil.primitiveWrappers.get(string3);
            string4 = string2 + "Wrapper";
            formatter.print(string5 + " " + string4 + " = (" + string5 + ")");
        } else {
            formatter.println(string3 + " " + string2 + " = null;");
            formatter.println("try {");
            formatter.startBlock();
            formatter.println(string2 + " = (" + string3 + ")");
        }
        if (aSTSoapPart.getMimePart()) {
            if (aSTSoapPart.isElement()) {
                formatter.println(string + ".readAttachment(" + "\"" + qName.getNamespaceURI() + "\", " + "\"" + qName.getLocalPart() + "\", " + string3 + ".class);");
            } else {
                formatter.println(string + ".readAttachment(" + "null, " + "\"" + aSTSoapPart.getName() + "\", " + string3 + ".class);");
            }
        } else if (bl) {
            if (aSTSoapPart.isElement()) {
                formatter.println(string + ".readObject(" + string3 + ".class, " + "\"" + qName.getNamespaceURI() + "\", " + "\"" + qName.getLocalPart() + "\");");
            } else {
                formatter.println(Util.getParmRead(string, string3, aSTSoapPart.getName()));
            }
        } else if (aSTSoapPart.isElement()) {
            formatter.println(Util.getParmRead(string, "com.sssw.jbroker.web.ObjectWrapper", aSTSoapPart.getName()));
        } else {
            formatter.println(Util.getParmRead(string, string3, aSTSoapPart.getName()));
        }
        if (n != 1) {
            if (aSTSoapPart.isInOutPrimitive()) {
                formatter.println(string2 + ".value = " + Util.getPrimitiveFromObject(aSTSoapPart.getInOutType(), string4) + ";");
            } else {
                formatter.endBlock();
                formatter.println("} catch (java.io.EOFException eofExc) {");
                formatter.startBlock();
                if (bl) {
                    formatter.println(string4 + " = null;");
                } else {
                    formatter.println("throw ServiceException.mapToRemote(eofExc);");
                }
                formatter.endBlock();
                formatter.println("}");
                formatter.println(string2 + ".value = " + string4 + ";");
            }
        } else if (aSTSoapPart.isPrimitive()) {
            formatter.println(string3 + " " + string2 + " = " + Util.getPrimitiveFromObject(aSTSoapPart.getDataType(), string4) + ";");
        } else {
            formatter.endBlock();
            formatter.println("} catch (java.io.EOFException eofExc) {");
            formatter.startBlock();
            if (bl) {
                formatter.println(string2 + " = null;");
            } else {
                formatter.println("throw ServiceException.mapToRemote(eofExc);");
            }
            formatter.endBlock();
            formatter.println("}");
        }
    }

    public static void generateParmRead(String string, ASTSoapPart aSTSoapPart, String string2, boolean bl, boolean bl2, Formatter formatter) {
        Util.generateParmRead(string, aSTSoapPart, string2, aSTSoapPart.getMode(), bl, bl2, formatter);
    }

    public static void generateFaultParmRead(String string, ASTPart aSTPart, boolean bl, Formatter formatter) {
        QName qName = aSTPart.getQName();
        String string2 = aSTPart.getName();
        String string3 = aSTPart.getDataType();
        String string4 = null;
        String string5 = null;
        if (aSTPart.isPrimitive()) {
            string5 = (String)PrimitiveUtil.primitiveWrappers.get(string3);
            string4 = string2 + "Wrapper";
            formatter.print(string5 + " " + string4 + " = (" + string5 + ")");
        } else {
            formatter.println(string3 + " " + string2 + " = null;");
            formatter.println(string2 + " = (" + string3 + ")");
        }
        if (bl) {
            if (aSTPart.isElement()) {
                formatter.println(string + ".readObject(" + string3 + ".class, " + "\"" + qName.getNamespaceURI() + "\", " + "\"" + qName.getLocalPart() + "\");");
            } else {
                formatter.println(Util.getParmRead(string, string3, aSTPart.getName()));
            }
        } else if (aSTPart.isElement()) {
            formatter.println(Util.getParmRead(string, "com.sssw.jbroker.web.ObjectWrapper", aSTPart.getName()));
        } else {
            formatter.println(Util.getParmRead(string, string3, aSTPart.getName()));
        }
    }

    public static String getPrimitiveFromObject(String string, String string2) {
        if (string.equals("char")) {
            return string2 + ".charAt(0)";
        }
        return string2 + "." + string + "Value()";
    }

    public static String getParmRead(String string, String string2, String string3) {
        return string + ".readObject(" + string2 + ".class, " + "\"" + string3 + "\");";
    }

    public static void generateSkelReturn(ASTSoapBodyMessage aSTSoapBodyMessage, boolean bl, Formatter formatter) {
        if (aSTSoapBodyMessage == null || aSTSoapBodyMessage.isVoid()) {
            return;
        }
        ASTPart[] aSTPartArray = aSTSoapBodyMessage.getParts();
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n].getMode() == 2) {
                Util.generateParmWrite((ASTSoapPart)aSTPartArray[n], "result", 1, bl, true, formatter);
                return;
            }
            ++n;
        }
    }

    public static void generateReturn(ASTSoapBodyMessage aSTSoapBodyMessage, Formatter formatter, boolean bl) {
        if (aSTSoapBodyMessage == null || aSTSoapBodyMessage.isVoid()) {
            formatter.println("return;");
            return;
        }
        ASTPart[] aSTPartArray = aSTSoapBodyMessage.getParts();
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n].getMode() == 2) {
                Util.generateParmRead("in", (ASTSoapPart)aSTPartArray[n], "ret", 1, bl, false, formatter);
                formatter.println("return ret;");
                return;
            }
            ++n;
        }
    }

    public static String getStubNamePrefix(String string) {
        return Util.insertUnderscore(string);
    }

    public static void generateHeader(Formatter formatter, String string) {
        formatter.println("// " + new Date() + "\n");
        if (Util.packageName(string) != null) {
            formatter.println("package " + Util.packageName(string) + ";\n");
        }
        formatter.flush();
    }

    public static void generateImports(Formatter formatter, ASTBinding aSTBinding, HashSet hashSet) {
        Object object;
        String string = aSTBinding.getPackage();
        if (string != null && string.length() > 0) {
            Object object2;
            Object object3;
            object = new Hashtable();
            ASTOperation[] aSTOperationArray = aSTBinding.getOperations();
            int n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null) {
                    ASTMessage[] aSTMessageArray;
                    ASTPart[] aSTPartArray;
                    Object object4;
                    object3 = (ASTSoapOperation)aSTOperationArray[n];
                    object2 = (ASTSoapBodyMessage)((ASTOperation)object3).getInput();
                    if (object2 != null) {
                        object4 = ((ASTMessage)object2).getParts();
                        int n2 = 0;
                        while (n2 < ((Object)object4).length) {
                            String string2 = Util.getGlobalPackageType((ASTPart)object4[n2]);
                            if (string2 != null) {
                                ((Hashtable)object).put(string2, string2);
                            }
                            ++n2;
                        }
                    }
                    if ((object4 = (ASTSoapBodyMessage)((ASTOperation)object3).getOutput()) != null) {
                        ASTPart[] aSTPartArray2 = ((ASTMessage)object4).getParts();
                        int n3 = 0;
                        while (n3 < aSTPartArray2.length) {
                            aSTPartArray = Util.getGlobalPackageType(aSTPartArray2[n3]);
                            if (aSTPartArray != null) {
                                ((Hashtable)object).put(aSTPartArray, aSTPartArray);
                            }
                            ++n3;
                        }
                    }
                    if ((aSTMessageArray = ((ASTOperation)object3).getFaults()) != null) {
                        int n4 = 0;
                        while (n4 < aSTMessageArray.length) {
                            if (aSTMessageArray[n4] == null) {
                                aSTPartArray = aSTMessageArray[n4].getParts();
                                int n5 = 0;
                                while (n5 < aSTPartArray.length) {
                                    String string3 = Util.getGlobalPackageType(aSTPartArray[n5]);
                                    if (string3 != null) {
                                        ((Hashtable)object).put(string3, string3);
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n;
            }
            object3 = ((Hashtable)object).elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                formatter.println("import " + (String)object2 + ";");
            }
            if (((Hashtable)object).size() > 0) {
                formatter.println();
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            formatter.println("import " + object.next() + ".*;");
        }
        formatter.println();
    }

    public static String removePackageName(String string) {
        if (string == null) {
            return null;
        }
        return string.lastIndexOf(".") == -1 ? string : string.substring(string.lastIndexOf(".") + 1);
    }

    public static String packageName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    static String getGlobalPackageType(ASTPart aSTPart) {
        String string = aSTPart.getDataType();
        int n = string.indexOf("[]");
        string = n != -1 ? string.substring(0, n) : string;
        string = Util.isPrimitive(string) || string.indexOf(46) != -1 ? null : string;
        return "void".equals(string) ? null : string;
    }

    public static String insertUnderscore(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "_" + string : string.substring(0, n) + "._" + string.substring(n + 1);
    }

    public static boolean isPrimitive(String string) {
        int n = 0;
        while (n < _primNames.length) {
            if (string.equals(_primNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String fileName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static File getFile(File file, String string) {
        return Util.getFile(file, string, ".java");
    }

    protected static File getFile(File file, String string, String string2) {
        String string3 = string.replace('.', File.separatorChar);
        File file2 = new File(file, string3 + string2);
        new File(file2.getParent()).mkdirs();
        return file2;
    }

    public static void writeRootMIMEHeaders(Formatter formatter) {
        formatter.println();
        formatter.println("private static java.util.Properties _rootHeaders = new java.util.Properties();");
        formatter.println("static {");
        formatter.startBlock();
        formatter.println("_rootHeaders.setProperty(\"Content-Type\", \"text/xml; charset=UTF-8\");");
        formatter.println("_rootHeaders.setProperty(\"Content-Id\", \"<soapbody>\");");
        formatter.endBlock();
        formatter.println("}");
    }

    public static void generatePortType(ASTSoapBinding aSTSoapBinding, Formatter formatter, String string) {
        formatter.println("private static final java.lang.String portNs = \"" + aSTSoapBinding.getNsURI() + "\";");
        formatter.println("private static final java.lang.String portName = \"" + aSTSoapBinding.getPortTypeClassName() + "\";");
        formatter.println("private static final " + string + " _portType =");
        formatter.startBlock();
        formatter.println("new " + string + "(portNs, portName);");
        formatter.endBlock();
        formatter.println();
    }

    static {
        int n = 0;
        while (n < _primitives.length) {
            Util._primNames[n] = _primitives[n].getName();
            ++n;
        }
        streamMethods = new Hashtable(17);
        streamMethods.put(_primNames[0], "Boolean");
        streamMethods.put(_primNames[1], "Byte");
        streamMethods.put(_primNames[2], "Char");
        streamMethods.put(_primNames[3], "Double");
        streamMethods.put(_primNames[4], "Float");
        streamMethods.put(_primNames[5], "Int");
        streamMethods.put(_primNames[6], "Long");
        streamMethods.put(_primNames[7], "Short");
    }
}

