/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.ClientGenerator;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import com.sssw.jbroker.web.Binding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;

public class CallClientGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String _clientName;
    protected Hashtable _bindings;
    protected Hashtable _services;
    protected Hashtable _ports;
    protected ClassLoader _loader;
    private static final boolean _debug = false;

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
        this._bindings = new Hashtable();
        this._services = new Hashtable();
        this._ports = new Hashtable();
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        Object object;
        boolean bl = true;
        ASTService[] aSTServiceArray = this._astdoc.getServices();
        if (aSTServiceArray != null) {
            int n = 0;
            while (n < aSTServiceArray.length) {
                object = aSTServiceArray[n].getPorts();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < ((ASTPort[])object).length) {
                        ASTBinding aSTBinding = object[n2].getBinding();
                        if (aSTBinding != null && aSTBinding instanceof ASTSoapBinding) {
                            String string = aSTBinding.getName();
                            if (!this._bindings.containsKey(string)) {
                                this._bindings.put(string, aSTBinding);
                            }
                            this._services.put(string, aSTServiceArray[n]);
                            String string2 = null;
                            if (object[n2] instanceof ASTHttpPort) {
                                string2 = ((ASTHttpPort)object[n2]).getLocation();
                            } else if (object[n2] instanceof ASTSoapPort) {
                                string2 = ((ASTSoapPort)object[n2]).getLocation();
                            }
                            if (string2 != null) {
                                Binding binding = new Binding("soap", string2);
                                Vector<Binding> vector2 = (Vector<Binding>)this._ports.get(string);
                                if (vector2 == null) {
                                    vector2 = new Vector<Binding>();
                                    this._ports.put(string, vector2);
                                }
                                vector2.add(binding);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this._bindings.size() == 0) {
            return bl;
        }
        try {
            Iterator iterator = this._bindings.values().iterator();
            while (iterator.hasNext()) {
                object = (ASTSoapBinding)iterator.next();
                this._clientName = ((ASTBinding)object).getPackage() + ((ASTBinding)object).getFileName() + "CallClient";
                this.createClient(hashtable, vector, (ASTSoapBinding)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void createClient(Hashtable hashtable, Vector vector, ASTSoapBinding aSTSoapBinding) throws Exception {
        String string = Util.fileName(this._clientName);
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, this._clientName);
        Object v = hashtable.get("d");
        File file3 = v != null ? (v instanceof String ? new File((String)v) : new File(((String[])v)[0])) : new File(".");
        URL[] uRLArray = new URL[]{file3.toURL()};
        this._loader = new URLClassLoader(uRLArray);
        if (vector.contains(file2)) {
            return;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._clientName);
        HashSet hashSet = this._astdoc.getPkgsWithHolders();
        Util.generateImports(formatter, aSTSoapBinding, hashSet);
        formatter.println("public class " + string);
        formatter.println("{");
        this.generateMain(aSTSoapBinding, hashtable, formatter, vector);
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        int n = 0;
        while (n < aSTOperationArray.length) {
            this.generateInvoke(aSTSoapBinding, (ASTSoapOperation)aSTOperationArray[n], formatter);
            formatter.println();
            ++n;
        }
        ClientGenerator.generateDumpMethod(formatter);
        formatter.println();
        ClientGenerator.generateElementMethod(formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
    }

    void generateMain(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter, Vector vector) throws Exception {
        int n;
        String string;
        ASTOperation[] aSTOperationArray;
        String[] stringArray;
        String string2;
        int n2;
        formatter.startBlock();
        formatter.println("public static void main(java.lang.String[] args) throws java.lang.Exception");
        formatter.startBlock("{");
        ASTService aSTService = (ASTService)this._services.get(aSTSoapBinding.getName());
        String string3 = "";
        ASTPort[] aSTPortArray = aSTService.getPorts();
        int n3 = 0;
        while (n3 < aSTPortArray.length) {
            if (aSTPortArray[n3].getBinding() == aSTSoapBinding) {
                string3 = aSTPortArray[n3].getName();
                n2 = string3.lastIndexOf(46);
                if (n2 <= 0) break;
                string3 = string3.substring(n2 + 1);
                break;
            }
            ++n3;
        }
        formatter.println("java.lang.System.setProperty(javax.xml.rpc.ServiceFactory.SERVICEFACTORY_PROPERTY,");
        formatter.startBlock();
        formatter.println("\"com.sssw.jbroker.web.xml.rpc.ServiceFactoryDelegate\");");
        formatter.endBlock();
        formatter.println("javax.xml.rpc.ServiceFactory factory = javax.xml.rpc.ServiceFactory.newInstance();");
        formatter.println("javax.xml.namespace.QName qname = new javax.xml.namespace.QName(\"" + aSTService.getNsURI() + "\", \"" + aSTService.getLocalName() + "\");");
        formatter.println("javax.xml.rpc.Service service = factory.createService(qname);");
        formatter.println("javax.xml.namespace.QName portName = new javax.xml.namespace.QName(\"" + aSTService.getNsURI() + "\", \"" + string3 + "\");");
        formatter.println();
        int n4 = n2 = hashtable.get("handler") != null ? 1 : 0;
        if (n2 != 0) {
            string2 = Util.fileName(this._clientName);
            formatter.println("java.util.ArrayList handlers = new java.util.ArrayList();");
            formatter.println("handlers.add(new javax.xml.rpc.handler.HandlerInfo(" + string2 + "Handler.class, null, null));");
            formatter.println("service.getHandlerRegistry().setHandlerChain(portName, handlers);");
            formatter.println();
            ClientGenerator.generateHandler(hashtable, this._clientName, true, vector);
        }
        String string4 = string2 = this._astdoc.getWSDLDocument() != null ? this._astdoc.getWSDLDocument().getFile() : null;
        if (string2 != null && (stringArray = (aSTOperationArray = (ASTOperation[])hashtable.get("destDir")).list(new FilenameFilter(string = (n = string2.lastIndexOf(47)) > 0 ? string2.substring(n + 1) + ".xmlrpc.type.mappings" : string2 + ".xmlrpc.type.mappings"){
            private final /* synthetic */ String val$tmfName;
            {
                this.val$tmfName = string;
            }

            public boolean accept(File file, String string) {
                return string.equals(this.val$tmfName);
            }
        })).length > 0) {
            formatter.println("com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry mapper =");
            formatter.startBlock();
            formatter.println("(com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry) service.getTypeMappingRegistry();");
            formatter.endBlock();
            formatter.println("mapper.importTypeMappings(\"" + stringArray[0] + "\");");
            formatter.println();
        }
        formatter.println("java.lang.String url = args.length > 0 ? args[0] :");
        formatter.startBlock();
        formatter.println("\"http://localhost:9090/" + aSTSoapBinding.getName().toLowerCase().replace('.', '_') + "\";");
        formatter.endBlock();
        formatter.println();
        aSTOperationArray = aSTSoapBinding.getOperations();
        n = 0;
        while (n < aSTOperationArray.length) {
            formatter.println(aSTOperationArray[n].getMangledName() + "(service, portName, url);");
            ++n;
        }
        formatter.endBlock("}");
        formatter.println();
    }

    void generateInvoke(ASTSoapBinding aSTSoapBinding, ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        QName qName;
        int n2;
        ASTPart[] aSTPartArray;
        formatter.println("public static void " + aSTSoapOperation.getMangledName() + "(javax.xml.rpc.Service service, javax.xml.namespace.QName portName, java.lang.String url)");
        formatter.startBlock();
        formatter.println("throws java.lang.Exception");
        formatter.endBlock();
        formatter.startBlock("{");
        formatter.println("try");
        formatter.startBlock("{");
        formatter.println("javax.xml.rpc.Call call = service.createCall(portName);");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        if (aSTSoapBodyMessage != null) {
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                qName = aSTPartArray[n2].getQName();
                if (aSTPartArray[n2].getMode() != 3) {
                    formatter.println("javax.xml.namespace.QName i" + n2 + " = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                    formatter.println("call.addParameter(\"" + qName + "\", i" + n2 + ", " + aSTPartArray[n2].getDataType() + ".class, javax.xml.rpc.ParameterMode.IN);");
                } else {
                    formatter.println("javax.xml.namespace.QName io" + n2 + " = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                    formatter.println("call.addParameter(\"" + qName + "\", io" + n2 + ", " + aSTPartArray[n2].getInOutType() + ".class, javax.xml.rpc.ParameterMode.INOUT);");
                }
                ++n2;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                qName = aSTPartArray[n2].getQName();
                if (aSTPartArray[n2].getMode() != 3) {
                    formatter.println("javax.xml.namespace.QName o" + n2 + " = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                    formatter.println("call.addParameter(\"" + qName + "\", o" + n2 + ", " + aSTPartArray[n2].getInOutType() + ".class, javax.xml.rpc.ParameterMode.OUT);");
                }
                ++n2;
            }
        }
        if (!aSTSoapOperation.isVoid()) {
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                qName = aSTPartArray[n2].getQName();
                if (aSTPartArray[n2].getMode() == 2) {
                    formatter.println("javax.xml.namespace.QName r = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                    formatter.println("call.setReturnType(r, " + aSTPartArray[n2].getDataType() + ".class);");
                }
                ++n2;
            }
        }
        if (aSTSoapBodyMessage != null) {
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                formatter.println(aSTPartArray[n2].getInOutType() + " iv" + n2 + " = " + ClientGenerator.value(aSTPartArray[n2].getInOutType(), this._loader) + ";");
                ++n2;
            }
        }
        formatter.println();
        formatter.print("Object[] parms = { ");
        boolean bl = false;
        if (aSTSoapBodyMessage != null) {
            ASTPart[] aSTPartArray2 = aSTSoapBodyMessage.getParts();
            int n3 = 0;
            while (n3 < aSTPartArray2.length) {
                if (bl) {
                    formatter.print(", ");
                } else {
                    bl = true;
                }
                if (aSTPartArray2[n3].isPrimitive() || aSTPartArray2[n3].isInOutPrimitive()) {
                    formatter.print(Util.getPrimitiveWrapper(aSTPartArray2[n3].getInOutType(), "iv" + n3));
                } else {
                    formatter.print("iv" + n3);
                }
                ++n3;
            }
        }
        formatter.println(" };");
        formatter.println();
        formatter.println("call.setTargetEndpointAddress(url);");
        formatter.println("call.setProperty(javax.xml.rpc.Call.SOAPACTION_URI_PROPERTY, \"" + aSTSoapOperation.getAction() + "\");");
        formatter.println("call.setProperty(javax.xml.rpc.Call.OPERATION_STYLE_PROPERTY, " + (aSTSoapOperation.isDocument() ? "\"document\");" : "\"rpc\");"));
        if (aSTSoapOperation.isDocument()) {
            formatter.println("call.setProperty(javax.xml.rpc.Call.ENCODINGSTYLE_URI_PROPERTY, null);");
        }
        formatter.println("call.setOperationName(new javax.xml.namespace.QName(\"" + aSTSoapOperation.getNsURI() + "\", \"" + aSTSoapOperation.getMangledName() + "\"));");
        formatter.println();
        if (!aSTSoapOperation.isVoid()) {
            if (Util.isPrimitive(aSTSoapOperation.getReturnType())) {
                String string = PrimitiveUtil.getPrimitiveWrapper(aSTSoapOperation.getReturnType());
                formatter.println(string + " wrapper = (" + string + ") call.invoke(parms);");
                formatter.println(aSTSoapOperation.getReturnType() + " result = wrapper." + aSTSoapOperation.getReturnType() + "Value();");
                formatter.println("java.lang.System.out.println(\"" + aSTSoapOperation.getMethodName() + " = \" + dump(wrapper));");
            } else {
                formatter.println(aSTSoapOperation.getReturnType() + " result = (" + aSTSoapOperation.getReturnType() + ") call.invoke(parms);");
                formatter.println("java.lang.System.out.println(\"" + aSTSoapOperation.getMethodName() + " = \" + dump(result));");
            }
        } else {
            formatter.println("call.invoke(parms);");
        }
        formatter.println("java.util.Map out = call.getOutputParams();");
        int n4 = 0;
        if (aSTSoapBodyMessage != null) {
            ASTPart[] aSTPartArray3 = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray3.length) {
                if (aSTPartArray3[n].getMode() == 3) {
                    ++n4;
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray4 = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray4.length) {
                if (aSTPartArray4[n].getMode() != 3) {
                    ++n4;
                }
                ++n;
            }
        }
        formatter.println();
        formatter.println("if (out.size() != " + n4 + ")");
        formatter.startBlock();
        formatter.println("throw new java.lang.Exception(\"got \" + out.size() + \" out parameters; expected " + n4 + ": \" + out);");
        formatter.endBlock();
        formatter.println("java.util.Iterator iter = out.entrySet().iterator();");
        formatter.println("while (iter.hasNext()) {");
        formatter.startBlock();
        formatter.println("java.util.Map.Entry entry = (java.util.Map.Entry) iter.next();");
        formatter.println("java.lang.System.out.println(entry.getKey() + \" = \" + dump(entry.getValue()));");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("java.lang.System.out.println();");
        formatter.endBlock();
        formatter.println("}");
        ASTMessage[] aSTMessageArray = aSTSoapOperation.getFaults();
        if (aSTMessageArray != null) {
            n = 0;
            while (n < aSTMessageArray.length) {
                formatter.print("catch (");
                if (aSTMessageArray[n].getName().endsWith("RemoteException")) {
                    formatter.print("java.rmi.RemoteException");
                } else {
                    formatter.print(aSTMessageArray[n].getClassName());
                }
                formatter.println(" ex)");
                formatter.startBlock("{");
                formatter.println("java.lang.System.out.println(\"error invoking " + aSTSoapOperation.getMethodName() + ":\" + ex.getMessage());");
                formatter.println("if (java.lang.System.getProperty(\"DEBUG\") != null)");
                formatter.startBlock();
                formatter.println("ex.printStackTrace();");
                formatter.endBlock();
                formatter.endBlock();
                formatter.println("}");
                ++n;
            }
        }
        formatter.endBlock();
        formatter.println("}");
    }
}

