/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.CodeGenUtil;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.web.Binding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ClientGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String _fileName;
    protected String _clientName;
    protected Hashtable _bindings;
    protected Hashtable _services;
    protected Hashtable _ports;
    protected ClassLoader _loader;
    private static final boolean _debug = false;
    private static String[] _objects = new String[]{"new java.lang.Boolean(true)", "new java.lang.Double(42.42)", "new java.lang.Float(21.21F)", "new java.lang.Integer(42)", "new java.lang.Long(84)", "new java.lang.String(\"hello world\")", "new java.math.BigDecimal(42.42)", "new java.math.BigInteger(32, new java.util.Random())", "new java.util.GregorianCalendar()"};
    private static String[] _strings = new String[]{"\"this is a test\"", "\"hello world\"", "\"ABCDEFG\"", "\"qwerty\""};
    private static ThreadLocal _recursiveDataTypeMgr = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$WeakHashMap;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$sssw$jbroker$web$QName;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$AnyURI;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Date;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Duration;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$ENTITIES;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$ENTITY;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$GDay;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$GMonth;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$GMonthDay;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$GYear;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$GYearMonth;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$ID;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$IDREF;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$IDREFS;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Language;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Name;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NCName;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NegativeInteger;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NMTOKEN;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NMTOKENS;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NonNegativeInteger;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NonPositiveInteger;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$NormalizedString;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$PositiveInteger;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Time;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$Token;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$UnsignedByte;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$UnsignedInt;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$UnsignedLong;
    static /* synthetic */ Class class$com$sssw$jbroker$web$xsd$UnsignedShort;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
        this._bindings = new Hashtable();
        this._services = new Hashtable();
        this._ports = new Hashtable();
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        Object object;
        boolean bl = true;
        ASTService[] aSTServiceArray = this._astdoc.getServices();
        if (aSTServiceArray != null) {
            int n = 0;
            while (n < aSTServiceArray.length) {
                object = aSTServiceArray[n].getPorts();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < ((ASTPort[])object).length) {
                        ASTBinding aSTBinding = object[n2].getBinding();
                        if (aSTBinding != null && aSTBinding instanceof ASTSoapBinding) {
                            String string = aSTBinding.getName();
                            if (!this._bindings.containsKey(string)) {
                                this._bindings.put(string, aSTBinding);
                            }
                            this._services.put(string, aSTServiceArray[n]);
                            String string2 = null;
                            if (object[n2] instanceof ASTHttpPort) {
                                string2 = ((ASTHttpPort)object[n2]).getLocation();
                            } else if (object[n2] instanceof ASTSoapPort) {
                                string2 = ((ASTSoapPort)object[n2]).getLocation();
                            }
                            if (string2 != null) {
                                Binding binding = new Binding("soap", string2);
                                Vector<Binding> vector2 = (Vector<Binding>)this._ports.get(string);
                                if (vector2 == null) {
                                    vector2 = new Vector<Binding>();
                                    this._ports.put(string, vector2);
                                }
                                vector2.add(binding);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this._bindings.size() == 0) {
            return bl;
        }
        try {
            Iterator iterator = this._bindings.values().iterator();
            while (iterator.hasNext()) {
                object = (ASTSoapBinding)iterator.next();
                this._clientName = ((ASTBinding)object).getPackage() + ((ASTBinding)object).getFileName() + "Client";
                this.createClient(hashtable, vector, (ASTSoapBinding)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void createClient(Hashtable hashtable, Vector vector, ASTSoapBinding aSTSoapBinding) throws Exception {
        this._fileName = Util.fileName(this._clientName);
        Object v = hashtable.get("d");
        File file = v != null ? (v instanceof String ? new File((String)v) : new File(((String[])v)[0])) : new File(".");
        File file2 = (File)hashtable.get("destDir");
        File file3 = Util.getFile(file2, this._clientName);
        URL[] uRLArray = new URL[]{file.toURL()};
        this._loader = new URLClassLoader(uRLArray);
        if (vector.contains(file3)) {
            return;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file3.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._clientName);
        HashSet hashSet = this._astdoc.getPkgsWithHolders();
        Util.generateImports(formatter, aSTSoapBinding, hashSet);
        formatter.println("public class " + this._fileName);
        formatter.println("{");
        this.generateMain(aSTSoapBinding, hashtable, formatter, vector);
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        int n = 0;
        while (n < aSTOperationArray.length) {
            this.generateInvoke((ASTSoapOperation)aSTOperationArray[n], aSTSoapBinding.getPortTypeClassName(), formatter);
            formatter.println();
            ++n;
        }
        ClientGenerator.generateDumpMethod(formatter);
        formatter.println();
        ClientGenerator.generateElementMethod(formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file3);
    }

    static void generateElementMethod(Formatter formatter) {
        formatter.println("private static final java.lang.String[] _street = {");
        formatter.startBlock();
        formatter.println("\"42 Palm Tree Ln\",");
        formatter.println("\"1234 Infinity Loop\",");
        formatter.println("\"271 Westheimer St\"");
        formatter.endBlock();
        formatter.println("};");
        formatter.println();
        formatter.println("private static final java.lang.String[] _state = {");
        formatter.startBlock();
        formatter.println("\"fl\",");
        formatter.println("\"ca\",");
        formatter.println("\"tx\"");
        formatter.endBlock();
        formatter.println("};");
        formatter.println();
        formatter.println("private static final java.lang.String[] _zip = {");
        formatter.startBlock();
        formatter.println("\"95110\",");
        formatter.println("\"45098\",");
        formatter.println("\"01234\"");
        formatter.endBlock();
        formatter.println("};");
        formatter.println();
        formatter.println("private static org.w3c.dom.Element generateElement()");
        formatter.startBlock("{");
        formatter.println("try");
        formatter.startBlock("{");
        formatter.println("int random = (int) (Math.random() * 3);");
        formatter.println("javax.xml.parsers.DocumentBuilderFactory factory;");
        formatter.println("factory = javax.xml.parsers.DocumentBuilderFactory.newInstance();");
        formatter.println("javax.xml.parsers.DocumentBuilder builder = factory.newDocumentBuilder();");
        formatter.println("org.w3c.dom.Document document = builder.newDocument();");
        formatter.println("org.w3c.dom.Element address = document.createElement(\"address\");");
        formatter.println("document.appendChild(address);");
        formatter.println("org.w3c.dom.Element zip = document.createElement(\"zip\");");
        formatter.println("address.appendChild(zip);");
        formatter.println("zip.appendChild(document.createTextNode(_zip[random]));");
        formatter.println("org.w3c.dom.Element state = document.createElement(\"state\");");
        formatter.println("address.appendChild(state);");
        formatter.println("state.appendChild(document.createTextNode(_zip[random]));");
        formatter.println("return document.getDocumentElement();");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("catch (java.lang.Exception ex)");
        formatter.startBlock("{");
        formatter.println("if (java.lang.System.getProperty(\"DEBUG\") != null)");
        formatter.startBlock();
        formatter.println("ex.printStackTrace();");
        formatter.endBlock();
        formatter.println("return null;");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
    }

    static void generateHandler(Hashtable hashtable, String string, boolean bl, Vector vector) throws Exception {
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, string + "Handler");
        String string2 = Util.fileName(string);
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, string + "Handler");
        formatter.print("public class " + string2 + "Handler implements javax.xml.rpc.handler.Handler");
        formatter.println();
        formatter.println("{");
        formatter.startBlock();
        String string3 = bl ? "handleRequest" : "handleResponse";
        String string4 = bl ? "handleResponse" : "handleRequest";
        formatter.println("public boolean " + string3 + "(javax.xml.rpc.handler.MessageContext context)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("try");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.rpc.handler.soap.SOAPMessageContext smc = (javax.xml.rpc.handler.soap.SOAPMessageContext) context;");
        formatter.println("javax.xml.soap.SOAPMessage message = smc.getMessage();");
        formatter.println("javax.xml.soap.SOAPPart part = message.getSOAPPart();");
        formatter.println("javax.xml.soap.SOAPEnvelope envelope = part.getEnvelope();");
        formatter.println();
        formatter.println("javax.xml.soap.SOAPHeader header = envelope.getHeader();");
        formatter.println("if (header == null)");
        formatter.startBlock();
        formatter.println("header = envelope.addHeader();");
        formatter.endBlock();
        formatter.println("javax.xml.soap.SOAPElement user = header.addChildElement(\"username\");");
        formatter.println("user.addTextNode(java.lang.System.getProperty(\"user.name\"));");
        formatter.println("javax.xml.soap.SOAPElement time = header.addChildElement(\"timestamp\");");
        formatter.println("time.addTextNode(Long.toString(java.lang.System.currentTimeMillis()));");
        formatter.println();
        formatter.println("javax.xml.soap.SOAPBody body = envelope.getBody();");
        formatter.println("compress(body);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("catch (java.lang.Exception ex)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("ex.printStackTrace();");
        formatter.println("throw new javax.xml.rpc.JAXRPCException(ex.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return true;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public boolean " + string4 + "(javax.xml.rpc.handler.MessageContext context)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("try");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.rpc.handler.soap.SOAPMessageContext smc = (javax.xml.rpc.handler.soap.SOAPMessageContext) context;");
        formatter.println("javax.xml.soap.SOAPMessage message = smc.getMessage();");
        formatter.println("javax.xml.soap.SOAPPart part = message.getSOAPPart();");
        formatter.println("javax.xml.soap.SOAPEnvelope envelope = part.getEnvelope();");
        formatter.println();
        formatter.println("javax.xml.soap.SOAPHeader header = envelope.getHeader();");
        formatter.println("if (header == null)");
        formatter.startBlock();
        formatter.println("return true;");
        formatter.endBlock();
        formatter.println("java.util.Iterator iter = header.getChildElements();");
        formatter.println("while (iter.hasNext())");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.SOAPElement element = (javax.xml.soap.SOAPElement) iter.next();");
        formatter.println("javax.xml.soap.Text text = (javax.xml.soap.Text) element.getChildElements().next();");
        formatter.println("java.lang.System.out.println(element.getElementName().getLocalName() + \" = \" + text.getValue());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("javax.xml.soap.SOAPBody body = envelope.getBody();");
        formatter.println("decompress(body);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("catch (java.lang.Exception ex)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("ex.printStackTrace();");
        formatter.println("throw new javax.xml.rpc.JAXRPCException(ex.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return true;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public boolean handleFault(javax.xml.rpc.handler.MessageContext context) { return true; }");
        formatter.println();
        formatter.println("private static void compress(javax.xml.soap.Node node) throws java.lang.Exception");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (node instanceof javax.xml.soap.Text)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.Text text = (javax.xml.soap.Text) node;");
        formatter.println("javax.xml.soap.SOAPElement parent = text.getParentElement();");
        formatter.println("text.detachNode();");
        formatter.println("java.lang.String value = text.getValue();");
        formatter.println("java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        formatter.println("java.util.zip.GZIPOutputStream zos = new java.util.zip.GZIPOutputStream(baos);");
        formatter.println("zos.write(value.getBytes());");
        formatter.println("zos.flush();");
        formatter.println("zos.finish();");
        formatter.println("zos.close();");
        formatter.println("byte[] data = baos.toByteArray();");
        formatter.println("java.lang.String compressed = com.sssw.jbroker.util.Base64Encoder.encode(data);");
        formatter.println("parent.addTextNode(compressed);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("else");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.SOAPElement element = (javax.xml.soap.SOAPElement) node;");
        formatter.println("java.util.Iterator iter = element.getChildElements();");
        formatter.println("while (iter.hasNext())");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.Node child = (javax.xml.soap.Node) iter.next();");
        formatter.println("compress(child);");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("private static void decompress(javax.xml.soap.Node node) throws java.lang.Exception");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (node instanceof javax.xml.soap.Text)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.Text text = (javax.xml.soap.Text) node;");
        formatter.println("javax.xml.soap.SOAPElement parent = text.getParentElement();");
        formatter.println("text.detachNode();");
        formatter.println("java.lang.String value = text.getValue();");
        formatter.println("byte[] compressed = com.sssw.jbroker.util.Base64Encoder.decode(value);");
        formatter.println("java.io.ByteArrayInputStream bais = new java.io.ByteArrayInputStream(compressed);");
        formatter.println("java.util.zip.GZIPInputStream zis = new java.util.zip.GZIPInputStream(bais);");
        formatter.println("java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        formatter.println("int c;");
        formatter.println("while ((c = zis.read()) != -1)");
        formatter.startBlock();
        formatter.println("baos.write(c);");
        formatter.endBlock();
        formatter.println("baos.flush();");
        formatter.println("byte[] data = baos.toByteArray();");
        formatter.println("java.lang.String decompressed = new java.lang.String(data);");
        formatter.println("parent.addTextNode(decompressed);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("else");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.SOAPElement element = (javax.xml.soap.SOAPElement) node;");
        formatter.println("java.util.Iterator iter = element.getChildElements();");
        formatter.println("while (iter.hasNext())");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.soap.Node child = (javax.xml.soap.Node) iter.next();");
        formatter.println("decompress(child);");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public void init(javax.xml.rpc.handler.HandlerInfo config) { }");
        formatter.println();
        formatter.println("public void destroy() { }");
        formatter.println();
        formatter.println("public javax.xml.namespace.QName[] getHeaders() { return null; }");
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
    }

    static void generateDumpMethod(Formatter formatter) {
        formatter.println("private static java.lang.String dump(java.lang.Object object)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (object == null) return \"null\";");
        formatter.println();
        formatter.println("if (object.getClass().isArray())");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("java.lang.StringBuffer buffer = new java.lang.StringBuffer();");
        formatter.println("buffer.append(\"[\");");
        formatter.println("int length = java.lang.reflect.Array.getLength(object);");
        formatter.println("for (int i = 0; i < length; i++) {");
        formatter.startBlock();
        formatter.println("buffer.append(dump(java.lang.reflect.Array.get(object, i)));");
        formatter.println("if (i != length - 1) buffer.append(\",\");");
        formatter.endBlock("}");
        formatter.println("buffer.append(\"]\");");
        formatter.println("return buffer.toString();");
        formatter.endBlock("}");
        formatter.println("else if (object instanceof org.w3c.dom.Element)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("try");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("org.w3c.dom.Element element = (org.w3c.dom.Element) object;");
        formatter.println("org.apache.xml.serialize.OutputFormat format =");
        formatter.startBlock();
        formatter.println("new org.apache.xml.serialize.OutputFormat(element.getOwnerDocument());");
        formatter.endBlock();
        formatter.println("format.setIndent(3);");
        formatter.println("format.setLineWidth(60);");
        formatter.println("java.io.StringWriter out = new java.io.StringWriter();");
        formatter.println("org.apache.xml.serialize.XMLSerializer serial =");
        formatter.startBlock();
        formatter.println("new org.apache.xml.serialize.XMLSerializer(out, format);");
        formatter.endBlock();
        formatter.println("serial.asDOMSerializer();");
        formatter.println("serial.serialize(element);");
        formatter.println("out.flush();");
        formatter.println("return out.toString();");
        formatter.endBlock("}");
        formatter.println("catch (java.io.IOException ex)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("return object.toString();");
        formatter.endBlock("}");
        formatter.endBlock("}");
        formatter.println("else return object.toString();");
        formatter.endBlock("}");
    }

    void generateMain(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter, Vector vector) throws Exception {
        int n;
        formatter.startBlock();
        formatter.println("public static void main(java.lang.String[] args) throws java.lang.Exception");
        formatter.startBlock("{");
        ASTService aSTService = (ASTService)this._services.get(aSTSoapBinding.getName());
        String string = "";
        ASTPort[] aSTPortArray = aSTService.getPorts();
        int n2 = 0;
        while (n2 < aSTPortArray.length) {
            if (aSTPortArray[n2].getBinding() == aSTSoapBinding) {
                string = aSTPortArray[n2].getName();
                n = string.lastIndexOf(46);
                if (n <= 0) break;
                string = string.substring(n + 1);
                break;
            }
            ++n2;
        }
        formatter.println("javax.naming.InitialContext ctx = new javax.naming.InitialContext();");
        formatter.println(aSTService.getFileName() + " service = (" + aSTService.getFileName() + ")");
        formatter.startBlock();
        formatter.println("ctx.lookup(\"xmlrpc:soap:" + aSTService.getPackage() + aSTService.getFileName() + "\");");
        formatter.endBlock();
        formatter.println();
        int n3 = n = hashtable.get("handler") != null ? 1 : 0;
        if (n != 0) {
            formatter.println("java.util.ArrayList handlers = new java.util.ArrayList();");
            formatter.println("handlers.add(new javax.xml.rpc.handler.HandlerInfo(" + this._fileName + "Handler.class, null, null));");
            formatter.println("javax.xml.namespace.QName pt = new javax.xml.namespace.QName(\"" + aSTService.getNsURI() + "\", \"" + string + "\");");
            formatter.println("service.getHandlerRegistry().setHandlerChain(pt, handlers);");
            formatter.println();
            ClientGenerator.generateHandler(hashtable, this._clientName, true, vector);
        }
        formatter.println(aSTSoapBinding.getPortTypeClassName() + " stub = service.get" + string + "();");
        formatter.println("((javax.xml.rpc.Stub)stub)._setProperty(\"javax.xml.rpc.service.endpoint.address\",");
        formatter.startBlock();
        formatter.println("args.length > 0 ? args[0] : \"http://localhost:9090/" + aSTSoapBinding.getName().toLowerCase().replace('.', '_') + "\");");
        formatter.endBlock();
        formatter.println();
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        int n4 = 0;
        while (n4 < aSTOperationArray.length) {
            formatter.println(aSTOperationArray[n4].getMangledName() + "(stub);");
            ++n4;
        }
        formatter.endBlock("}");
        formatter.println();
    }

    void generateInvoke(ASTSoapOperation aSTSoapOperation, String string, Formatter formatter) {
        int n;
        int n2;
        ASTPart[] aSTPartArray;
        formatter.println("public static void " + aSTSoapOperation.getMangledName() + "(" + string + " stub)");
        formatter.startBlock("{");
        formatter.println("try");
        formatter.startBlock("{");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        if (aSTSoapBodyMessage != null) {
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                if (aSTPartArray[n2].getMode() != 3) {
                    formatter.println(aSTPartArray[n2].getDataType() + " i" + n2 + " = " + ClientGenerator.value(aSTPartArray[n2].getDataType(), this._loader) + ";");
                } else {
                    formatter.println(aSTPartArray[n2].getDataType() + " io" + n2 + " = new " + aSTPartArray[n2].getDataType() + "();");
                    formatter.println("io" + n2 + ".value = " + ClientGenerator.value(aSTPartArray[n2].getInOutType(), this._loader) + ";");
                }
                ++n2;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n2 = 0;
            while (n2 < aSTPartArray.length) {
                if (aSTPartArray[n2].getMode() != 3) {
                    formatter.println(aSTPartArray[n2].getDataType() + " o" + n2 + " = new " + aSTPartArray[n2].getDataType() + "();");
                }
                ++n2;
            }
        }
        if (!aSTSoapOperation.isVoid()) {
            formatter.print(aSTSoapOperation.getReturnType() + " result = ");
        }
        formatter.print("stub." + aSTSoapOperation.getMethodName() + "(");
        boolean bl = false;
        if (aSTSoapBodyMessage != null) {
            ASTPart[] aSTPartArray2 = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray2.length) {
                if (bl) {
                    formatter.print(", ");
                } else {
                    bl = true;
                }
                if (aSTPartArray2[n].getMode() == 3) {
                    formatter.print("io" + n);
                } else {
                    formatter.print("i" + n);
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray3 = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray3.length) {
                if (aSTPartArray3[n].getMode() != 3) {
                    if (bl) {
                        formatter.print(", ");
                    } else {
                        bl = true;
                    }
                    formatter.print("o" + n);
                }
                ++n;
            }
        }
        formatter.println(");");
        if (!aSTSoapOperation.isVoid()) {
            if (Util.isPrimitive(aSTSoapOperation.getReturnType())) {
                formatter.println("java.lang.System.out.println(\"" + aSTSoapOperation.getMethodName() + " = \" + dump(" + Util.getPrimitiveWrapper(aSTSoapOperation.getReturnType(), "result") + "));");
            } else {
                formatter.println("java.lang.System.out.println(\"" + aSTSoapOperation.getMethodName() + " = \" + dump(result));");
            }
        } else {
            formatter.println("java.lang.System.out.println(\"" + aSTSoapOperation.getMethodName() + ": OK\");");
        }
        if (aSTSoapBodyMessage != null) {
            ASTPart[] aSTPartArray4 = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray4.length) {
                if (aSTPartArray4[n].getMode() == 3) {
                    if (Util.isPrimitive(aSTPartArray4[n].getInOutType())) {
                        formatter.println("java.lang.System.out.println(\"io" + n + " = \" + dump(" + Util.getPrimitiveWrapper(aSTPartArray4[n].getInOutType(), "io" + n + ".value") + "));");
                    } else {
                        formatter.println("java.lang.System.out.println(\"io" + n + " = \" + dump(io" + n + ".value));");
                    }
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray5 = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray5.length) {
                if (aSTPartArray5[n].getMode() != 3) {
                    if (Util.isPrimitive(aSTPartArray5[n].getInOutType())) {
                        formatter.println("java.lang.System.out.println(\"o" + n + " = \" + dump(" + Util.getPrimitiveWrapper(aSTPartArray5[n].getInOutType(), "o" + n + ".value") + "));");
                    } else {
                        formatter.println("java.lang.System.out.println(\"o" + n + " = \" + dump(o" + n + ".value));");
                    }
                }
                ++n;
            }
        }
        formatter.println("java.lang.System.out.println();");
        formatter.endBlock();
        formatter.println("}");
        ASTMessage[] aSTMessageArray = aSTSoapOperation.getFaults();
        if (aSTMessageArray != null) {
            n = 0;
            while (n < aSTMessageArray.length) {
                formatter.print("catch (");
                if (aSTMessageArray[n].getName().endsWith("RemoteException")) {
                    formatter.print("java.rmi.RemoteException");
                } else {
                    formatter.print(aSTMessageArray[n].getClassName());
                }
                formatter.println(" ex)");
                formatter.startBlock("{");
                formatter.println("java.lang.System.out.println(\"error invoking " + aSTSoapOperation.getMethodName() + ":\" + ex.getMessage());");
                formatter.println("if (java.lang.System.getProperty(\"DEBUG\") != null)");
                formatter.startBlock();
                formatter.println("ex.printStackTrace();");
                formatter.endBlock();
                formatter.endBlock();
                formatter.println("}");
                ++n;
            }
        }
        formatter.endBlock();
        formatter.println("}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String value(String string, ClassLoader classLoader) {
        String string2;
        try {
            try {
                int n = 0;
                int n2 = 0;
                while ((n2 = string.indexOf(91, n2)) > 0) {
                    ++n2;
                    ++n;
                }
                if (n > 0) {
                    string = string.substring(0, string.indexOf(91));
                }
                Class<Serializable> clazz = string.equals("boolean") ? Boolean.TYPE : (string.equals("byte") ? Byte.TYPE : (string.equals("char") ? Character.TYPE : (string.equals("double") ? Double.TYPE : (string.equals("float") ? Float.TYPE : (string.equals("int") ? Integer.TYPE : (string.equals("long") ? Long.TYPE : (string.equals("short") ? Short.TYPE : Class.forName(string, true, classLoader))))))));
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                        string2 = ClientGenerator.valueImpl(clazz);
                        Object var8_8 = null;
                        break;
                    }
                    clazz = Array.newInstance(clazz, 0).getClass();
                    ++n3;
                }
            }
            catch (Exception exception) {
                System.err.println("warn: failed to generate arg for " + string + ": " + exception.getMessage());
                Object var8_9 = null;
                Map map = (Map)_recursiveDataTypeMgr.get();
                map.clear();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Map map = (Map)_recursiveDataTypeMgr.get();
            map.clear();
            throw throwable;
        }
        Map map = (Map)_recursiveDataTypeMgr.get();
        map.clear();
        return string2;
    }

    private static String valueImpl(Class clazz) throws Exception {
        Map map = (Map)_recursiveDataTypeMgr.get();
        Integer n = (Integer)map.get(clazz);
        if (n != null && n == 2) {
            return "null";
        }
        n = new Integer(n == null ? 1 : n + 1);
        if (!CodeGenUtil.getComponentClass(clazz).isPrimitive()) {
            map.put(clazz, n);
        }
        return ClientGenerator.valueImpl2(clazz);
    }

    private static String valueImpl2(Class clazz) throws Exception {
        double d = Math.random() * 100.0;
        if (clazz.equals(Boolean.TYPE)) {
            return d > 50.0 ? "true" : "false";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "(byte)" + (byte)d;
        }
        if (clazz.equals(Character.TYPE)) {
            return "'c'";
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.toString(d);
        }
        if (clazz.equals(Float.TYPE)) {
            return (float)d + "F";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "" + (int)d;
        }
        if (clazz.equals(Long.TYPE)) {
            return "" + (long)d;
        }
        if (clazz.equals(Short.TYPE)) {
            return "(short)" + (short)d;
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClientGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return d > 50.0 ? "new java.lang.Boolean(true)" : "new java.lang.Boolean(false)";
        }
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = ClientGenerator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return "new java.lang.Byte((byte)" + (byte)d + ")";
        }
        if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = ClientGenerator.class$("java.lang.Character")) : class$java$lang$Character)) {
            return "new java.lang.Character('c')";
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = ClientGenerator.class$("java.lang.Double")) : class$java$lang$Double)) {
            return "new java.lang.Double(" + d + ")";
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = ClientGenerator.class$("java.lang.Float")) : class$java$lang$Float)) {
            return "new java.lang.Float(" + (float)d + "F)";
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = ClientGenerator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return "new java.lang.Integer(" + (int)d + ")";
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = ClientGenerator.class$("java.lang.Long")) : class$java$lang$Long)) {
            return "new java.lang.Long(" + (long)d + ")";
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = ClientGenerator.class$("java.lang.Short")) : class$java$lang$Short)) {
            return "new java.lang.Short((short)" + (short)d + ")";
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = ClientGenerator.class$("java.lang.String")) : class$java$lang$String)) {
            return _strings[(int)d % _strings.length];
        }
        if (clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = ClientGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            return _objects[(int)d % _objects.length];
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ClientGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return "new java.math.BigDecimal(" + d + ")";
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ClientGenerator.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return "new java.math.BigInteger(8, new java.util.Random())";
        }
        if (clazz.equals(class$java$util$Calendar == null ? (class$java$util$Calendar = ClientGenerator.class$("java.util.Calendar")) : class$java$util$Calendar)) {
            return "new java.util.GregorianCalendar()";
        }
        if (clazz.equals(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = ClientGenerator.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar)) {
            return "new java.util.GregorianCalendar()";
        }
        if (clazz.equals(class$java$util$Vector == null ? (class$java$util$Vector = ClientGenerator.class$("java.util.Vector")) : class$java$util$Vector)) {
            return "new java.util.Vector(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ClientGenerator.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return "new java.util.ArrayList(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$List == null ? (class$java$util$List = ClientGenerator.class$("java.util.List")) : class$java$util$List)) {
            return "new java.util.ArrayList(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$Collection == null ? (class$java$util$Collection = ClientGenerator.class$("java.util.Collection")) : class$java$util$Collection)) {
            return "new java.util.ArrayList(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$LinkedList == null ? (class$java$util$LinkedList = ClientGenerator.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
            return "new java.util.LinkedList(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$Stack == null ? (class$java$util$Stack = ClientGenerator.class$("java.util.Stack")) : class$java$util$Stack)) {
            return "new java.util.Stack(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$TreeSet == null ? (class$java$util$TreeSet = ClientGenerator.class$("java.util.TreeSet")) : class$java$util$TreeSet)) {
            return "new java.util.TreeSet(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$SortedSet == null ? (class$java$util$SortedSet = ClientGenerator.class$("java.util.SortedSet")) : class$java$util$SortedSet)) {
            return "new java.util.TreeSet(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$Set == null ? (class$java$util$Set = ClientGenerator.class$("java.util.Set")) : class$java$util$Set)) {
            return "new java.util.TreeSet(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$HashSet == null ? (class$java$util$HashSet = ClientGenerator.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            return "new java.util.HashSet(java.util.Arrays.asList(new java.lang.String[] { \"a\", \"b\", \"c\" }))";
        }
        if (clazz.equals(class$java$util$Map == null ? (class$java$util$Map = ClientGenerator.class$("java.util.Map")) : class$java$util$Map)) {
            return "new java.util.TreeMap(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$TreeMap == null ? (class$java$util$TreeMap = ClientGenerator.class$("java.util.TreeMap")) : class$java$util$TreeMap)) {
            return "new java.util.TreeMap(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$SortedMap == null ? (class$java$util$SortedMap = ClientGenerator.class$("java.util.SortedMap")) : class$java$util$SortedMap)) {
            return "new java.util.TreeMap(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$HashMap == null ? (class$java$util$HashMap = ClientGenerator.class$("java.util.HashMap")) : class$java$util$HashMap)) {
            return "new java.util.HashMap(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$Hashtable == null ? (class$java$util$Hashtable = ClientGenerator.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return "new java.util.Hashtable(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$Properties == null ? (class$java$util$Properties = ClientGenerator.class$("java.util.Properties")) : class$java$util$Properties)) {
            return "new java.util.Properties(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$WeakHashMap == null ? (class$java$util$WeakHashMap = ClientGenerator.class$("java.util.WeakHashMap")) : class$java$util$WeakHashMap)) {
            return "new java.util.WeakHashMap(java.util.Collections.singletonMap(\"key\", \"value\"))";
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = ClientGenerator.class$("java.util.Date")) : class$java$util$Date)) {
            return "new java.util.Date()";
        }
        if (clazz.equals(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ClientGenerator.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName)) {
            return "new javax.xml.namespace.QName(" + _strings[(int)d % _strings.length] + ", " + _strings[((int)d + 50) % _strings.length] + ")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$QName == null ? (class$com$sssw$jbroker$web$QName = ClientGenerator.class$("com.sssw.jbroker.web.QName")) : class$com$sssw$jbroker$web$QName)) {
            return "new com.sssw.jbroker.web.QName(" + _strings[(int)d % _strings.length] + ", " + _strings[((int)d + 50) % _strings.length] + ")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$AnyURI == null ? (class$com$sssw$jbroker$web$xsd$AnyURI = ClientGenerator.class$("com.sssw.jbroker.web.xsd.AnyURI")) : class$com$sssw$jbroker$web$xsd$AnyURI)) {
            return "new com.sssw.jbroker.web.xsd.AnyURI(\"http://www.foo.bar\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Date == null ? (class$com$sssw$jbroker$web$xsd$Date = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Date")) : class$com$sssw$jbroker$web$xsd$Date)) {
            return "new com.sssw.jbroker.web.xsd.Date(\"2002-06-05\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Duration == null ? (class$com$sssw$jbroker$web$xsd$Duration = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Duration")) : class$com$sssw$jbroker$web$xsd$Duration)) {
            return "new com.sssw.jbroker.web.xsd.Duration(\"P1Y2M3DT4H5M6.6S\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$ENTITIES == null ? (class$com$sssw$jbroker$web$xsd$ENTITIES = ClientGenerator.class$("com.sssw.jbroker.web.xsd.ENTITIES")) : class$com$sssw$jbroker$web$xsd$ENTITIES)) {
            return "new com.sssw.jbroker.web.xsd.ENTITIES(\"abc\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$ENTITY == null ? (class$com$sssw$jbroker$web$xsd$ENTITY = ClientGenerator.class$("com.sssw.jbroker.web.xsd.ENTITY")) : class$com$sssw$jbroker$web$xsd$ENTITY)) {
            return "new com.sssw.jbroker.web.xsd.ENTITY(\"def\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$GDay == null ? (class$com$sssw$jbroker$web$xsd$GDay = ClientGenerator.class$("com.sssw.jbroker.web.xsd.GDay")) : class$com$sssw$jbroker$web$xsd$GDay)) {
            return "new com.sssw.jbroker.web.xsd.GDay(\"17\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$GMonth == null ? (class$com$sssw$jbroker$web$xsd$GMonth = ClientGenerator.class$("com.sssw.jbroker.web.xsd.GMonth")) : class$com$sssw$jbroker$web$xsd$GMonth)) {
            return "new com.sssw.jbroker.web.xsd.GMonth(\"5\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$GMonthDay == null ? (class$com$sssw$jbroker$web$xsd$GMonthDay = ClientGenerator.class$("com.sssw.jbroker.web.xsd.GMonthDay")) : class$com$sssw$jbroker$web$xsd$GMonthDay)) {
            return "new com.sssw.jbroker.web.xsd.GMonthDay(\"--5-17\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$GYear == null ? (class$com$sssw$jbroker$web$xsd$GYear = ClientGenerator.class$("com.sssw.jbroker.web.xsd.GYear")) : class$com$sssw$jbroker$web$xsd$GYear)) {
            return "new com.sssw.jbroker.web.xsd.GYear(\"1971\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$GYearMonth == null ? (class$com$sssw$jbroker$web$xsd$GYearMonth = ClientGenerator.class$("com.sssw.jbroker.web.xsd.GYearMonth")) : class$com$sssw$jbroker$web$xsd$GYearMonth)) {
            return "new com.sssw.jbroker.web.xsd.GYearMonth(\"1971-05\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$ID == null ? (class$com$sssw$jbroker$web$xsd$ID = ClientGenerator.class$("com.sssw.jbroker.web.xsd.ID")) : class$com$sssw$jbroker$web$xsd$ID)) {
            return "new com.sssw.jbroker.web.xsd.ID(\"id\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$IDREF == null ? (class$com$sssw$jbroker$web$xsd$IDREF = ClientGenerator.class$("com.sssw.jbroker.web.xsd.IDREF")) : class$com$sssw$jbroker$web$xsd$IDREF)) {
            return "new com.sssw.jbroker.web.xsd.IDREF(\"idref\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$IDREFS == null ? (class$com$sssw$jbroker$web$xsd$IDREFS = ClientGenerator.class$("com.sssw.jbroker.web.xsd.IDREFS")) : class$com$sssw$jbroker$web$xsd$IDREFS)) {
            return "new com.sssw.jbroker.web.xsd.IDREFS(\"idrefs\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Language == null ? (class$com$sssw$jbroker$web$xsd$Language = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Language")) : class$com$sssw$jbroker$web$xsd$Language)) {
            return "new com.sssw.jbroker.web.xsd.Language(\"en\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Name == null ? (class$com$sssw$jbroker$web$xsd$Name = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Name")) : class$com$sssw$jbroker$web$xsd$Name)) {
            return "new com.sssw.jbroker.web.xsd.Name(\"jBroker\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NCName == null ? (class$com$sssw$jbroker$web$xsd$NCName = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NCName")) : class$com$sssw$jbroker$web$xsd$NCName)) {
            return "new com.sssw.jbroker.web.xsd.NCName(\"name\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NegativeInteger == null ? (class$com$sssw$jbroker$web$xsd$NegativeInteger = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NegativeInteger")) : class$com$sssw$jbroker$web$xsd$NegativeInteger)) {
            return "new com.sssw.jbroker.web.xsd.NegativeInteger(-42)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NMTOKEN == null ? (class$com$sssw$jbroker$web$xsd$NMTOKEN = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NMTOKEN")) : class$com$sssw$jbroker$web$xsd$NMTOKEN)) {
            return "new com.sssw.jbroker.web.xsd.NMTOKEN(\"token\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NMTOKENS == null ? (class$com$sssw$jbroker$web$xsd$NMTOKENS = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NMTOKENS")) : class$com$sssw$jbroker$web$xsd$NMTOKENS)) {
            return "new com.sssw.jbroker.web.xsd.NMTOKENS(\"tokens\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NonNegativeInteger == null ? (class$com$sssw$jbroker$web$xsd$NonNegativeInteger = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NonNegativeInteger")) : class$com$sssw$jbroker$web$xsd$NonNegativeInteger)) {
            return "new com.sssw.jbroker.web.xsd.NonNegativeInteger(42)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NonPositiveInteger == null ? (class$com$sssw$jbroker$web$xsd$NonPositiveInteger = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NonPositiveInteger")) : class$com$sssw$jbroker$web$xsd$NonPositiveInteger)) {
            return "new com.sssw.jbroker.web.xsd.NonPositiveInteger(-42)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$NormalizedString == null ? (class$com$sssw$jbroker$web$xsd$NormalizedString = ClientGenerator.class$("com.sssw.jbroker.web.xsd.NormalizedString")) : class$com$sssw$jbroker$web$xsd$NormalizedString)) {
            return "new com.sssw.jbroker.web.xsd.NormalizedString(\"string\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$PositiveInteger == null ? (class$com$sssw$jbroker$web$xsd$PositiveInteger = ClientGenerator.class$("com.sssw.jbroker.web.xsd.PositiveInteger")) : class$com$sssw$jbroker$web$xsd$PositiveInteger)) {
            return "new com.sssw.jbroker.web.xsd.PositiveInteger(42)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Time == null ? (class$com$sssw$jbroker$web$xsd$Time = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Time")) : class$com$sssw$jbroker$web$xsd$Time)) {
            return "new com.sssw.jbroker.web.xsd.Time(\"2:33:44\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$Token == null ? (class$com$sssw$jbroker$web$xsd$Token = ClientGenerator.class$("com.sssw.jbroker.web.xsd.Token")) : class$com$sssw$jbroker$web$xsd$Token)) {
            return "new com.sssw.jbroker.web.xsd.Token(\"thisisatoken\")";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$UnsignedByte == null ? (class$com$sssw$jbroker$web$xsd$UnsignedByte = ClientGenerator.class$("com.sssw.jbroker.web.xsd.UnsignedByte")) : class$com$sssw$jbroker$web$xsd$UnsignedByte)) {
            return "new com.sssw.jbroker.web.xsd.UnsignedByte((byte)11)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$UnsignedInt == null ? (class$com$sssw$jbroker$web$xsd$UnsignedInt = ClientGenerator.class$("com.sssw.jbroker.web.xsd.UnsignedInt")) : class$com$sssw$jbroker$web$xsd$UnsignedInt)) {
            return "new com.sssw.jbroker.web.xsd.UnsignedInt(42)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$UnsignedLong == null ? (class$com$sssw$jbroker$web$xsd$UnsignedLong = ClientGenerator.class$("com.sssw.jbroker.web.xsd.UnsignedLong")) : class$com$sssw$jbroker$web$xsd$UnsignedLong)) {
            return "new com.sssw.jbroker.web.xsd.UnsignedLong(84L)";
        }
        if (clazz.equals(class$com$sssw$jbroker$web$xsd$UnsignedShort == null ? (class$com$sssw$jbroker$web$xsd$UnsignedShort = ClientGenerator.class$("com.sssw.jbroker.web.xsd.UnsignedShort")) : class$com$sssw$jbroker$web$xsd$UnsignedShort)) {
            return "new com.sssw.jbroker.web.xsd.UnsignedShort((short)21)";
        }
        if (clazz.equals(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ClientGenerator.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            return "generateElement()";
        }
        if (clazz.isArray()) {
            int n = 1;
            Class<?> clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            String string = "new " + clazz2.getName();
            int n2 = 0;
            while (n2 < n) {
                string = string + "[]";
                ++n2;
            }
            string = string + " { " + ClientGenerator.valueImpl(clazz.getComponentType()) + ", " + ClientGenerator.valueImpl(clazz.getComponentType()) + " }";
            return string;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            Field[] fieldArray = clazz.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (!fieldArray[n].getName().startsWith("_") && fieldArray[n].getType().equals(clazz)) {
                    return clazz.getName() + "." + fieldArray[n].getName();
                }
                ++n;
            }
        }
        if (constructorArray.length == 1 && constructorArray[0].getParameterTypes().length == 0) {
            return "new " + clazz.getName() + "()";
        }
        if (constructorArray.length == 1 && constructorArray[0].getParameterTypes().length == 1) {
            return "new " + clazz.getName() + "(" + ClientGenerator.valueImpl(constructorArray[0].getParameterTypes()[0]) + ")";
        }
        if (constructorArray.length != 2) {
            throw new Exception(clazz + " isn't a generated type");
        }
        int n = constructorArray[0].getParameterTypes().length > 0 ? 0 : 1;
        Class<?>[] classArray = constructorArray[n].getParameterTypes();
        String string = "new " + clazz.getName() + "(";
        int n3 = 0;
        while (n3 < classArray.length) {
            string = string + ClientGenerator.valueImpl(classArray[n3]);
            if (n3 != classArray.length - 1) {
                string = string + ", ";
            }
            ++n3;
        }
        return string + ")";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

