/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.ClientGenerator;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.web.Binding;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String _serverName;
    protected Hashtable _bindings;
    protected Hashtable _services;
    protected Hashtable _ports;
    protected ClassLoader _loader;
    private static final boolean _debug = false;

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
        this._bindings = new Hashtable();
        this._services = new Hashtable();
        this._ports = new Hashtable();
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        Object object;
        boolean bl = true;
        ASTService[] aSTServiceArray = this._astdoc.getServices();
        if (aSTServiceArray != null) {
            int n = 0;
            while (n < aSTServiceArray.length) {
                object = aSTServiceArray[n].getPorts();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < ((ASTPort[])object).length) {
                        ASTBinding aSTBinding = object[n2].getBinding();
                        if (aSTBinding != null && aSTBinding instanceof ASTSoapBinding) {
                            String string = aSTBinding.getName();
                            if (!this._bindings.containsKey(string)) {
                                this._bindings.put(string, aSTBinding);
                            }
                            this._services.put(string, aSTServiceArray[n]);
                            String string2 = null;
                            if (object[n2] instanceof ASTHttpPort) {
                                string2 = ((ASTHttpPort)object[n2]).getLocation();
                            } else if (object[n2] instanceof ASTSoapPort) {
                                string2 = ((ASTSoapPort)object[n2]).getLocation();
                            }
                            if (string2 != null) {
                                Binding binding = new Binding("soap", string2);
                                Vector<Binding> vector2 = (Vector<Binding>)this._ports.get(string);
                                if (vector2 == null) {
                                    vector2 = new Vector<Binding>();
                                    this._ports.put(string, vector2);
                                }
                                vector2.add(binding);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this._bindings.size() == 0) {
            return bl;
        }
        try {
            Iterator iterator = this._bindings.values().iterator();
            while (iterator.hasNext()) {
                object = (ASTSoapBinding)iterator.next();
                this._serverName = ((ASTBinding)object).getPackage() + ((ASTBinding)object).getFileName() + "Server";
                this.createServer(hashtable, vector, (ASTSoapBinding)object);
            }
            this.generateWebXML(hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void createServer(Hashtable hashtable, Vector vector, ASTSoapBinding aSTSoapBinding) throws Exception {
        boolean bl;
        String string = Util.fileName(this._serverName);
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, this._serverName);
        Object v = hashtable.get("d");
        File file3 = v != null ? (v instanceof String ? new File((String)v) : new File(((String[])v)[0])) : new File(".");
        URL[] uRLArray = new URL[]{file3.toURL()};
        this._loader = new URLClassLoader(uRLArray);
        if (vector.contains(file2)) {
            return;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._serverName);
        HashSet hashSet = this._astdoc.getPkgsWithHolders();
        Util.generateImports(formatter, aSTSoapBinding, hashSet);
        formatter.println("public class " + string + " extends " + aSTSoapBinding.getPortTypeClassName() + "_ServiceSkeleton");
        formatter.println("{");
        formatter.startBlock();
        boolean bl2 = bl = hashtable.get("handler") != null;
        if (bl) {
            formatter.println("public void init() throws javax.servlet.ServletException");
            formatter.println("{");
            formatter.startBlock();
            formatter.println("super.init();");
            formatter.println("try");
            formatter.println("{");
            formatter.startBlock();
            formatter.println("java.util.ArrayList handlers = new java.util.ArrayList();");
            formatter.println("handlers.add(new javax.xml.rpc.handler.HandlerInfo(" + string + "Handler.class, null, null));");
            formatter.println("_setHandlerChain(handlers);");
            formatter.endBlock();
            formatter.println("}");
            formatter.println("catch (Exception ex)");
            formatter.println("{");
            formatter.startBlock();
            formatter.println("ex.printStackTrace();");
            formatter.println("throw new javax.servlet.ServletException(ex.getMessage());");
            formatter.endBlock();
            formatter.println("}");
            formatter.endBlock();
            formatter.println("}");
            ClientGenerator.generateHandler(hashtable, this._serverName, false, vector);
        }
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        int n = 0;
        while (n < aSTOperationArray.length) {
            this.generateMethod((ASTSoapOperation)aSTOperationArray[n], formatter);
            formatter.println();
            ++n;
        }
        ClientGenerator.generateElementMethod(formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
    }

    void generateMethod(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        int n2;
        Object[] objectArray;
        formatter.print("public ");
        formatter.print(aSTSoapOperation.isVoid() ? "void" : aSTSoapOperation.getReturnType());
        formatter.print(" " + aSTSoapOperation.getMethodName() + "(");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        boolean bl = false;
        if (aSTSoapBodyMessage != null) {
            objectArray = aSTSoapBodyMessage.getParts();
            n2 = 0;
            while (n2 < objectArray.length) {
                if (bl) {
                    formatter.print(", ");
                } else {
                    bl = true;
                }
                if (((ASTPart)objectArray[n2]).getMode() == 3) {
                    formatter.print(((ASTPart)objectArray[n2]).getDataType() + " io" + n2);
                } else {
                    formatter.print(((ASTPart)objectArray[n2]).getDataType() + " i" + n2);
                }
                ++n2;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            objectArray = aSTSoapBodyMessage2.getParts();
            n2 = 0;
            while (n2 < objectArray.length) {
                if (((ASTPart)objectArray[n2]).getMode() != 3) {
                    if (bl) {
                        formatter.print(", ");
                    } else {
                        bl = true;
                    }
                    formatter.print(((ASTPart)objectArray[n2]).getDataType() + " o" + n2);
                }
                ++n2;
            }
        }
        formatter.println(")");
        formatter.startBlock();
        objectArray = aSTSoapOperation.getFaults();
        if (objectArray != null) {
            formatter.print("throws ");
            n2 = 0;
            while (n2 < objectArray.length) {
                if (((ASTMessage)objectArray[n2]).getName().endsWith("RemoteException")) {
                    formatter.print("java.rmi.RemoteException");
                } else {
                    formatter.print(((ASTMessage)objectArray[n2]).getClassName());
                }
                if (n2 != objectArray.length - 1) {
                    formatter.print(", ");
                }
                ++n2;
            }
        }
        formatter.println();
        formatter.endBlock();
        formatter.println("{");
        formatter.startBlock();
        if (aSTSoapBodyMessage != null) {
            ASTPart[] aSTPartArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() == 3) {
                    formatter.println("io" + n + ".value = " + ClientGenerator.value(aSTPartArray[n].getInOutType(), this._loader) + ";");
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() != 3) {
                    formatter.println("o" + n + ".value = " + ClientGenerator.value(aSTPartArray[n].getInOutType(), this._loader) + ";");
                }
                ++n;
            }
        }
        if (!aSTSoapOperation.isVoid()) {
            formatter.println("return " + ClientGenerator.value(aSTSoapOperation.getReturnType(), this._loader) + ";");
        }
        formatter.endBlock();
        formatter.println("}");
    }

    private void generateWebXML(Hashtable hashtable) throws Exception {
        Element element;
        Element element2;
        Element element3;
        Object object;
        Object object2;
        Element element4;
        String string;
        Object object3;
        File file = (File)hashtable.get("destDir");
        File file2 = new File(file, "web.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element5 = document.createElement("web-app");
        document.appendChild(element5);
        Element element6 = document.createElement("display-name");
        element6.appendChild(document.createTextNode("jBrokerWeb"));
        element5.appendChild(element6);
        Element element7 = document.createElement("description");
        element7.appendChild(document.createTextNode("Generated test server"));
        element5.appendChild(element7);
        Document document2 = null;
        if (file2.exists()) {
            document2 = documentBuilder.parse(new FileInputStream(file2));
            if (hashtable.get("verbose") != null) {
                System.out.println("appending to: " + file2.getPath());
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this._bindings.values().iterator();
        while (iterator.hasNext()) {
            object3 = (ASTSoapBinding)iterator.next();
            string = ((ASTBinding)object3).getFileName() + "Server";
            hashSet.add(string);
        }
        if (document2 != null) {
            object3 = document2.getElementsByTagName("servlet");
            int n = object3.getLength();
            int n2 = 0;
            while (n2 < n) {
                element4 = (Element)object3.item(n2);
                object2 = ServerGenerator.getStringValue(element4, "servlet-name");
                if (!hashSet.contains(object2)) {
                    object = ServerGenerator.getStringValue(element4, "servlet-class");
                    element3 = document.createElement("servlet");
                    element2 = document.createElement("servlet-name");
                    element2.appendChild(document.createTextNode((String)object2));
                    element = document.createElement("servlet-class");
                    element.appendChild(document.createTextNode((String)object));
                    element3.appendChild(element2);
                    element3.appendChild(element);
                    element5.appendChild(element3);
                }
                ++n2;
            }
        }
        iterator = this._bindings.values().iterator();
        while (iterator.hasNext()) {
            object3 = (ASTSoapBinding)iterator.next();
            string = ((ASTBinding)object3).getFileName() + "Server";
            String string2 = ((ASTBinding)object3).getPackage() + ((ASTBinding)object3).getFileName() + "Server";
            element4 = document.createElement("servlet");
            object2 = document.createElement("servlet-name");
            object2.appendChild(document.createTextNode(string));
            object = document.createElement("servlet-class");
            object.appendChild(document.createTextNode(string2));
            element4.appendChild((Node)object2);
            element4.appendChild((Node)object);
            element5.appendChild(element4);
        }
        if (document2 != null) {
            object3 = document2.getElementsByTagName("servlet-mapping");
            int n = object3.getLength();
            int n3 = 0;
            while (n3 < n) {
                element4 = (Element)object3.item(n3);
                object2 = ServerGenerator.getStringValue(element4, "servlet-name");
                if (!hashSet.contains(object2)) {
                    object = ServerGenerator.getStringValue(element4, "url-pattern");
                    element3 = document.createElement("servlet-mapping");
                    element2 = document.createElement("servlet-name");
                    element2.appendChild(document.createTextNode((String)object2));
                    element = document.createElement("url-pattern");
                    element.appendChild(document.createTextNode((String)object));
                    element3.appendChild(element2);
                    element3.appendChild(element);
                    element5.appendChild(element3);
                }
                ++n3;
            }
        }
        iterator = this._bindings.values().iterator();
        while (iterator.hasNext()) {
            object3 = (ASTSoapBinding)iterator.next();
            String string3 = ((ASTBinding)object3).getFileName() + "Server";
            String string4 = ((ASTBinding)object3).getName().toLowerCase().replace('.', '_');
            element4 = document.createElement("servlet-mapping");
            object2 = document.createElement("servlet-name");
            object2.appendChild(document.createTextNode(string3));
            object = document.createElement("url-pattern");
            object.appendChild(document.createTextNode(string4));
            element4.appendChild((Node)object2);
            element4.appendChild((Node)object);
            element5.appendChild(element4);
        }
        object3 = new FileOutputStream(file2);
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setDoctype("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd");
        outputFormat.setIndent(4);
        outputFormat.setLineWidth(60);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)object3, outputFormat);
        xMLSerializer.asDOMSerializer();
        xMLSerializer.serialize(document);
        ((OutputStream)object3).flush();
        ((FileOutputStream)object3).close();
    }

    private static String getStringValue(Element element, String string) throws IOException {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            throw new IOException("no tag found for " + string + " in web.xml");
        }
        Node node = nodeList.item(0);
        if (!node.hasChildNodes()) {
            throw new IOException("element " + string + " has no value in web.xml");
        }
        return node.getFirstChild().getNodeValue();
    }
}

