/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.Formatter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;

public class ServiceGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String _serviceName;
    protected String _fileName;
    protected boolean _copyOnLocal;
    protected boolean _oldstyle;
    protected String _servimplext;
    static HashMap encodingURIMapping = new HashMap();
    private static final boolean _debug = false;

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        this._copyOnLocal = hashtable.get("localnocopy") == null;
        this._oldstyle = hashtable.get("oldstyle") != null;
        Object v = hashtable.get("servimplext");
        this._servimplext = null;
        if (v != null) {
            if (v instanceof String) {
                this._servimplext = (String)v;
            } else if (v instanceof String[]) {
                this._servimplext = ((String[])v)[0];
            }
        }
        if (this._servimplext == null || this._servimplext.length() == 0) {
            this._servimplext = "Impl";
        }
        boolean bl = true;
        ASTService[] aSTServiceArray = this._astdoc.getServices();
        if (aSTServiceArray == null) {
            return bl;
        }
        try {
            int n = 0;
            while (n < aSTServiceArray.length) {
                if (aSTServiceArray[n] != null && aSTServiceArray[n].getName() != null && this.generateServiceInterface(aSTServiceArray[n], hashtable, vector)) {
                    this.generateServiceImpl(aSTServiceArray[n], hashtable, vector);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public boolean generateServiceInterface(ASTService aSTService, Hashtable hashtable, Vector vector) throws Exception {
        this._serviceName = aSTService.getPackage() + aSTService.getFileName();
        this._fileName = Util.fileName(this._serviceName);
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, this._serviceName);
        if (vector.contains(file2)) {
            return false;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._serviceName);
        formatter.println("public interface " + this._fileName);
        formatter.println("    extends javax.xml.rpc.Service");
        formatter.println("{");
        this.generateBody(aSTService, hashtable, formatter, false);
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
        return true;
    }

    public boolean generateServiceImpl(ASTService aSTService, Hashtable hashtable, Vector vector) throws Exception {
        this._serviceName = aSTService.getPackage() + aSTService.getFileName() + this._servimplext;
        this._fileName = Util.fileName(this._serviceName);
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, this._serviceName);
        if (vector.contains(file2)) {
            return false;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._serviceName);
        this.generateStandardImports(formatter);
        formatter.println("public class " + this._fileName);
        formatter.startBlock();
        formatter.println("extends com.sssw.jbroker.web.xml.rpc.ServiceImpl ");
        formatter.println("implements " + this._fileName.substring(0, this._fileName.lastIndexOf(this._servimplext)));
        formatter.endBlock();
        formatter.println("{");
        this.generateConstructor(aSTService, hashtable, this._fileName, formatter);
        this.generateBody(aSTService, hashtable, formatter, true);
        this.generateDeclaration(formatter);
        this.generateStaticSection(aSTService, formatter);
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
        return true;
    }

    void generateDeclaration(Formatter formatter) {
        formatter.startBlock();
        formatter.println("static boolean _proxy = true;");
        formatter.println("static final java.util.HashMap _intfMapping = new java.util.HashMap();");
        formatter.println("static final java.util.HashMap _intfBinding = new java.util.HashMap();");
        formatter.println("static final java.util.HashMap _portBinding = new java.util.HashMap();");
        formatter.println("static final java.util.HashMap _portMapping = new java.util.HashMap();");
        formatter.println("static final java.util.HashMap _classInfo = new java.util.HashMap();");
        if (this._astdoc.hasTypeMappings()) {
            formatter.println("static final java.util.Properties _tmprops = new java.util.Properties();");
        }
        formatter.println("private final java.util.HashMap _calls = new java.util.HashMap();");
        formatter.endBlock();
        formatter.println();
    }

    void generateStaticSection(ASTService aSTService, Formatter formatter) {
        ASTPort[] aSTPortArray = aSTService.getPorts();
        formatter.startBlock();
        formatter.println("static {");
        formatter.startBlock();
        if (aSTPortArray != null) {
            int n = 0;
            while (n < aSTPortArray.length) {
                if (aSTPortArray[n] != null && aSTPortArray[n].getBinding() != null) {
                    String string = null;
                    if (aSTPortArray[n] instanceof ASTHttpPort) {
                        string = ((ASTHttpPort)aSTPortArray[n]).getLocation();
                    } else if (aSTPortArray[n] instanceof ASTSoapPort) {
                        string = ((ASTSoapPort)aSTPortArray[n]).getLocation();
                    }
                    if (string != null) {
                        formatter.println("_intfBinding.put(" + aSTPortArray[n].getBinding().getPortTypeClassName() + ".class, " + "new  com.sssw.jbroker.web.Binding(\"soap\", \"" + string + "\"));");
                        formatter.println("_portBinding.put(new javax.xml.namespace.QName(\"" + aSTPortArray[n].getNsURI() + "\", \"" + aSTPortArray[n].getLocalName() + "\"), " + "new com.sssw.jbroker.web.Binding(\"soap\", \"" + string + "\"));");
                    }
                    String string2 = null;
                    string2 = this._oldstyle ? aSTPortArray[n].getBinding().getPackage() + "_" + aSTPortArray[n].getBinding().getPortTypeClassName() + "_ServiceStub" : aSTPortArray[n].getBinding().getPackage() + aSTPortArray[n].getBinding().getFileName() + "_Stub";
                    formatter.println("_intfMapping.put(" + aSTPortArray[n].getBinding().getPortTypeClassName() + ".class, \"" + string2 + "\");");
                    formatter.println("_portMapping.put(new QName(\"" + aSTPortArray[n].getNsURI() + "\",");
                    formatter.println("\"" + aSTPortArray[n].getLocalName() + "\"), \"" + string2 + "\");");
                }
                ++n;
            }
        }
        this.generateServiceClassInfo(aSTService, formatter);
        this.generateTypeMappings(formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
    }

    void generateConstructor(ASTService aSTService, Hashtable hashtable, String string, Formatter formatter) {
        String[] stringArray;
        formatter.startBlock();
        formatter.println("public " + string + "()");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("super(new QName(\"" + aSTService.getNsURI() + "\", \"" + aSTService.getLocalName() + "\"));");
        if (this._astdoc.hasTypeMappings()) {
            stringArray = this._astdoc.getTypeMappings();
            formatter.println("try {");
            formatter.startBlock();
            formatter.println("_typeMappingRegistry.importTypeMappings(_tmprops);");
            formatter.endBlock();
            formatter.println("} catch (java.lang.Exception ex) {");
            formatter.startBlock();
            formatter.println("throw new JAXRPCException(\"failed to populate default type \" +");
            formatter.println("    \"mapping registry: \" + ex.getMessage());");
            formatter.endBlock();
            formatter.println("}");
        }
        formatter.println("try {");
        formatter.startBlock();
        formatter.println("createCalls();");
        formatter.endBlock();
        formatter.println("} catch (javax.xml.rpc.ServiceException ex) {");
        formatter.startBlock();
        formatter.println("throw new JAXRPCException(\"failed to create the call objects: \" +");
        formatter.println("    ex.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("java.util.ArrayList handlers = new java.util.ArrayList();");
        stringArray = (String[])hashtable.get("clienthandler");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                formatter.println("handlers.add(new javax.xml.rpc.handler.HandlerInfo(" + stringArray[n] + ".class, null, null));");
                ++n;
            }
        }
        formatter.println("java.util.Iterator ports = getPorts();");
        formatter.println("while (ports.hasNext()) {");
        formatter.startBlock();
        formatter.println("getHandlerRegistry().setHandlerChain((QName) ports.next(), handlers);");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
    }

    void generateBody(ASTService aSTService, Hashtable hashtable, Formatter formatter, boolean bl) {
        ASTPort[] aSTPortArray;
        formatter.startBlock();
        if (bl) {
            this.generateImplMethods(formatter, hashtable);
        }
        if ((aSTPortArray = aSTService.getPorts()) != null) {
            int n = 0;
            while (n < aSTPortArray.length) {
                if (aSTPortArray[n] != null) {
                    this.generatePort(aSTPortArray[n], formatter, bl);
                    if (n != aSTPortArray.length - 1) {
                        formatter.println();
                    }
                }
                ++n;
            }
        }
        if (bl) {
            this.generateGetCalls(aSTService, formatter);
        }
        formatter.endBlock();
    }

    void generateImplMethods(Formatter formatter, Hashtable hashtable) {
        formatter.println();
        formatter.println("public java.util.Iterator getPorts()");
        formatter.println("{");
        formatter.println("    return _portMapping.keySet().iterator();");
        formatter.println("}");
        formatter.println();
        formatter.println("public void setProxyMode(boolean proxy) { _proxy = proxy; }");
        formatter.println();
        formatter.println("public boolean getProxyMode() { return _proxy; }");
        formatter.println();
        formatter.println("public java.net.URL getWSDLDocumentLocation()");
        formatter.println("{");
        Object v = hashtable.get("wsdllocation");
        String string = null;
        if (v != null) {
            if (v instanceof String) {
                string = (String)v;
            } else if (v instanceof String[]) {
                string = ((String[])v)[0];
            }
        }
        if (string != null) {
            formatter.println("    try {");
            formatter.println("        return new java.net.URL(\"" + string + "\");");
            formatter.println("    } catch (java.net.MalformedURLException mex) {");
            formatter.println("        return null;");
            formatter.println("    }");
        } else if (this._astdoc.getWSDLDocument() == null) {
            formatter.println("    return null;");
        } else {
            formatter.println("    try {");
            formatter.println("        return new java.net.URL(\"" + this._astdoc.getWSDLDocument().toString() + "\");");
            formatter.println("    } catch (java.net.MalformedURLException mex) {");
            formatter.println("        return null;");
            formatter.println("    }");
        }
        formatter.println("}");
        formatter.println();
        formatter.println("public java.rmi.Remote getPort(java.lang.Class serviceDefInterface)");
        formatter.println("    throws javax.xml.rpc.ServiceException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (serviceDefInterface == null)");
        formatter.println("    throw new ServiceException(\"No Service class specified.\");");
        formatter.println("if (!java.rmi.Remote.class.isAssignableFrom(serviceDefInterface))");
        formatter.println("    throw new ServiceException(\"Class is not a valid Interface.\");");
        formatter.println();
        formatter.println("java.lang.String stubName = (java.lang.String) _intfMapping.get(serviceDefInterface);");
        formatter.println("Binding binding = (Binding) _intfBinding.get(serviceDefInterface);");
        formatter.println();
        formatter.println("if (stubName == null)");
        formatter.println("    return getPort(serviceDefInterface, binding, ");
        formatter.println("        _classInfo, _typeMappingRegistry, null);");
        formatter.println("else");
        formatter.println("    return getPort(stubName, binding, _typeMappingRegistry);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public java.rmi.Remote getPort(QName portName, java.lang.Class serviceDefInterface) ");
        formatter.println("    throws javax.xml.rpc.ServiceException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("return getPort(portName, serviceDefInterface, getProxyMode());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public java.rmi.Remote getPort(QName portName, java.lang.Class serviceDefInterface, boolean proxy) ");
        formatter.println("    throws javax.xml.rpc.ServiceException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (((proxy==false) || (serviceDefInterface == null)) && ");
        formatter.println("    (portName != null)) {");
        formatter.startBlock();
        formatter.println("java.lang.String stubName = (java.lang.String) _portMapping.get(portName);");
        formatter.println("Binding binding = (Binding) _portBinding.get(portName);");
        formatter.println();
        formatter.println("if (stubName == null) return getPort(null, serviceDefInterface);");
        formatter.println();
        formatter.println("try {");
        formatter.startBlock();
        formatter.println("return getPort(stubName, binding, portName,");
        formatter.println("   _typeMappingRegistry);");
        formatter.endBlock();
        formatter.println("} catch (java.lang.Exception ex) {");
        formatter.startBlock();
        formatter.println("return getPort(null, serviceDefInterface);");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("} else {");
        formatter.startBlock();
        formatter.println("if (serviceDefInterface == null)");
        formatter.println("    throw new ServiceException(\"No Service class specified.\");");
        formatter.println("if (!java.rmi.Remote.class.isAssignableFrom(serviceDefInterface))");
        formatter.println("    throw new ServiceException(\"Class is not a valid Interface.\");");
        formatter.println();
        formatter.println("Binding binding = (Binding) _intfBinding.get(serviceDefInterface);");
        formatter.println("return getPort(serviceDefInterface, binding, _classInfo,");
        formatter.println("   _typeMappingRegistry, portName);");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public javax.xml.rpc.Call[] getCalls(QName portName)");
        formatter.println("    throws javax.xml.rpc.ServiceException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (portName == null)");
        formatter.println("    throw new javax.xml.rpc.ServiceException(\"PortName not specified\");");
        formatter.println("if (!_calls.containsKey(portName))");
        formatter.println("    throw new javax.xml.rpc.ServiceException(\"Invalid PortName\");");
        formatter.println("java.util.ArrayList callslist = (java.util.ArrayList) _calls.get(portName);");
        formatter.println("if (callslist == null) return null;");
        formatter.println("javax.xml.rpc.Call[] calls = new javax.xml.rpc.Call[callslist.size()];");
        formatter.println("return (javax.xml.rpc.Call[]) callslist.toArray(calls);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("private void addCall(QName portName, javax.xml.rpc.Call call)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("java.util.ArrayList callslist = (java.util.ArrayList) _calls.get(portName);");
        formatter.println("if (callslist == null) {");
        formatter.println("    callslist = new java.util.ArrayList();");
        formatter.println("    _calls.put(portName, callslist);");
        formatter.println("}");
        formatter.println("callslist.add(call);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    void generateSoapCallParameters(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        String string;
        QName qName;
        int n;
        Object object;
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        if (aSTSoapBodyMessage != null) {
            object = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < ((ASTPart[])object).length) {
                qName = object[n].getQName() != null ? object[n].getQName() : new QName(aSTSoapOperation.getNsURI(), object[n].getName());
                string = object[n].getMode() == 1 ? "javax.xml.rpc.ParameterMode.IN" : "javax.xml.rpc.ParameterMode.INOUT";
                String string2 = ((ASTPart)object[n]).getMode() == 1 ? ((ASTPart)object[n]).getDataType() : ((ASTPart)object[n]).getInOutType();
                String string3 = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object[n]).getJavafiedName();
                formatter.println("call.addParameter(\"" + string3 + "\", new QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\"), " + string2 + ".class, " + string + ");");
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            object = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < ((ASTPart[])object).length) {
                if (object[n].getMode() != 3) {
                    qName = object[n].getQName() != null ? ((ASTPart)object[n]).getQName() : new QName(aSTSoapOperation.getNsURI(), ((ASTPart)object[n]).getName());
                    string = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object[n]).getJavafiedName();
                    formatter.println("call.addParameter(\"" + string + "\", new QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\"), " + ((ASTPart)object[n]).getInOutType() + ".class, " + "javax.xml.rpc.ParameterMode.OUT);");
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && !aSTSoapBodyMessage2.isVoid()) {
            object = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < ((ASTPart[])object).length) {
                if (object[n].getMode() == 2) {
                    qName = ((ASTPart)object[n]).getQName() != null ? ((ASTPart)object[n]).getQName() : new QName(aSTSoapOperation.getNsURI(), ((ASTPart)object[n]).getName());
                    string = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object[n]).getJavafiedName();
                    formatter.println("call.setReturnType(new QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\"), " + ((ASTPart)object[n]).getDataType() + ".class);");
                    break;
                }
                ++n;
            }
        }
        object = aSTSoapOperation.isDocument() ? "document" : "rpc";
        formatter.println("call.setProperty(Call.OPERATION_STYLE_PROPERTY, \"" + (String)object + "\");");
        if (((String)object).equals("document")) {
            formatter.println("call.setProperty(Call.ENCODINGSTYLE_URI_PROPERTY, null);");
        } else {
            String string4 = aSTSoapOperation.getEncodingStyle();
            if (string4 != null && string4.length() > 0) {
                formatter.println("call.setProperty(Call.ENCODINGSTYLE_URI_PROPERTY, \"" + string4 + "\");");
            }
        }
        String string5 = aSTSoapOperation.getAction();
        if (string5 != null && !string5.startsWith("\"") && !string5.endsWith("\"")) {
            string5 = "\"\\\"" + string5 + "\\\"\"";
        }
        formatter.println("call.setProperty(Call.SOAPACTION_URI_PROPERTY, " + string5 + ");");
    }

    void generateGetCalls(ASTService aSTService, Formatter formatter) {
        formatter.println();
        formatter.println("private void createCalls()");
        formatter.println("    throws javax.xml.rpc.ServiceException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.rpc.Call call = null;");
        formatter.println();
        ASTPort[] aSTPortArray = aSTService.getPorts();
        if (aSTPortArray != null) {
            int n = 0;
            while (n < aSTPortArray.length) {
                ASTOperation[] aSTOperationArray;
                ASTBinding aSTBinding;
                if (aSTPortArray[n] != null && (aSTBinding = aSTPortArray[n].getBinding()) != null && (aSTOperationArray = aSTBinding.getOperations()) != null) {
                    int n2 = 0;
                    while (n2 < aSTOperationArray.length) {
                        formatter.println("call = createCall(new QName(\"" + aSTPortArray[n].getNsURI() + "\", \"" + aSTPortArray[n].getLocalName() + "\"), new QName(\"" + aSTOperationArray[n2].getNsURI() + "\", \"" + aSTOperationArray[n2].getName() + "\"));");
                        if (aSTOperationArray[n2] instanceof ASTSoapOperation) {
                            this.generateSoapCallParameters((ASTSoapOperation)aSTOperationArray[n2], formatter);
                        }
                        String string = null;
                        if (aSTPortArray[n] instanceof ASTHttpPort) {
                            string = ((ASTHttpPort)aSTPortArray[n]).getLocation();
                        } else if (aSTPortArray[n] instanceof ASTSoapPort) {
                            string = ((ASTSoapPort)aSTPortArray[n]).getLocation();
                        }
                        if (string != null) {
                            formatter.println("call.setTargetEndpointAddress(\"" + string + "\");");
                        }
                        formatter.println("addCall(new QName(\"" + aSTPortArray[n].getNsURI() + "\", \"" + aSTPortArray[n].getLocalName() + "\"), call);");
                        if (n2 != aSTOperationArray.length - 1) {
                            formatter.println();
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    void generatePort(ASTPort aSTPort, Formatter formatter, boolean bl) {
        if (aSTPort.getBinding() == null) {
            return;
        }
        ASTBinding aSTBinding = aSTPort.getBinding();
        String string = null;
        if (aSTPort instanceof ASTHttpPort) {
            string = ((ASTHttpPort)aSTPort).getLocation();
        } else if (aSTPort instanceof ASTSoapPort) {
            string = ((ASTSoapPort)aSTPort).getLocation();
        }
        String string2 = null;
        string2 = this._oldstyle ? aSTBinding.getPackage() + "_" + aSTBinding.getPortTypeClassName() + "_ServiceStub" : aSTBinding.getPackage() + aSTBinding.getFileName() + "_Stub";
        formatter.println("public " + Util.removePackageName(aSTBinding.getPortTypeClassName()) + " " + "get" + Util.removePackageName(aSTPort.getLocalName()) + "()");
        formatter.print("    throws javax.xml.rpc.ServiceException");
        if (bl) {
            formatter.println();
            formatter.println("{");
            formatter.startBlock();
            formatter.println("try {");
            formatter.startBlock();
            formatter.println("return (" + Util.removePackageName(aSTBinding.getPortTypeClassName()) + ") " + "getPort(new javax.xml.namespace.QName(");
            formatter.println("    \"" + aSTPort.getNsURI() + "\", \"" + aSTPort.getLocalName() + "\"), null, false);");
            formatter.endBlock();
            formatter.println("} catch (java.lang.Exception ex) {");
            formatter.startBlock();
            formatter.println("return (" + Util.removePackageName(aSTBinding.getPortTypeClassName()) + ") getPort(" + aSTPort.getBinding().getPackage() + aSTPort.getBinding().getPortTypeClassName() + ".class);");
            formatter.endBlock();
            formatter.println("}");
            formatter.endBlock();
            formatter.println("}");
        } else {
            formatter.println(";");
        }
    }

    void generatePortClassInfo(ASTPort aSTPort, Formatter formatter) {
        ASTSoapBinding aSTSoapBinding = (ASTSoapBinding)aSTPort.getBinding();
        if (!aSTSoapBinding.hasOperations()) {
            return;
        }
        String string = aSTSoapBinding.getPackage() + aSTSoapBinding.getPortTypeClassName();
        formatter.println("_methodInfo = new java.util.HashMap();");
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        int n = 0;
        while (n < aSTOperationArray.length) {
            ASTSoapOperation aSTSoapOperation = (ASTSoapOperation)aSTOperationArray[n];
            if (aSTSoapOperation.getAction() != null || aSTSoapOperation.getInput() != null || aSTSoapOperation.hasOutParameters() || !aSTSoapOperation.isVoid()) {
                int n2;
                Object object;
                formatter.println("_paramInfo = new java.util.HashMap();");
                String string2 = aSTSoapOperation.getAction();
                if (string2 != null) {
                    if (!string2.startsWith("\"") && !string2.endsWith("\"")) {
                        string2 = "\"\\\"" + string2 + "\\\"\"";
                    }
                    formatter.println("_props = new java.util.Properties();");
                    formatter.println("_props.setProperty(\"jbroker.web.soap.action\"," + string2 + ");");
                    formatter.println("_paramInfo.put(\"Properties\", _props);");
                }
                ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
                ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
                int n3 = 0;
                if (aSTSoapBodyMessage != null) {
                    object = aSTSoapBodyMessage.getParts();
                    n2 = 0;
                    while (n2 < ((ASTPart[])object).length) {
                        formatter.println("_props = new java.util.Properties();");
                        formatter.println("_props.setProperty(\"jbroker.web.parameter.name\", \"" + ((ASTPart)object[n2]).getName() + "\");");
                        formatter.println("_props.setProperty(\"jbroker.web.parameter.inout\", \"" + ((ASTPart)object[n2]).getMode() + "\");");
                        formatter.println("_paramInfo.put(\"Param" + n3++ + "\", _props);");
                        ++n2;
                    }
                }
                if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
                    object = aSTSoapBodyMessage2.getParts();
                    n2 = 0;
                    while (n2 < ((ASTPart[])object).length) {
                        if (object[n2].getMode() != 3) {
                            formatter.println("_props = new java.util.Properties();");
                            formatter.println("_props.setProperty(\"jbroker.web.parameter.name\", \"" + ((ASTPart)object[n2]).getName() + "\");");
                            formatter.println("_props.setProperty(\"jbroker.web.parameter.inout\", \"" + ((ASTPart)object[n2]).getMode() + "\");");
                            formatter.println("_paramInfo.put(\"Param" + n3++ + "\", _props);");
                        }
                        ++n2;
                    }
                }
                if (!aSTSoapOperation.isVoid() && (object = aSTSoapOperation.getReturnPart()) != null) {
                    formatter.println("_props = new java.util.Properties();");
                    formatter.println("_props.setProperty(\"jbroker.web.parameter.name\", \"" + ((ASTPart)object).getName() + "\");");
                    formatter.println("_props.setProperty(\"jbroker.web.parameter.inout\", \"" + ((ASTPart)object).getMode() + "\");");
                    formatter.println("_paramInfo.put(\"Result\", _props);");
                }
                formatter.println("_methodInfo.put(\"" + aSTSoapOperation.getMangledName() + "\", _paramInfo);");
            }
            ++n;
        }
        formatter.println("_classInfo.put(\"" + string + "\", _methodInfo);");
    }

    void generateServiceClassInfo(ASTService aSTService, Formatter formatter) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ASTPort[] aSTPortArray = aSTService.getPorts();
        formatter.println();
        formatter.println("java.util.HashMap _methodInfo;");
        formatter.println("java.util.HashMap _paramInfo;");
        formatter.println("java.util.Properties _props;");
        if (aSTPortArray != null) {
            int n = 0;
            while (n < aSTPortArray.length) {
                String string;
                if (aSTPortArray[n] != null && aSTPortArray[n].getBinding() != null && !hashMap.containsKey(string = aSTPortArray[n].getBinding().getPackage() + aSTPortArray[n].getBinding().getPortTypeClassName())) {
                    formatter.println();
                    this.generatePortClassInfo(aSTPortArray[n], formatter);
                    hashMap.put(string, string);
                }
                ++n;
            }
        }
    }

    void generateTypeMappings(Formatter formatter) {
        if (this._astdoc.hasTypeMappings()) {
            Properties properties = this._astdoc.getTypeMappings();
            formatter.println();
            Iterator iterator = ((Hashtable)properties).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                formatter.println("_tmprops.put(\"" + entry.getKey() + "\", \"" + entry.getValue() + "\");");
            }
        }
    }

    protected void generateStandardImports(Formatter formatter) {
        formatter.println("import javax.xml.rpc.Call;");
        formatter.println("import javax.xml.rpc.JAXRPCException;");
        formatter.println("import javax.xml.rpc.ServiceException;");
        formatter.println();
        formatter.println("import javax.xml.namespace.QName;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.Binding;");
        formatter.println();
    }

    static {
        encodingURIMapping.put("http://schemas.xmlsoap.org/soap/encoding/", "soap");
    }
}

