/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapFaultMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPart;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;

public class SkelGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String[] _directs;
    protected String _skelName;
    protected String _fileName;
    protected String[] _implements;
    protected boolean _inheritance = true;
    protected String _extends = "com.sssw.jbroker.web.portable.ServletSkeleton";
    protected boolean _oldstyle;
    protected boolean _mdb;
    protected HashMap _bindings;

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
        this._bindings = new HashMap();
    }

    protected void generateNames(ASTSoapBinding aSTSoapBinding) {
        this._skelName = aSTSoapBinding.getPackage() + (this._oldstyle ? "_" : "") + aSTSoapBinding.getPortTypeClassName() + "_ServiceSkeleton";
        this._directs = new String[]{aSTSoapBinding.getPortTypeClassName()};
        this._implements = this.getImplementedInterfaces();
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        Object object;
        Object object2;
        Object object3;
        ASTService[] aSTServiceArray;
        boolean bl = true;
        this._oldstyle = hashtable.get("oldstyle") != null;
        boolean bl2 = this._mdb = hashtable.get("mdb") != null;
        if (this._mdb) {
            this._extends = "com.sssw.jbroker.web.portable.MDBSkeleton";
        }
        if ((aSTServiceArray = this._astdoc.getServices()) != null) {
            int n = 0;
            while (n < aSTServiceArray.length) {
                object3 = aSTServiceArray[n].getPorts();
                if (object3 != null) {
                    int n2 = 0;
                    while (n2 < ((ASTPort[])object3).length) {
                        object2 = object3[n2].getBinding();
                        if (object2 != null && object2 instanceof ASTSoapBinding && !this._bindings.containsKey(object = ((ASTBinding)object2).getName())) {
                            this._bindings.put(object, object2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this._bindings.size() == 0) {
            return bl;
        }
        try {
            Iterator iterator = this._bindings.values().iterator();
            while (iterator.hasNext()) {
                object3 = (ASTSoapBinding)iterator.next();
                this.generateNames((ASTSoapBinding)object3);
                this._fileName = Util.fileName(this._skelName);
                File file = (File)hashtable.get("destDir");
                object2 = Util.getFile(file, this._skelName);
                if (vector.contains(object2)) continue;
                if (hashtable.get("verbose") != null) {
                    System.out.println("creating: " + ((File)object2).getPath());
                }
                object = new FileOutputStream((File)object2);
                Formatter formatter = new Formatter("    ", (OutputStream)object);
                Util.generateHeader(formatter, this._skelName);
                HashSet hashSet = this._astdoc.getPkgsWithHolders();
                Util.generateImports(formatter, (ASTBinding)object3, hashSet);
                this.generateStandardImports(formatter);
                formatter.println("public abstract class " + this._fileName);
                formatter.startBlock();
                formatter.println("extends " + this._extends);
                if (this._implements != null) {
                    formatter.print("implements ");
                    int n = 0;
                    while (n < this._implements.length) {
                        formatter.print(this._implements[n] + (n == this._implements.length - 1 ? "" : ", "));
                        ++n;
                    }
                    formatter.println();
                }
                formatter.endBlock();
                formatter.println("{");
                this.generateBody((ASTSoapBinding)object3, hashtable, formatter);
                formatter.println("}");
                formatter.flush();
                ((FileOutputStream)object).close();
                vector.addElement(object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    protected String[] getImplementedInterfaces() {
        return this._directs;
    }

    protected void generateBody(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
        formatter.startBlock();
        this.generateConstructor(aSTSoapBinding, hashtable, formatter);
        this.generateInit(aSTSoapBinding, hashtable, formatter);
        this.generateInvokeMethod(aSTSoapBinding, formatter);
        this.generateAdditionalMethods(aSTSoapBinding, formatter);
        this.generateDeclaration(formatter);
        this.generateStaticSection(formatter);
        this.generateRootHeaders(aSTSoapBinding, formatter);
        formatter.endBlock();
    }

    protected void generateConstructor(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
        Util.generatePortType(aSTSoapBinding, formatter, "com.sssw.jbroker.web.QName");
        formatter.println("public " + this._fileName + "()");
        formatter.startBlock("{");
        formatter.println("super(_portType);");
        formatter.endBlock("}");
        formatter.println();
    }

    protected void generateInit(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
        String[] stringArray;
        formatter.println("public void init()");
        formatter.println("    throws ServletException");
        formatter.startBlock("{");
        String string = hashtable.get("xsd") != null ? ((String[])hashtable.get("xsd"))[0] : "http://www.w3.org/2001/XMLSchema";
        formatter.println("_setProperty(\"xmlrpc.schema.uri\", \"" + string + "\");");
        formatter.println("_setProperty(\"version\", \"1.1\");");
        if (this._astdoc.hasTypeMappings()) {
            stringArray = this._astdoc.getTypeMappings();
            formatter.println("try {");
            formatter.startBlock();
            formatter.println("TypeMappingRegistry _tm = new DefaultTypeMappingRegistry();");
            formatter.println("_tm.importTypeMappings(_tmprops);");
            formatter.println("_setTypeMappingRegistry(_tm);");
            formatter.endBlock();
            formatter.println("} catch (java.lang.Exception ex) {");
            formatter.startBlock();
            formatter.println("throw new ServletException(\"failed to populate default type \" +");
            formatter.println("    \"mapping registry: \" + ex.getMessage());");
            formatter.endBlock();
            formatter.println("}");
        }
        if ((stringArray = (String[])hashtable.get("serverhandler")) != null) {
            formatter.println("java.util.ArrayList handlers = new java.util.ArrayList();");
            int n = 0;
            while (n < stringArray.length) {
                formatter.println("handlers.add(new javax.xml.rpc.handler.HandlerInfo(" + stringArray[n] + ".class, null, null));");
                ++n;
            }
            formatter.println("_setHandlerChain(handlers);");
            formatter.endBlock();
        }
        formatter.endBlock("}");
        formatter.println();
    }

    protected void generateAdditionalMethods(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        int n = this.generateDocumentMethodTable(aSTSoapBinding, formatter);
        this.generateIsDocumentMethod(formatter, n);
    }

    public int generateDocumentMethodTable(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        String string;
        Vector<String> vector = new Vector<String>();
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray == null) {
            return 0;
        }
        int n = 0;
        while (n < aSTOperationArray.length) {
            if (aSTOperationArray[n] != null) {
                ASTSoapOperation aSTSoapOperation = (ASTSoapOperation)aSTOperationArray[n];
                string = aSTSoapOperation.getAction();
                if (string != null && !string.startsWith("\"") && !string.endsWith("\"")) {
                    string = "\"\\\"" + string + "\\\"\"";
                } else if (string == null) {
                    string = "\"\"";
                }
                if (aSTSoapOperation.isDocument()) {
                    vector.add(string);
                }
            }
            ++n;
        }
        if (vector.size() == aSTOperationArray.length) {
            return 1;
        }
        if (vector.size() == 0) {
            return 0;
        }
        formatter.println();
        formatter.print("private static java.util.HashSet _documentMethods =");
        formatter.println("new java.util.HashSet();");
        formatter.println("static {");
        formatter.startBlock();
        int n2 = 0;
        while (n2 < vector.size()) {
            string = (String)vector.elementAt(n2);
            if (string.charAt(0) == '\"') {
                formatter.println("_documentMethods.add(" + string + ");");
            } else {
                formatter.println("_documentMethods.add(\"" + string + "\");");
            }
            ++n2;
        }
        formatter.endBlock();
        formatter.println("}");
        return 2;
    }

    protected void generateIsDocumentMethod(Formatter formatter, int n) {
        formatter.println();
        formatter.println("public boolean isDocument(java.lang.String action)");
        formatter.startBlock("{");
        if (n == 1) {
            formatter.println("return true;");
        } else if (n == 0) {
            formatter.println("return false;");
        } else if (n == 2) {
            formatter.println("if (action == null) return false;");
            formatter.println("if (_documentMethods.contains(action)) return true;");
            formatter.println("return _documentMethods.contains(\"\\\"\"+action+\"\\\"\");");
        }
        formatter.endBlock("}");
    }

    protected void generateInvokeMethod(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        ASTSoapOperation aSTSoapOperation;
        String string;
        int n;
        formatter.println("private static java.util.Map _atable = new java.util.HashMap();");
        formatter.println("static {");
        formatter.startBlock();
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null) {
            n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null && (string = (aSTSoapOperation = (ASTSoapOperation)aSTOperationArray[n]).getAction()) != null && !string.equals("\"\"")) {
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < aSTOperationArray.length) {
                        if (n != n2 && string.equals(((ASTSoapOperation)aSTOperationArray[n2]).getAction())) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        if (string != null && !string.startsWith("\"") && !string.endsWith("\"")) {
                            string = "\"\\\"" + string + "\\\"\"";
                        }
                        formatter.println("_atable.put(" + string + "," + " new java.lang.Integer(" + n + "));");
                    }
                }
                ++n;
            }
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("private static java.util.Map _mtable = new java.util.HashMap();");
        formatter.println("static {");
        formatter.startBlock();
        aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null) {
            n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null) {
                    aSTSoapOperation = (ASTSoapOperation)aSTOperationArray[n];
                    string = aSTSoapOperation.getMangledName();
                    if (aSTSoapOperation.isDocument()) {
                        ASTPart[] aSTPartArray = aSTSoapOperation.getInput().getParts();
                        string = aSTPartArray.length != 0 ? aSTPartArray[0].getQName().getLocalPart() : "___void";
                    }
                    formatter.println("_mtable.put(\"" + string + "\"," + " new java.lang.Integer(" + n + "));");
                }
                ++n;
            }
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        formatter.println("public ServerResponse _invoke(ServerRequest in)");
        formatter.println("    throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("ServerResponse out = null;");
        formatter.println("java.lang.String soapEncURI = \"soap\";");
        formatter.println("java.lang.String literalURI = \"literal\";");
        aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null && aSTOperationArray.length != 0) {
            formatter.println();
            formatter.println("try {");
            formatter.startBlock();
            formatter.println();
            formatter.println("java.lang.Integer _m = null;");
            formatter.println("java.lang.String sac = in.getAction();");
            formatter.println("if (sac != null) _m = (java.lang.Integer) _atable.get(sac);");
            formatter.println();
            formatter.println("if (_m == null) {");
            formatter.startBlock();
            formatter.println("sac = \"\\\"\" + sac + \"\\\"\";");
            formatter.println("_m = (java.lang.Integer) _atable.get(sac);");
            formatter.endBlock();
            formatter.println("}");
            formatter.println();
            formatter.println("if (_m == null) {");
            formatter.startBlock();
            formatter.println("java.lang.String methodName = in.getMethod();");
            formatter.println("if (methodName == null) methodName = \"___void\";");
            formatter.println("_m = (java.lang.Integer) _mtable.get(methodName);");
            formatter.endBlock();
            formatter.println("}");
            formatter.println();
            formatter.println("if (_m == null) ");
            formatter.println("    throw new ServiceException(\"unable to dispatch SOAP request\");");
            formatter.println();
            formatter.println("switch(_m.intValue()) {");
            formatter.startBlock();
            n = 0;
            while (n < aSTOperationArray.length) {
                this.generateMethod(n, (ASTSoapOperation)aSTOperationArray[n], formatter);
                ++n;
            }
            formatter.endBlock();
            formatter.println("}");
            formatter.println();
            formatter.endBlock();
            formatter.println("} catch (java.lang.Throwable ex) {");
            formatter.startBlock();
            formatter.println("if (System.getProperty(\"SOAP_DEBUG\") != null) ex.printStackTrace();");
            formatter.println("out = in.createExceptionReply();");
            formatter.println("out.writeException(ex, null, \"exception\");");
            formatter.endBlock();
            formatter.println("}");
        }
        formatter.println();
        formatter.println("return out;");
        formatter.endBlock();
        formatter.println("}");
    }

    protected void generateMethod(int n, ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        ASTPart[] aSTPartArray;
        boolean bl = aSTSoapOperation.isDocument();
        boolean bl2 = false;
        ASTMessage[] aSTMessageArray = aSTSoapOperation.getFaults();
        int n6 = 0;
        while (n6 < aSTMessageArray.length) {
            if (aSTMessageArray[n6] != null && (aSTPartArray = aSTMessageArray[n6].getParts()) != null) {
                n5 = 0;
                while (n5 < aSTPartArray.length) {
                    if (aSTPartArray[n5] != null && aSTPartArray[n5].isAppEx()) {
                        bl2 = true;
                    }
                    ++n5;
                }
            }
            ++n6;
        }
        aSTPartArray = aSTSoapOperation.getMangledName();
        formatter.println();
        if (aSTPartArray.equals(aSTSoapOperation.getName())) {
            formatter.println("// " + (String)aSTPartArray);
        } else {
            formatter.println("// " + aSTSoapOperation.getName() + " ( " + (String)aSTPartArray + " )");
        }
        formatter.println("case " + n + ": {");
        formatter.startBlock();
        if (bl2) {
            formatter.println("try {");
            formatter.startBlock();
        }
        formatter.println("in.setEncodingStyleURI(\"" + aSTSoapOperation.getInputEncodingStyle() + "\");");
        n5 = 0;
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasParts()) {
            object = aSTSoapBodyMessage.getParts();
            n4 = 0;
            while (n4 < ((Object)object).length) {
                Util.generateParmRead("in", (ASTSoapPart)object[n4], "_arg" + n5++, bl, false, formatter);
                ++n4;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            object = aSTSoapBodyMessage2.getParts();
            n4 = 0;
            while (n4 < ((Object)object).length) {
                if (((ASTPart)object[n4]).getMode() != 3) {
                    Util.generateParmRead("in", (ASTSoapPart)object[n4], "_arg" + n5++, bl, false, formatter);
                }
                ++n4;
            }
        }
        if ((object = (ASTSoapBodyMessage)aSTSoapOperation.getOutput()) != null && !((ASTMessage)object).isVoid()) {
            formatter.print(aSTSoapOperation.getReturnType() + " result = ");
        }
        formatter.print((this._inheritance ? "" : "_target.") + aSTSoapOperation.getMethodName() + "(");
        n5 = 0;
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasParts()) {
            ASTPart[] aSTPartArray2 = aSTSoapBodyMessage.getParts();
            n3 = 0;
            while (n3 < aSTPartArray2.length) {
                if (n5 != 0) {
                    formatter.print(", ");
                }
                formatter.print("_arg" + n5++);
                ++n3;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray3 = aSTSoapBodyMessage2.getParts();
            n3 = 0;
            while (n3 < aSTPartArray3.length) {
                if (aSTPartArray3[n3].getMode() != 3) {
                    if (n5 != 0) {
                        formatter.print(", ");
                    }
                    formatter.print("_arg" + n5++);
                }
                ++n3;
            }
        }
        formatter.println(");");
        formatter.println("//create reply");
        if (aSTSoapOperation.hasMimeOutput()) {
            formatter.println("out = in.createReply(_rootHeaders);");
            formatter.println("//set the content type");
            formatter.println("out._getProperties().put(\"http.content.type\", \"Multipart/Related; boundary=\\\"MIME_boundary\\\"; type=\\\"text/xml\\\"; start=\\\"<soapbody>\\\"; charset=utf-8\");");
        } else {
            formatter.println("out = in.createReply();");
        }
        formatter.println("in.setEncodingStyleURI(\"" + aSTSoapOperation.getOutputEncodingStyle() + "\");");
        formatter.println("java.lang.Object arg = null;");
        n5 = 0;
        int n7 = 0;
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasParts()) {
            ASTPart[] aSTPartArray4 = aSTSoapBodyMessage.getParts();
            n2 = 0;
            while (n2 < aSTPartArray4.length) {
                if (aSTPartArray4[n2].getMode() == 3) {
                    Util.generateParmWrite((ASTSoapPart)aSTPartArray4[n2], "_arg" + n5++, bl, false, formatter);
                } else {
                    ++n5;
                    ++n7;
                }
                ++n2;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            ASTPart[] aSTPartArray5 = aSTSoapBodyMessage2.getParts();
            n2 = 0;
            while (n2 < aSTPartArray5.length) {
                if (aSTPartArray5[n2].getMode() != 3) {
                    Util.generateParmWrite((ASTSoapPart)aSTPartArray5[n2], "_arg" + n5++, bl, false, formatter);
                }
                ++n2;
            }
        }
        Util.generateSkelReturn((ASTSoapBodyMessage)object, bl, formatter);
        if (bl2) {
            formatter.endBlock();
            HashSet hashSet = new HashSet();
            n2 = 0;
            while (n2 < aSTMessageArray.length) {
                if (aSTMessageArray[n2] != null) {
                    ASTSoapFaultMessage aSTSoapFaultMessage = (ASTSoapFaultMessage)aSTMessageArray[n2];
                    String string = aSTSoapFaultMessage.getClassName();
                    String string2 = null;
                    String string3 = null;
                    formatter.println("} catch (" + string + " ex) {");
                    formatter.startBlock();
                    formatter.println("out = in.createExceptionReply();");
                    ASTPart[] aSTPartArray6 = aSTSoapFaultMessage.getParts();
                    String string4 = aSTPartArray6[0].getName();
                    if (aSTSoapOperation.isDocument()) {
                        QName qName = aSTPartArray6[0].getQName();
                        string3 = qName.getNamespaceURI();
                        string2 = qName.getLocalPart();
                    } else {
                        string3 = aSTSoapFaultMessage.getNamespace();
                        string2 = aSTPartArray6[0].getName();
                    }
                    formatter.println("Object " + string4 + " = null;");
                    if (!aSTSoapFaultMessage.getComplexTypeFault() && !aSTSoapFaultMessage.getName().equals("RemoteException")) {
                        formatter.print(string4 + " = ");
                        if (aSTPartArray6[0].isPrimitive()) {
                            formatter.print("new " + PrimitiveUtil.primitiveWrappers.get(aSTPartArray6[0].getDataType()) + "(");
                        }
                        formatter.print("ex.get" + Character.toUpperCase(string4.charAt(0)) + string4.substring(1) + "()");
                        if (aSTPartArray6[0].isPrimitive()) {
                            formatter.print(")");
                        }
                        formatter.println(";");
                    }
                    if (string3 == null) {
                        formatter.println("out.writeException(ex, " + string4 + ", \"" + string2 + "\");");
                    } else {
                        formatter.println("out.writeException(ex, " + string4 + ", \"" + string3 + "\", " + "\"" + string2 + "\");");
                    }
                    formatter.endBlock();
                }
                ++n2;
            }
            formatter.println("}");
        }
        formatter.println("break;");
        formatter.endBlock();
        formatter.println("}");
    }

    void generateDeclaration(Formatter formatter) {
        if (this._astdoc.hasTypeMappings()) {
            formatter.println();
            formatter.println("static final java.util.Properties _tmprops = new java.util.Properties();");
        }
    }

    void generateStaticSection(Formatter formatter) {
        if (this._astdoc.hasTypeMappings()) {
            formatter.println("static {");
            formatter.startBlock();
            this.generateTypeMappings(formatter);
            formatter.endBlock();
            formatter.println("}");
        }
    }

    void generateRootHeaders(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null) {
            int n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null && ((ASTSoapOperation)aSTOperationArray[n]).hasMimeOutput()) {
                    Util.writeRootMIMEHeaders(formatter);
                    return;
                }
                ++n;
            }
        }
    }

    void generateTypeMappings(Formatter formatter) {
        Properties properties = this._astdoc.getTypeMappings();
        if (properties != null && ((Hashtable)properties).size() > 0) {
            Iterator iterator = ((Hashtable)properties).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                formatter.println("_tmprops.put(\"" + entry.getKey() + "\", \"" + entry.getValue() + "\");");
            }
        }
    }

    protected void generateStandardImports(Formatter formatter) {
        formatter.println("import javax.servlet.ServletException;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.ServiceException;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;");
        formatter.println("import com.sssw.jbroker.web.encoding.TypeMappingRegistry;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.portable.ServerResponse;");
        formatter.println("import com.sssw.jbroker.web.portable.ServerRequest;");
        formatter.println();
    }
}

