/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.CodeGenerator;
import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.Constants;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapFaultMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPart;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.web.Binding;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;

public class StubGenerator
implements CodeGenerator,
Constants {
    protected ASTDocument _astdoc;
    protected String _stubName;
    protected String _fileName;
    protected Hashtable _bindings;
    protected Hashtable _ports;
    protected boolean _copyOnLocal;
    protected String[] _directs;
    static Hashtable encodingURIMapping = new Hashtable();
    private static final boolean _debug = false;
    private static final String SOAP11_ENV_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP12_ENV_URI = "http://www.w3.org/2002/06/soap-envelope";

    public void setASTDoc(ASTDocument aSTDocument) {
        this._astdoc = aSTDocument;
        this._bindings = new Hashtable();
        this._ports = new Hashtable();
    }

    public boolean generate(Hashtable hashtable, Vector vector) {
        Object object;
        this._copyOnLocal = hashtable.get("localnocopy") == null;
        boolean bl = true;
        ASTService[] aSTServiceArray = this._astdoc.getServices();
        if (aSTServiceArray != null) {
            int n = 0;
            while (n < aSTServiceArray.length) {
                object = aSTServiceArray[n].getPorts();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < ((ASTPort[])object).length) {
                        ASTBinding aSTBinding = object[n2].getBinding();
                        if (aSTBinding != null && aSTBinding instanceof ASTSoapBinding) {
                            String string = aSTBinding.getName();
                            if (!this._bindings.containsKey(string)) {
                                this._bindings.put(string, aSTBinding);
                            }
                            String string2 = null;
                            if (object[n2] instanceof ASTHttpPort) {
                                string2 = ((ASTHttpPort)object[n2]).getLocation();
                            } else if (object[n2] instanceof ASTSoapPort) {
                                string2 = ((ASTSoapPort)object[n2]).getLocation();
                            }
                            if (string2 != null) {
                                Binding binding = new Binding("soap", string2);
                                Vector<Binding> vector2 = (Vector<Binding>)this._ports.get(string);
                                if (vector2 == null) {
                                    vector2 = new Vector<Binding>();
                                    this._ports.put(string, vector2);
                                }
                                vector2.add(binding);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this._bindings.size() == 0) {
            return bl;
        }
        try {
            Iterator iterator = this._bindings.values().iterator();
            while (iterator.hasNext()) {
                object = (ASTSoapBinding)iterator.next();
                this._stubName = hashtable.get("oldstyle") != null ? ((ASTBinding)object).getPackage() + "_" + ((ASTBinding)object).getPortTypeClassName() + "_ServiceStub" : ((ASTBinding)object).getPackage() + ((ASTBinding)object).getFileName() + "_Stub";
                this.createStub(hashtable, vector, (ASTSoapBinding)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    void createStub(Hashtable hashtable, Vector vector, ASTSoapBinding aSTSoapBinding) throws Exception {
        this._fileName = Util.fileName(this._stubName);
        File file = (File)hashtable.get("destDir");
        File file2 = Util.getFile(file, this._stubName);
        if (vector.contains(file2)) {
            return;
        }
        if (hashtable.get("verbose") != null) {
            System.out.println("creating: " + file2.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Formatter formatter = new Formatter("    ", fileOutputStream);
        Util.generateHeader(formatter, this._stubName);
        HashSet hashSet = this._astdoc.getPkgsWithHolders();
        Util.generateImports(formatter, aSTSoapBinding, hashSet);
        this.generateStandardImports(formatter);
        formatter.println("public class " + this._fileName);
        formatter.startBlock();
        formatter.println("extends com.sssw.jbroker.web.portable.Stub");
        formatter.println("implements " + aSTSoapBinding.getPortTypeClassName());
        formatter.endBlock();
        formatter.println("{");
        this.generateBody(aSTSoapBinding, hashtable, formatter);
        formatter.println("}");
        formatter.flush();
        fileOutputStream.close();
        vector.addElement(file2);
    }

    void generateBody(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
        formatter.startBlock();
        this.generateConstructor(aSTSoapBinding, hashtable, formatter);
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null) {
            int n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null) {
                    this.generateMethod((ASTSoapOperation)aSTOperationArray[n], formatter);
                    if (n != aSTOperationArray.length - 1) {
                        formatter.println();
                    }
                }
                ++n;
            }
        }
        this.generateDeclaration(formatter);
        this.generateStaticSection(formatter);
        this.generateRootHeaders(aSTSoapBinding, formatter);
        formatter.endBlock();
    }

    void generateConstructor(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
        Object object;
        Util.generatePortType(aSTSoapBinding, formatter, "com.sssw.jbroker.web.QName");
        formatter.println("private static final Binding[] _bindings = new Binding[] {");
        formatter.startBlock();
        Vector vector = (Vector)this._ports.get(aSTSoapBinding.getName());
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                Binding binding = (Binding)object.nextElement();
                formatter.println("new Binding(\"" + binding.getProtocol() + "\",");
                formatter.println("    \"" + binding.getURLStr() + "\"),");
            }
        }
        formatter.endBlock();
        formatter.println("};");
        formatter.println();
        formatter.println("public " + this._fileName + "()");
        formatter.startBlock("{");
        formatter.println("this(null);");
        formatter.endBlock("}");
        formatter.println();
        formatter.println("public " + this._fileName + "(DefaultTypeMappingRegistry tmr)");
        formatter.startBlock("{");
        formatter.println("super(_portType, _bindings);");
        object = hashtable.get("xsd") != null ? ((String[])hashtable.get("xsd"))[0] : "http://www.w3.org/2001/XMLSchema";
        formatter.println("_setProperty(\"xmlrpc.schema.uri\",");
        formatter.println("   (Object) \"" + (String)object + "\".intern());");
        formatter.println("_setProperty(\"version\", (Object) \"1.1\");");
        formatter.println("TypeMappingRegistry _tm = null;");
        formatter.println("try {");
        formatter.startBlock();
        formatter.println("if (tmr != null)");
        formatter.println("    _tm = tmr;");
        formatter.println("else {");
        formatter.println("    _tm = new DefaultTypeMappingRegistry();");
        if (this._astdoc.hasTypeMappings()) {
            formatter.println("    if (_tmprops.size() > 0) _tm.importTypeMappings(_tmprops);");
        }
        formatter.println("}");
        formatter.println("_setTypeMappingRegistry(_tm);");
        formatter.endBlock();
        formatter.println("} catch (java.lang.Exception ex) {");
        formatter.startBlock();
        formatter.println("throw new JAXRPCException(\"failed to initialize type mapping \" + ");
        formatter.println("    \"registry: \" + ex.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock("}");
        formatter.println();
    }

    void generateMethod(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        Object[] objectArray;
        formatter.print("public " + aSTSoapOperation.getReturnType() + " " + aSTSoapOperation.getMethodName() + "(");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        int n2 = 0;
        if (aSTSoapBodyMessage != null) {
            objectArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < objectArray.length) {
                if (n2++ > 0) {
                    formatter.write(", ");
                }
                formatter.write(((ASTPart)objectArray[n]).getDataType());
                formatter.write(" _arg" + (n2 - 1));
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            objectArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < objectArray.length) {
                if (((ASTPart)objectArray[n]).getMode() != 3) {
                    if (n2++ > 0) {
                        formatter.write(", ");
                    }
                    formatter.write(((ASTPart)objectArray[n]).getDataType());
                    formatter.write(" _arg" + (n2 - 1));
                }
                ++n;
            }
        }
        formatter.println(") ");
        objectArray = aSTSoapOperation.getFaults();
        formatter.startBlock();
        formatter.print("throws ");
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    if (((ASTMessage)objectArray[n]).getName().endsWith("RemoteException")) {
                        formatter.print("java.rmi.RemoteException");
                    } else {
                        formatter.print(((ASTMessage)objectArray[n]).getClassName());
                    }
                    if (n != objectArray.length - 1) {
                        formatter.print(", ");
                    }
                }
                ++n;
            }
        }
        formatter.println();
        formatter.endBlock();
        formatter.println("{");
        formatter.startBlock();
        this.generateMethodBody(aSTSoapOperation, formatter);
        formatter.endBlock();
        formatter.println("}");
    }

    protected void generateMethodBody(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        ASTPart[] aSTPartArray;
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        boolean bl = aSTSoapOperation.isDocument();
        formatter.println("ClientResponse in = null;");
        formatter.println();
        formatter.println("try {");
        formatter.startBlock();
        formatter.println("// create an output stream");
        String string = aSTSoapOperation.getMangledName();
        formatter.println("_getDelegate().setProperty(\"xmlrpc.soap.operation.name\",");
        formatter.println("    new QName(\"" + aSTSoapOperation.getNsURI() + "\", ");
        formatter.println("        \"" + string + "\"));");
        if (aSTSoapOperation.hasMimeInput()) {
            formatter.println("_getDelegate().setProperty(\"xmlrpc.soap.mime.headers\", _rootHeaders);");
        }
        formatter.println();
        formatter.println("//create request");
        formatter.println("ClientRequest out = ");
        formatter.startBlock();
        String string2 = null;
        String string3 = aSTSoapOperation.getInputEncodingStyle();
        string2 = bl ? "true" : "false";
        String string4 = aSTSoapOperation.getSOAPURI();
        String string5 = aSTSoapOperation.getAction();
        if (string5 != null && !string5.startsWith("\"") && !string5.endsWith("\"")) {
            string5 = "\"\\\"" + string5 + "\\\"\"";
        }
        formatter.println("_request(\"" + string + "\", true, \"" + string3 + "\", " + string2 + ", " + string5 + ", \"" + string4 + "\");");
        formatter.endBlock();
        if (string5 != null) {
            formatter.println("_getDelegate().setProperty(\"soapAction\", (Object) " + string5 + ");");
        }
        String string6 = null;
        boolean bl2 = StubGenerator.isSOAP12(string4);
        formatter.print("java.lang.String contentType = \"");
        string6 = aSTSoapOperation.hasMimeInput() ? (bl2 ? "Multipart/Related; boundary=\\\"MIME_boundary\\\"; type=\\\"application/soap+xml\\\"; start=\\\"<soapbody>\\\"; charset=utf-8" : "Multipart/Related; boundary=\\\"MIME_boundary\\\"; type=\\\"text/xml\\\"; start=\\\"<soapbody>\\\"; charset=utf-8") : (bl2 ? "application/soap+xml; charset=" : "text/xml; charset=");
        formatter.print(string6);
        formatter.println("\";");
        if (!aSTSoapOperation.hasMimeInput()) {
            formatter.println("java.lang.String charset = (java.lang.String) _getDelegate().getProperty(\"jbroker.web.charset\");");
            formatter.println("if (charset == null) charset = \"utf-8\";");
            formatter.println("contentType += charset;");
        }
        formatter.println("_getDelegate().setProperty(com.sssw.jbroker.web.core.Constants.HTTP_CONTENT_TYPE, (Object) contentType);");
        formatter.println("out._setProperties(_getDelegate().getProperties());");
        formatter.println("Object arg = null;");
        int n2 = 0;
        boolean bl3 = false;
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasParts()) {
            formatter.println();
            formatter.println("// marshal the parameters");
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                Util.generateParmWrite((ASTSoapPart)aSTPartArray[n], "_arg" + n2++, bl, true, formatter);
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            if (aSTSoapBodyMessage == null || !aSTSoapBodyMessage.hasParts()) {
                formatter.println();
                formatter.println("// marshal the parameters");
            }
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() != 3) {
                    Util.generateParmWrite((ASTSoapPart)aSTPartArray[n], "_arg" + n2++, bl, true, formatter);
                }
                ++n;
            }
        }
        formatter.println();
        formatter.println("// do the invocation");
        formatter.println("in = _invoke(out);");
        n2 = 0;
        formatter.println();
        formatter.println("// unmarshal the results");
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasParts()) {
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() == 3) {
                    Util.generateParmRead("in", (ASTSoapPart)aSTPartArray[n], "_arg" + n2++, bl, true, formatter);
                } else {
                    ++n2;
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() != 3) {
                    Util.generateParmRead("in", (ASTSoapPart)aSTPartArray[n], "_arg" + n2++, bl, true, formatter);
                }
                ++n;
            }
        }
        formatter.println();
        formatter.println("// return");
        Util.generateReturn((ASTSoapBodyMessage)aSTSoapOperation.getOutput(), formatter, bl);
        formatter.println();
        formatter.endBlock();
        this.writeApplicationExceptionHandler(aSTSoapOperation, formatter);
        formatter.println("} catch (java.lang.Throwable t) {");
        formatter.startBlock();
        this.generateAppExceptions(aSTSoapOperation.getFaults(), formatter);
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeApplicationExceptionHandler(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        ASTMessage[] aSTMessageArray = aSTSoapOperation.getFaults();
        formatter.println("} catch (ApplicationException ae) {");
        formatter.startBlock();
        formatter.println("try {");
        formatter.startBlock();
        if (aSTMessageArray.length == 1) {
            this.writeReadDetail(formatter);
            formatter.endBlock();
            this.writeCatchIOException(formatter);
            formatter.endBlock();
            return;
        }
        formatter.println("QName excQName = ae.getQName();");
        formatter.println("InputStream is = ae.getInputStream();");
        int n = 0;
        while (n < aSTMessageArray.length) {
            ASTPart[] aSTPartArray;
            ASTSoapFaultMessage aSTSoapFaultMessage = (ASTSoapFaultMessage)aSTMessageArray[n];
            if (!(aSTSoapFaultMessage.getName().equals("RemoteException") || (aSTPartArray = aSTSoapFaultMessage.getParts()) == null || aSTPartArray.length == 0 || aSTPartArray.length > 0 && aSTPartArray[0].isRemote())) {
                String string;
                Object object;
                if (aSTSoapOperation.isDocument()) {
                    object = aSTPartArray[0].getQName();
                    formatter.println("if (excQName.getNamespaceURI().equals(");
                    formatter.println("    \"" + ((QName)object).getNamespaceURI() + "\") &&  ");
                    formatter.println("    excQName.getLocalPart().equals(\"" + ((QName)object).getLocalPart() + "\")) {");
                } else if (aSTSoapFaultMessage.getNamespace() != null) {
                    formatter.println("if (excQName.getNamespaceURI().equals(");
                    formatter.println("    \"" + aSTSoapFaultMessage.getNamespace() + "\") &&  ");
                    formatter.println("    excQName.getLocalPart().equals(\"" + aSTPartArray[0].getName() + "\")) {");
                } else {
                    formatter.println("if (excQName.getLocalPart().equals(\"" + aSTPartArray[0].getName() + "\")) {");
                }
                formatter.startBlock();
                object = "ex" + n;
                formatter.println(aSTSoapFaultMessage.getClassName() + " " + (String)object + " = null;");
                formatter.println("try {");
                formatter.startBlock();
                Util.generateFaultParmRead("is", aSTPartArray[0], aSTSoapOperation.isDocument(), formatter);
                String string2 = aSTPartArray[0].getDataType();
                int n2 = string2.lastIndexOf(".");
                String string3 = string = n2 == -1 ? string2 : string2.substring(n2 + 1);
                if (aSTSoapFaultMessage.getComplexTypeFault()) {
                    formatter.println((String)object + " = " + aSTPartArray[0].getName() + ";");
                } else {
                    formatter.print((String)object + " = new " + aSTSoapFaultMessage.getClassName() + "(");
                    if (aSTPartArray[0].isPrimitive()) {
                        formatter.print(aSTPartArray[0].getName() + "Wrapper." + aSTPartArray[0].getDataType() + "Value()");
                    } else {
                        formatter.print(aSTPartArray[0].getName());
                    }
                    formatter.println(");");
                }
                formatter.endBlock();
                formatter.println("} catch (java.io.EOFException eofExc) {");
                formatter.startBlock();
                formatter.print("throw new ServiceException(");
                formatter.println("\"unable to read \" + ");
                formatter.println("    \"exception information from stream\");");
                formatter.endBlock();
                formatter.println("}");
                formatter.println("throw " + (String)object + ";");
                formatter.endBlock();
                formatter.print("} else ");
            }
            ++n;
        }
        formatter.println("{");
        formatter.startBlock();
        this.writeReadDetail(formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        this.writeCatchIOException(formatter);
        formatter.endBlock();
    }

    private void writeReadDetail(Formatter formatter) {
        formatter.println("ae.getDetail();");
        formatter.print("throw new java.rmi.RemoteException(");
        formatter.println("\"unknown exception \" + ");
        formatter.println("    \"at server \" + ae.getFaultString() , ae);");
    }

    private void writeCatchIOException(Formatter formatter) {
        formatter.println("} catch (java.io.IOException ioe) {");
        formatter.startBlock();
        formatter.println("throw ServiceException.mapToRemote(ioe);");
        formatter.endBlock();
        formatter.println("}");
    }

    void generateAppExceptions(ASTMessage[] aSTMessageArray, Formatter formatter) {
        boolean bl = false;
        int n = 0;
        while (n < aSTMessageArray.length) {
            ASTPart[] aSTPartArray;
            if (aSTMessageArray[n] != null && (aSTPartArray = aSTMessageArray[n].getParts()) != null) {
                int n2 = 0;
                while (n2 < aSTPartArray.length) {
                    if (aSTPartArray[n2] != null && aSTPartArray[n2].isAppEx()) {
                        bl = true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (bl) {
            formatter.println("if (t instanceof ServiceException) {");
            formatter.startBlock();
            formatter.println("ServiceException sex = (ServiceException) t;");
            formatter.println("if (sex.getTargetException() != null)");
            formatter.startBlock();
            formatter.println("t = sex.getTargetException();");
            formatter.endBlock();
            formatter.endBlock("}");
            formatter.println();
        }
        formatter.println("// map to remote exception");
        formatter.println("throw ServiceException.mapToRemote(t);");
    }

    void generateDeclaration(Formatter formatter) {
        if (this._astdoc.hasTypeMappings()) {
            formatter.println();
            formatter.println("static final java.util.Properties _tmprops = new java.util.Properties();");
        }
    }

    void generateStaticSection(Formatter formatter) {
        if (this._astdoc.hasTypeMappings()) {
            formatter.println("static {");
            formatter.startBlock();
            this.generateTypeMappings(formatter);
            formatter.endBlock();
            formatter.println("}");
        }
    }

    void generateRootHeaders(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray != null) {
            int n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null && ((ASTSoapOperation)aSTOperationArray[n]).hasMimeInput()) {
                    Util.writeRootMIMEHeaders(formatter);
                    return;
                }
                ++n;
            }
        }
    }

    void generateTypeMappings(Formatter formatter) {
        Properties properties = this._astdoc.getTypeMappings();
        if (properties != null && ((Hashtable)properties).size() > 0) {
            Iterator iterator = ((Hashtable)properties).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                formatter.println("_tmprops.put(\"" + entry.getKey() + "\", \"" + entry.getValue() + "\");");
            }
        }
    }

    protected void generateStandardImports(Formatter formatter) {
        formatter.println("import javax.xml.rpc.JAXRPCException;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.Binding;");
        formatter.println("import com.sssw.jbroker.web.QName;");
        formatter.println("import com.sssw.jbroker.web.ServiceException;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;");
        formatter.println("import com.sssw.jbroker.web.encoding.TypeMappingRegistry;");
        formatter.println();
        formatter.println("import com.sssw.jbroker.web.portable.ApplicationException;");
        formatter.println("import com.sssw.jbroker.web.portable.ClientResponse;");
        formatter.println("import com.sssw.jbroker.web.portable.ClientRequest;");
        formatter.println("import com.sssw.jbroker.web.portable.InputStream;");
        formatter.println();
    }

    private static boolean isSOAP12(String string) {
        return SOAP12_ENV_URI.equalsIgnoreCase(string);
    }

    static {
        encodingURIMapping.put("http://schemas.xmlsoap.org/soap/encoding/", "soap");
    }
}

