/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2soap.generic;

import com.sssw.jbroker.tools.rmi2soap.Util;
import com.sssw.jbroker.tools.rmi2soap.generic.SkelGenerator;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.util.Formatter;
import java.util.Hashtable;

public class TieGenerator
extends SkelGenerator {
    public void setASTDoc(ASTDocument aSTDocument) {
        super.setASTDoc(aSTDocument);
        this._inheritance = false;
    }

    protected void generateNames(ASTSoapBinding aSTSoapBinding) {
        super.generateNames(aSTSoapBinding);
        this._extends = this._skelName;
        this._skelName = this._skelName.substring(0, this._skelName.lastIndexOf("Skeleton")) + "TieSkeleton";
        this._fileName = Util.fileName(this._skelName);
        this._implements = this.getImplementedInterfaces();
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{"com.sssw.jbroker.web.portable.TieSkeleton"};
    }

    protected void generateAdditionalMethods(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        this.generateSetTargetMethod(aSTSoapBinding, formatter);
        this.generateGetTargetMethod(formatter);
        this.generateDelegationMethods(aSTSoapBinding, formatter);
    }

    protected void generateSetTargetMethod(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        formatter.println("private " + aSTSoapBinding.getPortTypeClassName() + " _target;");
        formatter.println();
        formatter.println("public void setTarget(java.rmi.Remote target)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("_target = (" + aSTSoapBinding.getPortTypeClassName() + ") target;");
        formatter.endBlock();
        formatter.println("}");
    }

    protected void generateGetTargetMethod(Formatter formatter) {
        formatter.println();
        formatter.println("public java.rmi.Remote getTarget()");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("return _target;");
        formatter.endBlock();
        formatter.println("}");
    }

    protected void generateDelegationMethods(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
        ASTOperation[] aSTOperationArray = aSTSoapBinding.getOperations();
        if (aSTOperationArray == null) {
            return;
        }
        int n = 0;
        while (n < aSTOperationArray.length) {
            if (aSTOperationArray[n] != null) {
                formatter.println();
                this.generateDelegationMethod((ASTSoapOperation)aSTOperationArray[n], formatter);
            }
            ++n;
        }
    }

    private void generateDelegationMethod(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        Object[] objectArray;
        formatter.print("public " + aSTSoapOperation.getReturnType() + " " + aSTSoapOperation.getMethodName() + "(");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        int n2 = 0;
        if (aSTSoapBodyMessage != null) {
            objectArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < objectArray.length) {
                if (n2++ > 0) {
                    formatter.write(", ");
                }
                formatter.write(((ASTPart)objectArray[n]).getDataType());
                formatter.write(" _arg" + (n2 - 1));
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            objectArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < objectArray.length) {
                if (((ASTPart)objectArray[n]).getMode() != 3) {
                    if (n2++ > 0) {
                        formatter.write(", ");
                    }
                    formatter.write(((ASTPart)objectArray[n]).getDataType());
                    formatter.write(" _arg" + (n2 - 1));
                }
                ++n;
            }
        }
        formatter.println(") ");
        formatter.startBlock();
        objectArray = aSTSoapOperation.getFaults();
        if (objectArray != null && objectArray.length > 0) {
            formatter.print("throws ");
            n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    formatter.print(((ASTMessage)objectArray[n]).getClassName());
                    if (n != objectArray.length - 1) {
                        formatter.print(", ");
                    }
                }
                ++n;
            }
            formatter.println();
        }
        formatter.endBlock();
        formatter.println("{");
        formatter.startBlock();
        this.generateDelegationMethodBody(aSTSoapOperation, formatter);
        formatter.endBlock();
        formatter.println("}");
    }

    void generateDelegationMethodBody(ASTSoapOperation aSTSoapOperation, Formatter formatter) {
        int n;
        ASTPart[] aSTPartArray;
        if (!aSTSoapOperation.isVoid()) {
            formatter.print("return ");
        }
        formatter.print("_target." + aSTSoapOperation.getMethodName() + "(");
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        int n2 = 0;
        if (aSTSoapBodyMessage != null) {
            aSTPartArray = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (n2++ > 0) {
                    formatter.write(", ");
                }
                formatter.write("_arg" + (n2 - 1));
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            aSTPartArray = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < aSTPartArray.length) {
                if (aSTPartArray[n].getMode() != 3) {
                    if (n2++ > 0) {
                        formatter.write(", ");
                    }
                    formatter.write("_arg" + (n2 - 1));
                }
                ++n;
            }
        }
        formatter.println(");");
    }

    protected void generateInvokeMethod(ASTSoapBinding aSTSoapBinding, Formatter formatter) {
    }

    protected void generateConstructor(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
    }

    protected void generateInit(ASTSoapBinding aSTSoapBinding, Hashtable hashtable, Formatter formatter) {
    }

    protected void generateDeclaration(Formatter formatter) {
    }

    protected void generateStaticSection(Formatter formatter) {
    }

    protected void generateStandardImports(Formatter formatter) {
    }
}

