/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2wsdl;

import com.sssw.jbroker.tools.rmi2wsdl.Main;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPortType;
import com.sssw.jbroker.util.CodeGenUtil;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.Deserializer;
import com.sssw.jbroker.web.encoding.PublicFieldsMarshaler;
import com.sssw.jbroker.web.encoding.Serializer;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.encoding.XMLType;
import com.sssw.jbroker.web.mapping.BeanMarshaler;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeGenerator {
    private int _nsCount;
    private int _faultCount;
    private String _portName;
    private Hashtable _params;
    private Element _typeTag;
    private Element _defs;
    private Document _document;
    private String _xmlns;
    private String _xsd;
    private boolean _isLiteral;
    private boolean _isDocument;
    private boolean _noTypes;
    private String _serviceName;
    private HashSet _faultSet = new HashSet();
    private final HashMap _pack2ns = new HashMap();
    private final HashMap _namespaces = new HashMap();
    private final HashMap _revNamespaces = new HashMap();
    private final HashMap _importedTypes = new HashMap();
    private final HashSet _genMessages = new HashSet();
    private static final Class _remoteExc = class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = CodeGenerator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException;
    private DefaultTypeMappingRegistry _mapper = null;
    private static boolean _verbose;
    private static boolean _nowarn;
    private static boolean _embed;
    private static boolean _debug;
    private HashSet _generatedSchema = new HashSet();
    private HashSet _generatedTypes = new HashSet();
    HashMap _types = new HashMap();
    static PrimitiveTypeMapper _primitive;
    private static Class _stackTraceElementClass;
    private static Class[] _nonPrimitiveMappings;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$SetMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ListMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapEntryMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ClassMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$QNameMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$BindingMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$ElementMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping;

    public void setTypeMapper(TypeMappingRegistry typeMappingRegistry) {
        if (typeMappingRegistry == null) {
            this._mapper = new DefaultTypeMappingRegistry();
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                this._mapper.importTypeMappings("xmlrpc.type.mappings", classLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = 0;
            while (n < _nonPrimitiveMappings.length) {
                try {
                    TypeMappingBase typeMappingBase = (TypeMappingBase)_nonPrimitiveMappings[n].newInstance();
                    TypeMap[] typeMapArray = typeMappingBase.getTypeMappings();
                    int n2 = 0;
                    while (n2 < typeMapArray.length) {
                        this._mapper.put(typeMapArray[n2]);
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.loading.mappings.fail", throwable.toString()));
                }
                ++n;
            }
        } else {
            this._mapper = (DefaultTypeMappingRegistry)typeMappingRegistry;
        }
    }

    public void compile(Class clazz, Hashtable hashtable) {
        try {
            this.createDocument(clazz, hashtable);
            String string = ((File)hashtable.get("destDir")).toString();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            File file = new File(string + this._portName + ".wsdl");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputFormat outputFormat = new OutputFormat(this._document);
            outputFormat.setIndent(1);
            outputFormat.setLineWidth(60);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(this._document.getDocumentElement());
            CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.writing", file.toString()));
        }
        catch (Exception exception) {
            if (_debug) {
                exception.printStackTrace();
            }
            CodeGenerator.error(exception.getMessage() == null ? exception.toString() : exception.getMessage());
        }
    }

    public Document createDocument(Class clazz, Hashtable hashtable) throws Exception {
        Object object;
        Object object2;
        String[] stringArray;
        Object v;
        String[] stringArray2;
        _verbose = hashtable.get("verbose") != null;
        _nowarn = hashtable.get("nowarn") != null;
        _embed = hashtable.get("noinline") == null;
        this._noTypes = hashtable.get("notypes") != null;
        this._params = hashtable;
        this._isLiteral = hashtable.get("literal") != null;
        boolean bl = this._isDocument = hashtable.get("document") != null;
        if (this._isDocument) {
            if (!this._isLiteral) {
                CodeGenerator.error(Main._messages.get("rmi2wsdl.error.document.encoded"));
            }
        } else if (this._isLiteral) {
            CodeGenerator.error(Main._messages.get("rmi2wsdl.error.rpc.literal"));
        }
        if (this._mapper == null) {
            this.setTypeMapper(null);
        }
        if ((stringArray2 = (String[])hashtable.get("pkgns")) != null) {
            int n = 0;
            while (n < stringArray2.length) {
                this._pack2ns.put(stringArray2[n], stringArray2[n + 1]);
                n += 2;
            }
        }
        if ((v = hashtable.get("xmlns")) != null) {
            if (v instanceof String) {
                this._xmlns = (String)v;
            } else if (v instanceof String[]) {
                this._xmlns = ((String[])v)[0];
            }
        }
        Object v2 = hashtable.get("servicename");
        this._serviceName = null;
        if (v2 != null) {
            if (v2 instanceof String) {
                this._serviceName = (String)v2;
            } else if (v2 instanceof String[]) {
                this._serviceName = ((String[])v2)[0];
            }
        }
        if ((stringArray = (String[])hashtable.get("typemapping")) != null) {
            object2 = this.getClass().getClassLoader();
            int n = 0;
            while (n < stringArray.length) {
                this._mapper.importTypeMappingsFromFile(stringArray[n], (ClassLoader)object2);
                CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.loading.mappings", stringArray[n]));
                ++n;
            }
        }
        this._portName = clazz.getName();
        if (this._portName.indexOf(".") != -1) {
            int n = this._portName.lastIndexOf(".");
            this._portName = this._portName.substring(n + 1, this._portName.length());
        }
        object2 = new ASTDocument();
        String string = this.packageNS(clazz.getName());
        if (string != null && string.length() == 0) {
            string = null;
        }
        ((ASTDocument)object2).generateASTFromClass(clazz, false, this._xmlns);
        String[] stringArray3 = ((ASTDocument)object2).findInvalidRMI();
        if (stringArray3 != null) {
            CodeGenerator.error(Main._messages.get("rmi2wsdl.error.invalid.rmi", stringArray3[0], stringArray3[1]));
        }
        DocumentBuilder documentBuilder = CodeGenerator.getParser();
        this._document = documentBuilder.newDocument();
        this._xsd = Constants.XSD_URI;
        v = hashtable.get("xsd");
        if (v != null) {
            if (v instanceof String) {
                this._xsd = (String)v;
            } else if (v instanceof String[]) {
                this._xsd = ((String[])v)[0];
            }
        }
        this._namespaces.put(this._xsd, "xsd");
        this._revNamespaces.put("xsd", this._xsd);
        this.generateWSDL((ASTDocument)object2);
        this._defs = this._document.getDocumentElement();
        if (hashtable.get("soap") != null) {
            object = (String[])hashtable.get("soap");
            this.generateSoapBinding((ASTDocument)object2, (String)object[0], clazz);
        }
        object = this._namespaces.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            this._defs.setAttribute("xmlns:" + string3, string2);
        }
        this._defs.setAttribute("xmlns", "http://schemas.xmlsoap.org/wsdl/");
        this._defs.setAttribute("xmlns:wsdl", "http://schemas.xmlsoap.org/wsdl/");
        return this._document;
    }

    private void fixXMLTypes(ASTDocument aSTDocument) {
        if (aSTDocument == null) {
            return;
        }
        ASTPortType[] aSTPortTypeArray = aSTDocument.getPortTypes();
        if (aSTPortTypeArray == null || aSTPortTypeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < aSTPortTypeArray.length) {
            ASTOperation[] aSTOperationArray;
            ASTPortType aSTPortType = aSTPortTypeArray[n];
            if (aSTPortType != null && (aSTOperationArray = aSTPortType.getOperations()) != null && aSTOperationArray.length != 0) {
                int n2 = 0;
                while (n2 < aSTOperationArray.length) {
                    ASTOperation aSTOperation = aSTOperationArray[n2];
                    if (aSTOperation != null) {
                        ASTPart aSTPart;
                        int n3;
                        ASTPart[] aSTPartArray;
                        ASTMessage aSTMessage = aSTOperation.getInput();
                        if (aSTMessage != null) {
                            aSTPartArray = aSTMessage.getParts();
                            if (aSTPartArray == null) break;
                            n3 = 0;
                            while (n3 < aSTPartArray.length) {
                                aSTPart = aSTPartArray[n3];
                                if (aSTPart != null) {
                                    this.mapJavaType(aSTPart);
                                }
                                ++n3;
                            }
                        }
                        if ((aSTMessage = aSTOperation.getOutput()) != null) {
                            aSTPartArray = aSTMessage.getParts();
                            if (aSTPartArray == null) break;
                            n3 = 0;
                            while (n3 < aSTPartArray.length) {
                                aSTPart = aSTPartArray[n3];
                                if (aSTPart != null) {
                                    this.mapJavaType(aSTPart);
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public static String getClassName(Class clazz) {
        return clazz.isArray() ? CodeGenerator.getClassName(clazz.getComponentType()) + "[]" : clazz.getName();
    }

    private final Map getPublicFields(Class clazz) {
        HashMap hashMap = new HashMap();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            hashMap.put(fieldArray[n].getName(), fieldArray[n].getType());
            ++n;
        }
        return hashMap;
    }

    private final Map getPublicFields(Class clazz, boolean bl) {
        if (bl) {
            return this.getPublicFields(clazz);
        }
        HashMap hashMap = new HashMap();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (!Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                hashMap.put(fieldArray[n].getName(), fieldArray[n].getType());
            }
            ++n;
        }
        return hashMap;
    }

    private final Map getBeanProperties(Class clazz, Class clazz2) {
        HashMap hashMap = new HashMap();
        try {
            BeanInfo beanInfo = clazz2 == null ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, clazz2);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (!CodeGenerator.isReadWrite(propertyDescriptorArray[n])) {
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.bean.read.only.prop", propertyDescriptorArray[n].getName(), clazz.getName()));
                } else {
                    hashMap.put(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n].getPropertyType());
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.bean.introspection", clazz));
        }
        return hashMap;
    }

    private final void generateSoapBinding(ASTDocument aSTDocument, String string, Class clazz) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Element element;
        ASTOperation[] aSTOperationArray;
        if (aSTDocument == null || string == null) {
            return;
        }
        ASTPortType[] aSTPortTypeArray = aSTDocument.getPortTypes();
        if (aSTPortTypeArray == null) {
            return;
        }
        int n = 0;
        while (n < aSTPortTypeArray.length) {
            if (aSTPortTypeArray[n] != null && (aSTOperationArray = aSTPortTypeArray[n].getOperations()) != null && aSTOperationArray.length >= 1 && aSTOperationArray[0] != null) {
                element = this._document.createElement("binding");
                this._defs.appendChild(element);
                object3 = aSTPortTypeArray[n].getName();
                int n2 = ((String)object3).lastIndexOf(".");
                if (n2 > 0) {
                    object3 = ((String)object3).substring(n2 + 1);
                }
                CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.generating.something", "soap:binding", object3));
                element.setAttribute("name", (String)object3 + "Binding");
                element.setAttribute("type", "tns:" + (String)object3);
                object2 = this._document.createElement("soap:binding");
                object2.setAttribute("style", this._isDocument ? "document" : "rpc");
                object2.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
                element.appendChild((Node)object2);
                int n3 = 0;
                while (n3 < aSTOperationArray.length) {
                    if (aSTOperationArray[n3] != null) {
                        Element element2;
                        string2 = aSTOperationArray[n3].getName();
                        Element element3 = this._document.createElement("operation");
                        element3.setAttribute("name", string2);
                        element.appendChild(element3);
                        Element element4 = this._document.createElement("soap:operation");
                        element4.setAttribute("soapAction", this.packageNS(aSTPortTypeArray[0].getName()) + "/" + aSTOperationArray[n3].getMangledName());
                        element3.appendChild(element4);
                        if (aSTOperationArray[n3].getInput() != null) {
                            object = this._document.createElement("input");
                            if (aSTOperationArray[n3].getInput().getName().indexOf("__") > 0) {
                                object.setAttribute("name", aSTOperationArray[n3].getInput().getName());
                            }
                            element3.appendChild((Node)object);
                            element2 = this._document.createElement("soap:body");
                            object.appendChild(element2);
                            element2.setAttribute("use", this._isLiteral ? "literal" : "encoded");
                            if (!this._isLiteral) {
                                element2.setAttribute("namespace", this.packageNS(aSTPortTypeArray[0].getName()));
                                element2.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                            }
                        }
                        if (aSTOperationArray[n3].getOutput() != null) {
                            object = this._document.createElement("output");
                            if (aSTOperationArray[n3].getOutput().getName().indexOf("__") > 0) {
                                object.setAttribute("name", aSTOperationArray[n3].getOutput().getName());
                            }
                            element3.appendChild((Node)object);
                            element2 = this._document.createElement("soap:body");
                            object.appendChild(element2);
                            element2.setAttribute("use", this._isLiteral ? "literal" : "encoded");
                            if (!this._isLiteral) {
                                element2.setAttribute("namespace", this.packageNS(aSTPortTypeArray[0].getName()));
                                element2.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                            }
                        }
                        object = aSTOperationArray[n3].getFaults();
                        int n4 = 0;
                        while (n4 < ((ASTMessage[])object).length) {
                            ASTPart[] aSTPartArray;
                            if (object[n4] != null && (aSTPartArray = object[n4].getParts()) != null) {
                                int n5 = 0;
                                while (n5 < aSTPartArray.length) {
                                    if (aSTPartArray[n5] != null && !aSTPartArray[n5].isRemote()) {
                                        String string3;
                                        Element element5 = this._document.createElement("fault");
                                        element3.appendChild(element5);
                                        String string4 = aSTPartArray[n5].getClassName();
                                        int n6 = string4.lastIndexOf(".");
                                        String string5 = string3 = n6 == -1 ? string4 : string4.substring(n6 + 1, string4.length());
                                        if (string3.endsWith("Exception")) {
                                            String string6 = string3.substring(0, string3.length() - 9);
                                            element5.setAttribute("name", string6);
                                        } else {
                                            element5.setAttribute("name", string3);
                                        }
                                        element5.setAttribute("use", this._isLiteral ? "literal" : "encoded");
                                        if (!this._isLiteral) {
                                            element5.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                                        }
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
        aSTOperationArray = this._document.createElement("service");
        this._defs.appendChild((Node)aSTOperationArray);
        if (this._serviceName != null && this._serviceName.length() > 0) {
            aSTOperationArray.setAttribute("name", this._serviceName);
        } else {
            aSTOperationArray.setAttribute("name", this._portName + "Service");
        }
        element = null;
        object3 = null;
        Class[] classArray = CodeGenUtil.getAllRemoteInterfaces(clazz);
        if (classArray.length > 1) {
            object2 = new HashSet<String>();
            ((HashSet)object2).add(this._portName);
            String string7 = "";
            string2 = "";
            int n7 = string.lastIndexOf(47);
            if (n7 != -1 && string.length() - 1 == n7) {
                n7 = string.lastIndexOf(47, n7 - 1);
            }
            string7 = n7 != -1 ? string.substring(0, n7) : (string.endsWith("/") ? string.substring(0, string.length() - 1) : string);
            if (string.endsWith("/")) {
                string2 = "/";
            }
            int n8 = 0;
            while (n8 < classArray.length) {
                object = classArray[n8].getName();
                if (object.indexOf(".") != -1) {
                    n7 = object.lastIndexOf(".");
                    object = object.substring(n7 + 1, object.length());
                }
                if (!((HashSet)object2).contains(object)) {
                    element = this._document.createElement("port");
                    aSTOperationArray.appendChild(element);
                    element.setAttribute("name", (String)object + "Port");
                    element.setAttribute("binding", "tns:" + (String)object + "Binding");
                    object3 = this._document.createElement("soap:address");
                    element.appendChild((Node)object3);
                    object3.setAttribute("location", string7 + "/" + (String)object + string2);
                    ((HashSet)object2).add(object);
                }
                ++n8;
            }
        }
        element = this._document.createElement("port");
        aSTOperationArray.appendChild(element);
        element.setAttribute("name", this._portName + "Port");
        element.setAttribute("binding", "tns:" + this._portName + "Binding");
        object3 = this._document.createElement("soap:address");
        element.appendChild((Node)object3);
        object3.setAttribute("location", string);
    }

    private String packageNS(String string) {
        String string2;
        if (string.indexOf(".") == -1) {
            return "";
        }
        String string3 = string.substring(0, string.lastIndexOf("."));
        if (this._pack2ns.containsKey(string3)) {
            string2 = (String)this._pack2ns.get(string3);
            CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.mapped.pkg.to.ns", string3, string2));
        } else {
            if (this._xmlns != null) {
                return this._xmlns;
            }
            string2 = "http://www.";
            int n = string3.indexOf(".");
            if (n != -1) {
                int n2 = string3.indexOf(".", n + 1);
                if (n2 == -1) {
                    n2 = string3.length();
                }
                string2 = string2 + string3.substring(n + 1, n2);
                string2 = string2 + "." + string3.substring(0, n);
                if (n2 != -1 && n2 != string3.length()) {
                    string2 = string2 + "/" + string3.substring(n2 + 1, string3.length()).replace('.', '/');
                }
            } else {
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    private static void error(String string) {
        throw new RuntimeException(string);
    }

    private static void info(String string) {
        if (_verbose) {
            System.out.println(string);
        }
    }

    private static void warn(String string) {
        if (!_nowarn) {
            System.out.println("warn: " + string);
        }
    }

    private static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("failed to instantiate parser: " + parserConfigurationException);
        }
    }

    private String generateSchema(XMLType xMLType, Element element) {
        TypeMap typeMap = this._mapper.get(xMLType.getQName());
        return this.generateSchema(typeMap.getJavaType(), class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object, element);
    }

    private String generateSchema(Class clazz, Class clazz2, Element element) {
        if (this._noTypes) {
            return "xsd:anyType";
        }
        if (clazz.isArray()) {
            return this.generateXML(clazz, false, element);
        }
        ArrayList arrayList = CodeGenUtil.getSuperclasses(clazz, clazz2);
        Class[] classArray = new Class[arrayList.size()];
        classArray = arrayList.toArray(classArray);
        int n = classArray.length;
        this.checkForMarshalerDifferences(classArray);
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            Class clazz3 = classArray[n2];
            CodeGenerator.info("generating schema for " + clazz3.getName());
            string = this.generateSchema(clazz3, element);
            ++n2;
        }
        return string;
    }

    private void checkForMarshalerDifferences(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return;
        }
        int n = classArray.length;
        Class clazz = classArray[n - 1];
        TypeMap typeMap = this.getMapping(clazz);
        if (typeMap == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Class clazz2 = classArray[n2];
            TypeMap typeMap2 = this.getMapping(clazz2);
            if (typeMap2 == null) {
                CodeGenerator.error("incompatible mapping for superclasses of " + clazz.getName());
            }
            if (!this.isSameClass(typeMap2.getSerializer(), typeMap.getSerializer()) || !this.isSameClass(typeMap2.getDeserializer(), typeMap.getDeserializer())) {
                CodeGenerator.error("incompatible mapping for superclasses of " + clazz.getName());
            }
            ++n2;
        }
    }

    private boolean isSameClass(Object object, Object object2) {
        return object.getClass().getName().equals(object2.getClass().getName());
    }

    private TypeMap getMapping(Class clazz) {
        return this._mapper.get(clazz);
    }

    private String generateSchema(Class clazz, Element element) {
        String string = (String)this._types.get(clazz);
        if (string != null) {
            return string;
        }
        if (clazz.isArray()) {
            return this.generateXML(clazz, false, element);
        }
        TypeMap typeMap = this._mapper.get(clazz);
        String string2 = null;
        if (typeMap == null) {
            return this.generateXML(clazz, element);
        }
        string2 = this.importType(typeMap.getXMLType());
        if (string2 != null) {
            string = string2 + ":" + typeMap.getXMLType().getQName().getLocalPart();
            this._types.put(clazz, string);
            return string;
        }
        Serializer serializer = typeMap.getSerializer();
        Deserializer deserializer = typeMap.getDeserializer();
        if (serializer instanceof PublicFieldsMarshaler || deserializer instanceof PublicFieldsMarshaler || serializer instanceof com.sssw.jbroker.web.mapping.PublicFieldsMarshaler || deserializer instanceof com.sssw.jbroker.web.mapping.PublicFieldsMarshaler) {
            return this.generateXML(clazz, false, element);
        }
        if (serializer instanceof com.sssw.jbroker.web.encoding.BeanMarshaler || deserializer instanceof com.sssw.jbroker.web.encoding.BeanMarshaler || serializer instanceof BeanMarshaler || deserializer instanceof BeanMarshaler) {
            return this.generateXML(typeMap.getJavaType(), true, element);
        }
        CodeGenerator.info("unknown mapping for " + typeMap);
        return null;
    }

    private Set getCommon(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!set2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    private String generateXML(Class clazz, Element element) {
        Element element2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Element element3;
        Document document;
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var9_7 = null;
        TypeMap typeMap = this._mapper.get(clazz);
        string3 = typeMap == null ? null : typeMap.getQName().getNamespaceURI();
        if (string3 == null) {
            string3 = this.packageNS(CodeGenerator.getClassName(clazz));
        }
        if ((string2 = clazz.getName()).indexOf(".") != -1) {
            int n = string2.lastIndexOf(".");
            string2 = string2.substring(n + 1, string2.length());
        }
        if (element == null) {
            bl = true;
            if (_embed) {
                this._generatedSchema.add(clazz);
                document = this._document;
                element3 = this.getSchema(this._typeTag, string3);
                if (element3 == null) {
                    element3 = document.createElement("schema");
                }
            } else {
                DocumentBuilder documentBuilder = CodeGenerator.getParser();
                document = documentBuilder.newDocument();
                element3 = document.createElement("schema");
                document.appendChild(element3);
            }
        } else {
            element3 = element;
            document = element.getOwnerDocument();
        }
        if (string3 != null && string3.length() > 0) {
            string = (String)this._namespaces.get(string3);
            if (string == null) {
                string = "ns" + this._nsCount++;
                this._namespaces.put(string3, string);
                this._revNamespaces.put(string, string3);
            }
            element3.setAttribute("targetNamespace", string3);
            element3.setAttribute("xmlns", this._xsd);
            if (!_embed) {
                element3.setAttribute("xmlns:xsd", this._xsd);
            }
        }
        String string4 = string == null ? "tns:" + string2 : string + ":" + string2;
        this._types.put(clazz, string4);
        if (clazz.isPrimitive()) {
            return string4;
        }
        if (this._generatedTypes.contains(clazz)) {
            return null;
        }
        CodeGenerator.info("generating schema for " + clazz.getName());
        Element element4 = document.createElement("element");
        element3.appendChild(element4);
        if (Modifier.isStatic(clazz.getModifiers())) {
            string2 = string2.replace('$', '_');
            string4 = string4.replace('$', '_');
        }
        element4.setAttribute("name", string2);
        element4.setAttribute("type", string4);
        Object object7 = document.createElement("complexType");
        element3.appendChild((Node)object7);
        object7.setAttribute("name", string2);
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.getName().equals((class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
            object6 = (String)this._types.get(clazz2);
            if (object6 == null) {
                CodeGenerator.error("No complexType defined for " + clazz2.getName());
            }
            object5 = document.createElement("complexContent");
            object7.appendChild((Node)object5);
            object4 = document.createElement("extension");
            object5.appendChild((Node)object4);
            object4.setAttribute("base", (String)object6);
            object7 = object4;
        }
        object6 = document.createElement("all");
        object7.appendChild((Node)object6);
        object5 = this.getBeanProperties(clazz, clazz.getSuperclass());
        object4 = this.getPublicFields(clazz, false);
        Object[] objectArray = this.getCommon(object5.keySet(), object4.keySet()).toArray();
        String string5 = "";
        if (objectArray.length > 1) {
            int n = 0;
            while (n < objectArray.length) {
                string5 = string5 + objectArray[n];
                string5 = string5 + " ";
                ++n;
            }
            CodeGenerator.error(string2 + " has " + string5 + " bean properties which have the same name as that of public fields!");
        }
        object5.putAll(object4);
        Iterator iterator = object5.entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = (String)object3.getKey();
            object = (Class)object3.getValue();
            element2 = document.createElement("element");
            object6.appendChild(element2);
            element2.setAttribute("name", (String)object2);
            element2.setAttribute("type", this.mapJavaType((Class)object, element3));
        }
        if (bl) {
            if (_embed) {
                this._typeTag.appendChild(element3);
            } else {
                object3 = ((File)this._params.get("destDir")).toString();
                if (!((String)object3).endsWith(File.separator)) {
                    object3 = (String)object3 + File.separator;
                }
                object2 = new File((String)object3 + string2 + ".xsd");
                try {
                    object = new FileOutputStream((File)object2);
                    element2 = new OutputFormat(document);
                    element2.setIndent(1);
                    element2.setLineWidth(60);
                    XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)object, (OutputFormat)element2);
                    xMLSerializer.asDOMSerializer();
                    xMLSerializer.serialize(document.getDocumentElement());
                    CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.writing", ((File)object2).toString()));
                }
                catch (IOException iOException) {
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.unable.to.write.file", ((File)object2).toString()));
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = "";
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.import.null", ((File)object2).toString()));
                }
                object = this._document.createElement("import");
                this._defs.appendChild((Node)object);
                object.setAttribute("namespace", string3);
                object.setAttribute("location", ((File)object2).toString());
            }
        }
        string4 = string == null ? string2 : string + ":" + string2;
        this._generatedTypes.add(clazz);
        return string4;
    }

    private Element getSchema(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            String string2;
            if (nodeList.item(n2).getNodeName().endsWith("schema") && (string2 = (element2 = (Element)nodeList.item(n2)).getAttribute("targetNamespace")) != null && string2.equalsIgnoreCase(string)) {
                return element2;
            }
            ++n2;
        }
        return null;
    }

    private String generateXML(Class clazz, boolean bl, Element element) {
        Object object;
        Object object2;
        Element element2;
        Document document;
        Object object3;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        Class<?> clazz2 = null;
        Object object4 = null;
        int n = 0;
        if (clazz.isArray()) {
            n = 1;
            clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            string3 = this.packageNS(CodeGenerator.getClassName(clazz2));
            if (clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
                CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.object.array"));
                return "xsd:anyType";
            }
            string2 = clazz2.getName();
        } else {
            object3 = this._mapper.get(clazz);
            string3 = ((TypeMap)object3).getQName().getNamespaceURI();
            if (string3 == null) {
                string3 = this.packageNS(CodeGenerator.getClassName(clazz));
            }
            string2 = clazz.getName();
        }
        if (element == null) {
            bl2 = true;
            if (_embed) {
                this._generatedSchema.add(clazz);
                document = this._document;
                element2 = this.getSchema(this._typeTag, string3);
                if (element2 == null) {
                    element2 = document.createElement("schema");
                }
            } else {
                object3 = CodeGenerator.getParser();
                document = ((DocumentBuilder)object3).newDocument();
                element2 = document.createElement("schema");
                document.appendChild(element2);
            }
        } else {
            element2 = element;
            document = element.getOwnerDocument();
        }
        if (string2.indexOf(".") != -1) {
            int n2 = string2.lastIndexOf(".");
            string2 = string2.substring(n2 + 1, string2.length());
        }
        if (string3 != null && string3.length() > 0) {
            string = (String)this._namespaces.get(string3);
            if (string == null) {
                string = "ns" + this._nsCount++;
                this._namespaces.put(string3, string);
                this._revNamespaces.put(string, string3);
            }
            element2.setAttribute("targetNamespace", string3);
            if (!_embed) {
                element2.setAttribute("xmlns:xsd", this._xsd);
            }
        }
        if (n > 0) {
            int n3;
            int n4 = n3 = clazz2 == Byte.TYPE ? 1 : 0;
            while (n4 < n) {
                object2 = "ArrayOf";
                int n5 = 0;
                while (n5 < n4) {
                    object2 = (String)object2 + "ArrayOf";
                    ++n5;
                }
                object2 = (String)object2 + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                object = clazz;
                int n6 = 0;
                while (n6 < n - n4 - 1) {
                    object = ((Class)object).getComponentType();
                    ++n6;
                }
                if (this._types.get(object) == null) {
                    String string4;
                    object4 = string != null ? string + ":" + (String)object2 : object2;
                    this._types.put(object, object4);
                    Element element3 = document.createElement("complexType");
                    String string5 = string != null ? string + ":" + (String)object2 : "tns:" + (String)object2;
                    element3.setAttribute("name", (String)object2);
                    Element element4 = document.createElement("complexContent");
                    element3.appendChild(element4);
                    Element element5 = document.createElement("restriction");
                    element4.appendChild(element5);
                    element5.setAttribute("base", "soapenc:Array");
                    Element element6 = document.createElement("attribute");
                    element5.appendChild(element6);
                    element6.setAttribute("ref", "soapenc:arrayType");
                    String string6 = string4 = n4 == 0 ? this.mapJavaType(clazz2, element2) : ((String)object2).substring(7);
                    if (n4 > 0) {
                        String string7 = string4 = string != null ? string + ":" + string4 : "tns:" + string4;
                    }
                    string4 = n4 == 1 && clazz2 == Byte.TYPE ? this.mapJavaType(array$B == null ? CodeGenerator.class$("[B") : array$B, element2) + "[]" : string4 + "[]";
                    element6.setAttribute("wsdl:arrayType", string4);
                    element2.appendChild(element3);
                }
                ++n4;
            }
            if (!_embed) {
                element2.setAttribute("xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
                element2.setAttribute("xmlns:wsdl", "http://schemas.xmlsoap.org/wsdl/");
                element2.setAttribute("xmlns:xsd", this._xsd);
                if (!this.isSimple(clazz2) && (object2 = CodeGenerator.getPrefix(string2)) != null) {
                    Iterator iterator = this._namespaces.keySet().iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        if (!this._namespaces.get(object).equals(object2)) continue;
                        element2.setAttribute("xmlns:" + (String)object2, (String)object);
                        break;
                    }
                }
            }
        } else {
            object4 = string == null ? string2 : string + ":" + string2;
            this._types.put(clazz, object4);
            Element element7 = document.createElement("element");
            element2.appendChild(element7);
            element7.setAttribute("name", string2);
            Element element8 = document.createElement("complexType");
            element7.appendChild(element8);
            object2 = document.createElement("all");
            element8.appendChild((Node)object2);
            Map map = null;
            map = bl ? this.getBeanProperties(clazz, clazz.getSuperclass()) : this.getPublicFields(clazz, false);
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string8 = (String)entry.getKey();
                Class clazz3 = (Class)entry.getValue();
                Element element9 = document.createElement("element");
                object2.appendChild(element9);
                element9.setAttribute("name", string8);
                element9.setAttribute("type", this.mapJavaType(clazz3, element2));
            }
        }
        if (bl2) {
            if (_embed) {
                this._typeTag.appendChild(element2);
            } else {
                String string9 = ((File)this._params.get("destDir")).toString();
                if (!string9.endsWith(File.separator)) {
                    string9 = string9 + File.separator;
                }
                File file = new File(string9 + string2 + ".xsd");
                try {
                    object2 = new FileOutputStream(file);
                    OutputFormat outputFormat = new OutputFormat(document);
                    outputFormat.setIndent(1);
                    outputFormat.setLineWidth(60);
                    object = new XMLSerializer((OutputStream)object2, outputFormat);
                    object.asDOMSerializer();
                    object.serialize(document.getDocumentElement());
                    CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.writing", file.toString()));
                }
                catch (IOException iOException) {
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.unable.to.write.file", file.toString()));
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = "";
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.import.null", file.toString()));
                }
                object2 = this._document.createElement("import");
                this._defs.appendChild((Node)object2);
                object2.setAttribute("namespace", string3);
                object2.setAttribute("location", file.toString());
            }
        }
        return object4;
    }

    public static String getPrefix(String string) {
        int n = string.lastIndexOf(":");
        return n == -1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.lastIndexOf(":");
        return n == -1 ? string : string.substring(n + 1, string.length());
    }

    private String importType(XMLType xMLType) {
        Object object;
        String string = (String)this._importedTypes.get(xMLType);
        if (string != null) {
            return string;
        }
        QName qName = xMLType.getQName();
        string = (String)this._namespaces.get(qName.getNamespaceURI());
        if (string == null) {
            string = "ns" + this._nsCount++;
            this._namespaces.put(qName.getNamespaceURI(), string);
            this._revNamespaces.put(string, qName.getNamespaceURI());
        }
        this._importedTypes.put(xMLType, string);
        if (xMLType.getLocationURLStr() == null) {
            CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.missing.location", qName));
            return string;
        }
        boolean bl = false;
        if (_embed) {
            object = null;
            try {
                DocumentBuilder documentBuilder;
                Object object2;
                Object object3;
                Object object4;
                if (qName.getNamespaceURI().equals("http://schemas.silverstream.com/jBroker")) {
                    int n = "http://schemas.silverstream.com/jBroker".length();
                    object4 = xMLType.getLocationURLStr().substring(n);
                    object3 = this.getClass().getClassLoader();
                    object2 = ((ClassLoader)object3).getResource("schemas" + (String)object4);
                    if (object2 != null) {
                        object = ((URL)object2).openStream();
                    }
                } else {
                    try {
                        object = new FileInputStream(xMLType.getLocationURLStr());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.location.wrong", qName, xMLType.getLocationURLStr()));
                        return null;
                    }
                }
                if (!(object3 = (object4 = (documentBuilder = CodeGenerator.getParser()).parse((InputStream)object)).getDocumentElement()).getTagName().equals("schema")) {
                    CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.not.schema", qName, xMLType.getLocationURLStr()));
                    return string;
                }
                object2 = object3.cloneNode(true);
                object2 = this._document.importNode((Node)object2, true);
                this._typeTag.appendChild((Node)object2);
            }
            catch (Throwable throwable) {
                if (_debug) {
                    throwable.printStackTrace();
                }
                CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.inline.failed", qName, xMLType.getLocationURLStr(), throwable.toString()));
                bl = true;
            }
        }
        if (!_embed || bl) {
            object = this._document.createElement("import");
            this._defs.appendChild((Node)object);
            object.setAttribute("namespace", qName.getNamespaceURI());
            object.setAttribute("location", xMLType.getLocationURLStr());
        }
        return string;
    }

    public void mapJavaType(ASTPart aSTPart) {
        String string;
        String string2;
        Class clazz = aSTPart.getJavaClass();
        String string3 = this.mapJavaType(clazz, null);
        if (string3 == null) {
            string3 = "xsd:anyType";
        }
        if ((string2 = CodeGenerator.getPrefix(string3)) == null) {
            string2 = "";
        }
        if ((string = CodeGenerator.getLocalName(string3)) == null) {
            string2 = "xsd";
            string = "anyType";
        }
        string = string.replace('$', '.');
        aSTPart.setQName(new QName((String)this._revNamespaces.get(string2), string));
        aSTPart.setElement(false);
    }

    public String mapJavaType(Class clazz, Element element) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        TypeMap typeMap = _primitive.get(clazz, this._xsd);
        string = typeMap != null ? "xsd:" + typeMap.getQName().getLocalPart() : (String)this._types.get(clazz);
        if (string == null) {
            if (clazz.equals(Character.TYPE)) {
                CodeGenerator.warn(Main._messages.get("rmi2wsdl.warning.char.not.supported"));
                string = "xsd:string";
            } else {
                object3 = this._mapper.get(clazz);
                if (object3 != null) {
                    object2 = ((TypeMap)object3).getXMLType();
                    object = ((XMLType)object2).getQName();
                    String string2 = this.importType((XMLType)object2);
                    string = string2 == null ? this.generateSchema(clazz, class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object, element) : string2 + ":" + ((QName)object).getLocalPart();
                    this._types.put(clazz, string);
                }
            }
        }
        if (string == null) {
            string = this.generateSchema(clazz, class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object, element);
            this._types.put(clazz, string);
        }
        if (this._isLiteral && (object3 = CodeGenerator.getPrefix(string)) != null && ((String)object3).equals("xsd")) {
            if (!this._generatedTypes.contains(clazz)) {
                object2 = null;
                object = null;
                boolean bl = false;
                String string3 = (String)this._revNamespaces.get("tns");
                if (element == null) {
                    bl = true;
                    this._generatedSchema.add(clazz);
                    object2 = this._document;
                    object = this.getSchema(this._typeTag, string3);
                    if (object == null) {
                        object = object2.createElement("schema");
                    }
                } else {
                    object = element;
                    object2 = element.getOwnerDocument();
                }
                object.setAttribute("targetNamespace", string3);
                object.setAttribute("xmlns", this._xsd);
                object.setAttribute("xmlns:xsd", this._xsd);
                Element element2 = object2.createElement("element");
                object.appendChild(element2);
                element2.setAttribute("name", CodeGenerator.getLocalName(string));
                element2.setAttribute("type", string);
                if (bl) {
                    this._typeTag.appendChild((Node)object);
                }
                this._generatedTypes.add(clazz);
            }
            string = "tns:" + CodeGenerator.getLocalName(string);
        }
        return string;
    }

    private boolean isSimple(Class clazz) {
        return _primitive.get(clazz) != null;
    }

    public void generateWSDL(ASTPart aSTPart, Element element) {
        if (aSTPart == null) {
            return;
        }
        Element element2 = null;
        switch (aSTPart.getMode()) {
            case 1: 
            case 2: 
            case 3: {
                element2 = this._document.createElement("part");
                element2.setAttribute("name", aSTPart.getName());
                QName qName = aSTPart.getQName();
                String string = qName.getNamespaceURI();
                String string2 = string == null || string.length() == 0 ? "tns" : (this._xsd.equals(string) ? "xsd" : (String)this._namespaces.get(string));
                element2.setAttribute(this._isLiteral ? "element" : "type", string2 + ":" + qName.getLocalPart());
                element.appendChild(element2);
                break;
            }
            case 4: {
                Object object;
                Element element3;
                Object object2;
                Object object3;
                Object object4;
                String string;
                String string3 = aSTPart.getClassName();
                int n = string3.lastIndexOf(".");
                String string4 = string = n == -1 ? string3 : string3.substring(n + 1, string3.length());
                if (this._genMessages.contains(string)) break;
                this._genMessages.add(string);
                Element element4 = this._document.createElement("message");
                element4.setAttribute("name", string);
                Class clazz = aSTPart.getJavaClass();
                Map map = this.getBeanProperties(clazz, class$java$lang$Throwable == null ? (class$java$lang$Throwable = CodeGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                Iterator iterator = map.entrySet().iterator();
                if (map.size() == 1) {
                    object4 = iterator.next();
                    object3 = (String)object4.getKey();
                    object2 = (Class)object4.getValue();
                    if (this.isSimple((Class)object2)) {
                        element2 = this._document.createElement("part");
                        element4.appendChild(element2);
                        String string5 = Character.toLowerCase(((String)object3).charAt(0)) + ((String)object3).substring(1, ((String)object3).length());
                        element2.setAttribute("name", string5);
                        String string6 = this.mapJavaType((Class)object2, null);
                        element2.setAttribute(this._isLiteral ? "element" : "type", string6);
                        break;
                    }
                }
                if ((object3 = this.getSchema(this._typeTag, (String)(object4 = this.packageNS(aSTPart.getClassName())))) == null) {
                    object3 = this._document.createElement("schema");
                    object3.setAttribute("targetNamespace", (String)object4);
                    this._typeTag.appendChild((Node)object3);
                }
                if ((object2 = (String)this._namespaces.get(object4)) == null) {
                    object2 = "ns" + this._nsCount++;
                    this._namespaces.put(object4, object2);
                    this._revNamespaces.put(object2, object4);
                }
                if (this._isLiteral) {
                    element3 = this._document.createElement("element");
                    object3.appendChild(element3);
                    element3.setAttribute("name", string + "Part");
                    element3.setAttribute("type", (String)object2 + ":" + string);
                }
                element3 = this._document.createElement("complexType");
                object3.appendChild(element3);
                element3.setAttribute("name", string);
                Element element5 = this._document.createElement("sequence");
                element3.appendChild(element5);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    String string7 = (String)object.getKey();
                    element2 = this._document.createElement("element");
                    element5.appendChild(element2);
                    String string8 = Character.toLowerCase(string7.charAt(0)) + string7.substring(1, string7.length());
                    element2.setAttribute("name", string8);
                    Class clazz2 = (Class)object.getValue();
                    String string9 = this.mapJavaType(clazz2, null);
                    element2.setAttribute(this._isLiteral ? "element" : "type", string9);
                }
                element2 = this._document.createElement("part");
                element4.appendChild(element2);
                element2.setAttribute("name", "fault");
                object = this._isLiteral ? (String)object2 + ":" + string + "Part" : (String)object2 + ":" + string;
                element2.setAttribute(this._isLiteral ? "element" : "type", (String)object);
                element.appendChild(element4);
            }
        }
    }

    public void generateWSDL(ASTMessage aSTMessage, String string, Element element) {
        block21: {
            ASTPart[] aSTPartArray;
            block20: {
                if (aSTMessage == null || string == null) {
                    return;
                }
                aSTPartArray = aSTMessage.getParts();
                if (!string.equals("message")) break block20;
                Element element2 = null;
                switch (aSTMessage.getMode()) {
                    case 1: 
                    case 2: {
                        if (!this._genMessages.contains(aSTMessage.getName())) {
                            this._genMessages.add(aSTMessage.getName());
                            element2 = this._document.createElement("message");
                            element2.setAttribute("name", aSTMessage.getName());
                            element.appendChild(element2);
                            if (aSTPartArray == null) break;
                            boolean bl = false;
                            int n = 0;
                            while (n < aSTPartArray.length) {
                                this.generateWSDL(aSTPartArray[n], element2);
                                ++n;
                            }
                        }
                        break block21;
                    }
                    case 4: {
                        if (aSTPartArray != null) {
                            int n = 0;
                            while (n < aSTPartArray.length) {
                                if (aSTPartArray[n] != null && !aSTPartArray[n].isRemote() && !this._faultSet.contains(aSTPartArray[n].getClassName())) {
                                    this._faultSet.add(aSTPartArray[n].getClassName());
                                    this.generateWSDL(aSTPartArray[n], element);
                                }
                                ++n;
                            }
                        }
                        break block21;
                    }
                }
                break block21;
            }
            if (string.equals("portType")) {
                Element element3 = null;
                switch (aSTMessage.getMode()) {
                    case 1: {
                        element3 = this._document.createElement("input");
                        element3.setAttribute("message", "tns:" + aSTMessage.getName());
                        element.appendChild(element3);
                        break;
                    }
                    case 2: {
                        element3 = this._document.createElement("output");
                        element3.setAttribute("message", "tns:" + aSTMessage.getName());
                        element.appendChild(element3);
                        break;
                    }
                    case 4: {
                        if (aSTPartArray == null) break;
                        int n = 0;
                        while (n < aSTPartArray.length) {
                            if (aSTPartArray[n] != null && !aSTPartArray[n].isRemote()) {
                                element3 = this._document.createElement("fault");
                                String string2 = aSTPartArray[n].getClassName();
                                int n2 = string2.lastIndexOf(".");
                                String string3 = n2 == -1 ? string2 : string2.substring(n2 + 1, string2.length());
                                element3.setAttribute("message", "tns:" + string3);
                                if (string3.endsWith("Exception")) {
                                    String string4 = string3.substring(0, string3.length() - 9);
                                    element3.setAttribute("name", string4);
                                } else {
                                    element3.setAttribute("name", string3);
                                }
                                element.appendChild(element3);
                            }
                            ++n;
                        }
                        break;
                    }
                }
            }
        }
    }

    public void generateWSDL(ASTOperation aSTOperation, String string, Element aSTMessageArray) {
        ASTMessage[] aSTMessageArray2;
        if (aSTOperation == null) {
            return;
        }
        if (string != null && string.equals("portType")) {
            ASTPart[] aSTPartArray;
            aSTMessageArray2 = this._document.createElement("operation");
            aSTMessageArray2.setAttribute("name", aSTOperation.getName());
            if (aSTOperation.hasInput() && (aSTPartArray = aSTOperation.getInput().getParts()).length > 0) {
                String string2 = "";
                int n = 0;
                while (n < aSTPartArray.length) {
                    string2 = string2 + aSTPartArray[n].getName();
                    if (n != aSTPartArray.length - 1) {
                        string2 = string2 + " ";
                    }
                    ++n;
                }
                aSTMessageArray2.setAttribute("parameterOrder", string2);
            }
            aSTMessageArray.appendChild((Node)aSTMessageArray2);
            aSTMessageArray = aSTMessageArray2;
        }
        this.generateWSDL(aSTOperation.getInput(), string, (Element)aSTMessageArray);
        this.generateWSDL(aSTOperation.getOutput(), string, (Element)aSTMessageArray);
        aSTMessageArray2 = aSTOperation.getFaults();
        if (aSTMessageArray2 != null) {
            int n = 0;
            while (n < aSTMessageArray2.length) {
                if (string.equals("message")) {
                    this.generateWSDL(aSTMessageArray2[n], string, (Element)aSTMessageArray);
                } else if (string.equals("portType")) {
                    this.generateWSDL(aSTMessageArray2[n], string, (Element)aSTMessageArray);
                }
                ++n;
            }
        }
    }

    public void generateWSDL(ASTPortType aSTPortType, String string) {
        Object object;
        if (aSTPortType == null) {
            return;
        }
        Object object2 = null;
        if (string != null && string.equals("portType")) {
            object = this._document.createElement("portType");
            this._document.getDocumentElement().appendChild((Node)object);
            String string2 = aSTPortType.getName();
            int n = string2.lastIndexOf(".");
            if (n > 0) {
                string2 = string2.substring(n + 1);
            }
            object.setAttribute("name", string2);
            CodeGenerator.info(Main._messages.get("rmi2wsdl.verbose.generating.something", "portType", string2));
            object2 = object;
        } else if (string != null && string.equals("message")) {
            object2 = this._document.getDocumentElement();
        }
        object = aSTPortType.getOperations();
        if (object != null) {
            int n = 0;
            while (n < ((ASTOperation[])object).length) {
                this.generateWSDL(object[n], string, (Element)object2);
                ++n;
            }
        }
    }

    public void generateWSDL(ASTDocument aSTDocument) {
        int n;
        if (aSTDocument == null) {
            return;
        }
        this._defs = this._document.createElement("definitions");
        this._defs.setAttribute("name", this._portName + "Service");
        ASTPortType[] aSTPortTypeArray = aSTDocument.getPortTypes();
        if (aSTPortTypeArray != null) {
            n = 0;
            while (n < aSTPortTypeArray.length) {
                if (aSTPortTypeArray[n] != null) {
                    String string;
                    String string2 = aSTPortTypeArray[n].getName();
                    int n2 = string2.lastIndexOf(".");
                    String string3 = string = n2 > 0 ? (String)this._pack2ns.get(string2.substring(0, n2)) : null;
                    if (string == null) {
                        String string4 = string = this._xmlns != null ? this._xmlns : aSTPortTypeArray[0].getNsURI();
                    }
                    if (string == null || string.length() <= 0 || string.equals("none")) break;
                    this._defs.setAttribute("targetNamespace", string);
                    this._defs.setAttribute("xmlns:tns", string);
                    this._namespaces.put(string, "tns");
                    this._revNamespaces.put("tns", string);
                    break;
                }
                ++n;
            }
        }
        this._defs.setAttribute("xmlns:xsd", this._xsd);
        this._defs.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this._defs.setAttribute("xmlns", "http://schemas.xmlsoap.org/wsdl/");
        this._defs.setAttribute("xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        this._document.appendChild(this._defs);
        if (_embed) {
            this._typeTag = this._document.createElement("types");
            this._defs.appendChild(this._typeTag);
        }
        this.fixXMLTypes(aSTDocument);
        if (aSTPortTypeArray != null) {
            n = 0;
            while (n < aSTPortTypeArray.length) {
                this.generateWSDL(aSTPortTypeArray[n], "message");
                ++n;
            }
            int n3 = 0;
            while (n3 < aSTPortTypeArray.length) {
                this.generateWSDL(aSTPortTypeArray[n3], "portType");
                ++n3;
            }
        }
    }

    private static boolean isReadWrite(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getName() != "class" && !CodeGenerator.isStackTraceElement(propertyDescriptor);
    }

    private static boolean isStackTraceElement(PropertyDescriptor propertyDescriptor) {
        return _stackTraceElementClass != null && propertyDescriptor.getPropertyType().isArray() && propertyDescriptor.getPropertyType().getComponentType().equals(_stackTraceElementClass) && propertyDescriptor.getName().equals("stackTrace");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _debug = false;
        _primitive = PrimitiveTypeMapper.getSingleton();
        _stackTraceElementClass = null;
        try {
            _stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        _nonPrimitiveMappings = new Class[]{class$com$sssw$jbroker$web$core$mapping$SetMapping == null ? (class$com$sssw$jbroker$web$core$mapping$SetMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.SetMapping")) : class$com$sssw$jbroker$web$core$mapping$SetMapping, class$com$sssw$jbroker$web$core$mapping$ListMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ListMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ListMapping")) : class$com$sssw$jbroker$web$core$mapping$ListMapping, class$com$sssw$jbroker$web$core$mapping$MapMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.MapMapping")) : class$com$sssw$jbroker$web$core$mapping$MapMapping, class$com$sssw$jbroker$web$core$mapping$MapEntryMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapEntryMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.MapEntryMapping")) : class$com$sssw$jbroker$web$core$mapping$MapEntryMapping, class$com$sssw$jbroker$web$core$mapping$ClassMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ClassMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ClassMapping")) : class$com$sssw$jbroker$web$core$mapping$ClassMapping, class$com$sssw$jbroker$web$core$mapping$QNameMapping == null ? (class$com$sssw$jbroker$web$core$mapping$QNameMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.QNameMapping")) : class$com$sssw$jbroker$web$core$mapping$QNameMapping, class$com$sssw$jbroker$web$core$mapping$BindingMapping == null ? (class$com$sssw$jbroker$web$core$mapping$BindingMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.BindingMapping")) : class$com$sssw$jbroker$web$core$mapping$BindingMapping, class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ServiceObjectMapping")) : class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping, class$com$sssw$jbroker$web$soap$mapping$ElementMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$ElementMapping = CodeGenerator.class$("com.sssw.jbroker.web.soap.mapping.ElementMapping")) : class$com$sssw$jbroker$web$soap$mapping$ElementMapping, class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping = CodeGenerator.class$("com.sssw.jbroker.web.soap.mapping.StackTraceMapping")) : class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping};
    }
}

