/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.rmi2wsdl;

import com.sssw.jbroker.tools.rmi2wsdl.CodeGenerator;
import com.sssw.jbroker.util.ClassUtil;
import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.Messages;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Main {
    private static final boolean NO_ERROR = true;
    private static final boolean COMPILE_ERROR = false;
    private static final boolean _debug = false;
    private CommandLine _cmdline;
    public static final Messages _messages = new Messages(class$com$sssw$jbroker$tools$rmi2wsdl$Main == null ? (class$com$sssw$jbroker$tools$rmi2wsdl$Main = Main.class$("com.sssw.jbroker.tools.rmi2wsdl.Main")) : class$com$sssw$jbroker$tools$rmi2wsdl$Main);
    private static final String _usage = _messages.get("rmi2wsdl.usage") + Copyright._copyright + "\n";
    static /* synthetic */ Class class$com$sssw$jbroker$tools$rmi2wsdl$Main;
    static /* synthetic */ Class class$java$rmi$Remote;

    public static void main(String[] stringArray) {
        try {
            Main main = new Main();
            System.exit(main.compile(stringArray) ? 0 : 1);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (System.getProperty("DEBUG") != null) {
                exception.printStackTrace();
            } else if (string != null && string.length() > 0) {
                System.err.println(string);
            } else {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }

    boolean parseArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            return false;
        }
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("d", false, 1, 1), new CommandArg("nowarn", false, 0, 0), new CommandArg("verbose", false, 0, 0), new CommandArg("xsd", false, 1, 1), new CommandArg("xmlns", false, 1, 1), new CommandArg("literal", false, 0, 0), new CommandArg("document", false, 0, 0), new CommandArg("noinline", false, 0, 0), new CommandArg("notypes", false, 0, 0), new CommandArg("soap", false, 1, 1), new CommandArg("classpath", false, 1, 1), new CommandArg("pkgns", false, 2, 2), new CommandArg("typemapping", false, 1, 1), new CommandArg("servicename", false, 1, 1)};
        this._cmdline = new CommandLine("rmi2wsdl", commandArgArray, _usage, "-", true);
        this._cmdline.getArgDef("classpath").setAlias("cp");
        this._cmdline.markAppendable("pkgns");
        this._cmdline.markAppendable("typemapping");
        this._cmdline.getArgDef("servicename").setAlias("serviceName");
        boolean bl = this._cmdline.parse(stringArray, System.err);
        return bl;
    }

    boolean compile(String[] stringArray) throws Exception {
        Serializable serializable;
        Object object;
        boolean bl;
        if (!this.parseArguments(stringArray)) {
            System.err.println(_usage);
            return false;
        }
        boolean bl2 = this._cmdline.getArg("verbose") != null;
        CodeGenerator codeGenerator = new CodeGenerator();
        if (this._cmdline.getArg("nowarn") == null) {
            if (this._cmdline.getArg("literal") != null && this._cmdline.getArg("soap") == null) {
                System.out.println(_messages.get("rmi2wsdl.warning.soap.flags", "-literal"));
            }
            if (this._cmdline.getArg("document") != null && this._cmdline.getArg("soap") == null) {
                System.out.println(_messages.get("rmi2wsdl.warning.soap.flags", "-document"));
            }
        }
        boolean bl3 = this._cmdline.getArg("document") != null;
        boolean bl4 = bl = this._cmdline.getArg("literal") != null;
        if (bl3) {
            if (!bl) {
                throw new Exception(_messages.get("rmi2wsdl.error.document.encoded"));
            }
        } else if (bl) {
            throw new Exception(_messages.get("rmi2wsdl.error.rpc.literal"));
        }
        Hashtable hashtable = this._cmdline.getArgs();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Object v = hashtable.get("classpath");
        if (v != null) {
            URL[] uRLArray;
            object = v instanceof String ? (String)v : ((String[])v)[0];
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            serializable = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                uRLArray = stringTokenizer.nextToken();
                ((ArrayList)serializable).add(new File((String)uRLArray).toURL());
            }
            uRLArray = new URL[((ArrayList)serializable).size()];
            uRLArray = ((ArrayList)serializable).toArray(uRLArray);
            classLoader = new URLClassLoader(uRLArray);
        }
        object = this._cmdline.getTralingArguments();
        int n = 0;
        while (n < ((String[])object).length) {
            if (bl2) {
                System.out.println(_messages.get("rmi2wsdl.verbose.processing.class", object[n]));
            }
            try {
                serializable = ClassUtil.forName(object[n], classLoader);
                if (serializable == null) {
                    throw new ClassNotFoundException();
                }
                Main.compile(codeGenerator, (Class)serializable, hashtable);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(_messages.get("rmi2wsdl.error.unable.to.find.class", object[n]));
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void compile(CodeGenerator codeGenerator, Class clazz, Hashtable hashtable) throws Exception {
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Main.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz) || !clazz.isInterface()) {
            System.err.println(_messages.get("rmi2wsdl.error.not.remote", clazz.getName()));
            return;
        }
        String string = null;
        Object v = hashtable.get("d");
        if (v != null) {
            string = v instanceof String ? (String)v : ((String[])v)[0];
        }
        File file = Main.getDestDir(string);
        hashtable.put("destDir", file);
        codeGenerator.compile(clazz, hashtable);
    }

    private static File getDestDir(String string) throws Exception {
        File file = null;
        if (string != null) {
            file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(_messages.get("rmi2wsdl.error.unable.to.create.directory", string));
            }
            if (!file.isDirectory()) {
                throw new Exception(_messages.get("rmi2wsdl.error.exists.but.not.directory", string));
            }
        } else {
            file = new File(".");
        }
        return file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

