/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.tcptunnel;

import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class Tunnel
implements Runnable {
    private InetAddress _adr;
    private String _host;
    private ServerSocket _ssocket;
    private CommandLine _cmdline;
    private int _localPort;
    private int _remotePort;
    private JFrame _frame;
    private JTextArea _left;
    private JTextArea _right;
    public static boolean _verbose = false;
    public static boolean _nowarn = false;
    public static final Messages _messages = new Messages(class$com$sssw$jbroker$tools$tcptunnel$Tunnel == null ? (class$com$sssw$jbroker$tools$tcptunnel$Tunnel = Tunnel.class$("com.sssw.jbroker.tools.tcptunnel.Tunnel")) : class$com$sssw$jbroker$tools$tcptunnel$Tunnel);
    private static final String _usage = _messages.get("tunnel.usage") + Copyright._copyright + "\n";
    public static final int OK = 0;
    public static final int ERROR = 1;
    private final ThreadPool _pool = new ThreadPool(50, 10000);
    public static final int IN = 0;
    public static final int OUT = 1;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$tcptunnel$Tunnel;

    public static void main(String[] stringArray) throws Exception {
        Tunnel tunnel = new Tunnel();
        if (tunnel.init(stringArray) == 1) {
            System.exit(1);
        }
        if (tunnel.startTunnel() == 1) {
            System.exit(1);
        }
        tunnel.gui();
    }

    public int init(String[] stringArray) {
        if (stringArray.length == 0 || !this.parseArguments(stringArray)) {
            System.err.println(_usage);
            return 1;
        }
        _verbose = this._cmdline.getArg("verbose") != null;
        _nowarn = this._cmdline.getArg("nowarn") != null;
        String[] stringArray2 = this._cmdline.getTralingArguments();
        if (stringArray2.length != 3) {
            System.err.println(_usage);
            return 1;
        }
        try {
            this._localPort = Integer.parseInt(stringArray2[0]);
        }
        catch (NumberFormatException numberFormatException) {
            Tunnel.error(_messages.get("tunnel.error.port.not.integer", stringArray2[0]));
            return 1;
        }
        this._host = stringArray2[1];
        try {
            this._remotePort = Integer.parseInt(stringArray2[2]);
        }
        catch (NumberFormatException numberFormatException) {
            Tunnel.error(_messages.get("tunnel.error.port.not.integer", stringArray2[0]));
            return 1;
        }
        return 0;
    }

    boolean parseArguments(String[] stringArray) {
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("verbose", false, 0, 0), new CommandArg("nowarn", false, 0, 0)};
        this._cmdline = new CommandLine("tunnel", commandArgArray, _usage, "-", false);
        boolean bl = this._cmdline.parse(stringArray, System.err);
        return bl;
    }

    public int startTunnel() {
        try {
            this._adr = InetAddress.getByName(this._host);
            this._ssocket = new ServerSocket(this._localPort);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.length() == 0) {
                string = exception.toString();
            }
            Tunnel.error(_messages.get("tunnel.error.start.failed", string));
            return 1;
        }
        Thread thread = new Thread((Runnable)this, "listen" + this._localPort);
        thread.start();
        return 0;
    }

    public void gui() {
        String string = this._localPort + " to " + this._host + ":" + this._remotePort;
        this._frame = new JFrame("jBroker Web tunnel: " + string);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this._left = new JTextArea();
        this._right = new JTextArea();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add(new JScrollPane(this._left));
        FlowLayout flowLayout = new FlowLayout();
        JPanel jPanel2 = new JPanel(flowLayout);
        JButton jButton = new JButton("Clear");
        JButton jButton2 = new JButton("Save...");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        ButtonListener buttonListener = new ButtonListener(this._left);
        jButton.addActionListener(buttonListener);
        jButton2.addActionListener(buttonListener);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add(new JScrollPane(this._right));
        FlowLayout flowLayout2 = new FlowLayout();
        JPanel jPanel4 = new JPanel(flowLayout2);
        JButton jButton3 = new JButton("Clear");
        JButton jButton4 = new JButton("Save...");
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        jPanel3.add((Component)jPanel4, "South");
        ButtonListener buttonListener2 = new ButtonListener(this._right);
        jButton3.addActionListener(buttonListener2);
        jButton4.addActionListener(buttonListener2);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel3);
        jSplitPane.setOneTouchExpandable(true);
        this._frame.getContentPane().add(jSplitPane);
        ((Component)this._frame).setSize(new Dimension(700, 400));
        jSplitPane.setDividerLocation(350);
        jSplitPane.addComponentListener(new ResizeHandler());
        ((Component)this._frame).setVisible(true);
    }

    public void save(byte[] byArray) {
        Object[] objectArray;
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Data");
        int n2 = jFileChooser.showSaveDialog(this._frame);
        if (n2 == 1) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && (n = JOptionPane.showOptionDialog(this._frame, "File exists. Replace?", "Save Data", 2, 3, null, objectArray = new String[]{"OK", "Cancel"}, objectArray[0])) != 0) {
            return;
        }
        try {
            objectArray = new FileOutputStream(file);
            objectArray.write(byArray);
            objectArray.flush();
            objectArray.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this._frame, "I/O exception: " + iOException.getMessage(), "Error", 0);
        }
    }

    public void run() {
        try {
            try {
                while (true) {
                    Socket socket = this._ssocket.accept();
                    socket.setSoTimeout(240000);
                    Socket socket2 = new Socket(this._adr, this._remotePort);
                    this._pool.performWork(socket, socket2);
                }
            }
            catch (Throwable throwable) {
                Tunnel.error(_messages.get("tunnel.verbose.caught.exception", throwable.toString()));
                Object var4_4 = null;
                try {
                    this._ssocket.close();
                }
                catch (Throwable throwable2) {
                    Tunnel.error(_messages.get("tunnel.verbose.caught.exception", throwable2.toString()));
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                this._ssocket.close();
            }
            catch (Throwable throwable3) {
                Tunnel.error(_messages.get("tunnel.verbose.caught.exception", throwable3.toString()));
            }
            throw throwable;
        }
    }

    static void error(String string) {
        System.err.println(string);
    }

    static void info(String string) {
        if (_verbose) {
            System.out.println(string);
        }
    }

    static void warn(String string) {
        if (!_nowarn) {
            System.out.println("warn: " + string);
        }
    }

    private static String spaces(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + " ";
            ++n2;
        }
        return string;
    }

    private static int calcIndent(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (string.charAt(n4) == '<') {
                n3 = n4 != n2 - 1 && string.charAt(n4 + 1) == '/' ? --n3 : ++n3;
            }
            ++n4;
        }
        if (n3 == n) {
            return 0;
        }
        return n3 > n ? 1 : -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class WorkerThread
    extends Thread {
        private final ThreadPool _pool;
        private final int _timeout;
        private int _mode;
        private Socket _socket;
        private Socket _remote;
        private boolean firstL = true;
        private boolean firstR = true;

        public WorkerThread(ThreadPool threadPool, int n) {
            this._pool = threadPool;
            this._timeout = n;
        }

        public synchronized void assign(Socket socket, Socket socket2, int n) {
            this._socket = socket;
            this._remote = socket2;
            this._mode = n;
            this.notify();
        }

        /*
         * Loose catch block
         */
        public synchronized void run() {
            while (true) {
                block47: {
                    int n;
                    if (this._socket == null) {
                        try {
                            this.wait(this._timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._socket != null) continue;
                        this._pool.removeWorker(this);
                        return;
                    }
                    InputStream inputStream = null;
                    OutputStream outputStream = null;
                    int n2 = 0;
                    if (this._mode == 0) {
                        inputStream = this._remote.getInputStream();
                        outputStream = this._socket.getOutputStream();
                    } else {
                        inputStream = this._socket.getInputStream();
                        outputStream = this._remote.getOutputStream();
                    }
                    byte[] byArray = new byte[2048];
                    while ((n = inputStream.read(byArray)) != -1) {
                        int n3;
                        boolean bl = false;
                        String string = new String(byArray, 0, n);
                        int n4 = 0;
                        while ((n4 = string.indexOf("><", n4)) != -1) {
                            String string2 = string.substring(0, n4 + 1);
                            String string3 = string.substring(n4 + 1);
                            n2 += Tunnel.calcIndent(string2, n2);
                            string = string2 + "\n" + Tunnel.spaces(n2) + string3;
                        }
                        n4 = string.indexOf(">POST");
                        if (n4 > 0) {
                            string = string.substring(0, n4 + 1) + "\n\n" + string.substring(n4 + 1);
                        }
                        if ((n4 = string.indexOf(">HTTP")) > 0) {
                            string = string.substring(0, n4 + 1) + "\n\n" + string.substring(n4 + 1);
                        }
                        if (this._mode == 1 && (n4 = string.indexOf("\nHost: localhost")) > -1 && (n3 = string.indexOf("\n", n4 + 1)) > -1) {
                            string = string.substring(0, n4) + "\nHost: " + Tunnel.this._host + ":" + Tunnel.this._remotePort + string.substring(n3);
                            bl = true;
                        }
                        if (this._mode == 0) {
                            if (!this.firstR && (string.startsWith("POST") || string.startsWith("HTTP"))) {
                                Tunnel.this._right.append("\n\n");
                            }
                            this.firstR = false;
                            Tunnel.this._right.append(string);
                        } else {
                            if (!this.firstL && (string.startsWith("POST") || string.startsWith("HTTP"))) {
                                Tunnel.this._left.append("\n\n");
                            }
                            this.firstL = false;
                            Tunnel.this._left.append(string);
                        }
                        outputStream.write(byArray, 0, n);
                        outputStream.flush();
                    }
                    Object var12_16 = null;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        this._socket.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        this._remote.close();
                    }
                    catch (Throwable throwable2) {}
                    break block47;
                    {
                        catch (IOException iOException) {
                            var12_16 = null;
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                this._socket.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                this._remote.close();
                            }
                            catch (Throwable throwable2) {}
                            break block47;
                        }
                        catch (Throwable throwable) {
                            String string = throwable.getMessage();
                            if (string == null || string.length() == 0) {
                                string = throwable.toString();
                            }
                            Tunnel.warn(_messages.get("tunnel.verbose.caught.exception", string));
                            throwable.printStackTrace(System.err);
                            var12_16 = null;
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                this._socket.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                this._remote.close();
                            }
                            catch (Throwable throwable2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        var12_16 = null;
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        try {
                            this._socket.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        try {
                            this._remote.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                this._socket = null;
                this._pool.returnWorker(this);
            }
        }
    }

    public class ThreadPool {
        private final int _max;
        private final int _timeout;
        private final Vector _idle = new Vector();
        private int _num = 0;

        public ThreadPool(int n, int n2) {
            this._max = n;
            this._timeout = n2;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized void performWork(Socket var1_1, Socket var2_2) {
            block4: {
                block3: {
                    if (this._idle.size() <= 1) break block3;
                    var3_3 = (WorkerThread)this._idle.elementAt(0);
                    this._idle.removeElementAt(0);
                    var3_3.assign(var1_1, var2_2, 0);
                    var3_3 = (WorkerThread)this._idle.elementAt(0);
                    this._idle.removeElementAt(0);
                    var3_3.assign(var1_1, var2_2, 1);
                    break block4;
                }
                if (this._max != 0 && this._num >= this._max - 1) ** GOTO lbl25
                var3_4 = new WorkerThread(this, this._timeout);
                ++this._num;
                var3_4.assign(var1_1, var2_2, 0);
                var3_4.start();
                var3_4 = new WorkerThread(this, this._timeout);
                ++this._num;
                var3_4.assign(var1_1, var2_2, 1);
                var3_4.start();
                break block4;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var3_5) {
                        // empty catch block
                    }
lbl25:
                    // 3 sources

                    ** while (this._idle.size() < 2)
                }
lbl26:
                // 1 sources

                var3_6 = (WorkerThread)this._idle.elementAt(0);
                this._idle.removeElementAt(0);
                var3_6.assign(var1_1, var2_2, 0);
                var3_6 = (WorkerThread)this._idle.elementAt(0);
                this._idle.removeElementAt(0);
                var3_6.assign(var1_1, var2_2, 1);
            }
        }

        public synchronized void returnWorker(WorkerThread workerThread) {
            this._idle.addElement(workerThread);
            this.notify();
        }

        public synchronized void removeWorker(WorkerThread workerThread) {
            --this._num;
            this._idle.removeElement(workerThread);
        }
    }

    public class ButtonListener
    implements ActionListener {
        private final JTextArea _area;

        public ButtonListener(JTextArea jTextArea) {
            this._area = jTextArea;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Clear")) {
                this._area.setText("");
            } else if (string.equals("Save...")) {
                byte[] byArray = this._area.getText().getBytes();
                if (byArray.length == 0) {
                    JOptionPane.showMessageDialog(Tunnel.this._frame, "Nothing to save!", "Error", 0);
                } else {
                    Tunnel.this.save(byArray);
                }
            }
        }
    }

    public static class ResizeHandler
    extends ComponentAdapter {
        int _width = 700;

        public void componentResized(ComponentEvent componentEvent) {
            JSplitPane jSplitPane = (JSplitPane)componentEvent.getSource();
            double d = (double)jSplitPane.getDividerLocation() / (double)this._width;
            this._width = jSplitPane.getSize().width;
            if (this._width == 0 || d == 0.0) {
                return;
            }
            jSplitPane.setDividerLocation((int)(d * (double)this._width));
        }
    }
}

