/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.Util;
import com.sssw.jbroker.util.CodeGenUtil;
import javax.xml.namespace.QName;

public class ASTBinding {
    protected String _nsURI;
    protected String _name;
    protected String _portTypeName;
    protected String _portTypeClassName;
    protected ASTOperation[] _operations;
    protected String _doc;

    ASTBinding(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, new ASTOperation[0]);
    }

    ASTBinding(String string, String string2, String string3, String string4, ASTOperation[] aSTOperationArray) {
        this._nsURI = string;
        this._name = string2;
        this._portTypeName = string3;
        this._portTypeClassName = string4;
        this._operations = aSTOperationArray;
        this._doc = null;
    }

    public void setNsURI(String string) {
        this._nsURI = string;
    }

    public String getNsURI() {
        return this._nsURI;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public QName getQName() {
        return new QName(this._nsURI, this._name);
    }

    public String getLocalName() {
        return Util.getLocalName(this._name, ".");
    }

    public void setPortTypeName(String string) {
        this._portTypeName = string;
    }

    public String getPortTypeName() {
        return this._portTypeName;
    }

    public void setPortTypeClassName(String string) {
        this._portTypeClassName = string;
    }

    public String getPortTypeClassName() {
        return this._portTypeClassName;
    }

    public String getFileName() {
        String string = Util.getLocalName(this._name, ".");
        return CodeGenUtil.fixClassName(string);
    }

    public ASTOperation[] getOperations() {
        return this._operations;
    }

    public void setOperations(ASTOperation[] aSTOperationArray) {
        this._operations = aSTOperationArray == null ? new ASTOperation[]{} : aSTOperationArray;
    }

    public void initOperations(int n) {
        this._operations = new ASTOperation[n < 0 ? 0 : n];
    }

    public boolean addOperation(ASTOperation aSTOperation) {
        if (this._operations == null || aSTOperation == null) {
            return false;
        }
        int n = 0;
        while (n < this._operations.length && this._operations[n] != null) {
            if (!this._operations[n++].equals(aSTOperation)) continue;
            return false;
        }
        if (n >= this._operations.length) {
            return false;
        }
        this._operations[n] = aSTOperation;
        return true;
    }

    public int numOperations() {
        return this._operations == null ? 0 : this._operations.length;
    }

    public boolean hasOperations() {
        return this.numOperations() > 0 && this._operations[0] != null;
    }

    public void setDoc(String string) {
        this._doc = string;
    }

    public String getDoc() {
        return this._doc;
    }

    public String toString() {
        String string = "{BIND=NS:" + this._nsURI + ",N:" + this._name + ",PT:" + this._portTypeName;
        if (this._operations != null) {
            int n = 0;
            while (n < this._operations.length) {
                string = string + "," + this._operations[n].toString();
                ++n;
            }
        }
        string = string + "}";
        return string;
    }

    public boolean equals(String string, String string2) {
        return this._nsURI.equals(string) && this._name.equals(string2);
    }

    public boolean equals(ASTBinding aSTBinding) {
        return aSTBinding == null ? false : this.equals(aSTBinding.getNsURI(), aSTBinding.getName());
    }

    public String getPackage() {
        String string = Util.getPrefixName(this._name, ".");
        return string == null ? "" : string + ".";
    }
}

