/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTPortType;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapFaultMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.util.CodeGenUtil;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ASTDocument {
    private ASTPortType[] _porttypes;
    private ASTService[] _services;
    private Properties _typeMap;
    private URL _wsdlDocument;
    private HashSet _pkgsWithHolders;
    private boolean _compileStatus;

    public ASTDocument() {
        this._porttypes = new ASTPortType[0];
        this._services = new ASTService[0];
        this._pkgsWithHolders = new HashSet();
    }

    public ASTDocument(ASTPortType[] aSTPortTypeArray, ASTService[] aSTServiceArray) {
        this._porttypes = aSTPortTypeArray == null ? new ASTPortType[]{} : aSTPortTypeArray;
        this._services = aSTServiceArray == null ? new ASTService[]{} : aSTServiceArray;
        this._pkgsWithHolders = new HashSet();
    }

    public ASTPortType[] getPortTypes() {
        return this._porttypes;
    }

    public void setPortTypes(ASTPortType[] aSTPortTypeArray) {
        this._porttypes = aSTPortTypeArray == null ? new ASTPortType[]{} : aSTPortTypeArray;
    }

    public ASTPortType getPortType(String string, String string2) {
        int n = 0;
        while (n < this._porttypes.length) {
            if (this._porttypes[n] != null && this._porttypes[n].equals(string, string2)) {
                return this._porttypes[n];
            }
            ++n;
        }
        return null;
    }

    public void initPortTypes(int n) {
        this._porttypes = new ASTPortType[n < 0 ? 0 : n];
    }

    public boolean hasPortTypes() {
        return this._porttypes != null && this._porttypes.length >= 1 && this._porttypes[0] != null;
    }

    public boolean addPortType(ASTPortType aSTPortType) {
        if (this._porttypes == null) {
            return false;
        }
        int n = 0;
        while (n < this._porttypes.length && this._porttypes[n] != null) {
            if (!this._porttypes[n++].equals(aSTPortType)) continue;
            return false;
        }
        if (n >= this._porttypes.length) {
            return false;
        }
        this._porttypes[n] = aSTPortType;
        return true;
    }

    public boolean hasPortType(String string, String string2) {
        int n = 0;
        while (n < this._porttypes.length) {
            if (this._porttypes[n] != null && this._porttypes[n].equals(string, string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ASTService[] getServices() {
        return this._services;
    }

    public void setServices(ASTService[] aSTServiceArray) {
        this._services = aSTServiceArray == null ? new ASTService[]{} : aSTServiceArray;
    }

    public void initServices(int n) {
        this._services = new ASTService[n < 0 ? 0 : n];
    }

    public void generateASTFromClass(Class clazz, boolean bl, String string) {
        if (bl) {
            this.initPortTypes(1);
            this.addPortType(new ASTPortType(clazz, string));
        } else {
            Class[] classArray = CodeGenUtil.getAllRemoteInterfaces(clazz);
            this.initPortTypes(classArray.length);
            int n = 0;
            while (n < classArray.length) {
                this.addPortType(new ASTPortType(classArray[n], string));
                ++n;
            }
        }
    }

    public String[] findInvalidRMI() {
        if (!this.hasPortTypes()) {
            return null;
        }
        String[] stringArray = null;
        int n = 0;
        while (n < this._porttypes.length) {
            if (this._porttypes[n] != null) {
                stringArray = this._porttypes[n].findInvalidRMI();
            }
            if (stringArray != null) break;
            ++n;
        }
        return stringArray;
    }

    public void createSoapService(String string) {
    }

    public void makeAdjustments() {
        int n = 0;
        while (n < this._porttypes.length) {
            if (this._porttypes[n] != null) {
                this._porttypes[n].makeAdjustments();
            }
            ++n;
        }
    }

    public void addSoapBinding(String string, boolean bl, String string2, String string3, boolean bl2, String string4, String string5, String string6) {
        ASTService[] aSTServiceArray;
        Object object;
        Object object2;
        String string7;
        if (this._porttypes == null || this._porttypes.length < 1 || this._porttypes[0] == null) {
            return;
        }
        String string8 = this._porttypes[0].getName();
        String string9 = this._porttypes[0].getClassName();
        if (string9.indexOf(".") != -1) {
            string9 = string9.substring(string9.lastIndexOf(".") + 1);
        }
        String string10 = this._porttypes[0].getNsURI();
        String string11 = string8;
        ASTSoapBinding aSTSoapBinding = new ASTSoapBinding(string10, string11, string8, string9, string2, bl ? "document" : "rpc");
        ASTOperation[] aSTOperationArray = this._porttypes[0].getOperations();
        Vector<Object> vector = new Vector<Object>();
        if (aSTOperationArray != null && aSTOperationArray.length > 0) {
            int n = 0;
            while (n < aSTOperationArray.length) {
                if (aSTOperationArray[n] != null) {
                    string7 = aSTOperationArray[n].getName();
                    object2 = string3 != null ? string3 : string5 + "/" + string7;
                    object = new ASTSoapOperation(string10, string7, aSTOperationArray[n].getMangledName(), (String)object2, aSTSoapBinding.getStyle());
                    ((ASTOperation)object).setMethodName(string7);
                    if (aSTOperationArray[n].hasInput()) {
                        if (string4 == null) {
                            string4 = "http://schemas.xmlsoap.org/soap/encoding/";
                        }
                        aSTServiceArray = new ASTSoapBodyMessage(aSTOperationArray[n].getInput(), bl2 ? "literal" : "encoded", string4, null);
                        ((ASTOperation)object).setInput((ASTMessage)aSTServiceArray, false);
                    }
                    if (aSTOperationArray[n].hasOutput()) {
                        aSTServiceArray = new ASTSoapBodyMessage(aSTOperationArray[n].getOutput(), bl2 ? "literal" : "encoded", string4, null);
                        ((ASTOperation)object).setOutput((ASTMessage)aSTServiceArray, false);
                    }
                    if (aSTOperationArray[n].hasFaults()) {
                        aSTServiceArray = aSTOperationArray[n].getFaults();
                        ASTMessage[] aSTMessageArray = new ASTSoapFaultMessage[aSTServiceArray.length];
                        int n2 = 0;
                        while (n2 < aSTMessageArray.length) {
                            aSTMessageArray[n2] = new ASTSoapFaultMessage((ASTMessage)((Object)aSTServiceArray[n2]), bl2 ? "literal" : "encoded", string4, null);
                            ++n2;
                        }
                        ((ASTOperation)object).setFaults(aSTMessageArray);
                    }
                    vector.add(object);
                }
                ++n;
            }
        }
        aSTSoapBinding.initOperations(vector.size());
        ASTOperation[] aSTOperationArray2 = new ASTSoapOperation[vector.size()];
        aSTOperationArray2 = vector.toArray(aSTOperationArray2);
        aSTSoapBinding.setOperations(aSTOperationArray2);
        string7 = string8 + "Port";
        object2 = new ASTSoapPort(new ASTPort(string10, string7, aSTSoapBinding), string);
        object = null;
        object = string6 != null && string6.length() > 0 ? (string8.indexOf(".") > 0 ? string8.substring(0, string8.lastIndexOf(".") + 1) + string6 : string6) : string8 + "Service";
        aSTServiceArray = new ASTService[]{new ASTService(string10, (String)object)};
        aSTServiceArray[0].initPorts(1);
        aSTServiceArray[0].addPort((ASTPort)object2);
        this.setServices(aSTServiceArray);
    }

    public Properties getTypeMappings() {
        return this._typeMap;
    }

    public void setTypeMappings(Properties properties) {
        this._typeMap = properties;
    }

    public boolean hasTypeMappings() {
        return this._typeMap != null && ((Hashtable)this._typeMap).size() > 0;
    }

    public URL getWSDLDocument() {
        return this._wsdlDocument;
    }

    public void setWSDLDocument(URL uRL) {
        this._wsdlDocument = uRL;
    }

    public HashSet getPkgsWithHolders() {
        return this._pkgsWithHolders;
    }

    public void setPkgsWithHolders(HashSet hashSet) {
        this._pkgsWithHolders = hashSet;
    }

    public boolean getStatus() {
        return this._compileStatus;
    }

    public void setStatus(boolean bl) {
        this._compileStatus = bl;
    }
}

