/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTPart;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class ASTMessage {
    private String _nsURI;
    private String _name;
    private String _doc;
    private ASTPart[] _parts;
    private int _mode;
    private String _modedoc;
    private String _className;
    private String _faultName;
    private boolean _complexFault;

    public ASTMessage(QName qName) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public ASTMessage(String string, String string2) {
        this._nsURI = string;
        this._name = string2;
        this._parts = new ASTPart[0];
        this._doc = null;
        this._mode = 1;
        this._modedoc = null;
    }

    public String getNsURI() {
        return this._nsURI;
    }

    public void setNsURI(String string) {
        this._nsURI = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public QName getQName() {
        return new QName(this._nsURI, this._name);
    }

    public ASTPart[] getParts() {
        return this._parts;
    }

    public void setParts(ASTPart[] aSTPartArray) {
        this._parts = aSTPartArray != null ? aSTPartArray : new ASTPart[]{};
    }

    public void initParts(int n) {
        this._parts = new ASTPart[n < 0 ? 0 : n];
    }

    public boolean addPart(ASTPart aSTPart) {
        if (this._parts == null) {
            this._parts = new ASTPart[1];
            this._parts[0] = aSTPart;
            return true;
        }
        int n = 0;
        while (n < this._parts.length && this._parts[n] != null) {
            if (!this._parts[n++].equals(aSTPart)) continue;
            return false;
        }
        if (n < this._parts.length) {
            this._parts[n] = aSTPart;
        } else {
            ASTPart[] aSTPartArray = new ASTPart[this._parts.length + 1];
            int n2 = 0;
            n2 = 0;
            while (n2 < this._parts.length) {
                aSTPartArray[n2] = this._parts[n2];
                ++n2;
            }
            aSTPartArray[n2] = aSTPart;
            this._parts = aSTPartArray;
        }
        return true;
    }

    public boolean removePart(String string) {
        if (this._parts == null || string == null) {
            return false;
        }
        int n = this._parts.length;
        int n2 = 0;
        while (n2 < this._parts.length) {
            if (this._parts[n2] != null && this._parts[n2].getName().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == this._parts.length) {
            return false;
        }
        ASTPart[] aSTPartArray = new ASTPart[this._parts.length - 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this._parts.length) {
            if (n4 != n) {
                aSTPartArray[n3++] = this._parts[n4];
            }
            ++n4;
        }
        this._parts = aSTPartArray;
        return true;
    }

    public boolean hasParts() {
        return this._parts != null && this._parts.length > 0 && this._parts[0] != null;
    }

    public boolean hasPart(String string) {
        if (this._parts == null) {
            return false;
        }
        int n = 0;
        while (n < this._parts.length) {
            if (this._parts[n] != null && this._parts[n].getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ASTPart getPart(String string, String string2) {
        if (this._parts == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this._parts.length) {
            if (this._parts[n] != null && this._parts[n].getName().equals(string) && this._parts[n].getDataType().equals(string2)) {
                return this._parts[n];
            }
            ++n;
        }
        return null;
    }

    public ASTPart getPart(String string) {
        if (this._parts == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this._parts.length) {
            if (this._parts[n] != null && this._parts[n].getName().equals(string)) {
                return this._parts[n];
            }
            ++n;
        }
        return null;
    }

    public ASTPart getPart(int n) {
        if (this._parts == null || n < 0 || n >= this._parts.length) {
            return null;
        }
        return this._parts[n];
    }

    public int numParts() {
        return this._parts == null ? 0 : this._parts.length;
    }

    public void setDoc(String string) {
        this._doc = string;
    }

    public String getDoc() {
        return this._doc;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int n, boolean bl) {
        this._mode = n;
        if (this._parts == null || !bl) {
            return;
        }
        int n2 = 0;
        while (n2 < this._parts.length) {
            if (this._parts[n2] != null) {
                this._parts[n2].setMode(n);
            }
            ++n2;
        }
    }

    public void setModeDoc(String string) {
        this._modedoc = string;
    }

    public String getModeDoc() {
        return this._modedoc;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public String getFaultName() {
        return this._faultName;
    }

    public void setFaultName(String string) {
        this._faultName = string;
    }

    public boolean getComplexTypeFault() {
        return this._complexFault;
    }

    public void setComplexTypeFault(boolean bl) {
        this._complexFault = bl;
    }

    public boolean equals(String string, String string2) {
        return this._nsURI.equals(string) && this._name.equals(string2);
    }

    public boolean equals(ASTMessage aSTMessage) {
        return aSTMessage == null ? false : this.equals(aSTMessage.getNsURI(), aSTMessage.getName());
    }

    public ASTMessage returnCopy() {
        ASTMessage aSTMessage = new ASTMessage(this.getNsURI(), this.getName());
        aSTMessage.initParts(this.numParts());
        int n = 0;
        while (n < this.numParts()) {
            if (this._parts[n] != null) {
                aSTMessage.addPart(this._parts[n].returnCopy());
            }
            ++n;
        }
        aSTMessage.setDoc(this.getDoc());
        aSTMessage.setMode(this.getMode(), true);
        aSTMessage.setModeDoc(this.getModeDoc());
        aSTMessage.setClassName(this.getClassName());
        aSTMessage.setFaultName(this.getFaultName());
        aSTMessage.setComplexTypeFault(this.getComplexTypeFault());
        return aSTMessage;
    }

    public String toString() {
        String string = "{Message=NS:" + this._nsURI + ",N:" + this._name + ",M:" + this._mode;
        if (this._parts != null) {
            int n = 0;
            while (n < this._parts.length) {
                if (this._parts[n] != null) {
                    string = string + this._parts[n].toString();
                    if (n != this._parts.length - 1) {
                        string = string + ",";
                    }
                }
                ++n;
            }
        }
        string = string + "}";
        return string;
    }

    public boolean hasInvalidRMI() {
        if (this._mode != 4 || !this.hasParts()) {
            return false;
        }
        int n = 0;
        while (n < this._parts.length) {
            if (this._parts[n] != null && this._parts[n].isRemote()) break;
            ++n;
        }
        return n >= this._parts.length;
    }

    public boolean isVoid() {
        return !this.hasReturnType();
    }

    public Hashtable getPartsTable() {
        Hashtable<String, ASTPart> hashtable = new Hashtable<String, ASTPart>();
        int n = 0;
        while (n < this.numParts()) {
            if (this._parts[n] != null) {
                hashtable.put(this._parts[n].getName(), this._parts[n]);
            }
            ++n;
        }
        return hashtable;
    }

    public void switchParts(int n, int n2) {
        if (n <= this.numParts() && n2 <= this.numParts()) {
            ASTPart aSTPart = this._parts[n];
            this._parts[n] = this._parts[n2];
            this._parts[n2] = aSTPart;
        }
    }

    public void movePart(int n, int n2) {
        if (n <= n2) {
            return;
        }
        if (n <= this.numParts() && n2 <= this.numParts() && n > 0 && n2 > -1) {
            ASTPart aSTPart = this._parts[n];
            int n3 = n;
            while (n3 > n2) {
                this._parts[n3] = this._parts[n3 - 1];
                --n3;
            }
            this._parts[n2] = aSTPart;
        }
    }

    public int numOutParameters() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < aSTPartArray.length) {
            int n3;
            if (aSTPartArray[n2] != null && (n3 = aSTPartArray[n2].getMode()) == 2) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int numInOutParameters() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < aSTPartArray.length) {
            int n3;
            if (aSTPartArray[n2] != null && (n3 = aSTPartArray[n2].getMode()) == 3) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean hasOutParameters() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return false;
        }
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < aSTPartArray.length) {
            if (aSTPartArray[n3] != null) {
                if (aSTPartArray[n3].getMode() == 2) {
                    ++n;
                    n2 = n3;
                }
                if (n > 1) {
                    return true;
                }
            }
            ++n3;
        }
        return n == 1 && aSTPartArray[n2].getParameterOrder() > 0;
    }

    public boolean hasReturnType() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < aSTPartArray.length) {
            if (aSTPartArray[n2] != null) {
                if (aSTPartArray[n2].getMode() == 2 && aSTPartArray[n2].getParameterOrder() == 0) {
                    ++n;
                }
                if (n > 1) {
                    return false;
                }
            }
            ++n2;
        }
        return n == 1;
    }

    public String getMangledName() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && (this._mode == 1 || this._mode == 2 && aSTPartArray[n].getMode() == 2)) {
                string = string + "__" + aSTPartArray[n].getMangledName();
            }
            ++n;
        }
        return string;
    }

    public int outputInterface(FileWriter fileWriter, int n) throws IOException {
        int n2 = n;
        switch (this._mode) {
            case 1: {
                int n3 = 0;
                while (n3 < this.numParts()) {
                    if (n2++ > 0) {
                        fileWriter.write(", ");
                    }
                    ASTPart aSTPart = this.getPart(n3);
                    fileWriter.write(aSTPart.getDataType());
                    fileWriter.write(" " + aSTPart.getJavafiedName());
                    ++n3;
                }
                break;
            }
            case 2: {
                if (!this.hasOutParameters()) break;
                int n4 = 0;
                while (n4 < this.numParts()) {
                    ASTPart aSTPart = this.getPart(n4);
                    if (aSTPart.getMode() == 2) {
                        if (n2++ > 0) {
                            fileWriter.write(", ");
                        }
                        fileWriter.write(aSTPart.getDataType());
                        fileWriter.write(" " + aSTPart.getJavafiedName());
                    }
                    ++n4;
                }
                break;
            }
        }
        return n2;
    }
}

