/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.Util;
import com.sssw.jbroker.util.CodeGenUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class ASTOperation {
    private String _nsURI;
    private String _name;
    private String _methodName;
    private String _mangledName;
    private String _doc;
    private ASTMessage _input;
    private ASTMessage _output;
    private ASTMessage[] _faults;
    private String _parameterorder;

    public ASTOperation(QName qName) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public ASTOperation(String string, String string2) {
        this(string, string2, null, null, null);
    }

    public ASTOperation(String string, String string2, ASTMessage aSTMessage, ASTMessage aSTMessage2, ASTMessage[] aSTMessageArray) {
        this._nsURI = string;
        this._name = string2;
        this._input = aSTMessage;
        if (this._input != null) {
            this._input.setMode(1, false);
        }
        this._output = aSTMessage2;
        if (this._output != null) {
            this._output.setMode(2, false);
        }
        this._faults = aSTMessageArray;
        if (this._faults != null) {
            int n = 0;
            while (n < this._faults.length) {
                if (this._faults[n] != null) {
                    this._faults[n].setMode(4, true);
                }
                ++n;
            }
        } else {
            this._faults = new ASTMessage[0];
        }
        this._methodName = CodeGenUtil.fixMethodName(string2);
        this._doc = null;
        this._parameterorder = null;
    }

    public ASTOperation(String string, Method method, String string2) {
        this(string, method.getName(), ASTOperation.getDefaultInput(string, method, string2), ASTOperation.getDefaultOutput(string, method, string2), ASTOperation.getDefaultFaults(string, method));
        int n;
        this.setMangledName(string2);
        this.setMethodName(method.getName());
        ASTMessage aSTMessage = this.getInput();
        if (aSTMessage != null && (n = aSTMessage.numInOutParameters()) > 0) {
            Object object;
            ASTMessage aSTMessage2 = this.getOutput();
            if (aSTMessage2 == null) {
                object = aSTMessage.getName();
                if (object.lastIndexOf("Request") != -1) {
                    object = object.substring(0, object.lastIndexOf("Request"));
                }
                aSTMessage2 = new ASTMessage(aSTMessage.getNsURI(), (String)object + "Response");
                this.setOutput(aSTMessage2, true);
            }
            if (aSTMessage2.getParts() == null || aSTMessage2.getParts().length == 0) {
                aSTMessage2.initParts(n);
            }
            object = aSTMessage.getParts();
            int n2 = 0;
            while (n2 < ((ASTPart[])object).length) {
                if (object[n2].getMode() == 3) {
                    aSTMessage2.addPart(object[n2].returnCopy());
                }
                ++n2;
            }
        }
    }

    public void setNsURI(String string) {
        this._nsURI = string;
    }

    public String getNsURI() {
        return this._nsURI;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setMethodName(String string) {
        this._methodName = string;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMangledName() {
        this._mangledName = this.mangleName();
    }

    public void setMangledName(String string) {
        this._mangledName = string;
    }

    public String getMangledName() {
        return this._mangledName;
    }

    public QName getQName() {
        return new QName(this._nsURI, this._name);
    }

    public void setInput(ASTMessage aSTMessage, boolean bl) {
        this._input = aSTMessage;
        if (this._input != null && bl) {
            this._input.setMode(1, bl);
        }
    }

    public void copyInput(ASTMessage aSTMessage, boolean bl) {
        this.setInput(aSTMessage == null ? null : aSTMessage.returnCopy(), bl);
    }

    public ASTMessage getInput() {
        return this._input;
    }

    public int numInputParts() {
        return this._input == null ? 0 : this._input.numParts();
    }

    public void setOutput(ASTMessage aSTMessage, boolean bl) {
        this._output = aSTMessage;
        if (this._output != null && bl) {
            this._output.setMode(2, bl);
        }
    }

    public void copyOutput(ASTMessage aSTMessage, boolean bl) {
        this.setOutput(aSTMessage == null ? null : aSTMessage.returnCopy(), bl);
    }

    public ASTMessage getOutput() {
        return this._output;
    }

    public int numOutputParts() {
        return this._output == null ? 0 : this._output.numParts();
    }

    public void setFaults(ASTMessage[] aSTMessageArray) {
        this._faults = aSTMessageArray == null ? new ASTMessage[]{} : aSTMessageArray;
        int n = 0;
        while (n < this._faults.length) {
            if (this._faults[n] != null) {
                this._faults[n].setMode(4, true);
                this._faults[n].setNsURI(this.getNsURI());
            }
            ++n;
        }
    }

    public ASTMessage[] getFaults() {
        return this._faults;
    }

    public void initFaults(int n) {
        this._faults = new ASTMessage[n < 0 ? 0 : n];
    }

    public boolean addFault(ASTMessage aSTMessage) {
        if (aSTMessage == null || this._faults == null) {
            return false;
        }
        int n = 0;
        while (n < this._faults.length && this._faults[n] != null) {
            if (!this._faults[n++].equals(aSTMessage)) continue;
            return false;
        }
        if (n >= this._faults.length) {
            return false;
        }
        this._faults[n] = aSTMessage;
        this._faults[n].setMode(4, true);
        return true;
    }

    public void copyFault(ASTMessage aSTMessage) {
        this.addFault(aSTMessage.returnCopy());
    }

    public boolean hasInput() {
        return this._input != null;
    }

    public boolean hasOutput() {
        return this._output != null;
    }

    public boolean hasFaults() {
        return this._faults != null && this._faults.length > 0 && this._faults[0] != null;
    }

    public int numFaults() {
        return this._faults == null ? 0 : this._faults.length;
    }

    public void setDoc(String string) {
        this._doc = string;
    }

    public String getDoc() {
        return this._doc;
    }

    public int setParameterOrder(String string) {
        this._parameterorder = string;
        return string != null && string.length() > 0 ? this.reArrangeParameters() : -1;
    }

    public String getParameterOrder() {
        return this._parameterorder;
    }

    public ASTOperation returnCopy() {
        ASTOperation aSTOperation = new ASTOperation(this.getNsURI(), this.getName());
        aSTOperation.setDoc(this.getDoc());
        aSTOperation.setMethodName(this.getMethodName());
        aSTOperation.setMangledName(this.getMangledName());
        if (this._input != null) {
            aSTOperation.copyInput(this.getInput(), false);
        }
        if (this._output != null) {
            aSTOperation.copyOutput(this.getOutput(), false);
        }
        if (this._faults != null) {
            aSTOperation.initFaults(this._faults.length);
            int n = 0;
            while (n < this._faults.length) {
                if (this._faults[n] != null) {
                    aSTOperation.copyFault(this._faults[n]);
                }
                ++n;
            }
        }
        return aSTOperation;
    }

    public String toString() {
        String string = "{OPER=NS:" + this._nsURI + ",N:" + this._name;
        if (this._input != null) {
            string = string + ",IP:" + this._input.toString();
        }
        if (this._output != null) {
            string = string + ",OP:" + this._output.toString();
        }
        if (this._faults != null) {
            int n = 0;
            while (n < this._faults.length) {
                if (this._faults[n] != null) {
                    string = string + ",FLT:" + this._faults[n].toString();
                }
                ++n;
            }
        }
        string = string + "}";
        return string;
    }

    public boolean equals(String string, String string2) {
        return this._nsURI.equals(string) && this._name.equals(string2);
    }

    public boolean equals(ASTOperation aSTOperation) {
        return aSTOperation == null ? false : this.equals(aSTOperation.getNsURI(), aSTOperation.getName());
    }

    public boolean isVoid() {
        return this._output == null || !this._output.hasReturnType();
    }

    public String getReturnType() {
        if (this.isVoid()) {
            return "void";
        }
        ASTPart[] aSTPartArray = this._output.getParts();
        if (aSTPartArray == null) {
            return "void";
        }
        int n = 0;
        while (n < aSTPartArray.length) {
            int n2;
            if (aSTPartArray[n] != null && (n2 = aSTPartArray[n].getMode()) == 2) {
                return aSTPartArray[n].getDataType();
            }
            ++n;
        }
        return "void";
    }

    public void outputInterface(FileWriter fileWriter, String string) throws IOException {
        fileWriter.write("    " + this.getReturnType());
        fileWriter.write(" " + this.getMethodName() + "(");
        int n = 0;
        if (this._input != null) {
            n = this._input.outputInterface(fileWriter, n);
        }
        if (this._output != null) {
            n = this._output.outputInterface(fileWriter, n);
        }
        fileWriter.write(")\n        throws ");
        if (this._faults != null) {
            int n2 = 0;
            while (n2 < this._faults.length) {
                if (this._faults[n2].getComplexTypeFault()) {
                    fileWriter.write(this._faults[n2].getPart(0).getDataType());
                } else {
                    String string2 = this._faults[n2].getClassName();
                    String string3 = string != null && string.trim().length() > 0 ? string + "." + string2 : string2;
                    fileWriter.write(string3);
                }
                if (n2 != this._faults.length - 1) {
                    fileWriter.write(", ");
                }
                ++n2;
            }
        }
        fileWriter.write(";\n");
    }

    private static ASTMessage getDefaultInput(String string, Method method, String string2) {
        Class<?>[] classArray = method.getParameterTypes();
        ASTPart[] aSTPartArray = new ASTPart[classArray.length];
        int n = 0;
        while (n < aSTPartArray.length) {
            aSTPartArray[n] = new ASTPart("arg" + n, null, false, 1, classArray[n]);
            ++n;
        }
        ASTMessage aSTMessage = new ASTMessage(string, string2 + "Request");
        aSTMessage.setParts(aSTPartArray);
        aSTMessage.setMode(1, false);
        return aSTMessage;
    }

    private static ASTMessage getDefaultOutput(String string, Method method, String string2) {
        String string3 = Util.getClassName(method.getReturnType());
        ASTMessage aSTMessage = new ASTMessage(string, string2 + "Response");
        ASTPart[] aSTPartArray = string3.equals("void") ? null : new ASTPart[]{new ASTPart("result", null, false, 2, method.getReturnType())};
        aSTMessage.setParts(aSTPartArray);
        aSTMessage.setMode(2, true);
        return aSTMessage;
    }

    private static ASTMessage[] getDefaultFaults(String string, Method method) {
        Class[] classArray = method.getExceptionTypes();
        Util.orderClasses(classArray);
        ASTMessage[] aSTMessageArray = new ASTMessage[classArray.length];
        int n = 0;
        while (n < aSTMessageArray.length) {
            ASTPart[] aSTPartArray = new ASTPart[1];
            String string2 = Util.getLocalName(classArray[n].getName(), ".");
            aSTPartArray[0] = new ASTPart(string2, null, false, 4, classArray[n]);
            aSTMessageArray[n] = new ASTMessage(string, Util.getLocalName(classArray[n].getName(), "."));
            aSTMessageArray[n].setParts(aSTPartArray);
            aSTMessageArray[n].setMode(4, true);
            aSTMessageArray[n].setClassName(classArray[n].getName());
            aSTMessageArray[n].setFaultName(aSTMessageArray[n].getName());
            aSTMessageArray[n].setComplexTypeFault(true);
            ++n;
        }
        return aSTMessageArray;
    }

    public String findInvalidRMI() {
        if (!this.hasFaults()) {
            return null;
        }
        int n = 0;
        while (n < this._faults.length) {
            if (this._faults[n] != null && !this._faults[n].hasInvalidRMI()) break;
            ++n;
        }
        return n < this._faults.length ? null : this.getName();
    }

    public String setInputOutput(ASTMessage aSTMessage, ASTMessage aSTMessage2) {
        QName qName;
        ASTPart aSTPart;
        int n = aSTMessage == null ? 0 : aSTMessage.numParts();
        int n2 = aSTMessage2 == null ? 0 : aSTMessage2.numParts();
        this.copyInput(aSTMessage, true);
        this.copyOutput(aSTMessage2, true);
        int n3 = 0;
        while (n3 < n2) {
            ASTPart aSTPart2 = this._output.getPart(n3);
            ASTPart aSTPart3 = aSTPart = this._input == null ? null : this._input.getPart(aSTPart2.getName(), aSTPart2.getDataType());
            if (aSTPart != null) {
                qName = aSTPart.getQName();
                QName qName2 = aSTPart2.getQName();
                boolean bl = false;
                if (qName == null && qName2 == null) {
                    bl = true;
                } else if (qName != null && qName2 != null && qName.equals(qName2)) {
                    bl = true;
                }
                if (bl) {
                    aSTPart.setMode(3);
                    aSTPart2.setMode(3);
                } else {
                    aSTPart2.setName(aSTPart2.getName() + "out");
                }
            }
            ++n3;
        }
        if (!this.hasOutParameters()) {
            return null;
        }
        int n4 = 0;
        while (n4 < n2) {
            aSTPart = this._output.getPart(n4);
            if (aSTPart.getMode() != 3) {
                QName qName3 = qName = this._input == null ? null : this._input.getPart(aSTPart.getName());
                if (qName != null) {
                    return ((ASTPart)((Object)qName)).getName();
                }
            }
            ++n4;
        }
        return null;
    }

    public String mangleName() {
        String string = this.getName();
        if (this.hasInput()) {
            string = string + this._input.getMangledName();
        }
        if (this.hasOutParameters()) {
            string = string + this._output.getMangledName();
        }
        return string;
    }

    public void makeAdjustments() {
        boolean bl = false;
        int n = 0;
        while (n < this._faults.length) {
            if (this._faults[n] != null && this._faults[n].getName().equals("RemoteException")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            ASTMessage[] aSTMessageArray = new ASTMessage[this._faults.length + 1];
            int n2 = 0;
            while (n2 < this._faults.length) {
                aSTMessageArray[n2] = this._faults[n2].returnCopy();
                ++n2;
            }
            aSTMessageArray[this._faults.length] = new ASTMessage(this.getNsURI(), "RemoteException");
            aSTMessageArray[this._faults.length].setClassName("java.rmi.RemoteException");
            aSTMessageArray[this._faults.length].setFaultName("RemoteException");
            aSTMessageArray[this._faults.length].setComplexTypeFault(true);
            aSTMessageArray[this._faults.length].initParts(1);
            ASTPart aSTPart = new ASTPart("RemoteException");
            aSTPart.setDataType("java.rmi.RemoteException");
            aSTMessageArray[this._faults.length].addPart(aSTPart);
            this.setFaults(aSTMessageArray);
        }
    }

    public boolean hasOutParameters() {
        return this._output == null ? false : this._output.hasOutParameters();
    }

    public boolean throwsApplicationException() {
        if (this._faults == null) {
            return false;
        }
        int n = 0;
        while (n < this._faults.length) {
            ASTPart[] aSTPartArray;
            if (this._faults[n] != null && !this._faults[n].getName().equals("RemoteException") && (aSTPartArray = this._faults[n].getParts()) != null) {
                int n2 = 0;
                while (n2 < aSTPartArray.length) {
                    if (aSTPartArray[n2] != null && !aSTPartArray[n2].isRemote()) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    public int reArrangeParameters() {
        int n = this.numInputParts();
        int n2 = this.numOutputParts();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this._parameterorder);
        while (stringTokenizer.hasMoreTokens()) {
            int n6;
            String string = stringTokenizer.nextToken();
            ++n5;
            if (n3 < n) {
                n6 = n3;
                while (n6 < n) {
                    if (this._input.getPart(n6).getName().equals(string)) {
                        this._input.getPart(n6).setParameterOrder(n5);
                        this._input.movePart(n6, n3++);
                    }
                    ++n6;
                }
            }
            if (n4 >= n2) continue;
            n6 = n4;
            while (n6 < n2) {
                if (this._output.getPart(n6).getName().equals(string)) {
                    boolean bl = true;
                    if (this._output.getPart(n6).getMode() == 2) {
                        ASTPart aSTPart;
                        ASTPart aSTPart2 = aSTPart = this._input == null ? null : this._input.getPart(this._output.getPart(n6).getName());
                        if (aSTPart != null) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        this._output.getPart(n6).setParameterOrder(n5);
                        this._output.movePart(n6, n4++);
                    }
                }
                ++n6;
            }
        }
        return n3;
    }
}

