/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.Util;
import com.sssw.jbroker.util.CodeGenUtil;
import com.sssw.jbroker.util.xml.Namespace;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.xml.namespace.QName;

public class ASTPortType {
    private String _nsURI;
    private String _name;
    private String _className;
    private String _doc;
    private ASTOperation[] _operations;
    private boolean _generateInterface;

    public ASTPortType(Class clazz, String string) {
        this._nsURI = string != null ? string : Namespace.getNamespaceURI(clazz);
        this._name = clazz.getName();
        this._operations = ASTPortType.getOperationsFromClass(clazz, string);
        this._className = clazz.getName();
        this._generateInterface = false;
    }

    public ASTPortType(QName qName) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public ASTPortType(String string, String string2) {
        this(string, string2, new ASTOperation[0]);
    }

    public ASTPortType(String string, String string2, ASTOperation[] aSTOperationArray) {
        this._nsURI = string;
        this._name = string2;
        this._operations = aSTOperationArray == null ? new ASTOperation[]{} : aSTOperationArray;
        this._className = CodeGenUtil.fixClassName(string2);
        this._generateInterface = false;
    }

    public String getNsURI() {
        return this._nsURI;
    }

    public void setNsURI(String string) {
        this._nsURI = string;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public QName getQName() {
        return new QName(this._nsURI, this._name);
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public String getClassName() {
        return this._className;
    }

    public void setDoc(String string) {
        this._doc = string;
    }

    public String getDoc() {
        return this._doc;
    }

    public ASTOperation[] getOperations() {
        return this._operations;
    }

    public void setOperations(ASTOperation[] aSTOperationArray) {
        this._operations = aSTOperationArray == null ? new ASTOperation[]{} : aSTOperationArray;
    }

    public void initOperations(int n) {
        this._operations = new ASTOperation[n < 0 ? 0 : n];
    }

    public boolean addOperation(ASTOperation aSTOperation) {
        if (this._operations == null || aSTOperation == null) {
            return false;
        }
        int n = 0;
        while (n < this._operations.length && this._operations[n] != null) {
            if (!this._operations[n++].equals(aSTOperation)) continue;
            return false;
        }
        if (n >= this._operations.length) {
            return false;
        }
        this._operations[n] = aSTOperation;
        return true;
    }

    public boolean hasOperations() {
        return this._operations != null && this._operations.length > 0 && this._operations[0] != null;
    }

    public ASTOperation getOperation(String string) {
        if (this._operations == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this._operations.length) {
            if (this._operations[n].getName().equals(string)) {
                return this._operations[n];
            }
            ++n;
        }
        return null;
    }

    public ASTOperation getOperation(String string, String string2, String string3) throws Exception {
        int n = 0;
        int n2 = -1;
        if (this._operations == null || string == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < this._operations.length) {
            if (this._operations[n3].getName().equals(string) && (string2 == null || string2.length() <= 0 || this._operations[n3].hasInput() && string2.equals(this._operations[n3].getInput().getName())) && (string3 == null || string3.length() <= 0 || this._operations[n3].hasOutput() && string3.equals(this._operations[n3].getOutput().getName()))) {
                ++n;
                n2 = n3;
            }
            ++n3;
        }
        if (n > 1) {
            throw new Exception("Multiple operations");
        }
        return n2 == -1 ? null : this._operations[n2];
    }

    public String toString() {
        String string = "{PTYPE=NS:" + this._nsURI + ",N:" + this._name;
        if (this._operations != null) {
            int n = 0;
            while (n < this._operations.length) {
                string = string + "\n " + this._operations[n].toString();
                ++n;
            }
        }
        string = string + "\n}";
        return string;
    }

    public int numOperations() {
        return this._operations == null ? 0 : this._operations.length;
    }

    public boolean equals(String string, String string2) {
        return this._nsURI.equals(string) && this._name.equals(string2);
    }

    public boolean equals(ASTPortType aSTPortType) {
        return aSTPortType == null ? false : this.equals(aSTPortType.getNsURI(), aSTPortType.getName());
    }

    public void outputInterface(FileWriter fileWriter, String string, String string2, String string3) throws IOException {
        fileWriter.write("// Generated from " + string + "\n");
        fileWriter.write("// On " + new Date().toString() + "\n\n");
        if (string3 != null && string3.length() > 0) {
            fileWriter.write("package " + string3 + ";\n\n");
        }
        fileWriter.write("public interface " + string2 + "\n");
        fileWriter.write("    extends java.rmi.Remote\n{\n");
        int n = 0;
        while (n < this._operations.length) {
            if (this._operations[n] != null) {
                this._operations[n].outputInterface(fileWriter, string3);
                if (n < this._operations.length - 1) {
                    fileWriter.write("\n");
                }
            }
            ++n;
        }
        fileWriter.write("}\n");
        fileWriter.flush();
    }

    private static ASTOperation[] getOperationsFromClass(Class clazz, String string) {
        Class[] classArray = CodeGenUtil.getAllRemoteInterfaces(clazz);
        Method[] methodArray = CodeGenUtil.getUniqueMethods(classArray);
        String string2 = string != null ? string : Namespace.getNamespaceURI(clazz);
        ASTOperation[] aSTOperationArray = new ASTOperation[methodArray.length];
        int n = 0;
        while (n < methodArray.length) {
            aSTOperationArray[n] = new ASTOperation(string2, methodArray[n], Util.getLocalName(methodArray[n], methodArray));
            ++n;
        }
        return aSTOperationArray;
    }

    public String[] findInvalidRMI() {
        if (!this.hasOperations()) {
            return null;
        }
        String string = null;
        int n = 0;
        while (n < this._operations.length) {
            if (this._operations[n] != null) {
                string = this._operations[n].findInvalidRMI();
            }
            if (string != null) break;
            ++n;
        }
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{this.getName(), string};
        return stringArray;
    }

    public void makeAdjustments() {
        if (this._operations == null) {
            return;
        }
        int n = 0;
        while (n < this._operations.length) {
            if (this._operations[n] != null) {
                this._operations[n].makeAdjustments();
            }
            ++n;
        }
    }

    public boolean getGenerateInterface() {
        return this._generateInterface;
    }

    public void setGenerateInterface(boolean bl) {
        this._generateInterface = bl;
    }
}

