/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.Util;
import com.sssw.jbroker.util.CodeGenUtil;

public class ASTService {
    String _nsURI;
    String _name;
    String _doc;
    ASTPort[] _ports;

    public ASTService(String string, String string2) {
        this(string, string2, new ASTPort[0]);
    }

    public ASTService(String string, String string2, ASTPort[] aSTPortArray) {
        this._nsURI = string;
        this._name = string2;
        this._ports = aSTPortArray == null ? new ASTPort[]{} : aSTPortArray;
        this._doc = null;
    }

    public void setNsURI(String string) {
        this._nsURI = string;
    }

    public String getNsURI() {
        return this._nsURI;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public String getLocalName() {
        return Util.getLocalName(this._name, ".");
    }

    public void setDoc(String string) {
        this._doc = string;
    }

    public String getDoc() {
        return this._doc;
    }

    public void setPorts(ASTPort[] aSTPortArray) {
        this._ports = aSTPortArray == null ? new ASTPort[]{} : aSTPortArray;
    }

    public ASTPort[] getPorts() {
        return this._ports;
    }

    public boolean addPort(ASTPort aSTPort) {
        if (this._ports == null || aSTPort == null) {
            return false;
        }
        int n = 0;
        while (n < this._ports.length && this._ports[n] != null) {
            if (!this._ports[n++].equals(aSTPort)) continue;
            return false;
        }
        if (n >= this._ports.length) {
            return false;
        }
        this._ports[n] = aSTPort;
        return true;
    }

    public boolean hasPorts() {
        return this._ports != null && this._ports.length > 0 && this._ports[0] != null;
    }

    public int numPorts() {
        return this._ports == null ? 0 : this._ports.length;
    }

    public void initPorts(int n) {
        this._ports = new ASTPort[n < 0 ? 0 : n];
    }

    public String toString() {
        String string = "{SVC=NS:" + this._nsURI + ",N:" + this._name;
        if (this._ports != null) {
            int n = 0;
            while (n < this._ports.length) {
                string = string + "\n" + this._ports[n].toString();
                ++n;
            }
        }
        string = string + "\n}";
        return string;
    }

    public boolean equals(String string, String string2) {
        return this._nsURI.equals(string) && this._name.equals(string2);
    }

    public boolean equals(ASTService aSTService) {
        return aSTService == null ? false : this._nsURI.equals(aSTService.getNsURI()) && this._name.equals(aSTService.getName());
    }

    public String getFileName() {
        String string = Util.getLocalName(this._name, ".");
        return CodeGenUtil.fixClassName(string);
    }

    public String getPackage() {
        String string = Util.getPrefixName(this._name, ".");
        return string == null ? "" : string + ".";
    }
}

