/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPart;
import com.sssw.jbroker.tools.wsdlast.MimeTypes;
import com.sssw.jbroker.tools.wsdlast.SoapHeaderFault;
import com.sssw.jbroker.tools.wsdlast.Util;

public class ASTSoapBodyMessage
extends ASTMessage {
    private int _use;
    private String _encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    private String _namespace;
    private SoapHeaderFault _headerfault;

    public ASTSoapBodyMessage(ASTMessage aSTMessage) {
        super(aSTMessage == null ? null : aSTMessage.getNsURI(), aSTMessage == null ? null : aSTMessage.getName());
        if (aSTMessage == null) {
            return;
        }
        this.initParts(aSTMessage.numParts());
        int n = 0;
        while (n < aSTMessage.numParts()) {
            if (aSTMessage.getPart(n) != null) {
                ASTSoapPart aSTSoapPart = new ASTSoapPart(aSTMessage.getPart(n));
                Class clazz = aSTSoapPart.getJavaClass();
                if (clazz != null && MimeTypes.supportedMimeClass(clazz)) {
                    aSTSoapPart.setMimePart(true);
                    aSTSoapPart.setMimeType(MimeTypes.getMimeType(clazz));
                }
                this.addPart(aSTSoapPart);
            }
            ++n;
        }
        if (aSTMessage.getDoc() != null) {
            this.setDoc(aSTMessage.getDoc());
        }
        this.setMode(aSTMessage.getMode(), false);
        if (aSTMessage.getModeDoc() != null) {
            this.setModeDoc(aSTMessage.getModeDoc());
        }
        this._headerfault = null;
    }

    public ASTSoapBodyMessage(ASTMessage aSTMessage, String string, String string2, String string3) {
        this(aSTMessage);
        this._use = Util.soapEncoding(string);
        this._encodingStyle = string2;
        this._namespace = string3;
    }

    public SoapHeaderFault getHeaderFault() {
        return this._headerfault;
    }

    public void setHeaderFault(SoapHeaderFault soapHeaderFault) {
        this._headerfault = soapHeaderFault;
    }

    public String toString() {
        String string = "{SoapBodyMsg=" + super.toString();
        string = string + "}";
        return string;
    }

    public String getTypePart() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return null;
        }
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && !aSTPartArray[n].isElement()) {
                return aSTPartArray[n].getName();
            }
            ++n;
        }
        return null;
    }

    public String getElementPart() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return null;
        }
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && aSTPartArray[n].isElement()) {
                return aSTPartArray[n].getName();
            }
            ++n;
        }
        return null;
    }

    public boolean hasInOutParameters() {
        return this.numInOutParameters() > 0;
    }

    public String getEncodingString() {
        return Util.soapEncoding(this._use);
    }

    public int getUse() {
        return this._use;
    }

    public void setUse(String string) {
        this._use = Util.soapEncoding(string);
    }

    public String getEncodingStyle() {
        return this._encodingStyle;
    }

    public void setEncodingStyle(String string) {
        this._encodingStyle = string;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setNamespace(String string) {
        this._namespace = string;
    }

    public String getReturnType() {
        if (this.isVoid()) {
            return "void";
        }
        ASTPart[] aSTPartArray = this.getParts();
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && aSTPartArray[n].getMode() == 2 && aSTPartArray[n].getParameterOrder() == 0) {
                return aSTPartArray[n].getDataType();
            }
            ++n;
        }
        return "void";
    }

    public ASTSoapPart getReturnPart() {
        if (this.isVoid()) {
            return null;
        }
        ASTPart[] aSTPartArray = this.getParts();
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && aSTPartArray[n].getMode() == 2 && aSTPartArray[n].getParameterOrder() == 0) {
                return (ASTSoapPart)aSTPartArray[n];
            }
            ++n;
        }
        return null;
    }

    public boolean hasMimePart() {
        ASTPart[] aSTPartArray = this.getParts();
        if (aSTPartArray == null) {
            return false;
        }
        int n = 0;
        while (n < aSTPartArray.length) {
            if (aSTPartArray[n] != null && ((ASTSoapPart)aSTPartArray[n]).getMimePart()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

