/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.tools.wsdlast.ASTMessage;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapFaultMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPart;
import com.sssw.jbroker.tools.wsdlast.Util;

public class ASTSoapOperation
extends ASTOperation {
    private String _action;
    private int _encoding = 2;
    private int _style;
    private String _soapURI;

    public ASTSoapOperation(String string, String string2, String string3) {
        this(string, string2, string3, "\"\"", 1);
    }

    public ASTSoapOperation(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, Util.soapStyle(string5));
    }

    public ASTSoapOperation(String string, String string2, String string3, String string4, int n) {
        super(string, string2);
        this.setMangledName(string3);
        this._action = string4;
        this._style = n;
        this._soapURI = "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String string) {
        this._action = string;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(String string) {
        this._style = Util.soapStyle(string);
    }

    public boolean isDocument() {
        return this._style == 1;
    }

    public boolean isRPC() {
        return this._style == 0;
    }

    public boolean isVoid() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getOutput();
        return aSTSoapBodyMessage == null ? true : aSTSoapBodyMessage.isVoid();
    }

    public int getEncoding() {
        if (this.hasInput()) {
            return ((ASTSoapBodyMessage)this.getInput()).getUse();
        }
        if (this.hasOutput()) {
            return ((ASTSoapBodyMessage)this.getOutput()).getUse();
        }
        ASTMessage[] aSTMessageArray = this.getFaults();
        if (aSTMessageArray != null && aSTMessageArray.length > 0 && aSTMessageArray[0] != null) {
            return ((ASTSoapFaultMessage)aSTMessageArray[0]).getUse();
        }
        return this._encoding;
    }

    public void setEncoding(String string) {
        this._encoding = "literal".equalsIgnoreCase(string) ? 1 : 2;
    }

    public String getEncodingStyle() {
        if (this.hasInput()) {
            return ((ASTSoapBodyMessage)this.getInput()).getEncodingStyle();
        }
        if (this.hasOutput()) {
            return ((ASTSoapBodyMessage)this.getOutput()).getEncodingStyle();
        }
        return null;
    }

    public String getInputEncodingStyle() {
        if (this.hasInput()) {
            return ((ASTSoapBodyMessage)this.getInput()).getEncodingStyle();
        }
        return null;
    }

    public String getOutputEncodingStyle() {
        if (this.hasOutput()) {
            return ((ASTSoapBodyMessage)this.getOutput()).getEncodingStyle();
        }
        return null;
    }

    public String toString() {
        return "{SOAP-OP=A:" + this._action + ",S:" + Util.soapStyle(this._style) + super.toString() + "}";
    }

    public boolean hasOutParameters() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getInput();
        if (aSTSoapBodyMessage != null && aSTSoapBodyMessage.hasInOutParameters()) {
            return true;
        }
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)this.getOutput();
        return aSTSoapBodyMessage2 == null ? false : aSTSoapBodyMessage2.hasOutParameters();
    }

    public String getReturnType() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getOutput();
        return aSTSoapBodyMessage == null ? "void" : aSTSoapBodyMessage.getReturnType();
    }

    public ASTSoapPart getReturnPart() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getOutput();
        return aSTSoapBodyMessage == null ? null : aSTSoapBodyMessage.getReturnPart();
    }

    public boolean hasMimeInput() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getInput();
        return aSTSoapBodyMessage == null ? false : aSTSoapBodyMessage.hasMimePart();
    }

    public boolean hasMimeOutput() {
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)this.getOutput();
        return aSTSoapBodyMessage == null ? false : aSTSoapBodyMessage.hasMimePart();
    }

    public String getSOAPURI() {
        return this._soapURI;
    }

    public void setSOAPURI(String string) {
        this._soapURI = string;
    }
}

