/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.wsdlast;

import com.sssw.jbroker.util.CodeGenUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Util {
    private static final Class[] _primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private static final String[] _primNames = new String[_primitives.length];

    public static int soapEncoding(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("literal")) {
                return 1;
            }
            if (string.equalsIgnoreCase("encoded")) {
                return 2;
            }
        }
        return 2;
    }

    public static String soapEncoding(int n) {
        switch (n) {
            case 1: {
                return "Literal";
            }
            case 2: {
                return "Encoded";
            }
        }
        return "Unknwown";
    }

    public static int soapStyle(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("rpc")) {
                return 0;
            }
            if (string.equalsIgnoreCase("document")) {
                return 1;
            }
            if (string.equalsIgnoreCase("mixed")) {
                return 2;
            }
        }
        return 1;
    }

    public static String soapStyle(int n) {
        switch (n) {
            case 0: {
                return "RPC";
            }
            case 1: {
                return "DOCUMENT";
            }
            case 2: {
                return "MIXED";
            }
        }
        return "Unknwown";
    }

    public static String javafyName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = "";
        string2 = string2 + (Character.isJavaIdentifierStart(string.charAt(0)) ? string.charAt(0) : (char)'_');
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            string2 = string2 + (Character.isJavaIdentifierPart(string.charAt(n2)) ? string.charAt(n2) : (char)'_');
            ++n2;
        }
        return string2;
    }

    public static String getElementType(String string) {
        int n = string.indexOf("[]");
        return n == -1 ? string : string.substring(0, n);
    }

    public static int numDimension(String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("[]")) != -1) {
            ++n2;
            string = string.substring(n + 2);
        }
        return n2;
    }

    public static String getClassName(Class clazz) {
        return clazz.isArray() ? Util.getClassName(clazz.getComponentType()) + "[]" : clazz.getName();
    }

    public static String getPrefixName(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string.lastIndexOf(string2);
        return n == -1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getLocalName(Method method, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            if (method != methodArray[n] && method.getName().equals(methodArray[n].getName())) {
                return Util.getMangledName(method);
            }
            ++n;
        }
        return method.getName();
    }

    public static String getMangledName(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = Util.getClassName(classArray[n]);
            ++n;
        }
        return Util.getMangledName(method.getName(), stringArray);
    }

    public static String getMangledName(String string, String[] stringArray) {
        String string2 = string;
        int n = 0;
        while (n < stringArray.length) {
            string2 = string2 + "__" + Util.getMangledName(stringArray[n]);
            ++n;
        }
        return string2;
    }

    public static String getMangledName(String string) {
        String string2 = "";
        int n = Util.numDimension(string);
        if (n != 0) {
            string2 = string2 + "array" + n + "_";
        }
        string2 = string2 + Util.getElementType(string);
        return string2.replace('.', '_');
    }

    public static void orderClasses(Class[] classArray) {
        int n = 0;
        while (n < classArray.length - 1) {
            int n2 = n + 1;
            while (n2 < classArray.length) {
                if (classArray[n].isAssignableFrom(classArray[n2])) {
                    Class clazz = classArray[n];
                    classArray[n] = classArray[n2];
                    classArray[n2] = clazz;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static boolean isPrimitive(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < _primNames.length) {
            if (string.equals(_primNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static boolean isHolder(Class clazz) {
        Class[] classArray = CodeGenUtil.transitiveClosure(clazz);
        int n = 0;
        while (n < classArray.length) {
            if ("javax.xml.rpc.holders.Holder".equals(classArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static Class reverseHolderType(Class clazz) {
        Field field;
        try {
            field = clazz.getField("value");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = null;
        }
        return field == null ? null : field.getType();
    }

    static {
        int n = 0;
        while (n < _primitives.length) {
            Util._primNames[n] = _primitives[n].getName();
            ++n;
        }
    }
}

