/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.ComplexBeanWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleBeanWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleContentWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleTypeUtil;
import com.sssw.jbroker.tools.xsd2java.ast.ASTClass;
import com.sssw.jbroker.tools.xsd2java.ast.ASTComplexType;
import com.sssw.jbroker.tools.xsd2java.ast.ASTElement;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleContent;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleType;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.util.Map;

public class BeanWriter {
    protected static final String _JLS = "java.lang.String";
    protected boolean _validationRequired;
    protected boolean _final;
    protected static final String _CLASS = "class";
    protected static final String _GET = "get";
    protected static final String _UNDERSCORE = "_";

    public BeanWriter(Map map) {
        this._validationRequired = map.get("novalidate") == null;
        this._final = map.get("final") != null;
    }

    public static void writeBean(ASTClass aSTClass, Map map, Formatter formatter) {
        if (aSTClass.isSimpleContent()) {
            SimpleContentWriter.writeBean((ASTSimpleContent)aSTClass, map, formatter);
        } else if (aSTClass.isComplex()) {
            ComplexBeanWriter.writeBean((ASTComplexType)aSTClass, map, formatter);
        } else {
            SimpleBeanWriter.writeBean((ASTSimpleType)aSTClass, map, formatter);
        }
    }

    private static void writeNoArgConstructor(String string, ASTClass aSTClass, Formatter formatter) {
        formatter.println(string + " " + aSTClass.getName() + "() {}");
        formatter.println();
    }

    public static void writeHashCode(ASTClass aSTClass, Formatter formatter) {
        formatter.println("public int hashCode() { return toString().hashCode(); }");
        formatter.println();
    }

    public void writeBeanProperty(ASTField aSTField, Formatter formatter) {
        if (this._validationRequired && aSTField.getFixed() != null) {
            return;
        }
        BeanWriter.writeBeanReadProperty(aSTField, formatter);
        this.writeSetMethod(aSTField, formatter);
    }

    public void writeBeanProperty(String string, String string2, Formatter formatter) {
        BeanWriter.writeBeanReadProperty(string, string2, formatter);
        BeanWriter.writeSetMethod(string, string2, formatter);
    }

    public static void writeBeanReadProperty(String string, String string2, Formatter formatter) {
        String string3 = _UNDERSCORE + string;
        BeanWriter.writeField("private", string3, string2, null, formatter);
        BeanWriter.writeGetMethod(string3, false, string, string2, formatter);
    }

    public static void writeBeanReadProperty(ASTField aSTField, Formatter formatter) {
        BeanWriter.writeField(aSTField, formatter);
        BeanWriter.writeGetMethod(_UNDERSCORE + aSTField.getName(), false, aSTField, formatter);
    }

    public static void writeField(ASTField aSTField, Formatter formatter) {
        String string = aSTField.getDefault();
        if (string != null) {
            string = aSTField.isEnum() ? aSTField.getClassName() + ".fromString(\"" + string + "\")" : SimpleTypeUtil.getNewSimpleType(aSTField.getClassName(), "\"" + string + "\"");
        }
        BeanWriter.writeField("private", _UNDERSCORE + aSTField.getName(), aSTField.getClassName(), string, formatter);
    }

    public static void writeField(String string, String string2, String string3, String string4, Formatter formatter) {
        formatter.print(string);
        formatter.write(" ");
        formatter.print(string3);
        formatter.write(" ");
        formatter.print(string2);
        if (string4 != null) {
            formatter.write(" = ");
            formatter.write(string4);
        }
        formatter.println(";");
        formatter.println();
    }

    public static void writeGetMethod(String string, boolean bl, ASTField aSTField, Formatter formatter) {
        BeanWriter.writeGetMethod(string, bl, aSTField.getName(), aSTField.getClassName(), formatter);
    }

    public static void writeGetMethod(String string, boolean bl, String string2, String string3, Formatter formatter) {
        formatter.print("public ");
        formatter.print(string3);
        formatter.write(32);
        formatter.print(BeanWriter.getMethodName(string2));
        formatter.print("() {");
        formatter.println();
        formatter.startBlock();
        formatter.print("return ");
        if (bl) {
            formatter.print('(');
            formatter.print(string3);
            formatter.print(')');
        }
        formatter.print(string);
        formatter.println(';');
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeSetMethod(ASTField aSTField, Formatter formatter) {
        String string = aSTField.getName();
        String string2 = aSTField.getClassName();
        String string3 = _UNDERSCORE + string;
        String string4 = string + "Val";
        formatter.print("public void ");
        formatter.print(BeanWriter.setMethodName(string));
        formatter.print("(");
        formatter.print(string2);
        formatter.write(" ");
        formatter.print(string4);
        formatter.println(") {");
        formatter.startBlock();
        if (this._validationRequired && aSTField.getFixed() != null) {
            formatter.println("throw new IllegalArgumentException(\"Fixed value can not be set!\");");
        } else {
            if (this._validationRequired && aSTField.isElement()) {
                ASTElement aSTElement = (ASTElement)aSTField;
                if (aSTElement.isArray()) {
                    if (aSTElement.getMinOccurs() > 0) {
                        if (!aSTElement.isNillable()) {
                            formatter.println("if (" + string4 + " == null) throw new IllegalArgumentException(\"length of the argument should be " + aSTElement.getMinOccurs() + "\");");
                        }
                        formatter.println("if (" + string4 + " != null && " + string4 + ".length < " + aSTElement.getMinOccurs() + ") throw new IllegalArgumentException(\"length of the argument should be " + aSTElement.getMinOccurs() + "\");");
                    }
                    if (aSTElement.getMaxOccurs() != -1) {
                        formatter.println("if (" + string4 + " != null && " + string4 + ".length > " + aSTElement.getMaxOccurs() + ") throw new IllegalArgumentException(\"length of the argument should be " + aSTElement.getMaxOccurs() + "\");");
                    }
                } else if (aSTElement.getMinOccurs() == 1 && !aSTElement.isNillable() && !PrimitiveUtil.isPrimitive(string2)) {
                    formatter.println("if (" + string4 + " == null) throw new IllegalArgumentException(\"value can not be null for " + aSTField.getName() + "\");");
                }
            }
            formatter.print(string3);
            formatter.print(" = ");
            formatter.print(string + "Val");
            formatter.println(";");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public static void writeSetMethod(String string, String string2, Formatter formatter) {
        String string3 = _UNDERSCORE + string;
        formatter.print("public void ");
        formatter.print(BeanWriter.setMethodName(string));
        formatter.print("(");
        formatter.print(string2);
        formatter.write(" ");
        formatter.print(string + "Val");
        formatter.println(") {");
        formatter.startBlock();
        formatter.print(string3);
        formatter.print(" = ");
        formatter.print(string + "Val");
        formatter.println(";");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public static String getMethodName(String string) {
        String string2 = _GET;
        if (string.equals(_CLASS)) {
            string2 = "_get";
        }
        return string2 + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String setMethodName(String string) {
        return "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public String escape(String string) {
        return string.replace('\\', '/');
    }

    public static boolean isPrimitive(String string) {
        return PrimitiveUtil.isPrimitive(string);
    }
}

