/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.javac.Compiler;
import com.sssw.jbroker.tools.xsd2java.BeanWriter;
import com.sssw.jbroker.tools.xsd2java.Main;
import com.sssw.jbroker.tools.xsd2java.MarshalerWriter;
import com.sssw.jbroker.tools.xsd2java.ModelMarshalerWriter;
import com.sssw.jbroker.tools.xsd2java.SchemaUtil;
import com.sssw.jbroker.tools.xsd2java.SimpleTypeUtil;
import com.sssw.jbroker.tools.xsd2java.ast.ASTAttribute;
import com.sssw.jbroker.tools.xsd2java.ast.ASTClass;
import com.sssw.jbroker.tools.xsd2java.ast.ASTComplexType;
import com.sssw.jbroker.tools.xsd2java.ast.ASTConstraint;
import com.sssw.jbroker.tools.xsd2java.ast.ASTElement;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTModel;
import com.sssw.jbroker.tools.xsd2java.ast.ASTObject;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleContent;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleType;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.JavaUtil;
import com.sssw.jbroker.util.Namespace;
import com.sssw.jbroker.util.PrimitiveUtil;
import com.sssw.jbroker.util.XMLUtil;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CodeGenerator {
    private boolean _nowarn;
    private boolean _nomarsh;
    private boolean _validationRequired;
    private boolean _nocompile;
    private boolean _keep;
    private boolean _verbose;
    private boolean _final;
    private static final boolean _debug = false;
    private TreeMap _ns2pack = new TreeMap();
    private final TreeSet _incDirs = new TreeSet();
    private static final PrimitiveTypeMapper _primMapper = PrimitiveTypeMapper.getSingleton();
    private DefaultTypeMappingRegistry _mapper = new DefaultTypeMappingRegistry();
    private String _destDir = null;
    private final Vector _generatedFiles;
    private final PrintStream _ps;
    private final Vector _classes = new Vector();
    private final HashMap _complexTypeMap = new HashMap();
    private final HashMap _simpleTypeMap = new HashMap();
    private final HashMap _aliasTypeMap = new HashMap();
    private final HashSet _failedTypes = new HashSet();
    private Set _excTypes = new HashSet();
    private Set _excElems = new HashSet();
    private final HashMap _holderMap = new HashMap();
    private String _package;
    private String _xsdsource;
    private String _tmsource;
    private String _indent = "";
    private Namespace _defaultNS;
    private Namespace _currentNS;
    private SchemaInfo _schemaInfo;
    private final HashMap _complexTypes = new HashMap();
    private final HashMap _simpleTypes = new HashMap();
    private final HashMap _elements = new HashMap();
    private final HashMap _attributes = new HashMap();
    private final HashMap _groups = new HashMap();
    private final HashMap _attGroups = new HashMap();
    private final HashSet _typeMappings = new HashSet();
    private boolean _JBW_DEBUG;
    private Hashtable _params;
    private HashSet _holderPackages = new HashSet();
    private Set _missing = new HashSet();
    private HashMap _excClasses = new HashMap();
    private static final QName _soapenc11ArrayQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static final QName _soapenc11ArrayTypeQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName _soapenc12ArrayTypeQName = new QName("http://www.w3.org/2002/06/soap-encoding", "arrayType");
    private static final QName _soapenc12ArrayQName = new QName("http://www.w3.org/2002/06/soap-encoding", "Array");
    private static final QName _soapenc12ItemTypeQName = new QName("http://www.w3.org/2002/06/soap-encoding", "itemType");
    private static final QName _soapenc12ArraySizeQName = new QName("http://www.w3.org/2002/06/soap-encoding", "arraySize");
    private static final QName _wsdlArrayTypeQName = new QName("http://schemas.xmlsoap.org/wsdl/", "arrayType");
    private static final QName _jbrokerQName = new QName("http://schemas.silverstream.com/jBroker", "any");
    private static final String WSDL_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final String COLON = ":";
    private static final String _JLO = "java.lang.Object";
    private static final String _JLS = "java.lang.String";
    private HashSet _schema_loc_uris = new HashSet();
    private HashSet _knownSchemas = new HashSet();
    private HashMap _varNames = new HashMap();
    private HashMap _groupTypeMap = new HashMap();
    private static final QName _ANY = new QName("http://www.w3.org/2001/XMLSchema", "any");
    private HashMap _classNames = new HashMap();
    private static Class[] _nonPrimitiveMappings = new Class[]{class$com$sssw$jbroker$web$core$mapping$SetMapping == null ? (class$com$sssw$jbroker$web$core$mapping$SetMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.SetMapping")) : class$com$sssw$jbroker$web$core$mapping$SetMapping, class$com$sssw$jbroker$web$core$mapping$ListMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ListMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ListMapping")) : class$com$sssw$jbroker$web$core$mapping$ListMapping, class$com$sssw$jbroker$web$core$mapping$MapMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.MapMapping")) : class$com$sssw$jbroker$web$core$mapping$MapMapping, class$com$sssw$jbroker$web$core$mapping$MapEntryMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapEntryMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.MapEntryMapping")) : class$com$sssw$jbroker$web$core$mapping$MapEntryMapping, class$com$sssw$jbroker$web$core$mapping$ClassMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ClassMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ClassMapping")) : class$com$sssw$jbroker$web$core$mapping$ClassMapping, class$com$sssw$jbroker$web$core$mapping$QNameMapping == null ? (class$com$sssw$jbroker$web$core$mapping$QNameMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.QNameMapping")) : class$com$sssw$jbroker$web$core$mapping$QNameMapping, class$com$sssw$jbroker$web$core$mapping$BindingMapping == null ? (class$com$sssw$jbroker$web$core$mapping$BindingMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.BindingMapping")) : class$com$sssw$jbroker$web$core$mapping$BindingMapping, class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping = CodeGenerator.class$("com.sssw.jbroker.web.core.mapping.ServiceObjectMapping")) : class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping, class$com$sssw$jbroker$web$soap$mapping$ElementMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$ElementMapping = CodeGenerator.class$("com.sssw.jbroker.web.soap.mapping.ElementMapping")) : class$com$sssw$jbroker$web$soap$mapping$ElementMapping};
    private static HashMap _constraintMap = new HashMap();
    private static final HashSet _illegal_field_names;
    private static final HashSet _listConstraints;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$SetMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ListMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapEntryMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ClassMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$QNameMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$BindingMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$ElementMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxInclusive;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinInclusive;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxExclusive;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinExclusive;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTTotalDigits;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTFractionDigits;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTLength;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinLength;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxLength;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTPattern;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTWhiteSpace;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$ast$ASTEnumeration;

    public CodeGenerator(Vector vector, OutputStream outputStream) {
        this._generatedFiles = vector;
        this._ps = new PrintStream(outputStream);
        this._knownSchemas.add("http://www.w3.org/2001/XMLSchema");
    }

    public void compile(String string, Hashtable hashtable) throws Exception {
        block13: {
            Object object;
            Object object2;
            this._params = hashtable;
            this._xsdsource = string;
            this._schema_loc_uris.add(this._xsdsource);
            String[] stringArray = (String[])hashtable.get("typemapping");
            if (stringArray != null) {
                try {
                    object2 = this.getClass().getClassLoader();
                    int n = 0;
                    while (n < stringArray.length) {
                        this._mapper.importTypeMappingsFromFile(stringArray[n], (ClassLoader)object2);
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < _nonPrimitiveMappings.length) {
                        object = (TypeMappingBase)_nonPrimitiveMappings[n2].newInstance();
                        TypeMap[] typeMapArray = ((TypeMappingBase)object).getTypeMappings();
                        int n3 = 0;
                        while (n3 < typeMapArray.length) {
                            this._mapper.put(typeMapArray[n3]);
                            ++n3;
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    this.warn(Main._messages.get("xsd2java.warning.loading.mappings.fail", throwable.toString()));
                }
            }
            try {
                object2 = null;
                try {
                    object2 = new File(this._xsdsource);
                    if (!((File)object2).exists()) {
                        object2 = null;
                    }
                }
                catch (Throwable throwable) {
                    object2 = null;
                }
                DocumentBuilder documentBuilder = CodeGenerator.getParser();
                Document document = object2 != null ? documentBuilder.parse((File)object2) : documentBuilder.parse(this._xsdsource);
                object = document.getDocumentElement();
                this.compile((Element)object, new Namespace(), this._xsdsource, this._mapper, this._holderPackages, this._missing, hashtable, this._excTypes, this._excElems);
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                String string3 = string2 == null ? iOException.toString() : string2;
                this._ps.println("error processing " + this._xsdsource + ": " + string3);
                if (System.getProperty("JBWDebug") != null) {
                    iOException.printStackTrace();
                }
            }
            catch (SAXException sAXException) {
                String string4 = sAXException.getMessage();
                object = string4 == null ? sAXException.toString() : string4;
                this._ps.println("error processing " + this._xsdsource + ": " + (String)object);
                if (System.getProperty("JBWDebug") == null) break block13;
                sAXException.printStackTrace();
            }
        }
    }

    public TreeMap compile(Element element, Namespace namespace, String string, DefaultTypeMappingRegistry defaultTypeMappingRegistry, HashSet hashSet, Set set, Hashtable hashtable, Set set2, Set set3) {
        boolean bl;
        this._mapper = defaultTypeMappingRegistry;
        this._xsdsource = string;
        this._schema_loc_uris.add(this._xsdsource);
        this._params = hashtable;
        this._holderPackages = hashSet;
        this._missing = set;
        this._excTypes = set2;
        this._excElems = set3;
        this.parseParams(hashtable);
        this._defaultNS = Namespace.getNamespace(namespace, element);
        this.parseDocument(element);
        boolean bl2 = bl = hashtable.get("nogenerate") != null;
        if (!bl) {
            try {
                this.outputJavaFiles(this._classes, this._package, hashtable);
                this.compileJava();
                this.writeTypeMappings();
            }
            catch (IOException iOException) {
                if (this._JBW_DEBUG) {
                    iOException.printStackTrace();
                }
                CodeGenerator.error(iOException.getMessage());
            }
        }
        TreeMap<String, HashMap> treeMap = new TreeMap<String, HashMap>();
        this.populate(treeMap, this._aliasTypeMap);
        this.populate(treeMap, this._simpleTypeMap);
        this.populate(treeMap, this._complexTypeMap);
        treeMap.put("type2holder", this._holderMap);
        return treeMap;
    }

    private void populate(TreeMap treeMap, HashMap hashMap) {
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String) continue;
            QName qName = (QName)entry.getKey();
            TreeMap treeMap2 = (TreeMap)treeMap.get(qName.getNamespaceURI());
            if (treeMap2 == null) {
                treeMap2 = new TreeMap();
                treeMap.put(qName.getNamespaceURI(), treeMap2);
            }
            treeMap2.put(qName.getLocalPart(), entry.getValue());
        }
    }

    private void parseParams(Hashtable hashtable) {
        String[] stringArray;
        this._nowarn = hashtable.get("nowarn") != null;
        this._verbose = hashtable.get("verbose") != null;
        this._nomarsh = hashtable.get("nomarsh") != null;
        this._validationRequired = hashtable.get("novalidate") == null;
        this._nocompile = hashtable.get("nocompile") != null;
        this._keep = hashtable.get("keep") != null;
        this._final = hashtable.get("final") != null;
        this._JBW_DEBUG = System.getProperty("JBWDebug") != null;
        Object v = hashtable.get("package");
        if (v instanceof String) {
            this._package = (String)v;
        } else if (v instanceof String[]) {
            this._package = ((String[])v)[0];
        }
        if (this._package != null && this._package.trim().length() == 0) {
            this._package = null;
        }
        if ((stringArray = (String[])hashtable.get("nspkg")) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this._ns2pack.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
        }
        if ((v = hashtable.get("destDir")) instanceof File) {
            this._destDir = v.toString();
        } else if (v instanceof String) {
            this._destDir = (String)v;
        } else if (v instanceof File[]) {
            this._destDir = ((File[])v)[0].toString();
        } else if (v instanceof String[]) {
            this._destDir = ((String[])v)[0];
        }
        if (!this._destDir.endsWith(File.separator)) {
            this._destDir = this._destDir + File.separator;
        }
    }

    public void parseDocument(Element element) {
        Element element2 = element;
        String string = element.getTagName();
        if (!string.endsWith("schema")) {
            if (!string.endsWith("types")) {
                CodeGenerator.error(Main._messages.get("xsd2java.error.schema.not.valid", string));
            } else {
                NodeList nodeList = CodeGenerator.getChildren(element, "schema");
                this.info("compiling " + nodeList.getLength() + " schemas");
                if (nodeList.getLength() == 0) {
                    CodeGenerator.error(Main._messages.get("xsd2java.error.schema.not.valid", string));
                } else {
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        element2 = (Element)nodeList.item(n);
                        this.getChildren(element2);
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        element2 = (Element)nodeList.item(n2);
                        this.parseSchema(element2);
                        ++n2;
                    }
                }
            }
        } else {
            this.parseSchema(element2);
        }
    }

    private boolean isSchemaKnown(String string) {
        return this._knownSchemas.contains(string);
    }

    private void handleExternalSchemas(Element element) {
        NodeList nodeList = CodeGenerator.getChildren(element, "import");
        this.handleImports(nodeList);
        NodeList nodeList2 = CodeGenerator.getChildren(element, "include");
        this.handleIncludes(nodeList2);
    }

    private void handleImports(NodeList nodeList) {
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Element element = (Element)nodeList.item(n);
            String string2 = element.getAttribute("namespace");
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = element.getAttribute("schemaLocation")).length() == 0) {
                string = null;
            }
            if (!(string == null && string2 == null || string == null || this._schema_loc_uris.contains(string))) {
                this._schema_loc_uris.add(string);
                try {
                    Element element2 = this.getSchema(string);
                    if (element2 != null) {
                        String string3 = this.getTargetNamespace(element2);
                        if (!string3.equals(string2)) {
                            this.warn(Main._messages.get("xsd2java.warning.import.ns.nomatch", string));
                        }
                        this.parseSchema(element2);
                    }
                }
                catch (Exception exception) {
                    this.warn(Main._messages.get("xsd2java.warning.schema.loc.not.found", string, "import", exception.getMessage()));
                }
            }
            ++n;
        }
    }

    private void handleIncludes(NodeList nodeList) {
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Element element = (Element)nodeList.item(n);
            String string2 = element.getAttribute("namespace");
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = element.getAttribute("schemaLocation")).length() == 0) {
                string = null;
            }
            if (!(string == null && string2 == null || (string == null ? this.isSchemaKnown(string2) : this._schema_loc_uris.contains(string)))) {
                try {
                    Element element2 = this.getSchema(string);
                    if (element2 != null) {
                        String string3;
                        String string4 = this.getTargetNamespace(element2);
                        if (!string4.equals(string3 = this.getTargetNamespace((Element)element.getParentNode()))) {
                            this.warn(Main._messages.get("xsd2java.warning.include.ns.nomatch", string));
                        }
                        this.parseSchema(element2);
                    }
                }
                catch (Exception exception) {
                    this.warn(Main._messages.get("xsd2java.warning.schema.loc.not.found", string, "include", exception.getMessage()));
                }
            }
            ++n;
        }
    }

    private Element getSchema(String string) throws Exception {
        String string2 = string.indexOf("/") != -1 ? string.substring(0, string.lastIndexOf("/") + 1) : null;
        File file = new File(string);
        URL uRL = null;
        uRL = file.exists() ? file.toURL() : new URL(string);
        InputStream inputStream = uRL.openStream();
        return this.getDOM(inputStream, string2);
    }

    private Element getDOM(InputStream inputStream, String string) throws Exception {
        DocumentBuilder documentBuilder = CodeGenerator.getParser();
        Document document = string != null ? documentBuilder.parse(inputStream, string) : documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        if (!element.getTagName().endsWith("schema")) {
            return null;
        }
        return element;
    }

    private static void importElements(Element element, String string, Element element2) {
        Document document = element2.getOwnerDocument();
        NodeList nodeList = CodeGenerator.getChildren(element, string);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element3 = (Element)nodeList.item(n2);
            Node node = document.importNode(element3, true);
            element2.appendChild(node);
            ++n2;
        }
    }

    private void getChildren(Element element) {
        this._simpleTypes.put(element, CodeGenerator.getChildren(element, "simpleType"));
        this._complexTypes.put(element, CodeGenerator.getChildren(element, "complexType"));
        this._elements.put(element, CodeGenerator.getChildren(element, "element"));
        this._attributes.put(element, CodeGenerator.getChildren(element, "attribute"));
        this._groups.put(element, CodeGenerator.getChildren(element, "group"));
        this._attGroups.put(element, CodeGenerator.getChildren(element, "attributeGroup"));
    }

    private void readNamespaces(Element element) {
        this._currentNS = Namespace.getNamespace(this._defaultNS, element);
    }

    private String getTargetNamespace(Element element) {
        return Namespace.getNamespace(this._defaultNS, element).getTargetNamespace();
    }

    private void readSchemaInfo(Element element) {
        String string = CodeGenerator.getPrefix(element.getTagName());
        String string2 = null;
        string2 = string == null ? this._currentNS.getNamespaceURI() : this._currentNS.getNamespaceURI(string);
        this._schemaInfo = new SchemaInfo(element, string2);
        if (this._schemaInfo.getBlockDefault() != null) {
            this.warn(Main._messages.get("xsd2java.warning.block.default.not.supported"));
        }
    }

    public void parseSchema(Element element) {
        Object object;
        this.handleExternalSchemas(element);
        this.readNamespaces(element);
        this.readSchemaInfo(element);
        this.getChildren(element);
        NodeList nodeList = (NodeList)this._simpleTypes.get(element);
        NodeList nodeList2 = (NodeList)this._elements.get(element);
        NodeList nodeList3 = (NodeList)this._complexTypes.get(element);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            ASTClass aSTClass = this.parseSimpleType(element2);
            ++n2;
        }
        int n3 = nodeList2.getLength();
        int n4 = 0;
        while (n4 < n3) {
            block7: {
                Element element3 = (Element)nodeList2.item(n4);
                try {
                    this.validateGlobalElement(element3);
                    ASTElement aSTElement = this.parseXSDElement(element3, null, null);
                    if (aSTElement != null && this._excElems.contains(aSTElement.getXMLName()) && (object = (ASTClass)this._aliasTypeMap.get(aSTElement.getClassName())) != null && !((ASTClass)object).isSimple()) {
                        this.setExceptionInfo((ASTClass)object);
                    }
                }
                catch (CouldNotParseException couldNotParseException) {
                    if (!this._verbose) break block7;
                    couldNotParseException.printStackTrace();
                }
            }
            ++n4;
        }
        int n5 = nodeList3.getLength();
        int n6 = 0;
        while (n6 < n5) {
            object = (Element)nodeList3.item(n6);
            ASTComplexType aSTComplexType = this.parseComplexType((Element)object);
            if (aSTComplexType != null && this._excTypes.contains(aSTComplexType.getTypeQName())) {
                this.setExceptionInfo(aSTComplexType);
            }
            ++n6;
        }
    }

    private void setExceptionInfo(ASTClass aSTClass) {
        while (aSTClass != null) {
            aSTClass.setException(true);
            String string = aSTClass.getName();
            if (string.lastIndexOf("_Type") != -1) {
                aSTClass = aSTClass.getBaseClass();
                continue;
            }
            string = string + "_Type";
            String string2 = aSTClass.fullName();
            aSTClass.setName(string);
            String string3 = aSTClass.fullName();
            this._excClasses.put(string2, string3);
            aSTClass = aSTClass.getBaseClass();
        }
    }

    private ASTClass parseSimpleType(Element element) {
        QName qName;
        String string;
        String string2 = element.getAttribute("name");
        if (string2 == null || string2.trim().length() == 0) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.without.name", "simpleType", "schema with targetNamspace=" + this._currentNS.getTargetNamespace()));
        }
        if ((string = (String)this._simpleTypeMap.get(qName = this.getQName(string2))) != null) {
            return (ASTClass)this._simpleTypeMap.get(string);
        }
        ASTSimpleType aSTSimpleType = new ASTSimpleType();
        aSTSimpleType.setXMLType(qName);
        this.setClassInfo(aSTSimpleType);
        this.parseSimpleType(element, aSTSimpleType);
        return aSTSimpleType;
    }

    private ASTClass parseSimpleType(Element element, ASTSimpleType aSTSimpleType) {
        Object object;
        Object object2;
        NodeList nodeList = CodeGenerator.getChildren(element, "restriction");
        if (nodeList.getLength() != 0) {
            object2 = (Element)nodeList.item(0);
            try {
                this.parseRestriction((Element)object2, aSTSimpleType);
            }
            catch (CouldNotParseException couldNotParseException) {
                this.warn(Main._messages.get("xsd2java.warning.mapping", aSTSimpleType.getTypeQName().toString(), _JLS));
                ASTSimpleType aSTSimpleType2 = new ASTSimpleType();
                aSTSimpleType2.setName("String");
                aSTSimpleType2.setPackage("java.lang");
                aSTSimpleType2.setBasic(true);
                aSTSimpleType.setBaseClass(aSTSimpleType2);
            }
        } else {
            object2 = CodeGenerator.getChildren(element, "union");
            if (object2.getLength() != 0) {
                object = (Element)object2.item(0);
                String string = object.getAttribute("memberTypes");
                String[][] stringArray = this.parseTypes(string);
                aSTSimpleType.setUnionMemberTypes(stringArray);
            } else {
                object = CodeGenerator.getChildren(element, "list");
                if (object.getLength() != 0) {
                    Element element2 = (Element)object.item(0);
                    String string = element2.getAttribute("itemType");
                    String string2 = null;
                    if (string == null || string.trim().length() == 0) {
                        String string3 = aSTSimpleType.getName() + "ItemType";
                        QName qName = this.getQName(string3);
                        ASTClass aSTClass = this.parseAnonymousType(element2, aSTSimpleType, qName);
                        if (aSTClass == null) {
                            this.warn(Main._messages.get("xsd2java.warning.invalid.list.item.type", string, aSTSimpleType.getTypeQName().toString()));
                            string2 = _JLS;
                        } else {
                            string2 = aSTClass.fullName();
                            this._classes.add(aSTClass);
                        }
                    } else {
                        string2 = this.parseType(string);
                    }
                    aSTSimpleType.setListItemType(string2);
                } else {
                    this.warn(Main._messages.get("xsd2java.warning.mapping", aSTSimpleType.getTypeQName().toString(), _JLS));
                    ASTSimpleType aSTSimpleType3 = new ASTSimpleType();
                    aSTSimpleType3.setName("String");
                    aSTSimpleType3.setPackage("java.lang");
                    aSTSimpleType3.setBasic(true);
                    aSTSimpleType.setBaseClass(aSTSimpleType3);
                }
            }
        }
        object2 = aSTSimpleType.fullName();
        object = aSTSimpleType.getTypeQName();
        this._simpleTypeMap.put(object, object2);
        this._simpleTypeMap.put(object2, aSTSimpleType);
        if (!this._classes.contains(aSTSimpleType)) {
            this._classes.add(aSTSimpleType);
        }
        this.info(Main._messages.get("xsd2java.verbose.type.mapping", object, object2));
        return aSTSimpleType;
    }

    private void parseRestriction(Element element, ASTClass aSTClass) throws CouldNotParseException {
        String string = element.getAttribute("base");
        if (this.isSOAPENCArray(string)) {
            this.parseSOAPENCArray(element, aSTClass);
            return;
        }
        String string2 = this.parseType(string);
        this.extend(string, aSTClass, "restriction");
        if (!element.hasChildNodes()) {
            return;
        }
        if (aSTClass.isSimple() || aSTClass.isSimpleContent()) {
            this.parseConstraints(element, (ASTSimpleType)aSTClass);
        } else {
            this.parseComplexType(element, (ASTComplexType)aSTClass);
        }
    }

    private static void createFieldsForEnum(ASTSimpleType aSTSimpleType) {
        ArrayList<ASTField> arrayList = new ArrayList<ASTField>();
        ArrayList arrayList2 = aSTSimpleType.getConstraints();
        int n = arrayList2.size();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            ASTConstraint aSTConstraint = (ASTConstraint)arrayList2.get(n3);
            if (aSTConstraint.isEnum()) {
                String string = aSTConstraint.getValue();
                if (!JavaUtil.isJavaVarName(string)) {
                    string = "value" + n2;
                    ++n2;
                }
                ASTField aSTField = new ASTField(string, aSTSimpleType.getSimpleContentType(), new QName("", aSTConstraint.getValue()));
                arrayList.add(aSTField);
            }
            ++n3;
        }
        if (arrayList.size() == 0) {
            return;
        }
        aSTSimpleType.setEnums(arrayList);
    }

    private void parseConstraints(Element element, ASTSimpleType aSTSimpleType) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = nodeList.item(n2);
            if (object.getNodeType() != 3) {
                String string = object.getNodeName();
                string = CodeGenerator.getLocalName(string);
                this.parseConstraint(string, element, aSTSimpleType);
            }
            ++n2;
        }
        object = CodeGenerator.getChildren(element, "enumeration");
        this.parseEnumerations((NodeList)object, aSTSimpleType);
    }

    private void parseConstraint(String string, Element element, ASTSimpleType aSTSimpleType) {
        Object object;
        Set set;
        QName qName = aSTSimpleType.getBaseClass().getTypeQName();
        String string2 = aSTSimpleType.getBaseClass().getTypeQName().getLocalPart();
        boolean bl = true;
        if (((ASTSimpleType)aSTSimpleType.getBaseClass()).isList()) {
            bl = _listConstraints.contains(string);
        }
        if ((set = (Set)SimpleTypeUtil.simpleTypeConstraints.get(string2)) != null) {
            bl = set.contains(string);
        }
        if (!bl) {
            this.warn("constraint " + string + " not valid for simple type " + qName + ", ignoring the constraint");
            return;
        }
        NodeList nodeList = CodeGenerator.getChildren(element, string);
        if (SimpleTypeUtil._ENUMERATION.equals(string)) {
            return;
        }
        if (nodeList.getLength() > 1) {
            object = Main._messages.get("xsd2java.error.constraint.more.than.one", string, aSTSimpleType.getTypeQName());
            CodeGenerator.error((String)object);
        }
        if (nodeList.getLength() == 0) {
            return;
        }
        object = (Element)nodeList.item(0);
        String string3 = object.getAttribute("fixed");
        boolean bl2 = false;
        if ("true".equals(string3)) {
            bl2 = true;
        }
        String string4 = object.getAttribute("value");
        ASTConstraint aSTConstraint = CodeGenerator.createConstraint(string, string4, bl2);
        int n = aSTSimpleType.getConstraintPosition(string);
        if (n == -1) {
            aSTSimpleType.addConstraint(aSTConstraint);
        } else {
            CodeGenerator.replaceConstraint(n, aSTConstraint, aSTSimpleType);
        }
    }

    private void parseEnumerations(NodeList nodeList, ASTSimpleType aSTSimpleType) {
        int n = nodeList.getLength();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.parseEnumeration((Element)nodeList.item(n2), arrayList);
            ++n2;
        }
        if (arrayList.size() == 0) {
            aSTSimpleType.setEnums(null);
        } else {
            aSTSimpleType.setEnums(arrayList);
        }
    }

    private void parseEnumeration(Element element, ArrayList arrayList) {
        String string = element.getAttribute("value");
        QName qName = new QName("", string);
        String string2 = string;
        if (!JavaUtil.isJavaVarName(string2)) {
            string2 = "value" + (arrayList.size() + 1);
        }
        ASTField aSTField = new ASTField(string2, null, qName);
        arrayList.add(aSTField);
    }

    private static ASTConstraint createConstraint(String string, String string2, boolean bl) {
        try {
            Class clazz = (Class)_constraintMap.get(string);
            Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CodeGenerator.class$(_JLS)) : class$java$lang$String, Boolean.TYPE);
            return (ASTConstraint)constructor.newInstance(string2, new Boolean(bl));
        }
        catch (Exception exception) {
            CodeGenerator.error("Unable to create constraint for " + string);
            return null;
        }
    }

    private static void replaceConstraint(int n, ASTConstraint aSTConstraint, ASTSimpleType aSTSimpleType) {
        QName qName = aSTSimpleType.getBaseClass().getTypeQName();
        ASTConstraint aSTConstraint2 = (ASTConstraint)aSTSimpleType.getConstraints().get(n);
        if (aSTConstraint2.isFixed()) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.constraint.fixed", aSTConstraint.getName(), aSTSimpleType.getTypeQName(), qName));
        }
        aSTSimpleType.getConstraints().set(n, aSTConstraint);
    }

    private boolean isSOAPENCArray(String string) {
        QName qName = this.getTypeQName(string);
        return this.isSOAPENCArray(qName);
    }

    private boolean isSOAPENCArray(QName qName) {
        if (_soapenc11ArrayQName.equals(qName)) {
            return true;
        }
        return _soapenc12ArrayQName.equals(qName);
    }

    private boolean isSOAPENCArrayAttribute(QName qName) {
        if (_soapenc11ArrayTypeQName.equals(qName)) {
            return true;
        }
        if (_soapenc12ArrayTypeQName.equals(qName)) {
            return true;
        }
        if (_soapenc12ItemTypeQName.equals(qName)) {
            return true;
        }
        return _soapenc12ArraySizeQName.equals(qName);
    }

    private void parseSOAPENCArray(Element element, ASTClass aSTClass) {
        Namespace namespace;
        String string;
        String string2;
        String string3;
        QName qName;
        Object object;
        Object object2;
        NodeList nodeList = CodeGenerator.getChildren(element, "attribute");
        if (nodeList.getLength() > 1) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.more.1.attributes", aSTClass.getTypeQName()));
        }
        if (nodeList.getLength() == 0) {
            object2 = CodeGenerator.getChildren(element, "sequence");
            if (object2.getLength() == 0 || object2.getLength() > 1) {
                CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.invalid.definition", aSTClass.getTypeQName()));
            } else {
                object = CodeGenerator.getChildren((Element)object2.item(0), "element");
                if (object.getLength() == 0 || object.getLength() > 1) {
                    CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.invalid.definition", aSTClass.getTypeQName()));
                } else {
                    String string4;
                    String string5;
                    Element element2 = (Element)object.item(0);
                    if (!this.isArray(element2)) {
                        CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.invalid.definition", aSTClass.getTypeQName()));
                    }
                    if ((string5 = this.parseType(string4 = element2.getAttribute("type"))) == null) {
                        this.warn(Main._messages.get("xsd2java.warning.complex.type.not.found", string4, aSTClass.getTypeQName().toString()));
                        string5 = _JLO;
                    }
                    string5 = string5 + "[]";
                    aSTClass.setArray(true);
                    aSTClass.setArrayType(string5);
                    return;
                }
            }
        }
        if (!this.isSOAPENCArrayAttribute(qName = this.getTypeQName((String)(object = (object2 = (Element)nodeList.item(0)).getAttribute("ref"))))) {
            this.warn(Main._messages.get("xsd2java.warning.soapenc.array.invalid.ref", aSTClass.getTypeQName(), qName));
        }
        if ((string3 = object2.getAttribute(string2 = (string = (namespace = Namespace.getNamespace(this._currentNS, (Element)object2)).getPrefix(_wsdlArrayTypeQName.getNamespaceURI())) + COLON + _wsdlArrayTypeQName.getLocalPart())) == null) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.invalid.wsdl.arrayType", aSTClass.getTypeQName()));
        }
        int n = string3.indexOf("[");
        int n2 = string3.indexOf("]");
        if (n == -1 || n2 == -1) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.soapenc.array.invalid.wsdl.arrayType", aSTClass.getTypeQName()));
        }
        String string6 = string3.substring(0, n);
        int n3 = 1;
        int n4 = n;
        while (n4 < n2) {
            if (string3.charAt(n4) == ',') {
                ++n3;
            }
            ++n4;
        }
        String string7 = this.parseType(string6);
        if (string7 == null) {
            string7 = _JLO;
        }
        int n5 = 0;
        while (n5 < n3) {
            string7 = string7 + "[]";
            ++n5;
        }
        aSTClass.setArray(true);
        aSTClass.setArrayType(string7);
    }

    private Element getAttributeDefinition(String string) {
        return this.getElementByName(string, this._attributes);
    }

    private Element getAttributeGroupDefinition(String string) {
        return this.getElementByName(string, this._attGroups);
    }

    private Element getElementDefinition(String string) {
        return this.getElementByName(string, this._elements);
    }

    private Element getGroupDefinition(String string) {
        return this.getElementByName(string, this._groups);
    }

    private Element getElementByName(String string, HashMap hashMap) {
        String string2 = CodeGenerator.getLocalName(string);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Element element = (Element)entry.getKey();
            String string3 = this._currentNS.getNamespaceURI(CodeGenerator.getPrefix(string));
            if (!this.getTargetNamespace(element).equals(string3)) continue;
            NodeList nodeList = (NodeList)entry.getValue();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                String string4 = element2.getAttribute("name");
                if (string4 != null && string4.trim().length() != 0 && string4.equals(string2)) {
                    return element2;
                }
                ++n2;
            }
        }
        return null;
    }

    private String[][] parseTypes(String string) {
        String[] stringArray;
        Object object;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            stringArray = this.parseType((String)object);
            arrayList.add(stringArray);
            object = JavaUtil.toVariableName((String)object);
            arrayList2.add((String[])object);
        }
        object = new String[arrayList2.size()];
        arrayList2.toArray((T[])object);
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        String[][] stringArray2 = new String[2][arrayList2.size()];
        stringArray2[0] = stringArray;
        stringArray2[1] = object;
        return stringArray2;
    }

    private String parseType(String string) {
        return this.parseType(this.getTypeQName(string));
    }

    private String parseType(QName qName) {
        TypeMap typeMap = this.getTypeMapping(qName);
        if (typeMap != null) {
            return CodeGenerator.getClassName(typeMap.getJavaType());
        }
        String string = (String)this._simpleTypeMap.get(qName);
        if (string != null) {
            return string;
        }
        string = (String)this._aliasTypeMap.get(qName);
        if (string != null) {
            return string;
        }
        string = (String)this._complexTypeMap.get(qName);
        if (string != null) {
            return string;
        }
        string = this.parseOtherType(qName, true);
        if (string != null) {
            return string;
        }
        string = this.parseOtherType(qName, false);
        if (string != null) {
            return string;
        }
        if (this.isSOAPENCArray(qName)) {
            return "java.lang.Object[]";
        }
        return null;
    }

    private String parseOtherType(QName qName, boolean bl) {
        Object var3_3 = null;
        if (bl) {
            String string = this.parseOtherType(qName, bl, this._complexTypes);
            if (string != null) {
                return string;
            }
            return this.parseOtherType(qName, bl, this._elements);
        }
        return this.parseOtherType(qName, bl, this._simpleTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseOtherType(QName qName, boolean bl, HashMap hashMap) {
        String string = qName.getLocalPart();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Element element = (Element)entry.getKey();
            if (!this.getTargetNamespace(element).equals(qName.getNamespaceURI())) continue;
            NodeList nodeList = (NodeList)entry.getValue();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Object var21_18;
                Element element2 = (Element)nodeList.item(n2);
                String string2 = element2.getNodeName();
                String string3 = element2.getAttribute("name");
                if (string3 == null || string3.trim().length() == 0) {
                    CodeGenerator.error(Main._messages.get("xsd2java.error.without.name", string2, "schema with targetNamspace=" + this._currentNS.getTargetNamespace()));
                }
                Namespace namespace = this._currentNS;
                try {
                    block11: {
                        ASTElement aSTElement;
                        ASTClass aSTClass;
                        block13: {
                            block12: {
                                this.readNamespaces(element);
                                QName qName2 = this.getQName(string3);
                                if (!qName.equals(qName2)) break block11;
                                aSTClass = null;
                                if (!bl) break block12;
                                if (hashMap == this._elements) {
                                    aSTElement = this.parseXSDElement(element2);
                                    if (aSTElement != null) {
                                        aSTClass = this.getASTClass(aSTElement.getClassName());
                                    }
                                    break block13;
                                } else {
                                    aSTClass = this.parseComplexType(element2);
                                }
                                break block13;
                            }
                            aSTClass = this.parseSimpleType(element2);
                        }
                        if (aSTClass == null) {
                            aSTElement = null;
                            var21_18 = null;
                            this._currentNS = namespace;
                            return aSTElement;
                        }
                        if (aSTClass.isArray()) {
                            String string4 = aSTClass.getArrayType();
                            var21_18 = null;
                            this._currentNS = namespace;
                            return string4;
                        }
                        if (aSTClass != null) {
                            String string5 = aSTClass.fullName();
                            var21_18 = null;
                            this._currentNS = namespace;
                            return string5;
                        }
                    }
                    var21_18 = null;
                    this._currentNS = namespace;
                }
                catch (Throwable throwable) {
                    var21_18 = null;
                    this._currentNS = namespace;
                    throw throwable;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getClassName(Class clazz) {
        return clazz.isArray() ? CodeGenerator.getClassName(clazz.getComponentType()) + "[]" : clazz.getName();
    }

    private boolean isArray(Element element) {
        String string = element.getAttribute("maxOccurs");
        boolean bl = false;
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("unbounded")) {
            return true;
        }
        return !string.equals("1");
    }

    private boolean zeroOROneElementArray(Element element) {
        String string = element.getAttribute("minOccurs");
        if (!"0".equals(string)) {
            return false;
        }
        String string2 = element.getAttribute("maxOccurs");
        return "1".equals(string2);
    }

    private boolean zeroOROneElementArray(int n, int n2) {
        return n == 0 && n2 == 1;
    }

    public ASTComplexType parseComplexType(Element element) {
        QName qName;
        String string;
        String string2 = element.getAttribute("name");
        if (string2 == null || string2.trim().length() == 0) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.without.name", "complexType", "schema with targetNamspace=" + this._currentNS.getTargetNamespace()));
        }
        if ((string = (String)this._complexTypeMap.get(qName = this.getQName(string2))) != null) {
            return (ASTComplexType)this._complexTypeMap.get(string);
        }
        TypeMap typeMap = this.getTypeMapping(qName);
        if (typeMap != null) {
            this.info(Main._messages.get("xsd2java.verbose.mapping.exists", qName));
            return null;
        }
        ASTComplexType aSTComplexType = new ASTComplexType();
        aSTComplexType.setXMLType(qName);
        this.setClassInfo(aSTComplexType);
        this._complexTypeMap.put(qName, aSTComplexType.fullName());
        String string3 = element.getAttribute("mixed");
        if ("true".equalsIgnoreCase(string3)) {
            aSTComplexType.setMixed(true);
        }
        CodeGenerator.setFinal(aSTComplexType, element);
        try {
            Object object;
            this.parseComplexType(element, aSTComplexType);
            ASTClass aSTClass = aSTComplexType.getBaseClass();
            if (aSTComplexType.getBaseClass() == null) {
                if (aSTComplexType.isMixed() && !aSTComplexType.containsElement(null)) {
                    aSTComplexType.setMixed(false);
                    aSTComplexType.setSimpleContent(true);
                    object = new ASTSimpleType();
                    ((ASTClass)object).setName("String");
                    ((ASTClass)object).setPackage("java.lang");
                    ((ASTSimpleType)object).setBasic(true);
                    aSTComplexType.setBaseClass((ASTClass)object);
                }
            } else {
                aSTClass.setException(aSTComplexType.isException());
                if (!aSTClass.isComplex()) {
                    if (!aSTComplexType.containsElement(null)) {
                        aSTComplexType.setMixed(false);
                        aSTComplexType.setSimpleContent(true);
                    } else {
                        String string4 = Main._messages.get("xsd2java.warning.invalid.simple.base", aSTComplexType.getBaseClass().getTypeQName(), aSTComplexType.getTypeQName());
                        this.warn(string4);
                        throw new CouldNotParseException(string4, element);
                    }
                }
            }
            if (!this._classes.contains(aSTComplexType)) {
                this._classes.add(aSTComplexType);
            }
            object = aSTComplexType.fullName();
            if (aSTComplexType.isArray()) {
                object = aSTComplexType.getArrayType();
            }
            this.info(Main._messages.get("xsd2java.verbose.type.mapping", qName, object));
            this._complexTypeMap.put(qName, object);
            this._complexTypeMap.put(object, aSTComplexType);
        }
        catch (CouldNotParseException couldNotParseException) {
            this.warn(Main._messages.get("xsd2java.warning.mapping", qName.toString(), _JLO));
            this._complexTypeMap.put(qName, _JLO);
            this.removeClass(aSTComplexType, this._classes);
            aSTComplexType.setName("Object");
            aSTComplexType.setPackage("java.lang");
            aSTComplexType.setGenerateBean(false);
            aSTComplexType.setGenerateMarshaller(false);
            return aSTComplexType;
        }
        return aSTComplexType;
    }

    private void removeClass(ASTComplexType aSTComplexType, Vector vector) {
        vector.remove(aSTComplexType);
        ASTModel aSTModel = aSTComplexType.getModel();
        if (aSTModel == null) {
            return;
        }
        this.removeModel(aSTModel, vector);
    }

    private void removeModel(ASTModel aSTModel, Vector vector) {
        ASTComplexType aSTComplexType = aSTModel.getModelClass();
        if (aSTComplexType != null) {
            aSTComplexType.setGenerateBean(false);
            aSTComplexType.setGenerateMarshaller(false);
            vector.remove(aSTComplexType);
        }
        ArrayList arrayList = aSTModel.getChildren();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            if (aSTField.isModel()) {
                this.removeModel((ASTModel)aSTField, vector);
            }
            ++n2;
        }
    }

    public void parseComplexType(Element element, ASTComplexType aSTComplexType) throws CouldNotParseException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NodeList nodeList;
        NodeList nodeList2;
        NodeList nodeList3 = CodeGenerator.getChildren(element, "simpleContent");
        if (nodeList3.getLength() != 0) {
            aSTComplexType.setSimpleContent(true);
            this.parseSimpleContent((Element)nodeList3.item(0), aSTComplexType);
        }
        if ((nodeList2 = CodeGenerator.getChildren(element, "complexContent")).getLength() != 0) {
            this.parseComplexContent((Element)nodeList2.item(0), aSTComplexType);
        }
        if ((nodeList = CodeGenerator.getChildren(element, "choice")).getLength() != 0) {
            object4 = new ASTModel(ASTModel.CHOICE, "", aSTComplexType.fullName() + "Choice");
            this.parseModel((Element)nodeList.item(0), (ASTModel)object4, aSTComplexType);
            if (((ASTModel)object4).isArray()) {
                object3 = new ASTComplexType((ASTModel)object4);
                object2 = this.resolveClassName(((ASTClass)object3).getPackage(), ((ASTClass)object3).getName());
                ((ASTClass)object3).setName((String)object2);
                ((ASTModel)object4).setModelClass((ASTComplexType)object3);
                this._classes.add(object3);
                object = object4;
                object4 = new ASTModel(ASTModel.SEQUENCE, "", aSTComplexType.fullName() + "Sequence");
                ((ASTModel)object4).addModel((ASTModel)object);
            }
            aSTComplexType.setModel((ASTModel)object4);
        }
        if ((object4 = CodeGenerator.getChildren(element, "sequence")).getLength() != 0) {
            object3 = new ASTModel(ASTModel.SEQUENCE, "", aSTComplexType.fullName() + "Sequence");
            this.parseModel((Element)object4.item(0), (ASTModel)object3, aSTComplexType);
            if (((ASTModel)object3).isArray()) {
                object2 = new ASTComplexType((ASTModel)object3);
                object = this.resolveClassName(((ASTClass)object2).getPackage(), ((ASTClass)object2).getName());
                ((ASTClass)object2).setName((String)object);
                ((ASTModel)object3).setModelClass((ASTComplexType)object2);
                this._classes.add(object2);
                Object object5 = object3;
                object3 = new ASTModel(ASTModel.SEQUENCE, "", aSTComplexType.fullName() + "Sequence");
                ((ASTModel)object3).addModel((ASTModel)object5);
            }
            aSTComplexType.setModel((ASTModel)object3);
        }
        if ((object3 = CodeGenerator.getChildren(element, "all")).getLength() != 0) {
            object2 = new ASTModel(ASTModel.ALL, "", aSTComplexType.fullName() + "All");
            this.parseModel((Element)object3.item(0), (ASTModel)object2, aSTComplexType);
            aSTComplexType.setModel((ASTModel)object2);
        }
        object2 = CodeGenerator.getChildren(element, "attribute");
        int n = object2.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.parseAttribute((Element)object2.item(n2), aSTComplexType);
            ++n2;
        }
        NodeList nodeList4 = CodeGenerator.getChildren(element, "anyAttribute");
        n = nodeList4.getLength();
        if (n > 0) {
            aSTComplexType.setHasAnyAttributes(true);
        }
        NodeList nodeList5 = CodeGenerator.getChildren(element, "attributeGroup");
        n = nodeList5.getLength();
        int n3 = 0;
        while (n3 < n) {
            this.parseAttributeGroup((Element)nodeList5.item(n3), aSTComplexType);
            ++n3;
        }
    }

    private void parseAttributeGroup(Element element, ASTComplexType aSTComplexType) throws CouldNotParseException {
        String string = element.getAttribute("ref");
        if (string != null || string.length() > 0) {
            element = this.getAttributeGroupDefinition(string);
        }
        if (element == null) {
            String string2 = Main._messages.get("xsd2java.warning.not.found", "attributeGroup", string, aSTComplexType.getTypeQName());
            this.warn(string2);
            throw new CouldNotParseException(string2, element);
        }
        NodeList nodeList = CodeGenerator.getChildren(element, "attribute");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.parseAttribute((Element)nodeList.item(n2), aSTComplexType);
            ++n2;
        }
        NodeList nodeList2 = CodeGenerator.getChildren(element, "anyAttribute");
        n = nodeList2.getLength();
        if (n > 0) {
            aSTComplexType.setHasAnyAttributes(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASTAttribute parseAttribute(Element element, ASTSimpleContent aSTSimpleContent) throws CouldNotParseException {
        Object object;
        Namespace namespace;
        block22: {
            Object object2;
            block21: {
                String string = null;
                String string2 = null;
                QName qName = null;
                QName qName2 = null;
                namespace = this._currentNS;
                try {
                    String string3;
                    Object object3;
                    Object object4;
                    block24: {
                        block23: {
                            object4 = element.getAttribute("name");
                            if (object4 != null && ((String)object4).trim().length() != 0) break block23;
                            object2 = element.getAttribute("ref");
                            if (object2 == null || ((String)object2).trim().length() == 0) {
                                object2 = null;
                                CodeGenerator.error(Main._messages.get("xsd2java.error.without.name", "attribute", aSTSimpleContent.getTypeQName()));
                                break block24;
                            } else {
                                object3 = CodeGenerator.getPrefix((String)object2);
                                string3 = "";
                                try {
                                    string3 = namespace.getNamespaceURI((String)object3);
                                }
                                catch (RuntimeException runtimeException) {
                                    if (!((String)object3).equals("xml")) throw runtimeException;
                                    string3 = "http://www.w3.org/2001/namespace";
                                }
                                String string4 = CodeGenerator.getLocalName((String)object2);
                                object = string3 + COLON + string4;
                                boolean bl = SchemaUtil.isSpecial((String)object);
                                if (bl) {
                                    String string5 = (String)SchemaUtil.getSpecialAttrNames().get(object);
                                    object4 = object2;
                                    qName = new QName(this._schemaInfo.getNamespace(), "string");
                                    string = _JLS;
                                    qName2 = new QName(null, (String)object2);
                                    ASTAttribute aSTAttribute = new ASTAttribute(JavaUtil.toVariableName(string5), string, qName2);
                                    aSTSimpleContent.getAttributes().add(aSTAttribute);
                                    ASTAttribute aSTAttribute2 = aSTAttribute;
                                    Object var19_24 = null;
                                    this._currentNS = namespace;
                                    return aSTAttribute2;
                                }
                                qName2 = this.getQName((String)object2);
                                element = this.getAttributeDefinition((String)object2);
                                if (element == null) {
                                    String string6 = Main._messages.get("xsd2java.warning.ref.attr.not.found", object2, aSTSimpleContent.getTypeQName());
                                    this.warn(string6);
                                    throw new CouldNotParseException(string6, element);
                                }
                                Element element2 = (Element)element.getParentNode();
                                this.readNamespaces(element2);
                                this.validateGlobalAttribute(element);
                            }
                            break block24;
                        }
                        qName2 = this.getQName((String)object4);
                    }
                    string2 = element.getAttribute("type");
                    if (string2 == null || string2.length() == 0) {
                        object2 = this.parseAnonymousType(element, aSTSimpleContent);
                        if (object2 != null) {
                            qName = ((ASTClass)object2).getTypeQName();
                            string = ((ASTClass)object2).fullName();
                        }
                    } else {
                        object2 = CodeGenerator.getPrefix(string2);
                        object3 = namespace.getNamespaceURI((String)object2);
                        string3 = CodeGenerator.getLocalName(string2);
                        boolean bl = SchemaUtil.isSpecial((String)object3 + COLON + string3);
                        if (bl) {
                            object = (String)SchemaUtil.getSpecialAttrNames().get(string2);
                            qName = new QName(this._schemaInfo.getNamespace(), "string");
                            string = _JLS;
                        } else {
                            string = this.parseType(string2);
                            qName = this.getTypeQName(string2);
                        }
                    }
                    if (string == null) {
                        this.warn(Main._messages.get("xsd2java.error.attribute.without.type", qName == null ? "" : qName.toString(), qName2.toString(), aSTSimpleContent.getTypeQName().toString()));
                        string = _JLS;
                        object2 = new ASTAttribute(JavaUtil.toVariableName((String)object4), string, qName2);
                        break block21;
                    }
                    boolean bl = this.isSimpleType(qName);
                    if (!bl) {
                        CodeGenerator.error(Main._messages.get("xsd2java.error.att.type.not.simple", object4, aSTSimpleContent.getTypeQName().toString(), qName.toString()));
                    }
                    if (this.resolveAttributeName((ASTField)(object3 = new ASTAttribute(JavaUtil.toVariableName(qName2.getLocalPart()), string, qName2)), aSTSimpleContent)) {
                        aSTSimpleContent.getAttributes().add(object3);
                    }
                    if ((string3 = element.getAttribute("use")) == null || string3.length() == 0) {
                        string3 = "optional";
                    }
                    ((ASTAttribute)object3).setUse(string3);
                    boolean bl2 = ((ASTAttribute)object3).isOptional();
                    if (bl2 && PrimitiveUtil.isPrimitive(string)) {
                        string = PrimitiveUtil.getPrimitiveWrapper(string);
                        ((ASTField)object3).setClassName(string);
                    }
                    this.setForm((ASTField)object3, element, this._schemaInfo.isAttributeQualified());
                    if (this._validationRequired) {
                        CodeGenerator.setFixed((ASTField)object3, element);
                        CodeGenerator.setDefault((ASTField)object3, element);
                        if (((ASTField)object3).getDefault() != null && !bl2) {
                            CodeGenerator.error(Main._messages.get("xsd2java.error.default.no.optional", aSTSimpleContent.getTypeQName(), ((ASTField)object3).getXMLName()));
                        }
                        if (((ASTField)object3).getDefault() != null && ((ASTField)object3).getFixed() != null) {
                            CodeGenerator.error(Main._messages.get("xsd2java.error.default.fixed.together", aSTSimpleContent.getTypeQName(), ((ASTField)object3).getXMLName()));
                        }
                    }
                    object = object3;
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var19_27 = null;
                    this._currentNS = namespace;
                    throw throwable;
                }
            }
            Object var19_25 = null;
            this._currentNS = namespace;
            return object2;
        }
        Object var19_26 = null;
        this._currentNS = namespace;
        return object;
    }

    private boolean resolveAttributeName(ASTField aSTField, ASTSimpleContent aSTSimpleContent) {
        Object object;
        int n = aSTSimpleContent.getAttributes().size();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            object = (ASTField)aSTSimpleContent.getAttributes().get(n3);
            if (aSTField.getXMLName().equals(((ASTField)object).getXMLName())) {
                String string = Main._messages.get("xsd2java.error.same.name.attribute", aSTSimpleContent.getTypeQName().toString(), aSTField.getXMLName().toString());
                this.warn(string);
                n2 = n3;
                return false;
            }
            if (aSTField.getName().equals(((ASTField)object).getName())) {
                this.resolveFieldName(aSTField, "Attribute", aSTSimpleContent);
                break;
            }
            if (_illegal_field_names.contains(aSTField.getName())) {
                this.resolveFieldName(aSTField, "Attribute", aSTSimpleContent);
            }
            ++n3;
        }
        if (aSTSimpleContent.isComplex() && (n2 = CodeGenerator.getField(((ASTModel)(object = ((ASTComplexType)aSTSimpleContent).getModel())).getChildren(), aSTField.getName())) != -1) {
            String string = Main._messages.get("xsd2java.error.same.name.element", aSTSimpleContent.getTypeQName().toString(), aSTField.getName());
            this.warn(string);
            this.resolveFieldName(aSTField, "Attribute", aSTSimpleContent);
        }
        if ((object = aSTSimpleContent.getBaseClass()) == null) {
            return true;
        }
        if (((ASTClass)object).isSimple()) {
            return true;
        }
        return this.resolveAttributeName(aSTField, (ASTSimpleContent)object);
    }

    private void resolveFieldName(ASTField aSTField, String string, ASTClass aSTClass) {
        String string2 = aSTField.getName();
        string2 = string2 + string;
        String string3 = aSTClass.fullName() + "." + "fName";
        Integer n = (Integer)this._varNames.get(string3);
        if (n != null) {
            int n2 = n;
            string2 = string2 + ++n2;
            this._varNames.put(string3, new Integer(n2));
        } else {
            this._varNames.put(string3, new Integer(0));
        }
        aSTField.setName(string2);
    }

    private void setForm(ASTField aSTField, Element element, boolean bl) {
        String string = element.getAttribute("form");
        this.setForm(aSTField, string, bl);
    }

    private void setForm(ASTField aSTField, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            aSTField.setQualified(bl);
        } else {
            aSTField.setQualified(string.equals("qualified"));
        }
    }

    private static void setDefault(ASTField aSTField, Element element) {
        String string = element.getAttribute("default");
        if (string == null || string.length() == 0) {
            string = null;
        }
        aSTField.setDefault(string);
    }

    private static void setFixed(ASTField aSTField, Element element) {
        String string = element.getAttribute("fixed");
        if (string == null || string.length() == 0) {
            string = null;
        }
        aSTField.setFixed(string);
    }

    private static void setFinal(ASTClass aSTClass, Element element) {
        String string = element.getAttribute("final");
        if (string == null || string.length() == 0) {
            string = null;
        }
        aSTClass.setFinalDerivation(string);
    }

    private static String getDefault(Element element) {
        String string = element.getAttribute("default");
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    private static String getFixed(Element element) {
        String string = element.getAttribute("fixed");
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    private static int getField(ArrayList arrayList, String string) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            if (aSTField.getName().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void parseModel(Element element, ASTModel aSTModel, ASTComplexType aSTComplexType) throws CouldNotParseException {
        boolean bl = this.isArray(element);
        if (aSTModel.isAll() && bl) {
            String string = Main._messages.get("xsd2java.warning.elem.array", aSTModel.getName(), aSTComplexType == null ? "" : aSTComplexType.getXMLType().toString());
            this.warn(string);
            throw new CouldNotParseException(string, element);
        }
        aSTModel.setArray(bl);
        ASTModel aSTModel2 = null;
        ASTElement aSTElement = null;
        NodeList nodeList = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        nodeList = element.getChildNodes();
        int n6 = nodeList.getLength();
        int n7 = 0;
        while (n7 < n6) {
            Node node = nodeList.item(n7);
            if (node.getNodeType() == 1) {
                Object object;
                String string = ((Element)node).getTagName().toLowerCase();
                if (string.endsWith("element")) {
                    aSTElement = this.parseXSDElement((Element)node, aSTModel, aSTComplexType);
                    aSTModel.addElement(aSTElement);
                } else if (string.endsWith("any")) {
                    aSTElement = this.parseAny((Element)node, n, aSTComplexType);
                    aSTModel.addElement(aSTElement);
                } else if (string.endsWith("sequence")) {
                    aSTModel2 = new ASTModel(ASTModel.SEQUENCE, "" + n3, aSTModel.getClassName() + "Sequence" + n3);
                    ++n3;
                    this.parseModel((Element)node, aSTModel2, aSTComplexType);
                    aSTModel.addModel(aSTModel2);
                    object = new ASTComplexType(aSTModel2);
                    this._classes.add(object);
                } else if (string.endsWith("all")) {
                    aSTModel2 = new ASTModel(ASTModel.ALL, "" + n2, aSTModel.getClassName() + "All" + n2);
                    ++n2;
                    this.parseModel((Element)node, aSTModel2, aSTComplexType);
                    aSTModel.addModel(aSTModel2);
                    object = new ASTComplexType(aSTModel2);
                    this._classes.add(object);
                } else if (string.endsWith("choice")) {
                    aSTModel2 = new ASTModel(ASTModel.CHOICE, "" + n5, aSTModel.getClassName() + "Choice" + n5);
                    ++n5;
                    this.parseModel((Element)node, aSTModel2, aSTComplexType);
                    aSTModel.addModel(aSTModel2);
                    object = new ASTComplexType(aSTModel2);
                    this._classes.add(object);
                } else if (string.endsWith("group")) {
                    Object object2;
                    object = ((Element)node).getAttribute("ref");
                    if (object != null && ((String)object).length() == 0) {
                        object = null;
                    }
                    if (object == null) {
                        aSTModel2 = new ASTModel(ASTModel.GROUP, "" + n4, aSTModel.getClassName() + "Group" + n4);
                        ++n4;
                        this.parseModel((Element)node, aSTModel2, aSTComplexType);
                        aSTModel.addModel(aSTModel2);
                        object2 = new ASTComplexType(aSTModel2);
                        this._classes.add(object2);
                    } else {
                        element = this.getGroupDefinition((String)object);
                        if (element == null) {
                            object2 = Main._messages.get("xsd2java.warning.not.found", "group", object, aSTComplexType == null ? "schema" : aSTComplexType.getTypeQName().toString());
                            this.warn((String)object2);
                            throw new CouldNotParseException((String)object2, element);
                        }
                        object2 = new int[]{n4};
                        this.parseTLGroup(element, aSTModel, aSTComplexType, (int[])object2);
                        n4 = object2[0];
                    }
                }
            }
            ++n7;
        }
    }

    private void parseTLGroup(Element element, ASTModel aSTModel, ASTComplexType aSTComplexType, int[] nArray) throws CouldNotParseException {
        String string = element.getAttribute("name");
        QName qName = this.getQName(string);
        String string2 = JavaUtil.toClassName(string + "Group");
        String string3 = this.getPackage(qName.getNamespaceURI());
        if (string3 != null) {
            string2 = string3 + "." + string2;
        }
        ASTModel aSTModel2 = new ASTModel(ASTModel.GROUP, "" + nArray[0], string2);
        nArray[0] = nArray[0] + 1;
        aSTModel.addModel(aSTModel2);
        ASTComplexType aSTComplexType2 = (ASTComplexType)this._groupTypeMap.get(qName);
        if (aSTComplexType2 == null) {
            this.parseModel(element, aSTModel2, aSTComplexType);
            aSTComplexType2 = new ASTComplexType(aSTModel2);
            this._classes.add(aSTComplexType2);
            this._groupTypeMap.put(qName, aSTComplexType2);
        }
    }

    public ASTElement parseXSDElement(Element element) {
        try {
            ASTElement aSTElement = this.parseXSDElement(element, null, null);
            return aSTElement;
        }
        catch (CouldNotParseException couldNotParseException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASTElement parseXSDElement(Element element, ASTModel aSTModel, ASTComplexType aSTComplexType) throws CouldNotParseException {
        Object object;
        Namespace namespace;
        block31: {
            ASTElement aSTElement;
            block30: {
                String string = null;
                String string2 = null;
                String string3 = null;
                QName qName = null;
                String string4 = CodeGenerator.getDefault(element);
                String string5 = CodeGenerator.getFixed(element);
                String string6 = element.getAttribute("nillable");
                String string7 = element.getAttribute("form");
                String string8 = element.getAttribute("minOccurs");
                String string9 = element.getAttribute("maxOccurs");
                boolean bl = this.isArray(element);
                namespace = this._currentNS;
                try {
                    int n;
                    ASTClass aSTClass;
                    Object object2;
                    Object object3;
                    Object object4;
                    String string10 = element.getAttribute("ref");
                    if (string10 != null && string10.length() == 0) {
                        string10 = null;
                    }
                    if (string10 != null) {
                        element = this.getElementDefinition(string10);
                        if (element == null) {
                            String string11 = Main._messages.get("xsd2java.warning.not.found", "element", string10, aSTComplexType == null ? "schema" : aSTComplexType.getTypeQName().toString());
                            this.warn(string11);
                            throw new CouldNotParseException(string11, element);
                        }
                        object4 = (Element)element.getParentNode();
                        this.readNamespaces((Element)object4);
                        this.validateGlobalElement(element);
                    }
                    string = element.getAttribute("name");
                    qName = this.getQName(string);
                    if (string == null || string.trim().length() == 0) {
                        object4 = Main._messages.get("xsd2java.error.without.name", "element", aSTComplexType == null ? "schema with targetNamspace=" + this._currentNS.getTargetNamespace() : aSTComplexType.getTypeQName().toString());
                        this.warn((String)object4);
                        throw new CouldNotParseException((String)object4, element);
                    }
                    string2 = element.getAttribute("type");
                    object4 = null;
                    Object object5 = null;
                    if (string2 == null || string2.trim().length() == 0) {
                        if (aSTComplexType == null) {
                            object3 = null;
                            object3 = this.getTypeMapping(qName);
                            if (object3 != null) {
                                this.info(Main._messages.get("xsd2java.verbose.mapping.exists", qName));
                                ASTElement aSTElement2 = null;
                                Object var28_25 = null;
                                this._currentNS = namespace;
                                return aSTElement2;
                            }
                        }
                        if ((object3 = this.parseAnonymousType(element, aSTComplexType)) == null) {
                            this.warn(Main._messages.get("xsd2java.error.element.without.type", string, aSTComplexType == null ? "" : aSTComplexType.getTypeQName().toString()));
                            string3 = _JLO;
                            object4 = new QName(this._currentNS.getNamespaceURI(), "any");
                        } else {
                            string3 = ((ASTClass)object3).fullName();
                            object4 = ((ASTClass)object3).getTypeQName();
                            object5 = object3;
                        }
                    } else {
                        object4 = this.getTypeQName(string2);
                        string3 = aSTComplexType != null ? (((QName)object4).equals(aSTComplexType.getTypeQName()) ? aSTComplexType.fullName() : this.parseType(string2)) : this.parseType(string2);
                        object5 = this.getASTClass((QName)object4);
                    }
                    if (string3 == null) {
                        this.warn(Main._messages.get("xsd2java.warning.complex.type.not.found", string2, qName));
                        string3 = _JLO;
                    }
                    if (bl) {
                        string3 = string3 + "[]";
                    }
                    if (aSTComplexType == null) {
                        ASTElement aSTElement3;
                        if (string2 == null || string2.trim().length() == 0) {
                            this._complexTypeMap.put(qName, string3);
                            this._complexTypeMap.put(string3, object5);
                            this._aliasTypeMap.put(qName, string3);
                        }
                        object3 = new QName(qName.getNamespaceURI(), qName.getLocalPart() + "_element");
                        this._aliasTypeMap.put(object3, object4);
                        this._aliasTypeMap.put(string3, object5);
                        this.info(Main._messages.get("xsd2java.verbose.type.mapping", qName, string3));
                        aSTElement = aSTElement3 = new ASTElement(JavaUtil.toVariableName(string), string3, qName, (QName)object4);
                        break block30;
                    }
                    int n2 = this.getMinOccurs(string8, aSTModel);
                    int n3 = this.getMaxOccurs(string9, aSTModel);
                    boolean bl2 = "true".equals(string6);
                    if (aSTModel != null && aSTModel.isChoice()) {
                        n2 = 0;
                    }
                    if ((bl2 || n2 == 0 && n3 == 1) && (object2 = PrimitiveUtil.getPrimitiveWrapper(string3)) != null) {
                        string3 = object2;
                    }
                    object2 = new ASTElement(JavaUtil.toVariableName(string), string3, qName, (QName)object4);
                    ((ASTField)object2).setNillable(bl2);
                    ((ASTElement)object2).setMinOccurs(n2);
                    ((ASTElement)object2).setMaxOccurs(n3);
                    this.setForm((ASTField)object2, string7, this._schemaInfo.isElementQualified());
                    boolean bl3 = this.isSimpleType((QName)object4);
                    boolean bl4 = false;
                    if (bl3 && (aSTClass = this.getASTClass((QName)object4)) != null) {
                        bl4 = aSTClass.isEnum();
                    }
                    ((ASTField)object2).setEnum(bl4);
                    if (this._validationRequired) {
                        if (string4 != null) {
                            if (bl3) {
                                ((ASTField)object2).setDefault(string4);
                            } else {
                                this.warn(Main._messages.get("xsd2java.warning.default.element.not.simple", string, aSTComplexType.getTypeQName().toString()));
                            }
                        }
                        if (string5 != null) {
                            if (bl3) {
                                ((ASTField)object2).setFixed(string5);
                            } else {
                                this.warn(Main._messages.get("xsd2java.warning.fixed.element.not.simple", string, aSTComplexType.getTypeQName().toString()));
                            }
                        }
                    }
                    if ((n = CodeGenerator.getField(aSTModel.getChildren(), ((ASTField)object2).getName())) != -1) {
                        object = Main._messages.get("xsd2java.error.same.name.element", aSTComplexType.getTypeQName().toString(), ((ASTField)object2).getName());
                        this.warn((String)object);
                        this.resolveFieldName((ASTField)object2, "Element", aSTComplexType);
                    }
                    if ((n = CodeGenerator.getField(aSTComplexType.getAttributes(), ((ASTField)object2).getName())) != -1) {
                        object = Main._messages.get("xsd2java.error.same.name.attribute", aSTComplexType.getTypeQName().toString(), ((ASTField)object2).getName());
                        this.warn((String)object);
                        this.resolveFieldName((ASTField)object2, "Element", aSTComplexType);
                    }
                    if (_illegal_field_names.contains(((ASTField)object2).getName())) {
                        this.resolveFieldName((ASTField)object2, "Element", aSTComplexType);
                    }
                    object = object2;
                    break block31;
                }
                catch (Throwable throwable) {
                    Object var28_28 = null;
                    this._currentNS = namespace;
                    throw throwable;
                }
            }
            Object var28_26 = null;
            this._currentNS = namespace;
            return aSTElement;
        }
        Object var28_27 = null;
        this._currentNS = namespace;
        return object;
    }

    private int getMinOccurs(String string, ASTModel aSTModel) {
        if (string == null) {
            return ASTModel.getDefMinOccurs(aSTModel.getName());
        }
        if (string.length() == 0) {
            return ASTModel.getDefMinOccurs(aSTModel.getName());
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 0) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.warn(Main._messages.get("xsd2java.warning.minOccurs.invalid", string));
        return ASTModel.getDefMinOccurs(aSTModel.getName());
    }

    private int getMaxOccurs(String string, ASTModel aSTModel) {
        if (string == null) {
            return 1;
        }
        if (string.length() == 0) {
            return 1;
        }
        if (string.equalsIgnoreCase("unbounded")) {
            return -1;
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 0) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.warn(Main._messages.get("xsd2java.warning.minOccurs.invalid", string));
        return 1;
    }

    private void validateGlobalAttribute(Element element) {
        String string;
        String string2 = string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", "attribute", "name, missing"));
            return;
        }
        string = element.getAttribute("use");
        if (string != null && string.length() > 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", string2, "use"));
        }
    }

    private void validateGlobalElement(Element element) {
        String string;
        String string2 = string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", "element", "name, missing"));
            return;
        }
        string = element.getAttribute("ref");
        if (string != null && string.length() > 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", string2, "ref"));
        }
        if ((string = element.getAttribute("minOccurs")) != null && string.length() > 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", string2, "minOccurs"));
        }
        if ((string = element.getAttribute("maxOccurs")) != null && string.length() > 0) {
            this.warn(Main._messages.get("xsd2java.warning.global.element.invalid", string2, "maxOccurs"));
        }
    }

    public ASTClass parseAnonymousType(Element element, ASTClass aSTClass) {
        String string = element.getAttribute("name");
        QName qName = this.getQName(string);
        if (aSTClass != null) {
            string = aSTClass.getTypeQName().getLocalPart() + "_" + qName.getLocalPart();
        }
        qName = new QName(qName.getNamespaceURI(), string);
        return this.parseAnonymousType(element, aSTClass, qName);
    }

    public ASTClass parseAnonymousType(Element element, ASTClass aSTClass, QName qName) {
        NodeList nodeList = CodeGenerator.getChildren(element, "complexType");
        if (nodeList.getLength() != 0) {
            ASTComplexType aSTComplexType = new ASTComplexType();
            try {
                aSTComplexType.setXMLType(qName);
                aSTComplexType.setPackage(this.getPackage(qName.getNamespaceURI()));
                aSTComplexType.setName(this.resolveClassName(aSTComplexType.getPackage(), JavaUtil.toClassName(qName.getLocalPart())));
                this.parseComplexType((Element)nodeList.item(0), aSTComplexType);
                if (aSTComplexType.getBaseClass() != null && (aSTComplexType.getBaseClass().isSimple() || aSTComplexType.getBaseClass().isSimpleContent())) {
                    if (!aSTComplexType.containsElement(null)) {
                        aSTComplexType.setMixed(false);
                        aSTComplexType.setSimpleContent(true);
                    } else {
                        String string = Main._messages.get("xsd2java.warning.invalid.simple.base", aSTComplexType.getBaseClass().getTypeQName(), aSTComplexType.getTypeQName());
                        this.warn(string);
                        throw new CouldNotParseException(string, element);
                    }
                }
                if (this._complexTypeMap.get(qName) == null) {
                    this._complexTypeMap.put(qName, aSTComplexType);
                    this._complexTypeMap.put(aSTComplexType.fullName(), aSTComplexType);
                }
                if (!this._classes.contains(aSTComplexType)) {
                    this._classes.add(aSTComplexType);
                }
                return aSTComplexType;
            }
            catch (CouldNotParseException couldNotParseException) {
                this.warn(Main._messages.get("xsd2java.warning.mapping", qName.toString(), _JLO));
                this._complexTypeMap.put(qName, _JLO);
                this.removeClass(aSTComplexType, this._classes);
                aSTComplexType.setName("Object");
                aSTComplexType.setPackage("java.lang");
                aSTComplexType.setGenerateBean(false);
                aSTComplexType.setGenerateMarshaller(false);
                return aSTComplexType;
            }
        }
        nodeList = CodeGenerator.getChildren(element, "simpleType");
        if (nodeList.getLength() != 0) {
            ASTSimpleType aSTSimpleType = new ASTSimpleType();
            aSTSimpleType.setXMLType(qName);
            aSTSimpleType.setPackage(this.getPackage(qName.getNamespaceURI()));
            aSTSimpleType.setName(this.resolveClassName(aSTSimpleType.getPackage(), JavaUtil.toClassName(qName.getLocalPart())));
            this.parseSimpleType((Element)nodeList.item(0), aSTSimpleType);
            if (this._simpleTypeMap.get(qName) == null) {
                this._simpleTypeMap.put(qName, aSTSimpleType);
                this._simpleTypeMap.put(aSTSimpleType.fullName(), aSTSimpleType);
            }
            return aSTSimpleType;
        }
        return null;
    }

    private ASTElement parseAny(Element element, int n, ASTClass aSTClass) {
        return new ASTElement("any" + n, _JLO, _ANY, null);
    }

    private void parseSimpleContent(Element element, ASTComplexType aSTComplexType) throws CouldNotParseException {
        NodeList nodeList;
        NodeList nodeList2 = CodeGenerator.getChildren(element, "restriction");
        if (nodeList2.getLength() != 0) {
            this.parseRestriction((Element)nodeList2.item(0), aSTComplexType);
        }
        if ((nodeList = CodeGenerator.getChildren(element, "extension")).getLength() != 0) {
            this.parseExtension((Element)nodeList.item(0), aSTComplexType);
        }
    }

    private void parseComplexContent(Element element, ASTComplexType aSTComplexType) throws CouldNotParseException {
        NodeList nodeList;
        NodeList nodeList2 = CodeGenerator.getChildren(element, "extension");
        if (nodeList2.getLength() == 1) {
            this.parseExtension((Element)nodeList2.item(0), aSTComplexType);
        }
        if ((nodeList = CodeGenerator.getChildren(element, "restriction")).getLength() == 1) {
            Element element2 = (Element)nodeList.item(0);
            this.parseRestriction(element2, aSTComplexType);
            aSTComplexType.setBaseClass(null);
        }
    }

    private void parseExtension(Element element, ASTComplexType aSTComplexType) throws CouldNotParseException {
        String string = element.getAttribute("base");
        if (string != null && string.trim().length() > 0) {
            this.extend(string, aSTComplexType, "extension");
        }
        this.parseComplexType(element, aSTComplexType);
    }

    private void extend(String string, ASTClass aSTClass, String string2) {
        TypeMap typeMap;
        ASTClass aSTClass2;
        QName qName = this.getTypeQName(string);
        String string3 = this.parseType(string);
        if (string3 == null) {
            this.warn(Main._messages.get("xsd2java.error.derivation.base.missing", qName.toString(), aSTClass.getTypeQName().toString()));
        }
        if ((aSTClass2 = this.getASTClass(qName)) == null && (typeMap = _primMapper.get(this.getTypeQName(string))) != null) {
            aSTClass2 = this.getBuiltInAST(typeMap);
        }
        if (aSTClass2 != null && aSTClass2.fullName().equals(_JLO)) {
            aSTClass2 = null;
        }
        if (aSTClass2 == null) {
            if (!aSTClass.isComplex()) {
                aSTClass2 = new ASTSimpleType();
                aSTClass2.setXMLType(qName);
                aSTClass2.setName("String");
                aSTClass2.setPackage("java.lang");
                aSTClass2.setBasic(true);
            }
        } else if (aSTClass2.isEnum()) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.base.enum.invalid", aSTClass2.getTypeQName(), aSTClass.getTypeQName()));
        }
        if (aSTClass2 != null) {
            this.checkForValidDerivation(aSTClass2, aSTClass, string2);
        }
        aSTClass.setBaseClass(aSTClass2);
    }

    private void checkForValidDerivation(ASTClass aSTClass, ASTClass aSTClass2, String string) {
        if (string.equalsIgnoreCase(aSTClass.getFinalDerivation())) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.ct.final", aSTClass2.getTypeQName().toString(), aSTClass.getTypeQName().toString(), string));
        }
        if (string.equalsIgnoreCase("all")) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.ct.final", aSTClass2.getTypeQName().toString(), aSTClass.getTypeQName().toString(), string));
        }
    }

    private ASTClass getBuiltInAST(TypeMap typeMap) {
        ASTClass aSTClass = this.getBuiltInAST(typeMap.getJavaType());
        aSTClass.setTypeQName(typeMap.getXMLType().getQName());
        if (SimpleTypeUtil.isBasicType(typeMap.getXMLType().getQName())) {
            aSTClass.setBasic(true);
        }
        return aSTClass;
    }

    private ASTClass getBuiltInAST(Class clazz) {
        ASTClass aSTClass;
        ASTSimpleType aSTSimpleType = new ASTSimpleType();
        aSTSimpleType.setName(CodeGenerator.getClassName(clazz));
        if (clazz.isPrimitive()) {
            return aSTSimpleType;
        }
        if (clazz == (array$B == null ? (array$B = CodeGenerator.class$("[B")) : array$B)) {
            return aSTSimpleType;
        }
        if (clazz.getPackage().getName().equals("com.sssw.jbroker.web.xsd") && (aSTClass = this.getValueType(clazz)) != null) {
            aSTSimpleType.setBaseClass(aSTClass);
        }
        return aSTSimpleType;
    }

    private ASTClass getValueType(Class clazz) {
        Object object;
        Class<?> clazz2 = null;
        try {
            object = clazz.getMethod("getValue", new Class[0]);
            clazz2 = ((Method)object).getReturnType();
        }
        catch (Throwable throwable) {
            return null;
        }
        object = new ASTClass(clazz2);
        return object;
    }

    private ASTClass getASTClass(String string) {
        QName qName = this.getTypeQName(string);
        return this.getASTClass(qName);
    }

    private ASTClass getASTClass(QName qName) {
        String string = (String)this._simpleTypeMap.get(qName);
        ASTClass aSTClass = (ASTClass)this._simpleTypeMap.get(string);
        if (aSTClass != null) {
            return aSTClass;
        }
        string = (String)this._complexTypeMap.get(qName);
        aSTClass = (ASTClass)this._complexTypeMap.get(string);
        if (aSTClass != null) {
            return aSTClass;
        }
        string = (String)this._aliasTypeMap.get(qName);
        aSTClass = (ASTClass)this._aliasTypeMap.get(string);
        return aSTClass;
    }

    private QName getQName(String string) {
        String string2 = CodeGenerator.getLocalName(string);
        String string3 = CodeGenerator.getPrefix(string);
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        String string4 = string3 == null ? this._currentNS.getTargetNamespace() : this._currentNS.getNamespaceURI(string3);
        return new QName(string4, string2);
    }

    private QName getTypeQName(String string) {
        String string2 = CodeGenerator.getLocalName(string);
        String string3 = CodeGenerator.getPrefix(string);
        String string4 = string3 == null ? this._currentNS.getNamespaceURI() : this._currentNS.getNamespaceURI(string3);
        return new QName(string4, string2);
    }

    public void outputJavaFiles(Vector vector, String string, Map map) throws IOException {
        if (this._final) {
            this.info("writing bean classes as final");
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ASTClass aSTClass = (ASTClass)vector.get(n2);
            if (aSTClass.generateBean()) {
                String string2 = aSTClass.getPackage() == null ? "" : aSTClass.getPackage();
                String string3 = this._destDir + string2.replace('.', File.separatorChar);
                this.ensureDirExists(string3);
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                if (this._failedTypes.size() != 0) {
                    aSTClass.eraseFailedTypes(this._failedTypes);
                }
                if (this._excClasses.size() != 0) {
                    aSTClass.replaceTypes(this._excClasses);
                }
                if (!aSTClass.isArray()) {
                    this.writeBean(aSTClass, string3, map);
                    if (aSTClass.generateMarshaller()) {
                        this.writeMarshaler(aSTClass, string3);
                    }
                }
                this.writeHolder(aSTClass, string3);
            }
            ++n2;
        }
    }

    private void writeHolder(ASTClass aSTClass, String string) throws IOException {
        String string2 = null;
        String string3 = aSTClass.fullName();
        if (PrimitiveUtil.isPrimitive(string3)) {
            return;
        }
        if (aSTClass.isArray()) {
            string3 = aSTClass.getArrayType();
            int n = string3.indexOf("[");
            string2 = string3.substring(0, n);
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "holders" + File.separator;
        this.ensureDirExists(string);
        String string4 = string + aSTClass.getName() + "Holder.java";
        FileOutputStream fileOutputStream = new FileOutputStream(string4);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        Formatter formatter = new Formatter("    ", printWriter);
        formatter.println("// Generated from " + this.escape(this._xsdsource));
        formatter.println("// On " + new Date().toString());
        formatter.println();
        String string5 = aSTClass.getPackage();
        string5 = string5 == null || string5.length() == 0 ? "holders" : string5 + ".holders";
        this._holderPackages.add(string5);
        formatter.print("package ");
        formatter.print(string5);
        formatter.println(";");
        formatter.println();
        if (aSTClass.isArray()) {
            if (!PrimitiveUtil.isPrimitive(string2)) {
                formatter.println("import " + string2 + ";");
            }
        } else {
            formatter.println("import " + aSTClass.fullName() + ";");
        }
        formatter.println();
        formatter.print("public final class ");
        formatter.print(aSTClass.getName());
        formatter.println("Holder implements javax.xml.rpc.holders.Holder");
        formatter.println("{");
        formatter.startBlock();
        formatter.print("public ");
        formatter.print(string3);
        formatter.println(" value;");
        formatter.println();
        formatter.print("public ");
        formatter.print(aSTClass.getName());
        formatter.println("Holder() { }");
        formatter.println();
        formatter.print("public ");
        formatter.print(aSTClass.getName());
        formatter.print("Holder(");
        formatter.print(string3);
        formatter.println(" val)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("value = val;");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        this._generatedFiles.addElement(new File(string4));
        this.info(Main._messages.get("xsd2java.verbose.writing", string4));
        this._holderMap.put(string3, string5 + "." + aSTClass.getName() + "Holder");
    }

    private void writeBean(ASTClass aSTClass, String string, Map map) throws IOException {
        if (aSTClass.isException()) {
            String string2 = aSTClass.getName();
            this.setExceptionNames(aSTClass);
            this._writeBean(aSTClass, string, map);
            aSTClass.setName(string2);
            aSTClass.setException(false);
            this._writeBean(aSTClass, string, map);
            this._complexTypeMap.put(aSTClass.getTypeQName(), aSTClass.fullName());
            aSTClass.setException(true);
        } else {
            this._writeBean(aSTClass, string, map);
        }
    }

    private void setExceptionNames(ASTClass aSTClass) {
        String string;
        if (aSTClass == null) {
            return;
        }
        String string2 = string = aSTClass.getName();
        string2 = aSTClass.getExceptionName();
        aSTClass.setName(string2);
    }

    private void _writeBean(ASTClass aSTClass, String string, Map map) throws IOException {
        String string2 = string + aSTClass.getName() + ".java";
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        Formatter formatter = new Formatter("    ", printWriter);
        formatter.println("// Generated from " + this.escape(this._xsdsource));
        formatter.println("// On " + new Date().toString());
        formatter.println();
        BeanWriter.writeBean(aSTClass, map, formatter);
        fileOutputStream.flush();
        fileOutputStream.close();
        this._generatedFiles.addElement(new File(string2));
        this.info(Main._messages.get("xsd2java.verbose.writing", string2));
    }

    private void writeMarshaler(ASTClass aSTClass, String string) throws IOException {
        if (aSTClass.isException()) {
            String string2 = aSTClass.getName();
            this.setExceptionNames(aSTClass);
            this._writeMarshaler(aSTClass, string);
            aSTClass.setName(string2);
            aSTClass.setException(false);
            this._writeMarshaler(aSTClass, string);
            aSTClass.setException(true);
        } else {
            this._writeMarshaler(aSTClass, string);
        }
    }

    private void _writeMarshaler(ASTClass aSTClass, String string) throws IOException {
        Object object;
        if (this._nomarsh) {
            return;
        }
        String string2 = string + aSTClass.getName() + "Marshaler.java";
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        Formatter formatter = new Formatter("    ", printWriter);
        formatter.println("// Generated from " + this.escape(this._xsdsource));
        formatter.println("// On " + new Date().toString());
        formatter.println();
        if (aSTClass.isModel()) {
            object = new ModelMarshalerWriter(this._simpleTypeMap, this._complexTypeMap, this._params, this._ps);
            ((ModelMarshalerWriter)object).writeMarshaler((ASTComplexType)aSTClass, this._final, formatter);
        } else {
            object = new MarshalerWriter(this._simpleTypeMap, this._complexTypeMap, this._params, this._ps);
            ((MarshalerWriter)object).writeMarshaler(aSTClass, this._final, formatter);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        this._generatedFiles.addElement(new File(string2));
        this.info(Main._messages.get("xsd2java.verbose.writing", string2));
        if (this._currentNS.getTargetNamespace().equals(_jbrokerQName.getNamespaceURI())) {
            return;
        }
        if (aSTClass.isModel()) {
            return;
        }
        object = this.getTypeMappingEntry(aSTClass);
        this._typeMappings.add(object);
    }

    private String getTypeMappingEntry(ASTClass aSTClass) {
        String string = aSTClass.fullName();
        return this.getTypeMappingEntry(string, aSTClass.getXMLType());
    }

    private String getTypeMappingEntry(String string, QName qName) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("Marshaler ");
        stringBuffer.append(string);
        stringBuffer.append("Marshaler ");
        stringBuffer.append(qName.getNamespaceURI());
        stringBuffer.append(" ");
        stringBuffer.append(qName.getLocalPart());
        stringBuffer.append(" ");
        stringBuffer.append("none");
        return stringBuffer.toString();
    }

    private boolean compileJava() {
        Object object;
        boolean bl = true;
        if (!this._nocompile && this._generatedFiles.size() > 0) {
            if (this._verbose) {
                this._ps.println(Main._messages.get("xsd2java.verbose.compiling"));
            }
            Compiler compiler = new Compiler();
            object = null;
            Object v = this._params.get("d");
            if (v instanceof File) {
                object = v.toString();
            } else if (v instanceof String) {
                object = (String)v;
            } else if (v instanceof File[]) {
                object = ((File[])v)[0].toString();
            } else if (v instanceof String[]) {
                object = ((String[])v)[0];
            }
            if (object != null) {
                this.ensureDirExists((String)object);
            }
            String string = System.getProperty("java.class.path");
            Object v2 = this._params.get("classpath");
            String string2 = v2 != null ? (v2 instanceof String ? (String)v2 : ((String[])v2)[0]) : string;
            System.setProperty("java.class.path", string2);
            bl = compiler.compile(this._params, this._generatedFiles);
            System.setProperty("java.class.path", string);
        }
        if (!this._keep) {
            int n = 0;
            while (n < this._generatedFiles.size()) {
                object = (File)this._generatedFiles.elementAt(n);
                this.info(Main._messages.get("xsd2java.verbose.deleting", ((File)object).getName()));
                ((File)object).delete();
                ++n;
            }
        }
        return bl;
    }

    public String getTMSource() {
        return this._tmsource;
    }

    private void writeTypeMappings() throws IOException {
        if (this._typeMappings.size() == 0) {
            return;
        }
        int n = this._xsdsource.lastIndexOf(File.separatorChar);
        String string = n == -1 ? this._xsdsource : this._xsdsource.substring(n + 1);
        n = string.lastIndexOf(47);
        string = n == -1 ? string : string.substring(n + 1);
        n = string.indexOf(63);
        string = n == -1 ? string : string.substring(0, n);
        this._tmsource = this._destDir + string + ".xmlrpc.type.mappings";
        FileOutputStream fileOutputStream = new FileOutputStream(this._tmsource);
        this.info(Main._messages.get("xsd2java.verbose.writing", this._tmsource));
        PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
        Iterator iterator = this._typeMappings.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            printWriter.println(string2);
        }
        printWriter.flush();
        printWriter.close();
    }

    private TypeMap getTypeMapping(QName qName) {
        TypeMap typeMap = _primMapper.get(qName);
        if (typeMap != null) {
            return typeMap;
        }
        typeMap = this._mapper.get(qName);
        return typeMap;
    }

    String escape(String string) {
        return string.replace('\\', '/');
    }

    private void ensureDirExists(String string) {
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        if (!file.mkdirs()) {
            CodeGenerator.error(Main._messages.get("xsd2java.error.unable.to.create.directory", file));
        }
    }

    private static void error(String string) {
        throw new RuntimeException("error: " + string);
    }

    private void info(String string) {
        if (this._verbose) {
            this._ps.println(string);
        }
    }

    private void warn(String string) {
        if (!this._nowarn) {
            this._ps.println("warn: " + string);
        }
    }

    private static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("failed to instantiate parser: " + parserConfigurationException);
        }
    }

    public static String getPrefix(Attr attr) {
        return CodeGenerator.getPrefix(attr.getValue());
    }

    public static String getPrefix(String string) {
        int n = string.lastIndexOf(COLON);
        return n == -1 ? null : string.substring(0, n);
    }

    public static String getLocalName(Attr attr) {
        return CodeGenerator.getLocalName(attr.getValue());
    }

    public static String getLocalName(String string) {
        int n = string.lastIndexOf(COLON);
        return n == -1 ? string : string.substring(n + 1);
    }

    private boolean isSimpleType(String string) {
        QName qName = this.getTypeQName(string);
        return this.isSimpleType(qName);
    }

    public boolean isSimpleType(QName qName) {
        if (_primMapper.get(qName) != null) {
            return true;
        }
        return this._simpleTypeMap.get(qName) != null;
    }

    public static NodeList getChildren(Element element, String string) {
        return CodeGenerator.getChildren(element, string, false);
    }

    public static NodeList getChildren(Element element, String string, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 0;
        while (n2 < n) {
            if (nodeList.item(n2) instanceof Element) {
                Element element2 = (Element)nodeList.item(n2);
                if (element2.getTagName().endsWith(string)) {
                    arrayList.add(element2);
                }
                if (bl) {
                    NodeListImpl nodeListImpl = (NodeListImpl)CodeGenerator.getChildren(element2, string, bl);
                    arrayList.addAll(nodeListImpl.getList());
                }
            }
            ++n2;
        }
        return new NodeListImpl(arrayList);
    }

    private String resolveClassName(String string, String string2) {
        Integer n;
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this._classNames.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
            this._classNames.put(string, hashMap);
        }
        if ((n = (Integer)hashMap.get(string2)) == null) {
            n = new Integer(0);
        } else {
            int n2 = n;
            n = new Integer(++n2);
            string2 = string2 + n2;
        }
        hashMap.put(string2, n);
        return string2;
    }

    private void setClassInfo(ASTClass aSTClass) {
        QName qName = aSTClass.getXMLType();
        String string = this.getPackage(qName.getNamespaceURI());
        aSTClass.setPackage(string);
        String string2 = JavaUtil.toClassName(qName.getLocalPart());
        if (!aSTClass.isSimple() && this._excTypes.contains(qName)) {
            aSTClass.setException(true);
        }
        string2 = this.resolveClassName(string, string2);
        aSTClass.setName(string2);
        aSTClass.setValidationRequired(this._validationRequired);
    }

    private String getPackage(String string) {
        String string2 = (String)this._ns2pack.get(string);
        if (string2 == null) {
            string2 = this._package;
        }
        if (string2 == null) {
            string2 = XMLUtil.getPackageForURI(string);
        }
        return string2;
    }

    public static ArrayList clone(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        try {
            int n = arrayList.size();
            ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList2.add(((ASTObject)arrayList.get(n2)).clone());
                ++n2;
            }
            return arrayList2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CodeGenerator.error("error occured while cloning:" + cloneNotSupportedException.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _constraintMap.put("maxInclusive", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxInclusive == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxInclusive = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMaxInclusive")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxInclusive);
        _constraintMap.put("minInclusive", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinInclusive == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinInclusive = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMinInclusive")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinInclusive);
        _constraintMap.put("maxExclusive", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxExclusive == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxExclusive = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMaxExclusive")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxExclusive);
        _constraintMap.put("minExclusive", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinExclusive == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinExclusive = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMinExclusive")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinExclusive);
        _constraintMap.put("totalDigits", class$com$sssw$jbroker$tools$xsd2java$ast$ASTTotalDigits == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTTotalDigits = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTTotalDigits")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTTotalDigits);
        _constraintMap.put("fractionDigits", class$com$sssw$jbroker$tools$xsd2java$ast$ASTFractionDigits == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTFractionDigits = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTFractionDigits")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTFractionDigits);
        _constraintMap.put("length", class$com$sssw$jbroker$tools$xsd2java$ast$ASTLength == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTLength = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTLength")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTLength);
        _constraintMap.put("minLength", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinLength == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinLength = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMinLength")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMinLength);
        _constraintMap.put("maxLength", class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxLength == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxLength = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTMaxLength")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTMaxLength);
        _constraintMap.put("pattern", class$com$sssw$jbroker$tools$xsd2java$ast$ASTPattern == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTPattern = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTPattern")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTPattern);
        _constraintMap.put("whiteSpace", class$com$sssw$jbroker$tools$xsd2java$ast$ASTWhiteSpace == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTWhiteSpace = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTWhiteSpace")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTWhiteSpace);
        _constraintMap.put("enumeration", class$com$sssw$jbroker$tools$xsd2java$ast$ASTEnumeration == null ? (class$com$sssw$jbroker$tools$xsd2java$ast$ASTEnumeration = CodeGenerator.class$("com.sssw.jbroker.tools.xsd2java.ast.ASTEnumeration")) : class$com$sssw$jbroker$tools$xsd2java$ast$ASTEnumeration);
        _illegal_field_names = new HashSet();
        _illegal_field_names.add("content");
        _illegal_field_names.add("value");
        _illegal_field_names.add("obj");
        _illegal_field_names.add("object");
        _illegal_field_names.add("qname");
        _illegal_field_names.add("fName");
        _illegal_field_names.add("os");
        _illegal_field_names.add("is");
        _illegal_field_names.add("javaType");
        _illegal_field_names.add("attVal");
        _illegal_field_names.add("attribs");
        _illegal_field_names.add("attrs");
        _illegal_field_names.add("sattrs");
        _illegal_field_names.add("attr");
        _illegal_field_names.add("attributes");
        _listConstraints = new HashSet();
        _listConstraints.add("length");
        _listConstraints.add("minLength");
        _listConstraints.add("maxLength");
        _listConstraints.add("enumeration");
        _listConstraints.add("pattern");
        _listConstraints.add("whitespace");
    }

    private static class SchemaInfo {
        private String _namespace;
        private boolean _attributeQualified;
        private boolean _elementQualified;
        private String _finalDefault;
        private String _blockDefault;

        SchemaInfo(Element element, String string) {
            this._namespace = string;
            String string2 = element.getAttribute("attributeFormDefault");
            this._attributeQualified = string2 == null || string2.length() == 0 ? false : "qualified".equals(string2);
            string2 = element.getAttribute("elementFormDefault");
            this._elementQualified = string2 == null || string2.length() == 0 ? false : "qualified".equals(string2);
            this._finalDefault = element.getAttribute("finalDefault");
            if (this._finalDefault == null || this._finalDefault.length() == 0) {
                this._finalDefault = null;
            }
            this._blockDefault = element.getAttribute("blockDefault");
            if (this._blockDefault == null || this._blockDefault.length() == 0) {
                this._blockDefault = null;
            }
        }

        public String getNamespace() {
            return this._namespace;
        }

        boolean isAttributeQualified() {
            return this._attributeQualified;
        }

        boolean isElementQualified() {
            return this._elementQualified;
        }

        void setElementQualified(boolean bl) {
            this._elementQualified = bl;
        }

        String getFinalDefault() {
            return this._finalDefault;
        }

        String getBlockDefault() {
            return this._blockDefault;
        }

        public String toString() {
            return "attQ=" + this._attributeQualified + ",elemQ=" + this._elementQualified + ",final=" + this._finalDefault + ",block=" + this._blockDefault;
        }
    }

    static final class CouldNotParseException
    extends Exception {
        private Element _element;

        CouldNotParseException(String string, Element element) {
            super(string);
            this._element = element;
        }

        Element getElement() {
            return this._element;
        }
    }

    static final class NodeListImpl
    implements NodeList {
        private final ArrayList _list;

        public ArrayList getList() {
            return this._list;
        }

        NodeListImpl(ArrayList arrayList) {
            this._list = arrayList;
        }

        NodeListImpl(Element element) {
            this._list = new ArrayList(1);
            this._list.add(element);
        }

        public Node item(int n) {
            return (Node)this._list.get(n);
        }

        public int getLength() {
            return this._list.size();
        }
    }
}

