/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.BeanWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleContentWriter;
import com.sssw.jbroker.tools.xsd2java.ast.ASTClass;
import com.sssw.jbroker.tools.xsd2java.ast.ASTComplexType;
import com.sssw.jbroker.tools.xsd2java.ast.ASTElement;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTModel;
import com.sssw.jbroker.util.Formatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class ComplexBeanWriter
extends SimpleContentWriter {
    private HashSet _modelBeans = new HashSet();

    public static void writeBean(ASTComplexType aSTComplexType, Map map, Formatter formatter) {
        ComplexBeanWriter complexBeanWriter = new ComplexBeanWriter(map);
        complexBeanWriter.writeBean(aSTComplexType, formatter);
    }

    public ComplexBeanWriter(Map map) {
        super(map);
    }

    private void writeBean(ASTComplexType aSTComplexType, Formatter formatter) {
        boolean bl;
        if (aSTComplexType.getPackage() != null && aSTComplexType.getPackage().length() > 0) {
            formatter.println("package " + aSTComplexType.getPackage() + ";");
        }
        formatter.println();
        formatter.print("public ");
        formatter.print(this._final ? "final class " : "class ");
        formatter.println(aSTComplexType.getName());
        boolean bl2 = bl = aSTComplexType.getBaseClass() == null ? true : aSTComplexType.getBaseClass().isBasic();
        if (!bl) {
            if (aSTComplexType.isException()) {
                formatter.println("    extends " + aSTComplexType.getBaseClass().getPackage() + "." + aSTComplexType.getBaseClass().getExceptionName());
            } else {
                formatter.println("    extends " + aSTComplexType.getBaseClass().fullName());
            }
        } else if (aSTComplexType.isException()) {
            formatter.println("    extends java.lang.Exception");
        }
        formatter.println("    implements java.io.Serializable");
        formatter.println("{");
        formatter.startBlock();
        boolean bl3 = aSTComplexType.getModel().isChoice();
        if (!bl3) {
            this.writeConstructors(aSTComplexType, formatter);
        }
        if (this._validationRequired) {
            this.writeFixedFields(aSTComplexType, formatter);
        }
        this.writeBeanProperties(aSTComplexType.getAttributes(), formatter);
        if (aSTComplexType.hasAnyAttributes()) {
            this.writeOtherAttributesProperty(formatter);
        }
        if (bl3) {
            this.writeChoiceProperties(aSTComplexType.getModel().getChildren(), formatter);
        } else {
            this.writeBeanProperties(aSTComplexType.getModel().getChildren(), formatter);
        }
        if (aSTComplexType.isMixed()) {
            this.writeBeanProperty("contents", "java.util.ArrayList", formatter);
        }
        int n = 0;
        while (n < aSTComplexType.getMethods().size()) {
            String string = (String)aSTComplexType.getMethods().get(n);
            formatter.print(string);
            formatter.println();
            ++n;
        }
        if (bl3) {
            this.writeChoiceToString(aSTComplexType, formatter);
            this.writeChoiceEquals(aSTComplexType, formatter);
        } else {
            this.writeToString(aSTComplexType, formatter);
            this.writeEquals(aSTComplexType, formatter);
        }
        this.writeHashCode(aSTComplexType, formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        formatter.close();
    }

    private void writeConstructors(ASTComplexType aSTComplexType, Formatter formatter) {
        this.writeNoArgConstructor("public", aSTComplexType, formatter);
        StringBuffer stringBuffer = new StringBuffer(128);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        this.getMethodParamsAndSetFields(aSTComplexType, stringBuffer, stringBuffer2);
        if (stringBuffer.length() == 0) {
            return;
        }
        formatter.print("public " + aSTComplexType.getName() + "(");
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        formatter.print(stringBuffer);
        formatter.println(") {");
        formatter.startBlock();
        formatter.print(new String(stringBuffer2));
        formatter.endBlock();
        formatter.println("}");
    }

    private void getMethodParamsAndSetFields(ASTComplexType aSTComplexType, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.getMethodParamsAndSetFieldsForAttributes(aSTComplexType, stringBuffer, stringBuffer2);
        this.getMethodParamsAndSetFieldsForModel(aSTComplexType, stringBuffer, stringBuffer2);
    }

    private void getMethodParamsAndSetFieldsForAttributes(ASTComplexType aSTComplexType, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        ASTComplexType aSTComplexType2 = (ASTComplexType)aSTComplexType.getBaseClass();
        if (aSTComplexType2 != null) {
            this.getMethodParamsAndSetFieldsForAttributes(aSTComplexType2, stringBuffer, stringBuffer2);
        }
        this.getMethodParamsAndSetFieldsForFields(aSTComplexType.getAttributes(), stringBuffer, stringBuffer2);
    }

    private void getMethodParamsAndSetFieldsForModel(ASTComplexType aSTComplexType, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        ASTComplexType aSTComplexType2 = (ASTComplexType)aSTComplexType.getBaseClass();
        if (aSTComplexType2 != null) {
            this.getMethodParamsAndSetFieldsForModel(aSTComplexType2, stringBuffer, stringBuffer2);
        }
        this.getMethodParamsAndSetFieldsForFields(aSTComplexType.getModel().getChildren(), stringBuffer, stringBuffer2);
    }

    private void getMethodParamsAndSetFieldsForFields(ArrayList arrayList, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            this.getMethodParamsAndSetFieldsForField(aSTField, stringBuffer, stringBuffer2);
            ++n2;
        }
    }

    private void getMethodParamsAndSetFieldsForField(ASTField aSTField, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (this._validationRequired && aSTField.getFixed() != null) {
            return;
        }
        String string = aSTField.getName();
        String string2 = aSTField.getClassName();
        if (aSTField.isModel() && ((ASTModel)aSTField).isArray()) {
            string2 = string2 + "[]";
        }
        this.getMethodParamsAndSetFieldsFor(string, string2, stringBuffer, stringBuffer2);
    }

    private void getMethodParamsAndSetFieldsForModel(ASTModel aSTModel, ASTClass aSTClass, StringBuffer stringBuffer, StringBuffer stringBuffer2, int n, int n2) {
        String string = aSTModel.getName();
        String string2 = this.getModelClassName(string, aSTClass);
        if (aSTModel.isArray()) {
            string2 = string2 + "[]";
        }
        this.getMethodParamsAndSetFieldsFor(string, string2, stringBuffer, stringBuffer2);
    }

    private void getMethodParamsAndSetFieldsFor(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.getMethodParams(string, string2, stringBuffer);
        this.getSetField(string, stringBuffer2);
    }

    private void getMethodParams(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append("Val, ");
    }

    private void getSetField(String string, StringBuffer stringBuffer) {
        stringBuffer.append(BeanWriter.setMethodName(string));
        stringBuffer.append('(');
        stringBuffer.append(string);
        stringBuffer.append("Val);\n        ");
    }

    private void writeNoArgConstructor(String string, ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println(string + " " + aSTComplexType.getName() + "() {}");
        formatter.println();
    }

    public void writeToString(ASTComplexType aSTComplexType, Formatter formatter) {
        boolean bl;
        formatter.println("public java.lang.String toString() {");
        formatter.startBlock();
        formatter.println("java.lang.StringBuffer buffer = new java.lang.StringBuffer();");
        formatter.println("buffer.append(\"" + aSTComplexType.fullName() + "={\");");
        ArrayList arrayList = aSTComplexType.getAttributes();
        ArrayList arrayList2 = aSTComplexType.getModel().getChildren();
        ArrayList arrayList3 = new ArrayList(arrayList);
        arrayList3.addAll(arrayList2);
        this.writeToStringForFields(arrayList3, formatter);
        boolean bl2 = bl = aSTComplexType.getBaseClass() == null ? true : aSTComplexType.getBaseClass().isBasic();
        if (!bl) {
            formatter.println("buffer.append(super.toString());");
        }
        formatter.println("buffer.append(\"}\");");
        formatter.println("return buffer.toString();");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeChoiceToString(ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println("public java.lang.String toString()");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("java.lang.StringBuffer buffer = new java.lang.StringBuffer();");
        formatter.println("buffer.append(\"" + aSTComplexType.fullName() + "={\");");
        formatter.println("buffer.append(\"\"+_value);");
        formatter.println("return new java.lang.String(buffer);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeToStringForFields(ArrayList arrayList, Formatter formatter) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            String string = "_" + aSTField.getName();
            String string2 = aSTField.getClassName();
            if (this._validationRequired && aSTField.getFixed() != null) {
                string = this.getFixedVarName("", aSTField.getName());
            }
            formatter.println("buffer.append(\"" + string + "=\"+" + string + ");");
            if (n2 != n - 1) {
                formatter.println("buffer.append(\",\");");
            }
            ++n2;
        }
    }

    public void writeHashCode(ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println("public int hashCode() { return toString().hashCode(); }");
        formatter.println();
    }

    public void writeEquals(ASTComplexType aSTComplexType, Formatter formatter) {
        boolean bl;
        formatter.println("public boolean equals(java.lang.Object object) {");
        formatter.startBlock();
        formatter.println("if (object == null) return false;");
        formatter.println("if (!(" + aSTComplexType.fullName() + ".class.isAssignableFrom(object.getClass()))) return false;");
        formatter.println(aSTComplexType.fullName() + " obj = (" + aSTComplexType.fullName() + ") object;");
        formatter.println();
        this.writeEqualsForFields(aSTComplexType.getAttributes(), formatter);
        this.writeEqualsForFields(aSTComplexType.getModel().getChildren(), formatter);
        boolean bl2 = bl = aSTComplexType.getBaseClass() == null ? true : aSTComplexType.getBaseClass().isBasic();
        if (bl) {
            formatter.println("return true;");
        } else {
            formatter.println("return super.equals(obj);");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeChoiceEquals(ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println("public boolean equals(java.lang.Object object) {");
        formatter.startBlock();
        formatter.println("if (!(object instanceof " + aSTComplexType.fullName() + ")) return false;");
        formatter.println(aSTComplexType.fullName() + " obj = (" + aSTComplexType.fullName() + ") object;");
        formatter.println();
        formatter.println("if (this._value == null) return (obj._value == null);");
        formatter.println(" return this._value.equals(obj._value);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeFixedFields(ASTComplexType aSTComplexType, Formatter formatter) {
        this.writeFixedValuesForAttributes(aSTComplexType, formatter);
        this.writeFixedValuesForModel(aSTComplexType, formatter);
    }

    private void writeFixedValuesForModel(ASTComplexType aSTComplexType, Formatter formatter) {
        ASTModel aSTModel = aSTComplexType.getModel();
        ArrayList arrayList = aSTModel.getChildren();
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (arrayList.get(n2) instanceof ASTElement) {
                ASTElement aSTElement = (ASTElement)arrayList.get(n2);
                this.writeFixedValueForField(aSTElement, formatter);
            }
            ++n2;
        }
    }

    private String getModelClassName(String string, ASTClass aSTClass) {
        return aSTClass.getName() + string;
    }

    private void writeChoiceProperties(ArrayList arrayList, Formatter formatter) {
        this.writeChoiceHeaders(formatter);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            BeanWriter.writeField("public final static", aSTField.getName(), "int", "" + n2, formatter);
            this.writeChoiceProperty(aSTField, n2, formatter);
            ++n2;
        }
    }

    private void writeChoiceHeaders(Formatter formatter) {
        formatter.println("private int _choice = -1;");
        formatter.println();
        formatter.println("public int getChoice() { return _choice; }");
        formatter.println();
        formatter.println("private java.lang.Object _value;");
        formatter.println();
    }

    private void writeChoiceProperty(ASTField aSTField, int n, Formatter formatter) {
        String string = aSTField.getClassName();
        if (aSTField.isModel() && ((ASTModel)aSTField).isArray()) {
            string = string + "[]";
            BeanWriter.writeGetMethod("_value", true, aSTField.getName(), string, formatter);
        } else {
            BeanWriter.writeGetMethod("_value", true, aSTField, formatter);
        }
        this.writeChoiceSetMethod(aSTField, n, formatter);
    }

    public void writeChoiceSetMethod(ASTField aSTField, int n, Formatter formatter) {
        String string = aSTField.getName();
        String string2 = aSTField.getClassName();
        if (aSTField.isModel() && ((ASTModel)aSTField).isArray()) {
            string2 = string2 + "[]";
        }
        String string3 = "_value";
        formatter.print("public void ");
        formatter.print(BeanWriter.setMethodName(string));
        formatter.print("(");
        formatter.print(string2);
        formatter.write(" ");
        formatter.print(string + "Val");
        formatter.println(") {");
        formatter.startBlock();
        if (this._validationRequired && aSTField.getFixed() != null) {
            formatter.println("throw new IllegalArgumentException(\"Fixed value can not be set!\");");
        } else {
            formatter.print("_choice = ");
            formatter.print(n);
            formatter.println(';');
            formatter.print(string3);
            formatter.print(" = ");
            formatter.print(string + "Val");
            formatter.println(";");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeBeanProperty(ASTField aSTField, Formatter formatter) {
        if (aSTField.isModel() && ((ASTModel)aSTField).isArray()) {
            this.writeBeanProperty(aSTField.getName(), aSTField.getClassName() + "[]", formatter);
        } else {
            super.writeBeanProperty(aSTField, formatter);
        }
    }
}

