/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.CodeGenerator;
import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.Messages;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class Main {
    private static final boolean NO_ERROR = true;
    private static final boolean COMPILE_ERROR = false;
    private static final boolean _debug = false;
    private boolean _status = true;
    private CommandLine _cmdline;
    private static boolean _verbose;
    private static boolean _warn;
    public static final Messages _messages;
    private static final String _usage;
    private PrintStream _ps = null;
    static /* synthetic */ Class class$com$sssw$jbroker$tools$xsd2java$Main;

    public Main(OutputStream outputStream) {
        this._ps = new PrintStream(outputStream);
    }

    public static void main(String[] stringArray) {
        try {
            Main main = new Main(System.out);
            System.exit(main.compile(stringArray) ? 0 : 1);
        }
        catch (Exception exception) {
            String string;
            if (System.getProperty("JBWDebug") != null) {
                exception.printStackTrace();
            }
            if ((string = exception.getMessage()) != null && string.length() > 0) {
                System.out.println(string);
            } else {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }

    boolean parseArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            return false;
        }
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("ds", false, 1, 1), new CommandArg("d", false, 1, 1), new CommandArg("nowarn", false, 0, 0), new CommandArg("nomarsh", false, 0, 0), new CommandArg("novalidate", false, 0, 0), new CommandArg("keep", false, 0, 0), new CommandArg("keepgenerated", false, 0, 0), new CommandArg("verbose", false, 0, 0), new CommandArg("classpath", false, 1, 1), new CommandArg("nspkg", false, 2, 2), new CommandArg("typemapping", false, 2, 2), new CommandArg("package", false, 1, 1), new CommandArg("depend", false, 0, 0), new CommandArg("g", false, 0, 0), new CommandArg("O", false, 0, 0), new CommandArg("nocompile", false, 0, 0), new CommandArg("final", false, 0, 0)};
        this._cmdline = new CommandLine("xsd2java", commandArgArray, _usage, "-", true);
        this._cmdline.getArgDef("nocompile").setAlias("noCompile");
        this._cmdline.getArgDef("classpath").setAlias("cp");
        this._cmdline.getArgDef("typemapping").setAlias("tm");
        this._cmdline.markAppendable("nspkg");
        this._cmdline.markAppendable("tm");
        boolean bl = this._cmdline.parse(stringArray, System.err);
        return bl;
    }

    public static boolean compile(String[] stringArray, OutputStream outputStream) throws Exception {
        Main main = new Main(outputStream);
        return main.compile(stringArray);
    }

    private boolean compile(String[] stringArray) throws Exception {
        if (!this.parseArguments(stringArray)) {
            this._ps.println(_usage);
            return false;
        }
        _verbose = this._cmdline.getArg("verbose") != null;
        _warn = this._cmdline.getArg("nowarn") == null;
        boolean bl = this._cmdline.getArg("keep") == null && this._cmdline.getArg("keepgenerated") == null;
        Vector vector = new Vector();
        CodeGenerator codeGenerator = new CodeGenerator(vector, this._ps);
        String[] stringArray2 = this._cmdline.getTralingArguments();
        int n = 0;
        while (n < stringArray2.length) {
            if (_verbose) {
                this._ps.println(_messages.get("xsd2java.verbose.processing.xsd", stringArray2[n]));
            }
            this.compile(codeGenerator, stringArray2[n], this._cmdline.getArgs());
            ++n;
        }
        return true;
    }

    private void compile(CodeGenerator codeGenerator, String string, Hashtable hashtable) throws Exception {
        String string2 = null;
        Object v = hashtable.get("ds");
        if (v != null) {
            string2 = v instanceof String ? (String)v : ((String[])v)[0];
        }
        File file = Main.getDestDir(string2);
        hashtable.put("destDir", file);
        codeGenerator.compile(string, hashtable);
    }

    private static File getDestDir(String string) throws Exception {
        File file = null;
        if (string != null) {
            file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(_messages.get("xsd2java.error.unable.to.create.directory", string));
            }
            if (!file.isDirectory()) {
                throw new Exception(_messages.get("xsd2java.error.exists.but.not.directory", string));
            }
        } else {
            file = new File(".");
        }
        return file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _messages = new Messages(class$com$sssw$jbroker$tools$xsd2java$Main == null ? (class$com$sssw$jbroker$tools$xsd2java$Main = Main.class$("com.sssw.jbroker.tools.xsd2java.Main")) : class$com$sssw$jbroker$tools$xsd2java$Main);
        _usage = _messages.get("xsd2java.usage") + Copyright._copyright + "\n";
    }
}

